;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; RUN: foreach %s %t wasm-opt --generate-global-effects --simplify-globals -S -o - | filecheck %s

;; Compute function effects and then simplify globals. We must handle the case
;; of an expression that is not a global.set that sets a global - a function
;; whose effects we've computed to include some sets to globals.

(module
 ;; CHECK:      (type $0 (func))

 ;; CHECK:      (global $A (mut i32) (i32.const 10))
 (global $A (mut i32) (i32.const 10))

 ;; CHECK:      (global $B i32 (i32.const 20))
 (global $B (mut i32) (i32.const 20))

 ;; CHECK:      (global $C (mut i32) (i32.const 30))
 (global $C (mut i32) (i32.const 30))

 ;; CHECK:      (func $set
 ;; CHECK-NEXT:  (global.set $A
 ;; CHECK-NEXT:   (i32.const 0)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $set
  (global.set $A
   (i32.const 0)
  )
 )

 ;; CHECK:      (func $test
 ;; CHECK-NEXT:  (global.set $A
 ;; CHECK-NEXT:   (i32.const 11)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (global.set $C
 ;; CHECK-NEXT:   (i32.const 33)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i32.const 11)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i32.const 20)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i32.const 33)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (call $set)
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (global.get $A)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i32.const 20)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT:  (drop
 ;; CHECK-NEXT:   (i32.const 33)
 ;; CHECK-NEXT:  )
 ;; CHECK-NEXT: )
 (func $test
  (global.set $A
   (i32.const 11)
  )
  (global.set $C
   (i32.const 33)
  )
  ;; We can infer $A here since we see the write to it, above.
  (drop
   (global.get $A)
  )
  ;; We can infer $B since we'll prove it is immutable.
  (drop
   (global.get $B)
  )
  ;; We can infer $C here since we see the write to it, above.
  (drop
   (global.get $C)
  )
  ;; This call sets $A. After the call we can no longer infer $A, but we can
  ;; still infer the others.
  (call $set)
  (drop
   (global.get $A)
  )
  (drop
   (global.get $B)
  )
  (drop
   (global.get $C)
  )
 )
)
