/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.compression;

import java.nio.ByteBuffer;

public class NBitIntegerEncoder {
    private NBitIntegerEncoder() {
    }

    public static int octetsNeeded(int prefix, long value) {
        if (prefix <= 0 || prefix > 8) {
            throw new IllegalArgumentException();
        }
        int nbits = 255 >>> 8 - prefix;
        if ((value -= (long)nbits) < 0L) {
            return 1;
        }
        if (value == 0L) {
            return 2;
        }
        int lz = Long.numberOfLeadingZeros(value);
        int log2 = 64 - lz;
        return 1 + (log2 + 6) / 7;
    }

    public static void encode(ByteBuffer buffer2, int prefix, long value) {
        if (prefix <= 0 || prefix > 8) {
            throw new IllegalArgumentException();
        }
        if (prefix == 8) {
            buffer2.put((byte)0);
        }
        int bits = 255 >>> 8 - prefix;
        int p = buffer2.position() - 1;
        if (value >= (long)bits) {
            buffer2.put(p, (byte)(buffer2.get(p) | bits));
            long length = value - (long)bits;
            while (true) {
                if ((length & 0xFFFFFFFFFFFFFF80L) == 0L) {
                    buffer2.put((byte)length);
                    return;
                }
                buffer2.put((byte)(length & 0x7FL | 0x80L));
                length >>>= 7;
            }
        }
        buffer2.put(p, (byte)((long)(buffer2.get(p) & ~bits) | value));
    }
}

