/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.crypt;

import java.sql.SQLException;
import java.util.Objects;
import javax.crypto.Cipher;
import org.firebirdsql.gds.ng.wire.crypt.EncryptionIdentifier;

public final class EncryptionInitInfo {
    private static final SQLException NO_EXCEPTION = null;
    private static final Cipher NO_CIPHER = null;
    private final EncryptionIdentifier encryptionIdentifier;
    private final SQLException exception;
    private final InitResult initResult;
    private final Cipher encryptionCipher;
    private final Cipher decryptionCipher;

    private EncryptionInitInfo(EncryptionIdentifier encryptionIdentifier, InitResult initResult, Cipher encryptionCipher, Cipher decryptionCipher, SQLException exception) {
        this.encryptionIdentifier = encryptionIdentifier;
        this.exception = exception;
        this.initResult = initResult;
        this.encryptionCipher = encryptionCipher;
        this.decryptionCipher = decryptionCipher;
    }

    public static EncryptionInitInfo success(EncryptionIdentifier encryptionIdentifier, Cipher encryptionCipher, Cipher decryptionCipher) {
        return new EncryptionInitInfo(encryptionIdentifier, InitResult.SUCCESS, Objects.requireNonNull(encryptionCipher, "encryptionCipher"), Objects.requireNonNull(decryptionCipher, "decryptionCipher"), NO_EXCEPTION);
    }

    public static EncryptionInitInfo failure(EncryptionIdentifier encryptionIdentifier, SQLException exception) {
        return new EncryptionInitInfo(encryptionIdentifier, InitResult.FAILURE, NO_CIPHER, NO_CIPHER, Objects.requireNonNull(exception, "exception"));
    }

    public EncryptionIdentifier getEncryptionIdentifier() {
        return this.encryptionIdentifier;
    }

    public InitResult getInitResult() {
        return this.initResult;
    }

    public boolean isSuccess() {
        return this.initResult == InitResult.SUCCESS;
    }

    public Cipher getEncryptionCipher() {
        if (this.initResult != InitResult.SUCCESS) {
            throw new IllegalStateException("Getting cipher only allowed when initResult is SUCCESS, was " + (Object)((Object)this.initResult));
        }
        return this.encryptionCipher;
    }

    public Cipher getDecryptionCipher() {
        if (this.initResult != InitResult.SUCCESS) {
            throw new IllegalStateException("Getting cipher only allowed when initResult is SUCCESS, was " + (Object)((Object)this.initResult));
        }
        return this.decryptionCipher;
    }

    public SQLException getException() {
        return this.exception;
    }

    public static enum InitResult {
        SUCCESS,
        FAILURE;

    }
}

