/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import org.firebirdsql.gds.ng.fields.FieldDescriptor;

public final class JdbcTypeConverter {
    static final int SUBTYPE_NUMERIC = 1;
    static final int SUBTYPE_DECIMAL = 2;
    static final int smallint_type = 7;
    static final int integer_type = 8;
    static final int quad_type = 9;
    static final int float_type = 10;
    static final int d_float_type = 11;
    static final int date_type = 12;
    static final int time_type = 13;
    static final int char_type = 14;
    static final int int64_type = 16;
    static final int double_type = 27;
    static final int timestamp_type = 35;
    static final int varchar_type = 37;
    static final int blob_type = 261;
    static final short boolean_type = 23;

    private JdbcTypeConverter() {
    }

    public static int toJdbcType(FieldDescriptor fieldDescriptor) {
        return JdbcTypeConverter.fromFirebirdToJdbcType(fieldDescriptor.getType(), fieldDescriptor.getSubType(), fieldDescriptor.getScale());
    }

    public static int fromFirebirdToJdbcType(int firebirdType, int subtype, int scale) {
        switch (firebirdType &= 0xFFFFFFFE) {
            case 500: {
                if (subtype == 1 || subtype == 0 && scale < 0) {
                    return 2;
                }
                if (subtype == 2) {
                    return 3;
                }
                return 5;
            }
            case 496: {
                if (subtype == 1 || subtype == 0 && scale < 0) {
                    return 2;
                }
                if (subtype == 2) {
                    return 3;
                }
                return 4;
            }
            case 580: {
                if (subtype == 1 || subtype == 0 && scale < 0) {
                    return 2;
                }
                if (subtype == 2) {
                    return 3;
                }
                return -5;
            }
            case 480: 
            case 530: {
                if (subtype == 1 || subtype == 0 && scale < 0) {
                    return 2;
                }
                if (subtype == 2) {
                    return 3;
                }
                return 8;
            }
            case 482: {
                return 6;
            }
            case 452: {
                if (subtype == 1) {
                    return -2;
                }
                return 1;
            }
            case 448: {
                if (subtype == 1) {
                    return -3;
                }
                return 12;
            }
            case 510: {
                return 93;
            }
            case 560: {
                return 92;
            }
            case 570: {
                return 91;
            }
            case 520: {
                if (subtype < 0) {
                    return 2004;
                }
                if (subtype == 1) {
                    return -1;
                }
                return -4;
            }
            case 32764: {
                return 16;
            }
            case 32766: {
                return 0;
            }
            case 540: {
                return 2003;
            }
        }
        return 1111;
    }

    public static int fromMetaDataToJdbcType(int metaDataType, int subtype, int scale) {
        return JdbcTypeConverter.fromFirebirdToJdbcType(JdbcTypeConverter.fromMetaDataToFirebirdType(metaDataType), subtype, scale);
    }

    public static int fromMetaDataToFirebirdType(int metaDataType) {
        switch (metaDataType) {
            case 7: {
                return 500;
            }
            case 8: {
                return 496;
            }
            case 16: {
                return 580;
            }
            case 9: {
                return 550;
            }
            case 10: {
                return 482;
            }
            case 27: {
                return 480;
            }
            case 11: {
                return 530;
            }
            case 12: {
                return 570;
            }
            case 13: {
                return 560;
            }
            case 35: {
                return 510;
            }
            case 14: {
                return 452;
            }
            case 37: {
                return 448;
            }
            case 261: {
                return 520;
            }
            case 23: {
                return 32764;
            }
        }
        return 32766;
    }
}

