/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.jdbc;

import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.PartitionOptions;
import com.google.cloud.spanner.ReadContext;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.ResultSets;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.ValueBinder;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.cloud.spanner.jdbc.AbstractJdbcPreparedStatement;
import com.google.cloud.spanner.jdbc.CloudSpannerJdbcPartitionedQueryResultSet;
import com.google.cloud.spanner.jdbc.CloudSpannerJdbcPreparedStatement;
import com.google.cloud.spanner.jdbc.JdbcConnection;
import com.google.cloud.spanner.jdbc.JdbcParameterMetaData;
import com.google.cloud.spanner.jdbc.JdbcPartitionedQueryResultSet;
import com.google.cloud.spanner.jdbc.JdbcResultSet;
import com.google.cloud.spanner.jdbc.JdbcResultSetMetaData;
import com.google.cloud.spanner.jdbc.JdbcSqlExceptionFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.rpc.Code;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

class JdbcPreparedStatement
extends AbstractJdbcPreparedStatement
implements CloudSpannerJdbcPreparedStatement {
    private static final char POS_PARAM_CHAR = '?';
    private final String sql;
    private final AbstractStatementParser.ParametersInfo parameters;
    private JdbcParameterMetaData cachedParameterMetadata;
    private final ImmutableList<String> generatedKeysColumns;

    JdbcPreparedStatement(JdbcConnection connection, String sql, ImmutableList<String> generatedKeysColumns) throws SQLException {
        super(connection);
        this.sql = sql;
        try {
            String sqlForParameterExtraction = this.getConnection().getDialect() == Dialect.POSTGRESQL ? this.sql : this.parser.removeCommentsAndTrim(this.sql);
            this.parameters = this.parser.convertPositionalParametersToNamedParameters('?', sqlForParameterExtraction);
        }
        catch (SpannerException e) {
            throw JdbcSqlExceptionFactory.of(e);
        }
        this.generatedKeysColumns = (ImmutableList)Preconditions.checkNotNull(generatedKeysColumns);
    }

    AbstractStatementParser.ParametersInfo getParametersInfo() {
        return this.parameters;
    }

    @VisibleForTesting
    Statement createStatement() throws SQLException {
        AbstractStatementParser.ParametersInfo paramInfo = this.getParametersInfo();
        Statement.Builder builder = Statement.newBuilder((String)paramInfo.sqlWithNamedParameters);
        for (int index = 1; index <= this.getParameters().getHighestIndex(); ++index) {
            this.getParameters().bindParameterValue((ValueBinder<Statement.Builder>)builder.bind("p" + index), index);
        }
        return builder.build();
    }

    @Override
    public java.sql.ResultSet executeQuery() throws SQLException {
        this.checkClosed();
        return this.executeQuery(this.createStatement(), new Options.QueryOption[0]);
    }

    java.sql.ResultSet executeQueryWithOptions(Options.QueryOption ... options) throws SQLException {
        this.checkClosed();
        return this.executeQuery(this.createStatement(), options);
    }

    @Override
    public int executeUpdate() throws SQLException {
        long count = this.executeLargeUpdate(this.createStatement(), this.generatedKeysColumns);
        if (count > Integer.MAX_VALUE) {
            throw JdbcSqlExceptionFactory.of("update count too large for executeUpdate: " + count, Code.OUT_OF_RANGE);
        }
        return (int)count;
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        return this.executeLargeUpdate(this.createStatement(), this.generatedKeysColumns);
    }

    @Override
    public boolean execute() throws SQLException {
        return this.executeStatement(this.createStatement(), this.generatedKeysColumns);
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkClosed();
        this.checkAndSetBatchType(this.sql);
        this.batchedStatements.add(this.createStatement());
    }

    @Override
    public JdbcParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClosed();
        if (this.cachedParameterMetadata == null) {
            this.cachedParameterMetadata = this.getConnection().getParser().isUpdateStatement(this.sql) && !this.getConnection().getParser().checkReturningClause(this.sql) ? this.getParameterMetadataForUpdate() : this.getParameterMetadataForQuery();
        }
        return this.cachedParameterMetadata;
    }

    private JdbcParameterMetaData getParameterMetadataForUpdate() {
        try (ResultSet resultSet = this.getConnection().getSpannerConnection().analyzeUpdateStatement(Statement.of((String)this.parameters.sqlWithNamedParameters), ReadContext.QueryAnalyzeMode.PLAN, new Options.UpdateOption[0]);){
            JdbcParameterMetaData jdbcParameterMetaData = new JdbcParameterMetaData(this, resultSet);
            return jdbcParameterMetaData;
        }
    }

    private JdbcParameterMetaData getParameterMetadataForQuery() {
        try (ResultSet resultSet = this.getConnection().getSpannerConnection().analyzeQuery(Statement.of((String)this.parameters.sqlWithNamedParameters), ReadContext.QueryAnalyzeMode.PLAN);){
            JdbcParameterMetaData jdbcParameterMetaData = new JdbcParameterMetaData(this, resultSet);
            return jdbcParameterMetaData;
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.getConnection().getParser().isUpdateStatement(this.sql)) {
            ResultSet resultSet = ResultSets.forRows((Type)Type.struct((Type.StructField[])new Type.StructField[0]), (Iterable)ImmutableList.of());
            resultSet.next();
            return new JdbcResultSetMetaData(JdbcResultSet.of(resultSet), this);
        }
        try (java.sql.ResultSet rs = this.analyzeQuery(this.createStatement(), ReadContext.QueryAnalyzeMode.PLAN);){
            ResultSetMetaData resultSetMetaData = rs.getMetaData();
            return resultSetMetaData;
        }
    }

    @Override
    public java.sql.ResultSet partitionQuery(PartitionOptions partitionOptions, Options.QueryOption ... options) throws SQLException {
        return this.runWithStatementTimeout(connection -> JdbcResultSet.of(this, connection.partitionQuery(this.createStatement(), partitionOptions, options)));
    }

    @Override
    public java.sql.ResultSet runPartition() throws SQLException {
        return this.runWithStatementTimeout(connection -> {
            if (this.getParameters().getHighestIndex() < 1 || this.getParameters().getParameter(1) == null) {
                throw JdbcSqlExceptionFactory.of("No query parameter has been set. runPartition() requires the partition ID to be set as a query parameter with index 1. Call PreparedStatement#setString(1, \"some-partition-id\") before calling runPartition().", Code.FAILED_PRECONDITION);
            }
            String partitionId = this.getParameters().getParameter(1).toString();
            return JdbcResultSet.of(this, connection.runPartition(partitionId));
        });
    }

    @Override
    public CloudSpannerJdbcPartitionedQueryResultSet runPartitionedQuery(PartitionOptions partitionOptions, Options.QueryOption ... options) throws SQLException {
        return this.runWithStatementTimeout(connection -> JdbcPartitionedQueryResultSet.of((java.sql.Statement)this, connection.runPartitionedQuery(this.createStatement(), partitionOptions, options)));
    }
}

