/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.verb.schemas;

import java.util.ArrayList;
import java.util.Collection;
import org.flywaydb.core.api.CoreMigrationType;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.experimental.ExperimentalDatabase;
import org.flywaydb.core.experimental.schemahistory.SchemaHistoryItem;
import org.flywaydb.core.extensibility.CachingVerbExtension;
import org.flywaydb.core.extensibility.MigrationType;
import org.flywaydb.nc.preparation.PreparationContext;

public class SchemasVerbExtension
extends CachingVerbExtension {
    private static final Log LOG = LogFactory.getLog(SchemasVerbExtension.class);

    public boolean handlesVerb(String verb) {
        return "schemas".equals(verb);
    }

    public Object executeVerb(Configuration configuration) {
        PreparationContext context = PreparationContext.get((Configuration)configuration, (boolean)this.cached);
        ExperimentalDatabase database = context.getDatabase();
        Collection<String> missingSchemas = this.getMissingSchemas(configuration, database);
        if (missingSchemas.contains(null)) {
            throw new FlywayException("Unable to determine schema for the schema history table. Set a default schema for the connection or specify one using the defaultSchema property!");
        }
        if (missingSchemas.isEmpty()) {
            return null;
        }
        if (configuration.isCreateSchemas()) {
            database.createSchemas((String[])missingSchemas.toArray(String[]::new));
        }
        database.createSchemaHistoryTableIfNotExists(configuration);
        if (!missingSchemas.isEmpty()) {
            int installedRank = context.getSchemaHistoryModel().calculateInstalledRank((MigrationType)CoreMigrationType.SCHEMA);
            this.createSchemaMarker(database, configuration, installedRank, missingSchemas);
            context.refresh(configuration);
        }
        return null;
    }

    private Collection<String> getMissingSchemas(Configuration configuration, ExperimentalDatabase database) {
        ArrayList<String> missingSchemas = new ArrayList<String>();
        String defaultSchema = database.getCurrentSchema();
        if (defaultSchema != null && !database.isSchemaExists(defaultSchema)) {
            missingSchemas.add(defaultSchema);
        }
        for (String schema : configuration.getSchemas()) {
            if (database.isSchemaExists(schema) || missingSchemas.contains(schema)) continue;
            missingSchemas.add(schema);
        }
        return missingSchemas;
    }

    private void createSchemaMarker(ExperimentalDatabase experimentalDatabase, Configuration configuration, int installedRank, Collection<String> missingSchemas) {
        experimentalDatabase.appendSchemaHistoryItem(SchemaHistoryItem.builder().description("<< Flyway Schema Creation >>").installedRank(installedRank).type("SCHEMA").script(experimentalDatabase.doQuote(String.join((CharSequence)"\",\"", missingSchemas))).installedBy(experimentalDatabase.getInstalledBy(configuration)).executionTime(0).success(true).build(), configuration.getTable());
    }
}

