/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc;

import com.ing.data.cassandra.jdbc.CassandraConnection;
import com.ing.data.cassandra.jdbc.PooledCassandraConnection;
import com.ing.data.cassandra.jdbc.utils.ContactPoint;
import com.ing.data.cassandra.jdbc.utils.JdbcUrlUtil;
import java.io.PrintWriter;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;

public class CassandraDataSource
implements ConnectionPoolDataSource,
DataSource {
    protected static final String DATA_SOURCE_DESCRIPTION = "Cassandra Data Source";
    protected List<ContactPoint> contactPoints;
    protected String databaseName;
    protected String user;
    protected String password;
    protected String consistency = null;
    protected String complianceMode = null;
    protected String localDataCenter = null;

    public CassandraDataSource(List<ContactPoint> contactPoints, String keyspace, String user, String password, String consistency) {
        this(contactPoints, keyspace, user, password, consistency, null);
    }

    public CassandraDataSource(List<ContactPoint> contactPoints, String keyspace, String user, String password, String consistency, String localDataCenter) {
        if (contactPoints != null && !contactPoints.isEmpty()) {
            this.setContactPoints(contactPoints);
        }
        if (consistency != null) {
            this.setConsistency(consistency);
        }
        if (localDataCenter != null) {
            this.setLocalDataCenter(localDataCenter);
        }
        this.setDatabaseName(keyspace);
        this.setUser(user);
        this.setPassword(password);
    }

    public String getDescription() {
        return DATA_SOURCE_DESCRIPTION;
    }

    public List<ContactPoint> getContactPoints() {
        return this.contactPoints;
    }

    public void setContactPoints(List<ContactPoint> contactPoints) {
        this.contactPoints = contactPoints;
    }

    public String getConsistency() {
        return this.consistency;
    }

    public void setConsistency(String consistency) {
        this.consistency = consistency;
    }

    public void setComplianceMode(String complianceMode) {
        this.complianceMode = complianceMode;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getLocalDataCenter() {
        return this.localDataCenter;
    }

    public void setLocalDataCenter(String localDataCenter) {
        this.localDataCenter = localDataCenter;
    }

    @Override
    public CassandraConnection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    @Override
    public CassandraConnection getConnection(String user, String password) throws SQLException {
        Properties props = new Properties();
        this.user = user;
        this.password = password;
        if (this.contactPoints != null && !this.contactPoints.isEmpty()) {
            props.put("contactPoints", this.contactPoints);
        }
        if (this.databaseName != null) {
            props.setProperty("databaseName", this.databaseName);
        }
        if (user != null) {
            props.setProperty("user", user);
        }
        if (password != null) {
            props.setProperty("password", password);
        }
        if (this.consistency != null) {
            props.setProperty("consistencyLevel", this.consistency);
        }
        if (this.localDataCenter != null) {
            props.setProperty("localDatacenter", this.localDataCenter);
        }
        if (this.complianceMode != null) {
            props.setProperty("complianceMode", this.complianceMode);
        }
        String url = "jdbc:cassandra:".concat(JdbcUrlUtil.createSubName(props));
        return (CassandraConnection)DriverManager.getConnection(url, props);
    }

    @Override
    public int getLoginTimeout() {
        return DriverManager.getLoginTimeout();
    }

    @Override
    public PrintWriter getLogWriter() {
        return DriverManager.getLogWriter();
    }

    @Override
    public void setLoginTimeout(int timeout) {
        DriverManager.setLoginTimeout(timeout);
    }

    @Override
    public void setLogWriter(PrintWriter writer) {
        DriverManager.setLogWriter(writer);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return iface.cast(this);
        }
        throw new SQLException(String.format("No object was found that matched the provided interface: %s", iface.getSimpleName()));
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("The Cassandra implementation does not support this method.");
    }

    @Override
    public PooledCassandraConnection getPooledConnection() throws SQLException {
        return new PooledCassandraConnection(this.getConnection());
    }

    @Override
    public PooledCassandraConnection getPooledConnection(String user, String password) throws SQLException {
        return new PooledCassandraConnection(this.getConnection(user, password));
    }

    static {
        try {
            Class.forName("com.ing.data.cassandra.jdbc.CassandraDriver");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

