/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc;

import com.ing.data.cassandra.jdbc.CassandraConnection;
import com.ing.data.cassandra.jdbc.CassandraResultSet;
import com.ing.data.cassandra.jdbc.CassandraStatement;
import com.ing.data.cassandra.jdbc.metadata.BasicVersionedMetadata;
import com.ing.data.cassandra.jdbc.metadata.BuiltInFunctionsMetadataBuilder;
import com.ing.data.cassandra.jdbc.metadata.CatalogMetadataResultSetBuilder;
import com.ing.data.cassandra.jdbc.metadata.ColumnMetadataResultSetBuilder;
import com.ing.data.cassandra.jdbc.metadata.FunctionMetadataResultSetBuilder;
import com.ing.data.cassandra.jdbc.metadata.SchemaMetadataResultSetBuilder;
import com.ing.data.cassandra.jdbc.metadata.TableMetadataResultSetBuilder;
import com.ing.data.cassandra.jdbc.metadata.TypeMetadataResultSetBuilder;
import com.ing.data.cassandra.jdbc.metadata.VersionedMetadata;
import com.ing.data.cassandra.jdbc.utils.DriverUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLSyntaxErrorException;
import java.util.Arrays;
import java.util.List;

public class CassandraDatabaseMetaData
implements DatabaseMetaData {
    static final int UNKNOWN_MAX_VALUE = 0;
    static final int KEYSPACE_NAME_MAX_LENGTH = 48;
    static final int TABLE_NAME_MAX_LENGTH = 48;
    static final String CATALOG_VENDOR_TERM = "Cluster";
    static final String SCHEMA_VENDOR_TERM = "Keyspace";
    private final CassandraConnection connection;
    private CassandraStatement statement;

    public CassandraDatabaseMetaData(CassandraConnection connection) throws SQLException {
        this.connection = connection;
        this.statement = new CassandraStatement(this.connection);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return iface.cast(this);
        }
        throw new SQLException(String.format("No object was found that matched the provided interface: %s", iface.getSimpleName()));
    }

    @Override
    public boolean allProceduresAreCallable() {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() {
        return true;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() {
        return false;
    }

    @Override
    public boolean generatedKeyAlwaysReturned() {
        return false;
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        this.checkStatementClosed();
        if (catalog == null || catalog.equals(this.connection.getCatalog())) {
            return new TypeMetadataResultSetBuilder(this.statement).buildAttributes(schemaPattern, typeNamePattern, attributeNamePattern);
        }
        return CassandraResultSet.EMPTY_RESULT_SET;
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        this.checkStatementClosed();
        if (catalog == null || catalog.equals(this.connection.getCatalog())) {
            return new TableMetadataResultSetBuilder(this.statement).buildBestRowIdentifier(schema, table, scope);
        }
        return CassandraResultSet.EMPTY_RESULT_SET;
    }

    @Override
    public String getCatalogSeparator() {
        return "";
    }

    @Override
    public String getCatalogTerm() {
        return CATALOG_VENDOR_TERM;
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        this.checkStatementClosed();
        return new CatalogMetadataResultSetBuilder(this.statement).buildCatalogs();
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        throw new SQLFeatureNotSupportedException("The Cassandra implementation does not support this method.");
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException("The Cassandra implementation does not support this method.");
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        this.checkStatementClosed();
        if (catalog == null || catalog.equals(this.connection.getCatalog())) {
            return new ColumnMetadataResultSetBuilder(this.statement).buildColumns(schemaPattern, tableNamePattern, columnNamePattern);
        }
        return CassandraResultSet.EMPTY_RESULT_SET;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        throw new SQLFeatureNotSupportedException("The Cassandra implementation does not support this method.");
    }

    @Override
    public int getDatabaseMajorVersion() {
        return CassandraConnection.dbMajorVersion;
    }

    @Override
    public int getDatabaseMinorVersion() {
        return CassandraConnection.dbMinorVersion;
    }

    @Override
    public String getDatabaseProductName() {
        return DriverUtil.getDriverProperty("database.productName");
    }

    @Override
    public String getDatabaseProductVersion() {
        return String.format("%d.%d.%d", CassandraConnection.dbMajorVersion, CassandraConnection.dbMinorVersion, CassandraConnection.dbPatchVersion);
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return 0;
    }

    @Override
    public int getDriverMajorVersion() {
        return DriverUtil.safeParseVersion(this.getDriverVersion()).getMajor();
    }

    @Override
    public int getDriverMinorVersion() {
        return DriverUtil.safeParseVersion(this.getDriverVersion()).getMinor();
    }

    @Override
    public String getDriverName() {
        return DriverUtil.getDriverProperty("driver.name");
    }

    @Override
    public String getDriverVersion() {
        return DriverUtil.getDriverProperty("driver.version");
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        throw new SQLFeatureNotSupportedException("The Cassandra implementation does not support this method.");
    }

    @Override
    public String getExtraNameCharacters() {
        return "";
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        this.checkStatementClosed();
        if (catalog == null || catalog.equals(this.connection.getCatalog())) {
            return new FunctionMetadataResultSetBuilder(this.statement).buildFunctionColumns(schemaPattern, functionNamePattern, columnNamePattern);
        }
        return CassandraResultSet.EMPTY_RESULT_SET;
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        this.checkStatementClosed();
        if (catalog == null || catalog.equals(this.connection.getCatalog())) {
            return new FunctionMetadataResultSetBuilder(this.statement).buildFunctions(schemaPattern, functionNamePattern);
        }
        return CassandraResultSet.EMPTY_RESULT_SET;
    }

    @Override
    public String getIdentifierQuoteString() {
        return " ";
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        throw new SQLFeatureNotSupportedException("The Cassandra implementation does not support this method.");
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        this.checkStatementClosed();
        if (catalog == null || catalog.equals(this.connection.getCatalog())) {
            return new TableMetadataResultSetBuilder(this.statement).buildIndexes(schema, table, unique, approximate);
        }
        return CassandraResultSet.EMPTY_RESULT_SET;
    }

    @Override
    public int getJDBCMajorVersion() {
        return DriverUtil.safeParseVersion(DriverUtil.getDriverProperty("driver.jdbcVersion")).getMajor();
    }

    @Override
    public int getJDBCMinorVersion() {
        return DriverUtil.safeParseVersion(DriverUtil.getDriverProperty("driver.jdbcVersion")).getMinor();
    }

    @Override
    public int getMaxBinaryLiteralLength() {
        return 0x3FFFFFFF;
    }

    @Override
    public int getMaxCatalogNameLength() {
        return 127;
    }

    @Override
    public int getMaxCharLiteralLength() {
        return 65535;
    }

    @Override
    public int getMaxColumnNameLength() {
        return 65535;
    }

    @Override
    public int getMaxColumnsInGroupBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() {
        return 0;
    }

    @Override
    public int getMaxConnections() {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() {
        return 0;
    }

    @Override
    public int getMaxIndexLength() {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() {
        return 0;
    }

    @Override
    public int getMaxRowSize() {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() {
        return 48;
    }

    @Override
    public int getMaxStatementLength() {
        return 0;
    }

    @Override
    public int getMaxStatements() {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() {
        return 48;
    }

    @Override
    public int getMaxTablesInSelect() {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() {
        return 0;
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        this.checkStatementClosed();
        return new BuiltInFunctionsMetadataBuilder(this.getDatabaseProductVersion()).buildNumericFunctionsList();
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        this.checkStatementClosed();
        if (catalog == null || catalog.equals(this.connection.getCatalog())) {
            return new TableMetadataResultSetBuilder(this.statement).buildPrimaryKeys(schema, table);
        }
        return CassandraResultSet.EMPTY_RESULT_SET;
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException("The Cassandra implementation does not support this method.");
    }

    @Override
    public String getProcedureTerm() {
        return "";
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException("The Cassandra implementation does not support this method.");
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException("The Cassandra implementation does not support this method.");
    }

    @Override
    public int getResultSetHoldability() {
        return 1;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        this.checkStatementClosed();
        List<VersionedMetadata> cqlKeywords = Arrays.asList(new BasicVersionedMetadata("AGGREGATE"), new BasicVersionedMetadata("ALLOW"), new BasicVersionedMetadata("ANN OF", "5.0"), new BasicVersionedMetadata("APPLY"), new BasicVersionedMetadata("ASCII"), new BasicVersionedMetadata("AUTHORIZE"), new BasicVersionedMetadata("BATCH"), new BasicVersionedMetadata("CLUSTERING"), new BasicVersionedMetadata("COLUMNFAMILY"), new BasicVersionedMetadata("COMPACT"), new BasicVersionedMetadata("COUNTER"), new BasicVersionedMetadata("CUSTOM"), new BasicVersionedMetadata("ENTRIES"), new BasicVersionedMetadata("FILTERING"), new BasicVersionedMetadata("FINALFUNC"), new BasicVersionedMetadata("FROZEN"), new BasicVersionedMetadata("FUNCTIONS"), new BasicVersionedMetadata("IF"), new BasicVersionedMetadata("INDEX"), new BasicVersionedMetadata("INET"), new BasicVersionedMetadata("INFINITY"), new BasicVersionedMetadata("INITCOND"), new BasicVersionedMetadata("JSON"), new BasicVersionedMetadata("KEYS"), new BasicVersionedMetadata("KEYSPACE"), new BasicVersionedMetadata("KEYSPACES"), new BasicVersionedMetadata("LIMIT"), new BasicVersionedMetadata("LIST"), new BasicVersionedMetadata("LOGIN"), new BasicVersionedMetadata("MODIFY"), new BasicVersionedMetadata("NAN"), new BasicVersionedMetadata("NOLOGIN"), new BasicVersionedMetadata("NORECURSIVE"), new BasicVersionedMetadata("NOSUPERUSER"), new BasicVersionedMetadata("PASSWORD"), new BasicVersionedMetadata("PERMISSION"), new BasicVersionedMetadata("PERMISSIONS"), new BasicVersionedMetadata("RENAME"), new BasicVersionedMetadata("REPLACE"), new BasicVersionedMetadata("RETURNS"), new BasicVersionedMetadata("ROLES"), new BasicVersionedMetadata("SFUNC"), new BasicVersionedMetadata("SMALLINT"), new BasicVersionedMetadata("STORAGE"), new BasicVersionedMetadata("STYPE"), new BasicVersionedMetadata("SUPERUSER"), new BasicVersionedMetadata("TEXT"), new BasicVersionedMetadata("TIMEUUID"), new BasicVersionedMetadata("TINYINT"), new BasicVersionedMetadata("TOKEN"), new BasicVersionedMetadata("TRUNCATE"), new BasicVersionedMetadata("TTL"), new BasicVersionedMetadata("TUPLE"), new BasicVersionedMetadata("UNLOGGED"), new BasicVersionedMetadata("USE"), new BasicVersionedMetadata("USERS"), new BasicVersionedMetadata("UUID"), new BasicVersionedMetadata("VARINT"), new BasicVersionedMetadata("VECTOR", "5.0"), new BasicVersionedMetadata("WRITETIME"));
        return DriverUtil.buildMetadataList(cqlKeywords, this.getDatabaseProductVersion());
    }

    @Override
    public int getSQLStateType() {
        return 2;
    }

    @Override
    public String getSchemaTerm() {
        return SCHEMA_VENDOR_TERM;
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        this.checkStatementClosed();
        return new SchemaMetadataResultSetBuilder(this.statement).buildSchemas(null);
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        this.checkStatementClosed();
        if (catalog != null && !catalog.equals(this.statement.connection.getCatalog())) {
            throw new SQLSyntaxErrorException("Catalog name must exactly match or be null.");
        }
        return new SchemaMetadataResultSetBuilder(this.statement).buildSchemas(schemaPattern);
    }

    @Override
    public String getSearchStringEscape() {
        return "\\";
    }

    @Override
    public String getStringFunctions() throws SQLException {
        this.checkStatementClosed();
        return new BuiltInFunctionsMetadataBuilder(this.getDatabaseProductVersion()).buildSystemFunctionsList();
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException("The Cassandra implementation does not support this method.");
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException("The Cassandra implementation does not support this method.");
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        this.checkStatementClosed();
        return new BuiltInFunctionsMetadataBuilder(this.getDatabaseProductVersion()).buildSystemFunctionsList();
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException("The Cassandra implementation does not support this method.");
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        this.checkStatementClosed();
        return new TableMetadataResultSetBuilder(this.statement).buildTableTypes();
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        boolean askingForTable;
        boolean bl = askingForTable = types == null;
        if (types != null) {
            askingForTable = Arrays.asList(types).contains("TABLE");
        }
        if ((catalog == null || catalog.equals(this.connection.getCatalog())) && askingForTable) {
            this.checkStatementClosed();
            return new TableMetadataResultSetBuilder(this.statement).buildTables(schemaPattern, tableNamePattern);
        }
        return CassandraResultSet.EMPTY_RESULT_SET;
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        this.checkStatementClosed();
        return new BuiltInFunctionsMetadataBuilder(this.getDatabaseProductVersion()).buildTimeDateFunctionsList();
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        this.checkStatementClosed();
        return new TypeMetadataResultSetBuilder(this.statement).buildTypes(this.getDatabaseProductVersion());
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        this.checkStatementClosed();
        if (catalog == null || catalog.equals(this.connection.getCatalog())) {
            return new TypeMetadataResultSetBuilder(this.statement).buildUDTs(schemaPattern, typeNamePattern, types);
        }
        return CassandraResultSet.EMPTY_RESULT_SET;
    }

    @Override
    public String getURL() {
        return this.connection.url;
    }

    @Override
    public String getUserName() {
        if (this.connection.username == null) {
            return "";
        }
        return this.connection.username;
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        throw new SQLFeatureNotSupportedException("The Cassandra implementation does not support this method.");
    }

    @Override
    public boolean insertsAreDetected(int type) {
        return false;
    }

    @Override
    public boolean isCatalogAtStart() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean locatorsUpdateCopy() {
        return false;
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() {
        return true;
    }

    @Override
    public boolean nullsAreSortedHigh() {
        return true;
    }

    @Override
    public boolean nullsAreSortedLow() {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) {
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() {
        return true;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() {
        return true;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() {
        return true;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return true;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() {
        return true;
    }

    @Override
    public boolean supportsConvert() {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) {
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() {
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() {
        return false;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsFullOuterJoins() {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() {
        return false;
    }

    @Override
    public boolean supportsGroupBy() {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() {
        return false;
    }

    @Override
    public boolean supportsGroupByUnrelated() {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() {
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() {
        return false;
    }

    @Override
    public boolean supportsLimitedOuterJoins() {
        return false;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() {
        return true;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() {
        return true;
    }

    @Override
    public boolean supportsMultipleOpenResults() {
        return false;
    }

    @Override
    public boolean supportsMultipleResultSets() {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() {
        return false;
    }

    @Override
    public boolean supportsOrderByUnrelated() {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() {
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) {
        return false;
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) {
        return 1 == holdability;
    }

    @Override
    public boolean supportsResultSetType(int type) {
        return 1003 == type;
    }

    @Override
    public boolean supportsSavepoints() {
        return false;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() {
        return true;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() {
        return true;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() {
        return true;
    }

    @Override
    public boolean supportsSelectForUpdate() {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() {
        return false;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInExists() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInIns() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() {
        return false;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) {
        return 0 == level;
    }

    @Override
    public boolean supportsTransactions() {
        return false;
    }

    @Override
    public boolean supportsUnion() {
        return false;
    }

    @Override
    public boolean supportsUnionAll() {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() {
        return false;
    }

    @Override
    public boolean usesLocalFiles() {
        return false;
    }

    private void checkStatementClosed() throws SQLException {
        if (this.statement.isClosed()) {
            this.statement = new CassandraStatement(this.connection);
        }
    }
}

