/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.ing.data.cassandra.jdbc.codec.AbstractCodec;
import com.ing.data.cassandra.jdbc.utils.ByteBufferUtil;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;

public class FloatToDoubleCodec
extends AbstractCodec<Double>
implements TypeCodec<Double> {
    @Nonnull
    public GenericType<Double> getJavaType() {
        return GenericType.DOUBLE;
    }

    @Nonnull
    public DataType getCqlType() {
        return DataTypes.FLOAT;
    }

    public ByteBuffer encode(Double value, @Nonnull ProtocolVersion protocolVersion) {
        if (value == null) {
            return null;
        }
        return ByteBufferUtil.bytes(value.floatValue());
    }

    public Double decode(ByteBuffer bytes, @Nonnull ProtocolVersion protocolVersion) {
        if (bytes == null) {
            return null;
        }
        float value = ByteBufferUtil.toFloat(bytes.duplicate());
        return value;
    }

    @Override
    Double parseNonNull(@Nonnull String value) {
        return Double.valueOf(value);
    }

    @Override
    String formatNonNull(@Nonnull Double value) {
        return String.valueOf(value);
    }
}

