/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc.metadata;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.IndexMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.ing.data.cassandra.jdbc.CassandraMetadataResultSet;
import com.ing.data.cassandra.jdbc.CassandraStatement;
import com.ing.data.cassandra.jdbc.ColumnDefinitions;
import com.ing.data.cassandra.jdbc.metadata.AbstractMetadataResultSetBuilder;
import com.ing.data.cassandra.jdbc.metadata.MetadataResultSet;
import com.ing.data.cassandra.jdbc.metadata.MetadataRow;
import com.ing.data.cassandra.jdbc.types.AbstractJdbcType;
import com.ing.data.cassandra.jdbc.types.TypesMap;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableMetadataResultSetBuilder
extends AbstractMetadataResultSetBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(TableMetadataResultSetBuilder.class);

    public TableMetadataResultSetBuilder(CassandraStatement statement) throws SQLException {
        super(statement);
    }

    public CassandraMetadataResultSet buildTableTypes() throws SQLException {
        ArrayList<MetadataRow> tableTypes = new ArrayList<MetadataRow>();
        MetadataRow.MetadataRowTemplate rowTemplate = new MetadataRow.MetadataRowTemplate(ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("TABLE_TYPE", DataTypes.TEXT));
        tableTypes.add(new MetadataRow().withTemplate(rowTemplate, "TABLE"));
        return CassandraMetadataResultSet.buildFrom(this.statement, new MetadataResultSet(rowTemplate).setRows(tableTypes));
    }

    public CassandraMetadataResultSet buildTables(String schemaPattern, String tableNamePattern) throws SQLException {
        String catalog = this.connection.getCatalog();
        ArrayList<MetadataRow> tables = new ArrayList<MetadataRow>();
        MetadataRow.MetadataRowTemplate rowTemplate = new MetadataRow.MetadataRowTemplate(ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("TABLE_CAT", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("TABLE_SCHEM", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("TABLE_NAME", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("TABLE_TYPE", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("REMARKS", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("TYPE_CAT", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("TYPE_SCHEM", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("TYPE_NAME", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("SELF_REFERENCING_COL_NAME", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("REF_GENERATION", DataTypes.TEXT));
        this.filterBySchemaNamePattern(schemaPattern, keyspaceMetadata -> this.filterByTableNamePattern(tableNamePattern, (KeyspaceMetadata)keyspaceMetadata, tableMetadata -> {
            MetadataRow row = new MetadataRow().withTemplate(rowTemplate, catalog, keyspaceMetadata.getName().asInternal(), tableMetadata.getName().asInternal(), "TABLE", tableMetadata.getOptions().get(CqlIdentifier.fromCql((String)"comment")).toString(), null, null, null, null, null);
            tables.add(row);
        }, null), null);
        tables.sort(Comparator.comparing(row -> ((MetadataRow)row).getString("TABLE_SCHEM")).thenComparing(row -> ((MetadataRow)row).getString("TABLE_NAME")));
        return CassandraMetadataResultSet.buildFrom(this.statement, new MetadataResultSet(rowTemplate).setRows(tables));
    }

    public CassandraMetadataResultSet buildIndexes(String schema, String tableName, boolean unique, boolean approximate) throws SQLException {
        String catalog = this.connection.getCatalog();
        ArrayList<MetadataRow> indexes = new ArrayList<MetadataRow>();
        MetadataRow.MetadataRowTemplate rowTemplate = new MetadataRow.MetadataRowTemplate(ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("TABLE_CAT", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("TABLE_SCHEM", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("TABLE_NAME", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("NON_UNIQUE", DataTypes.BOOLEAN), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("INDEX_QUALIFIER", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("INDEX_NAME", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("TYPE", DataTypes.SMALLINT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("ORDINAL_POSITION", DataTypes.SMALLINT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("COLUMN_NAME", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("ASC_OR_DESC", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("CARDINALITY", DataTypes.INT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("PAGES", DataTypes.INT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("FILTER_CONDITION", DataTypes.TEXT));
        this.filterBySchemaNamePattern(schema, keyspaceMetadata -> this.filterByTableNamePattern(tableName, (KeyspaceMetadata)keyspaceMetadata, tableMetadata -> {
            for (Map.Entry index : tableMetadata.getIndexes().entrySet()) {
                IndexMetadata indexMetadata = (IndexMetadata)index.getValue();
                MetadataRow row = new MetadataRow().withTemplate(rowTemplate, catalog, keyspaceMetadata.getName().asInternal(), tableMetadata.getName().asInternal(), true, catalog, indexMetadata.getName().asInternal(), (short)3, 1, indexMetadata.getTarget(), null, -1, -1, null);
                indexes.add(row);
            }
        }, null), null);
        indexes.sort(Comparator.comparing(row -> row.getString("INDEX_NAME")));
        return CassandraMetadataResultSet.buildFrom(this.statement, new MetadataResultSet(rowTemplate).setRows(indexes));
    }

    public CassandraMetadataResultSet buildPrimaryKeys(String schema, String tableName) throws SQLException {
        String catalog = this.connection.getCatalog();
        ArrayList<MetadataRow> primaryKeys = new ArrayList<MetadataRow>();
        MetadataRow.MetadataRowTemplate rowTemplate = new MetadataRow.MetadataRowTemplate(ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("TABLE_CAT", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("TABLE_SCHEM", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("TABLE_NAME", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("COLUMN_NAME", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("KEY_SEQ", DataTypes.SMALLINT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("PK_NAME", DataTypes.TEXT));
        this.filterBySchemaNamePattern(schema, keyspaceMetadata -> this.filterByTableNamePattern(tableName, (KeyspaceMetadata)keyspaceMetadata, tableMetadata -> {
            int seq = 1;
            for (ColumnMetadata col : tableMetadata.getPrimaryKey()) {
                MetadataRow row = new MetadataRow().withTemplate(rowTemplate, catalog, keyspaceMetadata.getName().asInternal(), tableMetadata.getName().asInternal(), col.getName().asInternal(), seq, null);
                primaryKeys.add(row);
                ++seq;
            }
        }, null), null);
        primaryKeys.sort(Comparator.comparing(row -> row.getString("COLUMN_NAME")));
        return CassandraMetadataResultSet.buildFrom(this.statement, new MetadataResultSet(rowTemplate).setRows(primaryKeys));
    }

    public CassandraMetadataResultSet buildBestRowIdentifier(String schema, String table, int scope) throws SQLException {
        ArrayList<MetadataRow> bestRowIdentifiers = new ArrayList<MetadataRow>();
        MetadataRow.MetadataRowTemplate rowTemplate = new MetadataRow.MetadataRowTemplate(ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("SCOPE", DataTypes.SMALLINT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("COLUMN_NAME", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("DATA_TYPE", DataTypes.INT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("TYPE_NAME", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("COLUMN_SIZE", DataTypes.INT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("BUFFER_LENGTH", DataTypes.INT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("DECIMAL_DIGITS", DataTypes.INT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("PSEUDO_COLUMN", DataTypes.SMALLINT));
        this.filterBySchemaNamePattern(schema, keyspaceMetadata -> this.filterByTableNamePattern(table, (KeyspaceMetadata)keyspaceMetadata, tableMetadata -> {
            for (ColumnMetadata columnMetadata : tableMetadata.getPrimaryKey()) {
                AbstractJdbcType<?> jdbcEquivalentType = TypesMap.getTypeForComparator(columnMetadata.getType().toString());
                int columnSize = -1;
                if (jdbcEquivalentType != null) {
                    columnSize = jdbcEquivalentType.getPrecision(null);
                }
                int jdbcType = 1111;
                try {
                    jdbcType = TypesMap.getTypeForComparator(columnMetadata.getType().toString()).getJdbcType();
                }
                catch (Exception e) {
                    LOG.warn("Unable to get JDBC type for comparator [{}]: {}", (Object)columnMetadata.getType(), (Object)e.getMessage());
                }
                MetadataRow row = new MetadataRow().withTemplate(rowTemplate, (short)scope, columnMetadata.getName().asInternal(), jdbcType, columnMetadata.getType().toString(), columnSize, 0, null, (short)1);
                bestRowIdentifiers.add(row);
            }
        }, null), null);
        return CassandraMetadataResultSet.buildFrom(this.statement, new MetadataResultSet(rowTemplate).setRows(bestRowIdentifiers));
    }
}

