/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.db2z;

import java.sql.Connection;
import java.util.Properties;
import org.flywaydb.community.database.DB2ZDatabaseExtension;
import org.flywaydb.community.database.db2z.DB2ZDatabase;
import org.flywaydb.community.database.db2z.DB2ZJdbcTemplate;
import org.flywaydb.community.database.db2z.DB2ZParser;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.callback.CallbackExecutor;
import org.flywaydb.core.internal.database.DatabaseType;
import org.flywaydb.core.internal.database.base.BaseDatabaseType;
import org.flywaydb.core.internal.database.base.CommunityDatabaseType;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.sqlscript.DefaultSqlScriptExecutor;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutor;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutorFactory;

public class DB2ZDatabaseType
extends BaseDatabaseType
implements CommunityDatabaseType {
    public String getName() {
        return "DB2 for z/OS";
    }

    public int getNullType() {
        return 12;
    }

    public boolean handlesJDBCUrl(String url) {
        return url.startsWith("jdbc:db2:") || url.startsWith("jdbc:p6spy:db2:");
    }

    public String getDriverClass(String url, ClassLoader classLoader) {
        if (url.startsWith("jdbc:p6spy:db2:")) {
            return "com.p6spy.engine.spy.P6SpyDriver";
        }
        return "com.ibm.db2.jcc.DB2Driver";
    }

    public boolean handlesDatabaseProductNameAndVersion(String databaseProductName, String databaseProductVersion, Connection connection) {
        return databaseProductName.startsWith("DB2") && databaseProductVersion.startsWith("DSN");
    }

    public Database createDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        return new DB2ZDatabase(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    public Parser createParser(Configuration configuration, ResourceProvider resourceProvider, ParsingContext parsingContext) {
        return new DB2ZParser(configuration, parsingContext);
    }

    public void setDefaultConnectionProps(String url, Properties props, ClassLoader classLoader) {
        props.put("clientProgramName", "Flyway by Redgate");
        props.put("retrieveMessagesFromServerOnGetMessage", "true");
    }

    public SqlScriptExecutorFactory createSqlScriptExecutorFactory(JdbcConnectionFactory jdbcConnectionFactory, CallbackExecutor callbackExecutor, StatementInterceptor statementInterceptor) {
        boolean supportsBatch;
        boolean finalSupportsBatch = supportsBatch = false;
        DB2ZDatabaseType thisRef = this;
        return (arg_0, arg_1, arg_2, arg_3) -> DB2ZDatabaseType.lambda$createSqlScriptExecutorFactory$0((DatabaseType)thisRef, callbackExecutor, finalSupportsBatch, statementInterceptor, arg_0, arg_1, arg_2, arg_3);
    }

    public int getPriority() {
        return 1;
    }

    public String getPluginVersion(Configuration config) {
        return DB2ZDatabaseExtension.readVersion();
    }

    private static /* synthetic */ SqlScriptExecutor lambda$createSqlScriptExecutorFactory$0(DatabaseType thisRef, CallbackExecutor callbackExecutor, boolean finalSupportsBatch, StatementInterceptor statementInterceptor, Connection connection, boolean undo, boolean batch, boolean outputQueryResults) {
        return new DefaultSqlScriptExecutor((JdbcTemplate)new DB2ZJdbcTemplate(connection, thisRef), callbackExecutor, undo, finalSupportsBatch && batch, outputQueryResults, statementInterceptor);
    }
}

