/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.nc.preparation;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.flywaydb.core.FlywayTelemetryManager;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.resource.LoadableResourceMetadata;
import org.flywaydb.core.experimental.ExperimentalDatabase;
import org.flywaydb.core.experimental.ExperimentalModeUtils;
import org.flywaydb.core.experimental.MetaData;
import org.flywaydb.core.experimental.schemahistory.SchemaHistoryModel;
import org.flywaydb.core.extensibility.Plugin;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.nc.callbacks.CallbackManager;
import org.flywaydb.nc.utils.VerbUtils;

public final class PreparationContext
implements Plugin {
    private ExperimentalDatabase database;
    private SchemaHistoryModel schemaHistoryModel;
    private Collection<LoadableResourceMetadata> resources;
    private MigrationInfo[] migrations;
    private ParsingContext parsingContext;
    private boolean isInitialized;
    private String cacheString;

    public void initialize(Configuration configuration) {
        try {
            this.database = VerbUtils.getExperimentalDatabase(configuration);
            this.parsingContext = new ParsingContext();
            this.parsingContext.populate(this.database, configuration);
            CompletableFuture<Collection> resourcesFuture = CompletableFuture.supplyAsync(() -> VerbUtils.scanForResources(configuration, this.parsingContext));
            this.resources = (Collection)this.getFromFuture(resourcesFuture);
            if (configuration.getInitSql() != null) {
                throw new FlywayException("InitSql is not supported in Native Connectors. Please use the afterConnect callback instead");
            }
            CallbackManager callbackManager = new CallbackManager(configuration, this.resources);
            callbackManager.handleEvent(Event.AFTER_CONNECT, this.database, configuration, this.parsingContext);
            CompletableFuture<SchemaHistoryModel> schemaHistoryModelFuture = CompletableFuture.supplyAsync(() -> VerbUtils.getSchemaHistoryModel(configuration, this.database));
            this.schemaHistoryModel = (SchemaHistoryModel)this.getFromFuture(schemaHistoryModelFuture);
            CompletableFuture.runAsync(() -> ExperimentalModeUtils.logExperimentalDataTelemetry((FlywayTelemetryManager)VerbUtils.getFlywayTelemetryManager(configuration), (MetaData)this.database.getDatabaseMetaData()));
            this.cacheString = this.getCacheString(configuration);
            this.migrations = VerbUtils.getMigrations(this.schemaHistoryModel, (LoadableResourceMetadata[])this.resources.toArray(LoadableResourceMetadata[]::new), configuration);
            this.isInitialized = true;
        }
        catch (SQLException sqlException) {
            throw new FlywayException((Throwable)sqlException);
        }
    }

    private String getCacheString(Configuration configuration) {
        return String.join((CharSequence)",", (CharSequence[])Arrays.stream(configuration.getLocations()).map(Object::toString).toArray(String[]::new)) + configuration.getPlaceholders().entrySet().stream().map(x -> "[" + (String)x.getKey() + "=" + (String)x.getValue() + "]").reduce("", String::concat);
    }

    public void refresh(Configuration configuration) {
        if (this.database.isClosed()) {
            try {
                this.database = VerbUtils.getExperimentalDatabase(configuration);
            }
            catch (SQLException sqlException) {
                throw new FlywayException((Throwable)sqlException);
            }
        }
        this.schemaHistoryModel = VerbUtils.getSchemaHistoryModel(configuration, this.database);
        this.migrations = VerbUtils.getMigrations(this.schemaHistoryModel, (LoadableResourceMetadata[])this.resources.toArray(LoadableResourceMetadata[]::new), configuration);
    }

    public static PreparationContext get(Configuration configuration, boolean cached) {
        PreparationContext preparationContext = (PreparationContext)configuration.getPluginRegister().getPlugin(PreparationContext.class);
        if (cached) {
            preparationContext.refresh(configuration);
        } else {
            preparationContext.initialize(configuration);
        }
        return preparationContext;
    }

    private Object getFromFuture(Future<?> future) {
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            if (e.getCause() != null) {
                throw new FlywayException(e.getCause());
            }
            throw new FlywayException((Throwable)e);
        }
    }

    public ExperimentalDatabase getDatabase() {
        return this.database;
    }

    public SchemaHistoryModel getSchemaHistoryModel() {
        return this.schemaHistoryModel;
    }

    public Collection<LoadableResourceMetadata> getResources() {
        return this.resources;
    }

    public MigrationInfo[] getMigrations() {
        return this.migrations;
    }

    public ParsingContext getParsingContext() {
        return this.parsingContext;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public String getCacheString() {
        return this.cacheString;
    }
}

