/*
 * Decompiled with CFR 0.152.
 */
package com.google.spanner.admin.database.v1;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.Timestamp;
import com.google.protobuf.TimestampOrBuilder;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import com.google.spanner.admin.database.v1.DatabaseDialect;
import com.google.spanner.admin.database.v1.DatabaseOrBuilder;
import com.google.spanner.admin.database.v1.EncryptionConfig;
import com.google.spanner.admin.database.v1.EncryptionConfigOrBuilder;
import com.google.spanner.admin.database.v1.EncryptionInfo;
import com.google.spanner.admin.database.v1.EncryptionInfoOrBuilder;
import com.google.spanner.admin.database.v1.RestoreInfo;
import com.google.spanner.admin.database.v1.RestoreInfoOrBuilder;
import com.google.spanner.admin.database.v1.SpannerDatabaseAdminProto;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Database
extends GeneratedMessageV3
implements DatabaseOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    public static final int NAME_FIELD_NUMBER = 1;
    private volatile Object name_ = "";
    public static final int STATE_FIELD_NUMBER = 2;
    private int state_ = 0;
    public static final int CREATE_TIME_FIELD_NUMBER = 3;
    private Timestamp createTime_;
    public static final int RESTORE_INFO_FIELD_NUMBER = 4;
    private RestoreInfo restoreInfo_;
    public static final int ENCRYPTION_CONFIG_FIELD_NUMBER = 5;
    private EncryptionConfig encryptionConfig_;
    public static final int ENCRYPTION_INFO_FIELD_NUMBER = 8;
    private List<EncryptionInfo> encryptionInfo_;
    public static final int VERSION_RETENTION_PERIOD_FIELD_NUMBER = 6;
    private volatile Object versionRetentionPeriod_ = "";
    public static final int EARLIEST_VERSION_TIME_FIELD_NUMBER = 7;
    private Timestamp earliestVersionTime_;
    public static final int DEFAULT_LEADER_FIELD_NUMBER = 9;
    private volatile Object defaultLeader_ = "";
    public static final int DATABASE_DIALECT_FIELD_NUMBER = 10;
    private int databaseDialect_ = 0;
    public static final int ENABLE_DROP_PROTECTION_FIELD_NUMBER = 11;
    private boolean enableDropProtection_ = false;
    public static final int RECONCILING_FIELD_NUMBER = 12;
    private boolean reconciling_ = false;
    private byte memoizedIsInitialized = (byte)-1;
    private static final Database DEFAULT_INSTANCE = new Database();
    private static final Parser<Database> PARSER = new AbstractParser<Database>(){

        public Database parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = Database.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private Database(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private Database() {
        this.name_ = "";
        this.state_ = 0;
        this.encryptionInfo_ = Collections.emptyList();
        this.versionRetentionPeriod_ = "";
        this.defaultLeader_ = "";
        this.databaseDialect_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new Database();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return SpannerDatabaseAdminProto.internal_static_google_spanner_admin_database_v1_Database_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return SpannerDatabaseAdminProto.internal_static_google_spanner_admin_database_v1_Database_fieldAccessorTable.ensureFieldAccessorsInitialized(Database.class, Builder.class);
    }

    @Override
    public String getName() {
        Object ref = this.name_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.name_ = s;
        return s;
    }

    @Override
    public ByteString getNameBytes() {
        Object ref = this.name_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.name_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getStateValue() {
        return this.state_;
    }

    @Override
    public State getState() {
        State result = State.forNumber(this.state_);
        return result == null ? State.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasCreateTime() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public Timestamp getCreateTime() {
        return this.createTime_ == null ? Timestamp.getDefaultInstance() : this.createTime_;
    }

    @Override
    public TimestampOrBuilder getCreateTimeOrBuilder() {
        return this.createTime_ == null ? Timestamp.getDefaultInstance() : this.createTime_;
    }

    @Override
    public boolean hasRestoreInfo() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public RestoreInfo getRestoreInfo() {
        return this.restoreInfo_ == null ? RestoreInfo.getDefaultInstance() : this.restoreInfo_;
    }

    @Override
    public RestoreInfoOrBuilder getRestoreInfoOrBuilder() {
        return this.restoreInfo_ == null ? RestoreInfo.getDefaultInstance() : this.restoreInfo_;
    }

    @Override
    public boolean hasEncryptionConfig() {
        return (this.bitField0_ & 4) != 0;
    }

    @Override
    public EncryptionConfig getEncryptionConfig() {
        return this.encryptionConfig_ == null ? EncryptionConfig.getDefaultInstance() : this.encryptionConfig_;
    }

    @Override
    public EncryptionConfigOrBuilder getEncryptionConfigOrBuilder() {
        return this.encryptionConfig_ == null ? EncryptionConfig.getDefaultInstance() : this.encryptionConfig_;
    }

    @Override
    public List<EncryptionInfo> getEncryptionInfoList() {
        return this.encryptionInfo_;
    }

    @Override
    public List<? extends EncryptionInfoOrBuilder> getEncryptionInfoOrBuilderList() {
        return this.encryptionInfo_;
    }

    @Override
    public int getEncryptionInfoCount() {
        return this.encryptionInfo_.size();
    }

    @Override
    public EncryptionInfo getEncryptionInfo(int index) {
        return this.encryptionInfo_.get(index);
    }

    @Override
    public EncryptionInfoOrBuilder getEncryptionInfoOrBuilder(int index) {
        return this.encryptionInfo_.get(index);
    }

    @Override
    public String getVersionRetentionPeriod() {
        Object ref = this.versionRetentionPeriod_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.versionRetentionPeriod_ = s;
        return s;
    }

    @Override
    public ByteString getVersionRetentionPeriodBytes() {
        Object ref = this.versionRetentionPeriod_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.versionRetentionPeriod_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasEarliestVersionTime() {
        return (this.bitField0_ & 8) != 0;
    }

    @Override
    public Timestamp getEarliestVersionTime() {
        return this.earliestVersionTime_ == null ? Timestamp.getDefaultInstance() : this.earliestVersionTime_;
    }

    @Override
    public TimestampOrBuilder getEarliestVersionTimeOrBuilder() {
        return this.earliestVersionTime_ == null ? Timestamp.getDefaultInstance() : this.earliestVersionTime_;
    }

    @Override
    public String getDefaultLeader() {
        Object ref = this.defaultLeader_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.defaultLeader_ = s;
        return s;
    }

    @Override
    public ByteString getDefaultLeaderBytes() {
        Object ref = this.defaultLeader_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.defaultLeader_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getDatabaseDialectValue() {
        return this.databaseDialect_;
    }

    @Override
    public DatabaseDialect getDatabaseDialect() {
        DatabaseDialect result = DatabaseDialect.forNumber(this.databaseDialect_);
        return result == null ? DatabaseDialect.UNRECOGNIZED : result;
    }

    @Override
    public boolean getEnableDropProtection() {
        return this.enableDropProtection_;
    }

    @Override
    public boolean getReconciling() {
        return this.reconciling_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.name_);
        }
        if (this.state_ != State.STATE_UNSPECIFIED.getNumber()) {
            output.writeEnum(2, this.state_);
        }
        if ((this.bitField0_ & 1) != 0) {
            output.writeMessage(3, (MessageLite)this.getCreateTime());
        }
        if ((this.bitField0_ & 2) != 0) {
            output.writeMessage(4, (MessageLite)this.getRestoreInfo());
        }
        if ((this.bitField0_ & 4) != 0) {
            output.writeMessage(5, (MessageLite)this.getEncryptionConfig());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.versionRetentionPeriod_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)6, (Object)this.versionRetentionPeriod_);
        }
        if ((this.bitField0_ & 8) != 0) {
            output.writeMessage(7, (MessageLite)this.getEarliestVersionTime());
        }
        for (int i = 0; i < this.encryptionInfo_.size(); ++i) {
            output.writeMessage(8, (MessageLite)this.encryptionInfo_.get(i));
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.defaultLeader_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)9, (Object)this.defaultLeader_);
        }
        if (this.databaseDialect_ != DatabaseDialect.DATABASE_DIALECT_UNSPECIFIED.getNumber()) {
            output.writeEnum(10, this.databaseDialect_);
        }
        if (this.enableDropProtection_) {
            output.writeBool(11, this.enableDropProtection_);
        }
        if (this.reconciling_) {
            output.writeBool(12, this.reconciling_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.name_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.name_);
        }
        if (this.state_ != State.STATE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)2, (int)this.state_);
        }
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeMessageSize((int)3, (MessageLite)this.getCreateTime());
        }
        if ((this.bitField0_ & 2) != 0) {
            size += CodedOutputStream.computeMessageSize((int)4, (MessageLite)this.getRestoreInfo());
        }
        if ((this.bitField0_ & 4) != 0) {
            size += CodedOutputStream.computeMessageSize((int)5, (MessageLite)this.getEncryptionConfig());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.versionRetentionPeriod_)) {
            size += GeneratedMessageV3.computeStringSize((int)6, (Object)this.versionRetentionPeriod_);
        }
        if ((this.bitField0_ & 8) != 0) {
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)this.getEarliestVersionTime());
        }
        for (int i = 0; i < this.encryptionInfo_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)8, (MessageLite)((MessageLite)this.encryptionInfo_.get(i)));
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.defaultLeader_)) {
            size += GeneratedMessageV3.computeStringSize((int)9, (Object)this.defaultLeader_);
        }
        if (this.databaseDialect_ != DatabaseDialect.DATABASE_DIALECT_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)10, (int)this.databaseDialect_);
        }
        if (this.enableDropProtection_) {
            size += CodedOutputStream.computeBoolSize((int)11, (boolean)this.enableDropProtection_);
        }
        if (this.reconciling_) {
            size += CodedOutputStream.computeBoolSize((int)12, (boolean)this.reconciling_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Database)) {
            return super.equals(obj);
        }
        Database other = (Database)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (this.state_ != other.state_) {
            return false;
        }
        if (this.hasCreateTime() != other.hasCreateTime()) {
            return false;
        }
        if (this.hasCreateTime() && !this.getCreateTime().equals((Object)other.getCreateTime())) {
            return false;
        }
        if (this.hasRestoreInfo() != other.hasRestoreInfo()) {
            return false;
        }
        if (this.hasRestoreInfo() && !this.getRestoreInfo().equals(other.getRestoreInfo())) {
            return false;
        }
        if (this.hasEncryptionConfig() != other.hasEncryptionConfig()) {
            return false;
        }
        if (this.hasEncryptionConfig() && !this.getEncryptionConfig().equals(other.getEncryptionConfig())) {
            return false;
        }
        if (!this.getEncryptionInfoList().equals(other.getEncryptionInfoList())) {
            return false;
        }
        if (!this.getVersionRetentionPeriod().equals(other.getVersionRetentionPeriod())) {
            return false;
        }
        if (this.hasEarliestVersionTime() != other.hasEarliestVersionTime()) {
            return false;
        }
        if (this.hasEarliestVersionTime() && !this.getEarliestVersionTime().equals((Object)other.getEarliestVersionTime())) {
            return false;
        }
        if (!this.getDefaultLeader().equals(other.getDefaultLeader())) {
            return false;
        }
        if (this.databaseDialect_ != other.databaseDialect_) {
            return false;
        }
        if (this.getEnableDropProtection() != other.getEnableDropProtection()) {
            return false;
        }
        if (this.getReconciling() != other.getReconciling()) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + Database.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getName().hashCode();
        hash = 37 * hash + 2;
        hash = 53 * hash + this.state_;
        if (this.hasCreateTime()) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.getCreateTime().hashCode();
        }
        if (this.hasRestoreInfo()) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getRestoreInfo().hashCode();
        }
        if (this.hasEncryptionConfig()) {
            hash = 37 * hash + 5;
            hash = 53 * hash + this.getEncryptionConfig().hashCode();
        }
        if (this.getEncryptionInfoCount() > 0) {
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getEncryptionInfoList().hashCode();
        }
        hash = 37 * hash + 6;
        hash = 53 * hash + this.getVersionRetentionPeriod().hashCode();
        if (this.hasEarliestVersionTime()) {
            hash = 37 * hash + 7;
            hash = 53 * hash + this.getEarliestVersionTime().hashCode();
        }
        hash = 37 * hash + 9;
        hash = 53 * hash + this.getDefaultLeader().hashCode();
        hash = 37 * hash + 10;
        hash = 53 * hash + this.databaseDialect_;
        hash = 37 * hash + 11;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getEnableDropProtection());
        hash = 37 * hash + 12;
        hash = 53 * hash + Internal.hashBoolean((boolean)this.getReconciling());
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static Database parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (Database)PARSER.parseFrom(data);
    }

    public static Database parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Database)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Database parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (Database)PARSER.parseFrom(data);
    }

    public static Database parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Database)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Database parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (Database)PARSER.parseFrom(data);
    }

    public static Database parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Database)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Database parseFrom(InputStream input) throws IOException {
        return (Database)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static Database parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Database)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Database parseDelimitedFrom(InputStream input) throws IOException {
        return (Database)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static Database parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Database)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Database parseFrom(CodedInputStream input) throws IOException {
        return (Database)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static Database parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Database)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return Database.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Database prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static Database getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<Database> parser() {
        return PARSER;
    }

    public Parser<Database> getParserForType() {
        return PARSER;
    }

    public Database getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements DatabaseOrBuilder {
        private int bitField0_;
        private Object name_ = "";
        private int state_ = 0;
        private Timestamp createTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> createTimeBuilder_;
        private RestoreInfo restoreInfo_;
        private SingleFieldBuilderV3<RestoreInfo, RestoreInfo.Builder, RestoreInfoOrBuilder> restoreInfoBuilder_;
        private EncryptionConfig encryptionConfig_;
        private SingleFieldBuilderV3<EncryptionConfig, EncryptionConfig.Builder, EncryptionConfigOrBuilder> encryptionConfigBuilder_;
        private List<EncryptionInfo> encryptionInfo_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<EncryptionInfo, EncryptionInfo.Builder, EncryptionInfoOrBuilder> encryptionInfoBuilder_;
        private Object versionRetentionPeriod_ = "";
        private Timestamp earliestVersionTime_;
        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> earliestVersionTimeBuilder_;
        private Object defaultLeader_ = "";
        private int databaseDialect_ = 0;
        private boolean enableDropProtection_;
        private boolean reconciling_;

        public static final Descriptors.Descriptor getDescriptor() {
            return SpannerDatabaseAdminProto.internal_static_google_spanner_admin_database_v1_Database_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return SpannerDatabaseAdminProto.internal_static_google_spanner_admin_database_v1_Database_fieldAccessorTable.ensureFieldAccessorsInitialized(Database.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getCreateTimeFieldBuilder();
                this.getRestoreInfoFieldBuilder();
                this.getEncryptionConfigFieldBuilder();
                this.getEncryptionInfoFieldBuilder();
                this.getEarliestVersionTimeFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.name_ = "";
            this.state_ = 0;
            this.createTime_ = null;
            if (this.createTimeBuilder_ != null) {
                this.createTimeBuilder_.dispose();
                this.createTimeBuilder_ = null;
            }
            this.restoreInfo_ = null;
            if (this.restoreInfoBuilder_ != null) {
                this.restoreInfoBuilder_.dispose();
                this.restoreInfoBuilder_ = null;
            }
            this.encryptionConfig_ = null;
            if (this.encryptionConfigBuilder_ != null) {
                this.encryptionConfigBuilder_.dispose();
                this.encryptionConfigBuilder_ = null;
            }
            if (this.encryptionInfoBuilder_ == null) {
                this.encryptionInfo_ = Collections.emptyList();
            } else {
                this.encryptionInfo_ = null;
                this.encryptionInfoBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFDF;
            this.versionRetentionPeriod_ = "";
            this.earliestVersionTime_ = null;
            if (this.earliestVersionTimeBuilder_ != null) {
                this.earliestVersionTimeBuilder_.dispose();
                this.earliestVersionTimeBuilder_ = null;
            }
            this.defaultLeader_ = "";
            this.databaseDialect_ = 0;
            this.enableDropProtection_ = false;
            this.reconciling_ = false;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return SpannerDatabaseAdminProto.internal_static_google_spanner_admin_database_v1_Database_descriptor;
        }

        public Database getDefaultInstanceForType() {
            return Database.getDefaultInstance();
        }

        public Database build() {
            Database result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public Database buildPartial() {
            Database result = new Database(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(Database result) {
            if (this.encryptionInfoBuilder_ == null) {
                if ((this.bitField0_ & 0x20) != 0) {
                    this.encryptionInfo_ = Collections.unmodifiableList(this.encryptionInfo_);
                    this.bitField0_ &= 0xFFFFFFDF;
                }
                result.encryptionInfo_ = this.encryptionInfo_;
            } else {
                result.encryptionInfo_ = this.encryptionInfoBuilder_.build();
            }
        }

        private void buildPartial0(Database result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.name_ = this.name_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.state_ = this.state_;
            }
            int to_bitField0_ = 0;
            if ((from_bitField0_ & 4) != 0) {
                result.createTime_ = this.createTimeBuilder_ == null ? this.createTime_ : (Timestamp)this.createTimeBuilder_.build();
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.restoreInfo_ = this.restoreInfoBuilder_ == null ? this.restoreInfo_ : (RestoreInfo)this.restoreInfoBuilder_.build();
                to_bitField0_ |= 2;
            }
            if ((from_bitField0_ & 0x10) != 0) {
                result.encryptionConfig_ = this.encryptionConfigBuilder_ == null ? this.encryptionConfig_ : (EncryptionConfig)this.encryptionConfigBuilder_.build();
                to_bitField0_ |= 4;
            }
            if ((from_bitField0_ & 0x40) != 0) {
                result.versionRetentionPeriod_ = this.versionRetentionPeriod_;
            }
            if ((from_bitField0_ & 0x80) != 0) {
                result.earliestVersionTime_ = this.earliestVersionTimeBuilder_ == null ? this.earliestVersionTime_ : (Timestamp)this.earliestVersionTimeBuilder_.build();
                to_bitField0_ |= 8;
            }
            if ((from_bitField0_ & 0x100) != 0) {
                result.defaultLeader_ = this.defaultLeader_;
            }
            if ((from_bitField0_ & 0x200) != 0) {
                result.databaseDialect_ = this.databaseDialect_;
            }
            if ((from_bitField0_ & 0x400) != 0) {
                result.enableDropProtection_ = this.enableDropProtection_;
            }
            if ((from_bitField0_ & 0x800) != 0) {
                result.reconciling_ = this.reconciling_;
            }
            result.bitField0_ |= to_bitField0_;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof Database) {
                return this.mergeFrom((Database)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(Database other) {
            if (other == Database.getDefaultInstance()) {
                return this;
            }
            if (!other.getName().isEmpty()) {
                this.name_ = other.name_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (other.state_ != 0) {
                this.setStateValue(other.getStateValue());
            }
            if (other.hasCreateTime()) {
                this.mergeCreateTime(other.getCreateTime());
            }
            if (other.hasRestoreInfo()) {
                this.mergeRestoreInfo(other.getRestoreInfo());
            }
            if (other.hasEncryptionConfig()) {
                this.mergeEncryptionConfig(other.getEncryptionConfig());
            }
            if (this.encryptionInfoBuilder_ == null) {
                if (!other.encryptionInfo_.isEmpty()) {
                    if (this.encryptionInfo_.isEmpty()) {
                        this.encryptionInfo_ = other.encryptionInfo_;
                        this.bitField0_ &= 0xFFFFFFDF;
                    } else {
                        this.ensureEncryptionInfoIsMutable();
                        this.encryptionInfo_.addAll(other.encryptionInfo_);
                    }
                    this.onChanged();
                }
            } else if (!other.encryptionInfo_.isEmpty()) {
                if (this.encryptionInfoBuilder_.isEmpty()) {
                    this.encryptionInfoBuilder_.dispose();
                    this.encryptionInfoBuilder_ = null;
                    this.encryptionInfo_ = other.encryptionInfo_;
                    this.bitField0_ &= 0xFFFFFFDF;
                    this.encryptionInfoBuilder_ = alwaysUseFieldBuilders ? this.getEncryptionInfoFieldBuilder() : null;
                } else {
                    this.encryptionInfoBuilder_.addAllMessages((Iterable)other.encryptionInfo_);
                }
            }
            if (!other.getVersionRetentionPeriod().isEmpty()) {
                this.versionRetentionPeriod_ = other.versionRetentionPeriod_;
                this.bitField0_ |= 0x40;
                this.onChanged();
            }
            if (other.hasEarliestVersionTime()) {
                this.mergeEarliestVersionTime(other.getEarliestVersionTime());
            }
            if (!other.getDefaultLeader().isEmpty()) {
                this.defaultLeader_ = other.defaultLeader_;
                this.bitField0_ |= 0x100;
                this.onChanged();
            }
            if (other.databaseDialect_ != 0) {
                this.setDatabaseDialectValue(other.getDatabaseDialectValue());
            }
            if (other.getEnableDropProtection()) {
                this.setEnableDropProtection(other.getEnableDropProtection());
            }
            if (other.getReconciling()) {
                this.setReconciling(other.getReconciling());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block20: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block20;
                        }
                        case 10: {
                            this.name_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block20;
                        }
                        case 16: {
                            this.state_ = input.readEnum();
                            this.bitField0_ |= 2;
                            continue block20;
                        }
                        case 26: {
                            input.readMessage((MessageLite.Builder)this.getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 4;
                            continue block20;
                        }
                        case 34: {
                            input.readMessage((MessageLite.Builder)this.getRestoreInfoFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 8;
                            continue block20;
                        }
                        case 42: {
                            input.readMessage((MessageLite.Builder)this.getEncryptionConfigFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x10;
                            continue block20;
                        }
                        case 50: {
                            this.versionRetentionPeriod_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x40;
                            continue block20;
                        }
                        case 58: {
                            input.readMessage((MessageLite.Builder)this.getEarliestVersionTimeFieldBuilder().getBuilder(), extensionRegistry);
                            this.bitField0_ |= 0x80;
                            continue block20;
                        }
                        case 66: {
                            EncryptionInfo m = (EncryptionInfo)input.readMessage(EncryptionInfo.parser(), extensionRegistry);
                            if (this.encryptionInfoBuilder_ == null) {
                                this.ensureEncryptionInfoIsMutable();
                                this.encryptionInfo_.add(m);
                                continue block20;
                            }
                            this.encryptionInfoBuilder_.addMessage((AbstractMessage)m);
                            continue block20;
                        }
                        case 74: {
                            this.defaultLeader_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 0x100;
                            continue block20;
                        }
                        case 80: {
                            this.databaseDialect_ = input.readEnum();
                            this.bitField0_ |= 0x200;
                            continue block20;
                        }
                        case 88: {
                            this.enableDropProtection_ = input.readBool();
                            this.bitField0_ |= 0x400;
                            continue block20;
                        }
                        case 96: {
                            this.reconciling_ = input.readBool();
                            this.bitField0_ |= 0x800;
                            continue block20;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.name_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.name_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearName() {
            this.name_ = Database.getDefaultInstance().getName();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Database.checkByteStringIsUtf8((ByteString)value);
            this.name_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public int getStateValue() {
            return this.state_;
        }

        public Builder setStateValue(int value) {
            this.state_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public State getState() {
            State result = State.forNumber(this.state_);
            return result == null ? State.UNRECOGNIZED : result;
        }

        public Builder setState(State value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 2;
            this.state_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearState() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.state_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasCreateTime() {
            return (this.bitField0_ & 4) != 0;
        }

        @Override
        public Timestamp getCreateTime() {
            if (this.createTimeBuilder_ == null) {
                return this.createTime_ == null ? Timestamp.getDefaultInstance() : this.createTime_;
            }
            return (Timestamp)this.createTimeBuilder_.getMessage();
        }

        public Builder setCreateTime(Timestamp value) {
            if (this.createTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.createTime_ = value;
            } else {
                this.createTimeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder setCreateTime(Timestamp.Builder builderForValue) {
            if (this.createTimeBuilder_ == null) {
                this.createTime_ = builderForValue.build();
            } else {
                this.createTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder mergeCreateTime(Timestamp value) {
            if (this.createTimeBuilder_ == null) {
                if ((this.bitField0_ & 4) != 0 && this.createTime_ != null && this.createTime_ != Timestamp.getDefaultInstance()) {
                    this.getCreateTimeBuilder().mergeFrom(value);
                } else {
                    this.createTime_ = value;
                }
            } else {
                this.createTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.createTime_ != null) {
                this.bitField0_ |= 4;
                this.onChanged();
            }
            return this;
        }

        public Builder clearCreateTime() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.createTime_ = null;
            if (this.createTimeBuilder_ != null) {
                this.createTimeBuilder_.dispose();
                this.createTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getCreateTimeBuilder() {
            this.bitField0_ |= 4;
            this.onChanged();
            return (Timestamp.Builder)this.getCreateTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getCreateTimeOrBuilder() {
            if (this.createTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.createTimeBuilder_.getMessageOrBuilder();
            }
            return this.createTime_ == null ? Timestamp.getDefaultInstance() : this.createTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getCreateTimeFieldBuilder() {
            if (this.createTimeBuilder_ == null) {
                this.createTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getCreateTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.createTime_ = null;
            }
            return this.createTimeBuilder_;
        }

        @Override
        public boolean hasRestoreInfo() {
            return (this.bitField0_ & 8) != 0;
        }

        @Override
        public RestoreInfo getRestoreInfo() {
            if (this.restoreInfoBuilder_ == null) {
                return this.restoreInfo_ == null ? RestoreInfo.getDefaultInstance() : this.restoreInfo_;
            }
            return (RestoreInfo)this.restoreInfoBuilder_.getMessage();
        }

        public Builder setRestoreInfo(RestoreInfo value) {
            if (this.restoreInfoBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.restoreInfo_ = value;
            } else {
                this.restoreInfoBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder setRestoreInfo(RestoreInfo.Builder builderForValue) {
            if (this.restoreInfoBuilder_ == null) {
                this.restoreInfo_ = builderForValue.build();
            } else {
                this.restoreInfoBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder mergeRestoreInfo(RestoreInfo value) {
            if (this.restoreInfoBuilder_ == null) {
                if ((this.bitField0_ & 8) != 0 && this.restoreInfo_ != null && this.restoreInfo_ != RestoreInfo.getDefaultInstance()) {
                    this.getRestoreInfoBuilder().mergeFrom(value);
                } else {
                    this.restoreInfo_ = value;
                }
            } else {
                this.restoreInfoBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.restoreInfo_ != null) {
                this.bitField0_ |= 8;
                this.onChanged();
            }
            return this;
        }

        public Builder clearRestoreInfo() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.restoreInfo_ = null;
            if (this.restoreInfoBuilder_ != null) {
                this.restoreInfoBuilder_.dispose();
                this.restoreInfoBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public RestoreInfo.Builder getRestoreInfoBuilder() {
            this.bitField0_ |= 8;
            this.onChanged();
            return (RestoreInfo.Builder)this.getRestoreInfoFieldBuilder().getBuilder();
        }

        @Override
        public RestoreInfoOrBuilder getRestoreInfoOrBuilder() {
            if (this.restoreInfoBuilder_ != null) {
                return (RestoreInfoOrBuilder)this.restoreInfoBuilder_.getMessageOrBuilder();
            }
            return this.restoreInfo_ == null ? RestoreInfo.getDefaultInstance() : this.restoreInfo_;
        }

        private SingleFieldBuilderV3<RestoreInfo, RestoreInfo.Builder, RestoreInfoOrBuilder> getRestoreInfoFieldBuilder() {
            if (this.restoreInfoBuilder_ == null) {
                this.restoreInfoBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getRestoreInfo(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.restoreInfo_ = null;
            }
            return this.restoreInfoBuilder_;
        }

        @Override
        public boolean hasEncryptionConfig() {
            return (this.bitField0_ & 0x10) != 0;
        }

        @Override
        public EncryptionConfig getEncryptionConfig() {
            if (this.encryptionConfigBuilder_ == null) {
                return this.encryptionConfig_ == null ? EncryptionConfig.getDefaultInstance() : this.encryptionConfig_;
            }
            return (EncryptionConfig)this.encryptionConfigBuilder_.getMessage();
        }

        public Builder setEncryptionConfig(EncryptionConfig value) {
            if (this.encryptionConfigBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.encryptionConfig_ = value;
            } else {
                this.encryptionConfigBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder setEncryptionConfig(EncryptionConfig.Builder builderForValue) {
            if (this.encryptionConfigBuilder_ == null) {
                this.encryptionConfig_ = builderForValue.build();
            } else {
                this.encryptionConfigBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x10;
            this.onChanged();
            return this;
        }

        public Builder mergeEncryptionConfig(EncryptionConfig value) {
            if (this.encryptionConfigBuilder_ == null) {
                if ((this.bitField0_ & 0x10) != 0 && this.encryptionConfig_ != null && this.encryptionConfig_ != EncryptionConfig.getDefaultInstance()) {
                    this.getEncryptionConfigBuilder().mergeFrom(value);
                } else {
                    this.encryptionConfig_ = value;
                }
            } else {
                this.encryptionConfigBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.encryptionConfig_ != null) {
                this.bitField0_ |= 0x10;
                this.onChanged();
            }
            return this;
        }

        public Builder clearEncryptionConfig() {
            this.bitField0_ &= 0xFFFFFFEF;
            this.encryptionConfig_ = null;
            if (this.encryptionConfigBuilder_ != null) {
                this.encryptionConfigBuilder_.dispose();
                this.encryptionConfigBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public EncryptionConfig.Builder getEncryptionConfigBuilder() {
            this.bitField0_ |= 0x10;
            this.onChanged();
            return (EncryptionConfig.Builder)this.getEncryptionConfigFieldBuilder().getBuilder();
        }

        @Override
        public EncryptionConfigOrBuilder getEncryptionConfigOrBuilder() {
            if (this.encryptionConfigBuilder_ != null) {
                return (EncryptionConfigOrBuilder)this.encryptionConfigBuilder_.getMessageOrBuilder();
            }
            return this.encryptionConfig_ == null ? EncryptionConfig.getDefaultInstance() : this.encryptionConfig_;
        }

        private SingleFieldBuilderV3<EncryptionConfig, EncryptionConfig.Builder, EncryptionConfigOrBuilder> getEncryptionConfigFieldBuilder() {
            if (this.encryptionConfigBuilder_ == null) {
                this.encryptionConfigBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getEncryptionConfig(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.encryptionConfig_ = null;
            }
            return this.encryptionConfigBuilder_;
        }

        private void ensureEncryptionInfoIsMutable() {
            if ((this.bitField0_ & 0x20) == 0) {
                this.encryptionInfo_ = new ArrayList<EncryptionInfo>(this.encryptionInfo_);
                this.bitField0_ |= 0x20;
            }
        }

        @Override
        public List<EncryptionInfo> getEncryptionInfoList() {
            if (this.encryptionInfoBuilder_ == null) {
                return Collections.unmodifiableList(this.encryptionInfo_);
            }
            return this.encryptionInfoBuilder_.getMessageList();
        }

        @Override
        public int getEncryptionInfoCount() {
            if (this.encryptionInfoBuilder_ == null) {
                return this.encryptionInfo_.size();
            }
            return this.encryptionInfoBuilder_.getCount();
        }

        @Override
        public EncryptionInfo getEncryptionInfo(int index) {
            if (this.encryptionInfoBuilder_ == null) {
                return this.encryptionInfo_.get(index);
            }
            return (EncryptionInfo)this.encryptionInfoBuilder_.getMessage(index);
        }

        public Builder setEncryptionInfo(int index, EncryptionInfo value) {
            if (this.encryptionInfoBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureEncryptionInfoIsMutable();
                this.encryptionInfo_.set(index, value);
                this.onChanged();
            } else {
                this.encryptionInfoBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setEncryptionInfo(int index, EncryptionInfo.Builder builderForValue) {
            if (this.encryptionInfoBuilder_ == null) {
                this.ensureEncryptionInfoIsMutable();
                this.encryptionInfo_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.encryptionInfoBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addEncryptionInfo(EncryptionInfo value) {
            if (this.encryptionInfoBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureEncryptionInfoIsMutable();
                this.encryptionInfo_.add(value);
                this.onChanged();
            } else {
                this.encryptionInfoBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addEncryptionInfo(int index, EncryptionInfo value) {
            if (this.encryptionInfoBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureEncryptionInfoIsMutable();
                this.encryptionInfo_.add(index, value);
                this.onChanged();
            } else {
                this.encryptionInfoBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addEncryptionInfo(EncryptionInfo.Builder builderForValue) {
            if (this.encryptionInfoBuilder_ == null) {
                this.ensureEncryptionInfoIsMutable();
                this.encryptionInfo_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.encryptionInfoBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addEncryptionInfo(int index, EncryptionInfo.Builder builderForValue) {
            if (this.encryptionInfoBuilder_ == null) {
                this.ensureEncryptionInfoIsMutable();
                this.encryptionInfo_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.encryptionInfoBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllEncryptionInfo(Iterable<? extends EncryptionInfo> values) {
            if (this.encryptionInfoBuilder_ == null) {
                this.ensureEncryptionInfoIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.encryptionInfo_);
                this.onChanged();
            } else {
                this.encryptionInfoBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearEncryptionInfo() {
            if (this.encryptionInfoBuilder_ == null) {
                this.encryptionInfo_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFDF;
                this.onChanged();
            } else {
                this.encryptionInfoBuilder_.clear();
            }
            return this;
        }

        public Builder removeEncryptionInfo(int index) {
            if (this.encryptionInfoBuilder_ == null) {
                this.ensureEncryptionInfoIsMutable();
                this.encryptionInfo_.remove(index);
                this.onChanged();
            } else {
                this.encryptionInfoBuilder_.remove(index);
            }
            return this;
        }

        public EncryptionInfo.Builder getEncryptionInfoBuilder(int index) {
            return (EncryptionInfo.Builder)this.getEncryptionInfoFieldBuilder().getBuilder(index);
        }

        @Override
        public EncryptionInfoOrBuilder getEncryptionInfoOrBuilder(int index) {
            if (this.encryptionInfoBuilder_ == null) {
                return this.encryptionInfo_.get(index);
            }
            return (EncryptionInfoOrBuilder)this.encryptionInfoBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends EncryptionInfoOrBuilder> getEncryptionInfoOrBuilderList() {
            if (this.encryptionInfoBuilder_ != null) {
                return this.encryptionInfoBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.encryptionInfo_);
        }

        public EncryptionInfo.Builder addEncryptionInfoBuilder() {
            return (EncryptionInfo.Builder)this.getEncryptionInfoFieldBuilder().addBuilder((AbstractMessage)EncryptionInfo.getDefaultInstance());
        }

        public EncryptionInfo.Builder addEncryptionInfoBuilder(int index) {
            return (EncryptionInfo.Builder)this.getEncryptionInfoFieldBuilder().addBuilder(index, (AbstractMessage)EncryptionInfo.getDefaultInstance());
        }

        public List<EncryptionInfo.Builder> getEncryptionInfoBuilderList() {
            return this.getEncryptionInfoFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<EncryptionInfo, EncryptionInfo.Builder, EncryptionInfoOrBuilder> getEncryptionInfoFieldBuilder() {
            if (this.encryptionInfoBuilder_ == null) {
                this.encryptionInfoBuilder_ = new RepeatedFieldBuilderV3(this.encryptionInfo_, (this.bitField0_ & 0x20) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.encryptionInfo_ = null;
            }
            return this.encryptionInfoBuilder_;
        }

        @Override
        public String getVersionRetentionPeriod() {
            Object ref = this.versionRetentionPeriod_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.versionRetentionPeriod_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getVersionRetentionPeriodBytes() {
            Object ref = this.versionRetentionPeriod_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.versionRetentionPeriod_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setVersionRetentionPeriod(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.versionRetentionPeriod_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        public Builder clearVersionRetentionPeriod() {
            this.versionRetentionPeriod_ = Database.getDefaultInstance().getVersionRetentionPeriod();
            this.bitField0_ &= 0xFFFFFFBF;
            this.onChanged();
            return this;
        }

        public Builder setVersionRetentionPeriodBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Database.checkByteStringIsUtf8((ByteString)value);
            this.versionRetentionPeriod_ = value;
            this.bitField0_ |= 0x40;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasEarliestVersionTime() {
            return (this.bitField0_ & 0x80) != 0;
        }

        @Override
        public Timestamp getEarliestVersionTime() {
            if (this.earliestVersionTimeBuilder_ == null) {
                return this.earliestVersionTime_ == null ? Timestamp.getDefaultInstance() : this.earliestVersionTime_;
            }
            return (Timestamp)this.earliestVersionTimeBuilder_.getMessage();
        }

        public Builder setEarliestVersionTime(Timestamp value) {
            if (this.earliestVersionTimeBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.earliestVersionTime_ = value;
            } else {
                this.earliestVersionTimeBuilder_.setMessage((AbstractMessage)value);
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder setEarliestVersionTime(Timestamp.Builder builderForValue) {
            if (this.earliestVersionTimeBuilder_ == null) {
                this.earliestVersionTime_ = builderForValue.build();
            } else {
                this.earliestVersionTimeBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.bitField0_ |= 0x80;
            this.onChanged();
            return this;
        }

        public Builder mergeEarliestVersionTime(Timestamp value) {
            if (this.earliestVersionTimeBuilder_ == null) {
                if ((this.bitField0_ & 0x80) != 0 && this.earliestVersionTime_ != null && this.earliestVersionTime_ != Timestamp.getDefaultInstance()) {
                    this.getEarliestVersionTimeBuilder().mergeFrom(value);
                } else {
                    this.earliestVersionTime_ = value;
                }
            } else {
                this.earliestVersionTimeBuilder_.mergeFrom((AbstractMessage)value);
            }
            if (this.earliestVersionTime_ != null) {
                this.bitField0_ |= 0x80;
                this.onChanged();
            }
            return this;
        }

        public Builder clearEarliestVersionTime() {
            this.bitField0_ &= 0xFFFFFF7F;
            this.earliestVersionTime_ = null;
            if (this.earliestVersionTimeBuilder_ != null) {
                this.earliestVersionTimeBuilder_.dispose();
                this.earliestVersionTimeBuilder_ = null;
            }
            this.onChanged();
            return this;
        }

        public Timestamp.Builder getEarliestVersionTimeBuilder() {
            this.bitField0_ |= 0x80;
            this.onChanged();
            return (Timestamp.Builder)this.getEarliestVersionTimeFieldBuilder().getBuilder();
        }

        @Override
        public TimestampOrBuilder getEarliestVersionTimeOrBuilder() {
            if (this.earliestVersionTimeBuilder_ != null) {
                return (TimestampOrBuilder)this.earliestVersionTimeBuilder_.getMessageOrBuilder();
            }
            return this.earliestVersionTime_ == null ? Timestamp.getDefaultInstance() : this.earliestVersionTime_;
        }

        private SingleFieldBuilderV3<Timestamp, Timestamp.Builder, TimestampOrBuilder> getEarliestVersionTimeFieldBuilder() {
            if (this.earliestVersionTimeBuilder_ == null) {
                this.earliestVersionTimeBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getEarliestVersionTime(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.earliestVersionTime_ = null;
            }
            return this.earliestVersionTimeBuilder_;
        }

        @Override
        public String getDefaultLeader() {
            Object ref = this.defaultLeader_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.defaultLeader_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getDefaultLeaderBytes() {
            Object ref = this.defaultLeader_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.defaultLeader_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setDefaultLeader(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.defaultLeader_ = value;
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        public Builder clearDefaultLeader() {
            this.defaultLeader_ = Database.getDefaultInstance().getDefaultLeader();
            this.bitField0_ &= 0xFFFFFEFF;
            this.onChanged();
            return this;
        }

        public Builder setDefaultLeaderBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Database.checkByteStringIsUtf8((ByteString)value);
            this.defaultLeader_ = value;
            this.bitField0_ |= 0x100;
            this.onChanged();
            return this;
        }

        @Override
        public int getDatabaseDialectValue() {
            return this.databaseDialect_;
        }

        public Builder setDatabaseDialectValue(int value) {
            this.databaseDialect_ = value;
            this.bitField0_ |= 0x200;
            this.onChanged();
            return this;
        }

        @Override
        public DatabaseDialect getDatabaseDialect() {
            DatabaseDialect result = DatabaseDialect.forNumber(this.databaseDialect_);
            return result == null ? DatabaseDialect.UNRECOGNIZED : result;
        }

        public Builder setDatabaseDialect(DatabaseDialect value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 0x200;
            this.databaseDialect_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearDatabaseDialect() {
            this.bitField0_ &= 0xFFFFFDFF;
            this.databaseDialect_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getEnableDropProtection() {
            return this.enableDropProtection_;
        }

        public Builder setEnableDropProtection(boolean value) {
            this.enableDropProtection_ = value;
            this.bitField0_ |= 0x400;
            this.onChanged();
            return this;
        }

        public Builder clearEnableDropProtection() {
            this.bitField0_ &= 0xFFFFFBFF;
            this.enableDropProtection_ = false;
            this.onChanged();
            return this;
        }

        @Override
        public boolean getReconciling() {
            return this.reconciling_;
        }

        public Builder setReconciling(boolean value) {
            this.reconciling_ = value;
            this.bitField0_ |= 0x800;
            this.onChanged();
            return this;
        }

        public Builder clearReconciling() {
            this.bitField0_ &= 0xFFFFF7FF;
            this.reconciling_ = false;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static enum State implements ProtocolMessageEnum
    {
        STATE_UNSPECIFIED(0),
        CREATING(1),
        READY(2),
        READY_OPTIMIZING(3),
        UNRECOGNIZED(-1);

        public static final int STATE_UNSPECIFIED_VALUE = 0;
        public static final int CREATING_VALUE = 1;
        public static final int READY_VALUE = 2;
        public static final int READY_OPTIMIZING_VALUE = 3;
        private static final Internal.EnumLiteMap<State> internalValueMap;
        private static final State[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static State valueOf(int value) {
            return State.forNumber(value);
        }

        public static State forNumber(int value) {
            switch (value) {
                case 0: {
                    return STATE_UNSPECIFIED;
                }
                case 1: {
                    return CREATING;
                }
                case 2: {
                    return READY;
                }
                case 3: {
                    return READY_OPTIMIZING;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<State> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)State.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return State.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)Database.getDescriptor().getEnumTypes().get(0);
        }

        public static State valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != State.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private State(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<State>(){

                public State findValueByNumber(int number) {
                    return State.forNumber(number);
                }
            };
            VALUES = State.values();
        }
    }
}

