/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.util.Optional;
import java.util.stream.Stream;
import oracle.net.resolver.TimeUnit;

public class TimeUnitSuffixUtility {
    private static int getTimeInMilliseconds(String string) {
        Optional<TimeUnit> optional = Stream.of(TimeUnit.values()).filter(timeUnit -> string.toUpperCase().endsWith(timeUnit.name())).findAny();
        if (optional.isPresent()) {
            return Integer.parseInt(string.toUpperCase().replaceFirst(optional.get().name(), "")) * optional.get().getMultiplier();
        }
        return Integer.parseInt(string);
    }

    public static int getTimeInMilliseconds(String string, boolean bl) {
        if (!string.isEmpty() && string.matches("\\d*")) {
            return bl ? Integer.parseInt(string) * 1000 : Integer.parseInt(string);
        }
        return TimeUnitSuffixUtility.getTimeInMilliseconds(string);
    }

    public static int getTimeInMilliseconds(String string, boolean bl, int n2) {
        try {
            return TimeUnitSuffixUtility.getTimeInMilliseconds(string, bl);
        }
        catch (NumberFormatException numberFormatException) {
            return bl ? n2 * 1000 : n2;
        }
    }
}

