/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc.jdbc41.future;

import com.databricks.client.dsi.core.interfaces.IStatement;
import com.databricks.client.exceptions.ExceptionConverter;
import com.databricks.client.jdbc.common.SConnection;
import com.databricks.client.jdbc.common.future.SPreparedStatement;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.utilities.JDBCVersion;
import java.sql.SQLException;

public class S41PreparedStatement
extends SPreparedStatement {
    public S41PreparedStatement(String string, IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        this(string, iStatement, sConnection, n, JDBCVersion.JDBC41);
    }

    protected S41PreparedStatement(String string, IStatement iStatement, SConnection sConnection, int n, JDBCVersion jDBCVersion) throws SQLException {
        super(string, iStatement, sConnection, n);
        this.m_jdbcVersion = jDBCVersion;
    }

    @Override
    public synchronized void closeOnCompletion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            this.m_closeOnCompletion = true;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public synchronized boolean isCloseOnCompletion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            return this.m_closeOnCompletion;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }
}

