/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.executor.etree.statement;

import com.databricks.client.dsi.dataengine.utilities.CursorType;
import com.databricks.client.dsi.dataengine.utilities.DataWrapper;
import com.databricks.client.sqlengine.dsiext.dataengine.DSIExtJResultSet;
import com.databricks.client.sqlengine.executor.etree.ETBoolean;
import com.databricks.client.sqlengine.executor.etree.ETDataRequest;
import com.databricks.client.sqlengine.executor.etree.IETNode;
import com.databricks.client.sqlengine.executor.etree.IETNodeVisitor;
import com.databricks.client.sqlengine.executor.etree.bool.ETBooleanExpr;
import com.databricks.client.sqlengine.executor.etree.relation.ETTable;
import com.databricks.client.sqlengine.executor.etree.statement.ETSetClause;
import com.databricks.client.sqlengine.executor.etree.statement.ETSetClauseList;
import com.databricks.client.sqlengine.executor.etree.statement.RowCountStatement;
import com.databricks.client.sqlengine.executor.etree.value.ETParameter;
import com.databricks.client.sqlengine.utilities.SQLEngineMessageKey;
import com.databricks.client.support.exceptions.DiagState;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.AbstractList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class ETSearchedUpdate
extends RowCountStatement {
    private ETTable m_table;
    private ETBooleanExpr m_searchCondition;
    private ETSetClauseList m_setClauseList;
    private long m_updateCount = -1L;
    private ETDataRequest[] m_dataRequests;
    private int[] m_colTypes;
    private boolean m_doInsertOnRC0;
    private int[] m_defaultColToIns;

    public ETSearchedUpdate(ETTable eTTable, ETSetClauseList eTSetClauseList, ETBooleanExpr eTBooleanExpr, boolean bl, Map<Integer, ETParameter> map) throws ErrorException {
        super(map);
        this.m_table = eTTable;
        this.m_setClauseList = eTSetClauseList;
        this.m_searchCondition = eTBooleanExpr;
        this.m_doInsertOnRC0 = bl;
        this.initializeDataRequests();
    }

    @Override
    public boolean isResultSet() {
        return false;
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public void close() {
        if (null != this.m_table) {
            try {
                this.m_table.close(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_table = null;
        }
        if (null != this.m_searchCondition) {
            try {
                this.m_searchCondition.close(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_searchCondition = null;
        }
        this.m_setClauseList = null;
        this.m_dataRequests = null;
        this.m_colTypes = null;
        this.m_defaultColToIns = null;
    }

    @Override
    public void startBatch() throws ErrorException {
        this.m_table.open(CursorType.FORWARD_ONLY);
        if (this.m_doInsertOnRC0) {
            this.m_table.onStartDMLBatch(DSIExtJResultSet.DMLType.UPSERT, -1L);
        } else {
            this.m_table.onStartDMLBatch(DSIExtJResultSet.DMLType.UPDATE, -1L);
        }
    }

    @Override
    public void endBatch() throws ErrorException {
        this.m_table.onFinishDMLBatch();
        this.m_table.close(false);
    }

    @Override
    public void execute() throws ErrorException {
        this.m_updateCount = 0L;
        this.m_table.reset();
        this.m_searchCondition.open();
        while (this.m_table.move()) {
            if (ETBoolean.SQL_BOOLEAN_TRUE != this.m_searchCondition.evaluate()) continue;
            this.m_table.onStartRowUpdate();
            this.updateRow();
            this.m_table.onFinishRowUpdate();
            ++this.m_updateCount;
        }
        if (this.m_updateCount == 0L && this.m_doInsertOnRC0) {
            this.m_table.appendRow();
            this.updateRow();
            this.writeDefaultColumns();
            this.m_table.onFinishRowUpdate();
            ++this.m_updateCount;
        }
        this.m_searchCondition.close(false);
    }

    @Override
    public Iterator<? extends IETNode> getChildItr() {
        return new AbstractList<IETNode>(){

            @Override
            public IETNode get(int n) {
                return ETSearchedUpdate.this.getChild(n);
            }

            @Override
            public int size() {
                return ETSearchedUpdate.this.getNumChildren();
            }
        }.iterator();
    }

    @Override
    public String getLogString() {
        return "ETSearchedUpdate";
    }

    @Override
    public int getNumChildren() {
        return 3;
    }

    @Override
    public long getRowCount() throws ErrorException {
        return this.m_updateCount;
    }

    private IETNode getChild(int n) {
        switch (n) {
            case 0: {
                return this.m_table;
            }
            case 1: {
                return this.m_setClauseList;
            }
            case 2: {
                return this.m_searchCondition;
            }
        }
        throw new IndexOutOfBoundsException("index: " + n);
    }

    private void initializeDataRequests() throws ErrorException {
        int n;
        this.m_colTypes = new int[this.m_table.getColumnCount()];
        int n2 = this.m_setClauseList.getNumChildren();
        this.m_dataRequests = new ETDataRequest[n2];
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (n = 0; n < n2; ++n) {
            ETSetClause eTSetClause = this.m_setClauseList.getChild(n);
            int n3 = eTSetClause.getColumnIndex();
            this.m_dataRequests[n] = new ETDataRequest(this.m_table.getColumn(n3));
            hashSet.add(n3);
        }
        this.m_defaultColToIns = new int[this.m_colTypes.length - hashSet.size()];
        n = 0;
        for (int i = 0; i < this.m_colTypes.length; ++i) {
            this.m_colTypes[i] = this.m_table.getColumn(i).getTypeMetadata().getType();
            if (hashSet.contains(i)) continue;
            this.m_defaultColToIns[n++] = i;
        }
        assert (n == this.m_defaultColToIns.length);
    }

    private void updateRow() throws ErrorException {
        DataWrapper dataWrapper = new DataWrapper();
        for (int i = 0; i < this.m_setClauseList.getNumChildren(); ++i) {
            ETSetClause eTSetClause = this.m_setClauseList.getChild(i);
            ETDataRequest eTDataRequest = this.m_dataRequests[i];
            int n = eTSetClause.getColumnIndex();
            eTDataRequest.getData().setNull();
            eTDataRequest.setOffset(0L);
            boolean bl = eTSetClause.retrieveData(eTDataRequest);
            do {
                long l;
                bl = eTSetClause.retrieveData(eTDataRequest);
                if (eTDataRequest.isDefault()) {
                    dataWrapper.setNull(this.m_colTypes[n]);
                    l = 0L;
                } else {
                    eTDataRequest.getData().retrieveData(dataWrapper);
                    l = eTDataRequest.getOffset();
                }
                boolean bl2 = this.m_table.writeData(n, dataWrapper, l, eTDataRequest.isDefault());
                if (bl2) {
                    throw new ErrorException(DiagState.DIAG_STR_RIGHT_TRUNC_ERR, 7, SQLEngineMessageKey.RIGHT_DATA_TRUNCATION.name(), -1, i + 1);
                }
                if (!bl) continue;
                eTDataRequest.setOffset(eTDataRequest.getOffset() + eTDataRequest.getMaxSize());
            } while (bl);
        }
    }

    private void writeDefaultColumns() throws ErrorException {
        if (this.m_defaultColToIns.length == 0) {
            return;
        }
        DataWrapper dataWrapper = new DataWrapper();
        for (int n : this.m_defaultColToIns) {
            dataWrapper.setNull(this.m_colTypes[n]);
            if (!this.m_table.writeData(n, dataWrapper, 0L, true)) continue;
            throw new ErrorException(DiagState.DIAG_INTERVAL_OVERFLOW, 7, SQLEngineMessageKey.RIGHT_DATA_TRUNCATION.name(), -1, n);
        }
    }
}

