/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.sqlengine.executor.etree.value;

import com.databricks.client.sqlengine.executor.datawrapper.ISqlDataWrapper;
import com.databricks.client.sqlengine.executor.etree.ETBoolean;
import com.databricks.client.sqlengine.executor.etree.ETDataRequest;
import com.databricks.client.sqlengine.executor.etree.IETNode;
import com.databricks.client.sqlengine.executor.etree.IETNodeVisitor;
import com.databricks.client.sqlengine.executor.etree.bool.ETBooleanExpr;
import com.databricks.client.sqlengine.executor.etree.value.ETValueExpr;
import com.databricks.client.support.exceptions.ErrorException;

public class ETBooleanValueExpr
extends ETValueExpr {
    private ETBooleanExpr m_operand;

    public ETBooleanValueExpr(ETBooleanExpr eTBooleanExpr) throws ErrorException {
        this.m_operand = eTBooleanExpr;
    }

    @Override
    public void close(boolean bl) {
        this.m_operand.close(bl);
    }

    @Override
    public boolean isOpen() {
        return this.m_operand.isOpen();
    }

    @Override
    public <T> T acceptVisitor(IETNodeVisitor<T> iETNodeVisitor) throws ErrorException {
        return iETNodeVisitor.visit(this);
    }

    @Override
    public int getNumChildren() {
        return 1;
    }

    @Override
    public void open() throws ErrorException {
        this.m_operand.open();
    }

    @Override
    public boolean retrieveData(ETDataRequest eTDataRequest) throws ErrorException {
        ISqlDataWrapper iSqlDataWrapper = eTDataRequest.getData();
        assert (-7 == iSqlDataWrapper.getType() || 16 == iSqlDataWrapper.getType());
        Boolean bl = ETBoolean.toBoolean(this.m_operand.evaluate());
        if (null == bl) {
            iSqlDataWrapper.setNull();
        } else {
            iSqlDataWrapper.setBoolean(bl);
        }
        return false;
    }

    @Override
    protected IETNode getChild(int n) throws IndexOutOfBoundsException {
        if (0 == n) {
            return this.m_operand;
        }
        throw new IndexOutOfBoundsException();
    }
}

