/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.bigquery;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.extensibility.LicenseGuard;
import org.flywaydb.core.extensibility.Tier;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.license.FlywayEditionUpgradeRequiredException;
import org.flywaydb.core.internal.util.DataUnits;
import org.flywaydb.core.internal.util.StringUtils;
import org.flywaydb.database.bigquery.BigQueryConnection;

public class BigQueryDatabase
extends Database<BigQueryConnection> {
    private static final Log LOG = LogFactory.getLog(BigQueryDatabase.class);
    private static final long TEN_GB_DATABASE_SIZE_LIMIT = DataUnits.GIGABYTE.toBytes(10L);
    private static final long NINE_GB_DATABASE_SIZE = DataUnits.GIGABYTE.toBytes(9L);

    public BigQueryDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        super(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    protected BigQueryConnection doGetConnection(Connection connection) {
        return new BigQueryConnection(this, connection);
    }

    public void ensureSupported(Configuration configuration) {
        if (!LicenseGuard.isLicensed((Configuration)configuration, (List)Tier.PREMIUM)) {
            long databaseSize = this.getDatabaseSize();
            if (databaseSize > TEN_GB_DATABASE_SIZE_LIMIT) {
                throw new FlywayEditionUpgradeRequiredException(Tier.TEAMS, LicenseGuard.getTier((Configuration)configuration), "A Google BigQuery database that exceeds the 10 GB database size limit (Calculated size: " + DataUnits.GIGABYTE.toHumanReadableString(databaseSize) + ")");
            }
            String usageLimitMessage = "Google BigQuery databases have a 10 GB database size limit in " + Tier.COMMUNITY.getDisplayName() + ".\nYou have used " + DataUnits.GIGABYTE.toHumanReadableString(databaseSize) + " / 10 GB\nConsider upgrading to " + Tier.ENTERPRISE.getDisplayName() + " for unlimited usage: https://rd.gt/3CWAuTb";
            if (databaseSize >= NINE_GB_DATABASE_SIZE) {
                LOG.warn(usageLimitMessage);
            } else {
                LOG.info(usageLimitMessage);
            }
        }
    }

    private long getDatabaseSize() {
        long totalDatabaseSize = 0L;
        try {
            ResultSet schemaRs = this.getJdbcMetaData().getSchemas();
            while (schemaRs.next()) {
                totalDatabaseSize += this.jdbcTemplate.queryForLong("select sum(size_bytes) from " + schemaRs.getString("TABLE_SCHEM") + ".__TABLES__", new String[0]);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return totalDatabaseSize;
    }

    public String getRawCreateScript(Table table, boolean baseline) {
        return "CREATE TABLE " + String.valueOf(table) + " (\n    `installed_rank` INT64 NOT NULL,\n    `version` STRING,\n    `description` STRING NOT NULL,\n    `type` STRING NOT NULL,\n    `script` STRING NOT NULL,\n    `checksum` INT64,\n    `installed_by` STRING NOT NULL,\n    `installed_on` TIMESTAMP,\n    `execution_time` INT64 NOT NULL,\n    `success` BOOL NOT NULL\n);\n" + (String)(baseline ? this.getBaselineStatement(table) + ";\n" : "");
    }

    public String getInsertStatement(Table table) {
        return "INSERT INTO " + String.valueOf(table) + " (" + this.quote(new String[]{"installed_rank"}) + ", " + this.quote(new String[]{"version"}) + ", " + this.quote(new String[]{"description"}) + ", " + this.quote(new String[]{"type"}) + ", " + this.quote(new String[]{"script"}) + ", " + this.quote(new String[]{"checksum"}) + ", " + this.quote(new String[]{"installed_by"}) + ", " + this.quote(new String[]{"installed_on"}) + ", " + this.quote(new String[]{"execution_time"}) + ", " + this.quote(new String[]{"success"}) + ") VALUES (?, ?, ?, ?, ?, ?, ?, CURRENT_TIMESTAMP(), ?, ?)";
    }

    protected String doGetCurrentUser() throws SQLException {
        return ((BigQueryConnection)this.getMainConnection()).getJdbcTemplate().queryForString("SELECT SESSION_USER() as user;", new String[0]);
    }

    public boolean supportsDdlTransactions() {
        return false;
    }

    public String getBooleanTrue() {
        return "TRUE";
    }

    public String getBooleanFalse() {
        return "FALSE";
    }

    public String doQuote(String identifier) {
        return this.getOpenQuote() + StringUtils.replaceAll((String)identifier, (String)this.getCloseQuote(), (String)this.getEscapedQuote()) + this.getCloseQuote();
    }

    public String getOpenQuote() {
        return "`";
    }

    public String getCloseQuote() {
        return "`";
    }

    public String getEscapedQuote() {
        return "\\`";
    }

    public boolean catalogIsSchema() {
        return false;
    }

    public boolean supportsMultiStatementTransactions() {
        return false;
    }

    public boolean useSingleConnection() {
        return true;
    }

    public String getDatabaseHosting() {
        return "gcp-big-query";
    }
}

