/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.scanners;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.resource.LoadableResource;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.resource.ResourceName;
import org.flywaydb.core.internal.resource.ResourceNameParser;
import org.flywaydb.core.internal.resource.classpath.ClassPathResource;
import org.flywaydb.core.internal.sqlscript.SqlScriptMetadata;
import org.flywaydb.core.internal.util.Pair;
import org.flywaydb.scanners.BaseSqlMigrationScanner;
import org.flywaydb.scanners.ScannerUtils;

public class ClasspathSqlMigrationScanner
extends BaseSqlMigrationScanner {
    private static final Log LOG = LogFactory.getLog(ClasspathSqlMigrationScanner.class);

    public Collection<Pair<LoadableResource, SqlScriptMetadata>> scan(Location location, Configuration configuration, ParsingContext parsingContext) {
        if (!location.isClassPath()) {
            return List.of();
        }
        LOG.debug("Scanning for classpath resources at '" + location.getRootPath() + "'");
        ClassLoader classLoader = configuration.getClassLoader();
        ArrayList<URL> locationUrls = new ArrayList<URL>();
        try {
            Enumeration<URL> urls = classLoader.getResources(location.getRootPath());
            while (urls.hasMoreElements()) {
                locationUrls.add(urls.nextElement());
            }
        }
        catch (IOException e) {
            LOG.error("Unable to resolve location " + String.valueOf(location) + " (ClassLoader: " + String.valueOf(classLoader) + "): " + e.getMessage() + ".");
        }
        if (locationUrls.isEmpty()) {
            if (configuration.isFailOnMissingLocations()) {
                throw new FlywayException("Failed to find classpath location: " + location.getRootPath());
            }
            LOG.debug("Skipping classpath location: " + location.getRootPath());
            return Collections.emptyList();
        }
        ArrayList<Pair<LoadableResource, SqlScriptMetadata>> classPathMigrations = new ArrayList<Pair<LoadableResource, SqlScriptMetadata>>();
        for (URL locationUrl : locationUrls) {
            LOG.debug("Scanning URL: " + locationUrl.toExternalForm());
            String protocol = locationUrl.getProtocol();
            if ("file".equals(protocol)) {
                classPathMigrations.addAll(this.scanFromFileSystem(new File(locationUrl.getPath()), location, configuration, parsingContext));
                continue;
            }
            if (!"jar".equals(protocol)) continue;
            classPathMigrations.addAll(this.scanFromJarFile(location, locationUrl, configuration, parsingContext));
        }
        return classPathMigrations;
    }

    @Override
    boolean matchesPath(String path, Location location) {
        String rootPath = new File(Thread.currentThread().getContextClassLoader().getResource(".").getPath()).getAbsolutePath();
        String remainingPath = path.replace("\\", "/").substring(rootPath.length() + 1);
        return location.matchesPath(remainingPath);
    }

    private Collection<Pair<LoadableResource, SqlScriptMetadata>> scanFromJarFile(Location location, URL locationUrl, Configuration configuration, ParsingContext parsingContext) {
        Set<String> resourceNames = this.findResourceNames(location.getRootPath(), locationUrl);
        List<Pair> fileList = resourceNames.stream().map(resourceName -> this.processJarResource(location, locationUrl, configuration, (String)resourceName, parsingContext)).toList();
        List<Pair<String, ResourceName>> resources = fileList.stream().map(x -> Pair.of((Object)((LoadableResource)x.getLeft()).getFilename(), (Object)new ResourceNameParser(configuration).parse(((LoadableResource)x.getLeft()).getFilename()))).toList();
        ScannerUtils.validateMigrationNaming(resources, configuration.isValidateMigrationNaming(), configuration.getSqlMigrationSuffixes());
        return fileList.stream().filter(x -> {
            ResourceName name = new ResourceNameParser(configuration).parse(((LoadableResource)x.getLeft()).getFilename());
            return name.isValid() && !"".equals(name.getSuffix());
        }).collect(Collectors.toSet());
    }

    private Pair<LoadableResource, SqlScriptMetadata> processJarResource(Location location, URL locationUrl, Configuration configuration, String resourceName, ParsingContext parsingContext) {
        ClassPathResource classPathResource = new ClassPathResource(location, resourceName, configuration.getClassLoader(), configuration.getEncoding(), locationUrl.getPath(), configuration.isStream());
        return Pair.of((Object)classPathResource, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> findResourceNames(String location, URL locationUrl) {
        JarFile jarFile;
        try {
            URLConnection con = locationUrl.openConnection();
            if (!(con instanceof JarURLConnection)) {
                return Collections.emptySet();
            }
            JarURLConnection jarCon = (JarURLConnection)con;
            jarCon.setUseCaches(false);
            jarFile = jarCon.getJarFile();
        }
        catch (IOException e) {
            LOG.warn("Unable to determine jar from url (" + String.valueOf(locationUrl) + "): " + e.getMessage());
            return Collections.emptySet();
        }
        try {
            Set<String> set = this.findResourceNamesFromJarFile(jarFile, location);
            return set;
        }
        finally {
            try {
                jarFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    private Set<String> findResourceNamesFromJarFile(JarFile jarFile, String location) {
        String toScan = location + (location.endsWith("/") ? "" : "/");
        TreeSet<String> resourceNames = new TreeSet<String>();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            String entryName;
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory() || !(entryName = entry.getName()).startsWith(toScan)) continue;
            resourceNames.add(entryName);
        }
        return resourceNames;
    }
}

