/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.admin.instance.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.httpjson.longrunning.stub.OperationsStub;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.resourcenames.ResourceName;
import com.google.cloud.spanner.admin.instance.v1.InstanceAdminSettings;
import com.google.cloud.spanner.admin.instance.v1.stub.InstanceAdminStub;
import com.google.cloud.spanner.admin.instance.v1.stub.InstanceAdminStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.spanner.admin.instance.v1.CreateInstanceConfigMetadata;
import com.google.spanner.admin.instance.v1.CreateInstanceConfigRequest;
import com.google.spanner.admin.instance.v1.CreateInstanceMetadata;
import com.google.spanner.admin.instance.v1.CreateInstancePartitionMetadata;
import com.google.spanner.admin.instance.v1.CreateInstancePartitionRequest;
import com.google.spanner.admin.instance.v1.CreateInstanceRequest;
import com.google.spanner.admin.instance.v1.DeleteInstanceConfigRequest;
import com.google.spanner.admin.instance.v1.DeleteInstancePartitionRequest;
import com.google.spanner.admin.instance.v1.DeleteInstanceRequest;
import com.google.spanner.admin.instance.v1.GetInstanceConfigRequest;
import com.google.spanner.admin.instance.v1.GetInstancePartitionRequest;
import com.google.spanner.admin.instance.v1.GetInstanceRequest;
import com.google.spanner.admin.instance.v1.Instance;
import com.google.spanner.admin.instance.v1.InstanceConfig;
import com.google.spanner.admin.instance.v1.InstanceConfigName;
import com.google.spanner.admin.instance.v1.InstanceName;
import com.google.spanner.admin.instance.v1.InstancePartition;
import com.google.spanner.admin.instance.v1.InstancePartitionName;
import com.google.spanner.admin.instance.v1.ListInstanceConfigOperationsRequest;
import com.google.spanner.admin.instance.v1.ListInstanceConfigOperationsResponse;
import com.google.spanner.admin.instance.v1.ListInstanceConfigsRequest;
import com.google.spanner.admin.instance.v1.ListInstanceConfigsResponse;
import com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsRequest;
import com.google.spanner.admin.instance.v1.ListInstancePartitionOperationsResponse;
import com.google.spanner.admin.instance.v1.ListInstancePartitionsRequest;
import com.google.spanner.admin.instance.v1.ListInstancePartitionsResponse;
import com.google.spanner.admin.instance.v1.ListInstancesRequest;
import com.google.spanner.admin.instance.v1.ListInstancesResponse;
import com.google.spanner.admin.instance.v1.MoveInstanceMetadata;
import com.google.spanner.admin.instance.v1.MoveInstanceRequest;
import com.google.spanner.admin.instance.v1.MoveInstanceResponse;
import com.google.spanner.admin.instance.v1.ProjectName;
import com.google.spanner.admin.instance.v1.UpdateInstanceConfigMetadata;
import com.google.spanner.admin.instance.v1.UpdateInstanceConfigRequest;
import com.google.spanner.admin.instance.v1.UpdateInstanceMetadata;
import com.google.spanner.admin.instance.v1.UpdateInstancePartitionMetadata;
import com.google.spanner.admin.instance.v1.UpdateInstancePartitionRequest;
import com.google.spanner.admin.instance.v1.UpdateInstanceRequest;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class InstanceAdminClient
implements BackgroundResource {
    private final InstanceAdminSettings settings;
    private final InstanceAdminStub stub;
    private final com.google.api.gax.httpjson.longrunning.OperationsClient httpJsonOperationsClient;
    private final OperationsClient operationsClient;

    public static final InstanceAdminClient create() throws IOException {
        return InstanceAdminClient.create(InstanceAdminSettings.newBuilder().build());
    }

    public static final InstanceAdminClient create(InstanceAdminSettings settings) throws IOException {
        return new InstanceAdminClient(settings);
    }

    public static final InstanceAdminClient create(InstanceAdminStub stub) {
        return new InstanceAdminClient(stub);
    }

    protected InstanceAdminClient(InstanceAdminSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((InstanceAdminStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    protected InstanceAdminClient(InstanceAdminStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((com.google.longrunning.stub.OperationsStub)this.stub.getOperationsStub());
        this.httpJsonOperationsClient = com.google.api.gax.httpjson.longrunning.OperationsClient.create((OperationsStub)this.stub.getHttpJsonOperationsStub());
    }

    public final InstanceAdminSettings getSettings() {
        return this.settings;
    }

    public InstanceAdminStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    @BetaApi
    public final com.google.api.gax.httpjson.longrunning.OperationsClient getHttpJsonOperationsClient() {
        return this.httpJsonOperationsClient;
    }

    public final ListInstanceConfigsPagedResponse listInstanceConfigs(ProjectName parent) {
        ListInstanceConfigsRequest request = ListInstanceConfigsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listInstanceConfigs(request);
    }

    public final ListInstanceConfigsPagedResponse listInstanceConfigs(String parent) {
        ListInstanceConfigsRequest request = ListInstanceConfigsRequest.newBuilder().setParent(parent).build();
        return this.listInstanceConfigs(request);
    }

    public final ListInstanceConfigsPagedResponse listInstanceConfigs(ListInstanceConfigsRequest request) {
        return (ListInstanceConfigsPagedResponse)((Object)this.listInstanceConfigsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInstanceConfigsRequest, ListInstanceConfigsPagedResponse> listInstanceConfigsPagedCallable() {
        return this.stub.listInstanceConfigsPagedCallable();
    }

    public final UnaryCallable<ListInstanceConfigsRequest, ListInstanceConfigsResponse> listInstanceConfigsCallable() {
        return this.stub.listInstanceConfigsCallable();
    }

    public final InstanceConfig getInstanceConfig(InstanceConfigName name) {
        GetInstanceConfigRequest request = GetInstanceConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getInstanceConfig(request);
    }

    public final InstanceConfig getInstanceConfig(String name) {
        GetInstanceConfigRequest request = GetInstanceConfigRequest.newBuilder().setName(name).build();
        return this.getInstanceConfig(request);
    }

    public final InstanceConfig getInstanceConfig(GetInstanceConfigRequest request) {
        return (InstanceConfig)this.getInstanceConfigCallable().call((Object)request);
    }

    public final UnaryCallable<GetInstanceConfigRequest, InstanceConfig> getInstanceConfigCallable() {
        return this.stub.getInstanceConfigCallable();
    }

    public final OperationFuture<InstanceConfig, CreateInstanceConfigMetadata> createInstanceConfigAsync(ProjectName parent, InstanceConfig instanceConfig, String instanceConfigId) {
        CreateInstanceConfigRequest request = CreateInstanceConfigRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setInstanceConfig(instanceConfig).setInstanceConfigId(instanceConfigId).build();
        return this.createInstanceConfigAsync(request);
    }

    public final OperationFuture<InstanceConfig, CreateInstanceConfigMetadata> createInstanceConfigAsync(String parent, InstanceConfig instanceConfig, String instanceConfigId) {
        CreateInstanceConfigRequest request = CreateInstanceConfigRequest.newBuilder().setParent(parent).setInstanceConfig(instanceConfig).setInstanceConfigId(instanceConfigId).build();
        return this.createInstanceConfigAsync(request);
    }

    public final OperationFuture<InstanceConfig, CreateInstanceConfigMetadata> createInstanceConfigAsync(CreateInstanceConfigRequest request) {
        return this.createInstanceConfigOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateInstanceConfigRequest, InstanceConfig, CreateInstanceConfigMetadata> createInstanceConfigOperationCallable() {
        return this.stub.createInstanceConfigOperationCallable();
    }

    public final UnaryCallable<CreateInstanceConfigRequest, Operation> createInstanceConfigCallable() {
        return this.stub.createInstanceConfigCallable();
    }

    public final OperationFuture<InstanceConfig, UpdateInstanceConfigMetadata> updateInstanceConfigAsync(InstanceConfig instanceConfig, FieldMask updateMask) {
        UpdateInstanceConfigRequest request = UpdateInstanceConfigRequest.newBuilder().setInstanceConfig(instanceConfig).setUpdateMask(updateMask).build();
        return this.updateInstanceConfigAsync(request);
    }

    public final OperationFuture<InstanceConfig, UpdateInstanceConfigMetadata> updateInstanceConfigAsync(UpdateInstanceConfigRequest request) {
        return this.updateInstanceConfigOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateInstanceConfigRequest, InstanceConfig, UpdateInstanceConfigMetadata> updateInstanceConfigOperationCallable() {
        return this.stub.updateInstanceConfigOperationCallable();
    }

    public final UnaryCallable<UpdateInstanceConfigRequest, Operation> updateInstanceConfigCallable() {
        return this.stub.updateInstanceConfigCallable();
    }

    public final void deleteInstanceConfig(InstanceConfigName name) {
        DeleteInstanceConfigRequest request = DeleteInstanceConfigRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteInstanceConfig(request);
    }

    public final void deleteInstanceConfig(String name) {
        DeleteInstanceConfigRequest request = DeleteInstanceConfigRequest.newBuilder().setName(name).build();
        this.deleteInstanceConfig(request);
    }

    public final void deleteInstanceConfig(DeleteInstanceConfigRequest request) {
        this.deleteInstanceConfigCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteInstanceConfigRequest, Empty> deleteInstanceConfigCallable() {
        return this.stub.deleteInstanceConfigCallable();
    }

    public final ListInstanceConfigOperationsPagedResponse listInstanceConfigOperations(ProjectName parent) {
        ListInstanceConfigOperationsRequest request = ListInstanceConfigOperationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listInstanceConfigOperations(request);
    }

    public final ListInstanceConfigOperationsPagedResponse listInstanceConfigOperations(String parent) {
        ListInstanceConfigOperationsRequest request = ListInstanceConfigOperationsRequest.newBuilder().setParent(parent).build();
        return this.listInstanceConfigOperations(request);
    }

    public final ListInstanceConfigOperationsPagedResponse listInstanceConfigOperations(ListInstanceConfigOperationsRequest request) {
        return (ListInstanceConfigOperationsPagedResponse)((Object)this.listInstanceConfigOperationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInstanceConfigOperationsRequest, ListInstanceConfigOperationsPagedResponse> listInstanceConfigOperationsPagedCallable() {
        return this.stub.listInstanceConfigOperationsPagedCallable();
    }

    public final UnaryCallable<ListInstanceConfigOperationsRequest, ListInstanceConfigOperationsResponse> listInstanceConfigOperationsCallable() {
        return this.stub.listInstanceConfigOperationsCallable();
    }

    public final ListInstancesPagedResponse listInstances(ProjectName parent) {
        ListInstancesRequest request = ListInstancesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listInstances(request);
    }

    public final ListInstancesPagedResponse listInstances(String parent) {
        ListInstancesRequest request = ListInstancesRequest.newBuilder().setParent(parent).build();
        return this.listInstances(request);
    }

    public final ListInstancesPagedResponse listInstances(ListInstancesRequest request) {
        return (ListInstancesPagedResponse)((Object)this.listInstancesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInstancesRequest, ListInstancesPagedResponse> listInstancesPagedCallable() {
        return this.stub.listInstancesPagedCallable();
    }

    public final UnaryCallable<ListInstancesRequest, ListInstancesResponse> listInstancesCallable() {
        return this.stub.listInstancesCallable();
    }

    public final ListInstancePartitionsPagedResponse listInstancePartitions(InstanceName parent) {
        ListInstancePartitionsRequest request = ListInstancePartitionsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listInstancePartitions(request);
    }

    public final ListInstancePartitionsPagedResponse listInstancePartitions(String parent) {
        ListInstancePartitionsRequest request = ListInstancePartitionsRequest.newBuilder().setParent(parent).build();
        return this.listInstancePartitions(request);
    }

    public final ListInstancePartitionsPagedResponse listInstancePartitions(ListInstancePartitionsRequest request) {
        return (ListInstancePartitionsPagedResponse)((Object)this.listInstancePartitionsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInstancePartitionsRequest, ListInstancePartitionsPagedResponse> listInstancePartitionsPagedCallable() {
        return this.stub.listInstancePartitionsPagedCallable();
    }

    public final UnaryCallable<ListInstancePartitionsRequest, ListInstancePartitionsResponse> listInstancePartitionsCallable() {
        return this.stub.listInstancePartitionsCallable();
    }

    public final Instance getInstance(InstanceName name) {
        GetInstanceRequest request = GetInstanceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getInstance(request);
    }

    public final Instance getInstance(String name) {
        GetInstanceRequest request = GetInstanceRequest.newBuilder().setName(name).build();
        return this.getInstance(request);
    }

    public final Instance getInstance(GetInstanceRequest request) {
        return (Instance)this.getInstanceCallable().call((Object)request);
    }

    public final UnaryCallable<GetInstanceRequest, Instance> getInstanceCallable() {
        return this.stub.getInstanceCallable();
    }

    public final OperationFuture<Instance, CreateInstanceMetadata> createInstanceAsync(ProjectName parent, String instanceId, Instance instance) {
        CreateInstanceRequest request = CreateInstanceRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setInstanceId(instanceId).setInstance(instance).build();
        return this.createInstanceAsync(request);
    }

    public final OperationFuture<Instance, CreateInstanceMetadata> createInstanceAsync(String parent, String instanceId, Instance instance) {
        CreateInstanceRequest request = CreateInstanceRequest.newBuilder().setParent(parent).setInstanceId(instanceId).setInstance(instance).build();
        return this.createInstanceAsync(request);
    }

    public final OperationFuture<Instance, CreateInstanceMetadata> createInstanceAsync(CreateInstanceRequest request) {
        return this.createInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateInstanceRequest, Instance, CreateInstanceMetadata> createInstanceOperationCallable() {
        return this.stub.createInstanceOperationCallable();
    }

    public final UnaryCallable<CreateInstanceRequest, Operation> createInstanceCallable() {
        return this.stub.createInstanceCallable();
    }

    public final OperationFuture<Instance, UpdateInstanceMetadata> updateInstanceAsync(Instance instance, FieldMask fieldMask) {
        UpdateInstanceRequest request = UpdateInstanceRequest.newBuilder().setInstance(instance).setFieldMask(fieldMask).build();
        return this.updateInstanceAsync(request);
    }

    public final OperationFuture<Instance, UpdateInstanceMetadata> updateInstanceAsync(UpdateInstanceRequest request) {
        return this.updateInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateInstanceRequest, Instance, UpdateInstanceMetadata> updateInstanceOperationCallable() {
        return this.stub.updateInstanceOperationCallable();
    }

    public final UnaryCallable<UpdateInstanceRequest, Operation> updateInstanceCallable() {
        return this.stub.updateInstanceCallable();
    }

    public final void deleteInstance(InstanceName name) {
        DeleteInstanceRequest request = DeleteInstanceRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteInstance(request);
    }

    public final void deleteInstance(String name) {
        DeleteInstanceRequest request = DeleteInstanceRequest.newBuilder().setName(name).build();
        this.deleteInstance(request);
    }

    public final void deleteInstance(DeleteInstanceRequest request) {
        this.deleteInstanceCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteInstanceRequest, Empty> deleteInstanceCallable() {
        return this.stub.deleteInstanceCallable();
    }

    public final Policy setIamPolicy(ResourceName resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(String resource, Policy policy) {
        SetIamPolicyRequest request = SetIamPolicyRequest.newBuilder().setResource(resource).setPolicy(policy).build();
        return this.setIamPolicy(request);
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final Policy getIamPolicy(ResourceName resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource == null ? null : resource.toString()).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(String resource) {
        GetIamPolicyRequest request = GetIamPolicyRequest.newBuilder().setResource(resource).build();
        return this.getIamPolicy(request);
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(ResourceName resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource == null ? null : resource.toString()).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(String resource, List<String> permissions) {
        TestIamPermissionsRequest request = TestIamPermissionsRequest.newBuilder().setResource(resource).addAllPermissions(permissions).build();
        return this.testIamPermissions(request);
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final InstancePartition getInstancePartition(InstancePartitionName name) {
        GetInstancePartitionRequest request = GetInstancePartitionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getInstancePartition(request);
    }

    public final InstancePartition getInstancePartition(String name) {
        GetInstancePartitionRequest request = GetInstancePartitionRequest.newBuilder().setName(name).build();
        return this.getInstancePartition(request);
    }

    public final InstancePartition getInstancePartition(GetInstancePartitionRequest request) {
        return (InstancePartition)this.getInstancePartitionCallable().call((Object)request);
    }

    public final UnaryCallable<GetInstancePartitionRequest, InstancePartition> getInstancePartitionCallable() {
        return this.stub.getInstancePartitionCallable();
    }

    public final OperationFuture<InstancePartition, CreateInstancePartitionMetadata> createInstancePartitionAsync(InstanceName parent, InstancePartition instancePartition, String instancePartitionId) {
        CreateInstancePartitionRequest request = CreateInstancePartitionRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setInstancePartition(instancePartition).setInstancePartitionId(instancePartitionId).build();
        return this.createInstancePartitionAsync(request);
    }

    public final OperationFuture<InstancePartition, CreateInstancePartitionMetadata> createInstancePartitionAsync(String parent, InstancePartition instancePartition, String instancePartitionId) {
        CreateInstancePartitionRequest request = CreateInstancePartitionRequest.newBuilder().setParent(parent).setInstancePartition(instancePartition).setInstancePartitionId(instancePartitionId).build();
        return this.createInstancePartitionAsync(request);
    }

    public final OperationFuture<InstancePartition, CreateInstancePartitionMetadata> createInstancePartitionAsync(CreateInstancePartitionRequest request) {
        return this.createInstancePartitionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateInstancePartitionRequest, InstancePartition, CreateInstancePartitionMetadata> createInstancePartitionOperationCallable() {
        return this.stub.createInstancePartitionOperationCallable();
    }

    public final UnaryCallable<CreateInstancePartitionRequest, Operation> createInstancePartitionCallable() {
        return this.stub.createInstancePartitionCallable();
    }

    public final void deleteInstancePartition(InstancePartitionName name) {
        DeleteInstancePartitionRequest request = DeleteInstancePartitionRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteInstancePartition(request);
    }

    public final void deleteInstancePartition(String name) {
        DeleteInstancePartitionRequest request = DeleteInstancePartitionRequest.newBuilder().setName(name).build();
        this.deleteInstancePartition(request);
    }

    public final void deleteInstancePartition(DeleteInstancePartitionRequest request) {
        this.deleteInstancePartitionCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteInstancePartitionRequest, Empty> deleteInstancePartitionCallable() {
        return this.stub.deleteInstancePartitionCallable();
    }

    public final OperationFuture<InstancePartition, UpdateInstancePartitionMetadata> updateInstancePartitionAsync(InstancePartition instancePartition, FieldMask fieldMask) {
        UpdateInstancePartitionRequest request = UpdateInstancePartitionRequest.newBuilder().setInstancePartition(instancePartition).setFieldMask(fieldMask).build();
        return this.updateInstancePartitionAsync(request);
    }

    public final OperationFuture<InstancePartition, UpdateInstancePartitionMetadata> updateInstancePartitionAsync(UpdateInstancePartitionRequest request) {
        return this.updateInstancePartitionOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateInstancePartitionRequest, InstancePartition, UpdateInstancePartitionMetadata> updateInstancePartitionOperationCallable() {
        return this.stub.updateInstancePartitionOperationCallable();
    }

    public final UnaryCallable<UpdateInstancePartitionRequest, Operation> updateInstancePartitionCallable() {
        return this.stub.updateInstancePartitionCallable();
    }

    public final ListInstancePartitionOperationsPagedResponse listInstancePartitionOperations(InstanceName parent) {
        ListInstancePartitionOperationsRequest request = ListInstancePartitionOperationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listInstancePartitionOperations(request);
    }

    public final ListInstancePartitionOperationsPagedResponse listInstancePartitionOperations(String parent) {
        ListInstancePartitionOperationsRequest request = ListInstancePartitionOperationsRequest.newBuilder().setParent(parent).build();
        return this.listInstancePartitionOperations(request);
    }

    public final ListInstancePartitionOperationsPagedResponse listInstancePartitionOperations(ListInstancePartitionOperationsRequest request) {
        return (ListInstancePartitionOperationsPagedResponse)((Object)this.listInstancePartitionOperationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListInstancePartitionOperationsRequest, ListInstancePartitionOperationsPagedResponse> listInstancePartitionOperationsPagedCallable() {
        return this.stub.listInstancePartitionOperationsPagedCallable();
    }

    public final UnaryCallable<ListInstancePartitionOperationsRequest, ListInstancePartitionOperationsResponse> listInstancePartitionOperationsCallable() {
        return this.stub.listInstancePartitionOperationsCallable();
    }

    public final OperationFuture<MoveInstanceResponse, MoveInstanceMetadata> moveInstanceAsync(MoveInstanceRequest request) {
        return this.moveInstanceOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<MoveInstanceRequest, MoveInstanceResponse, MoveInstanceMetadata> moveInstanceOperationCallable() {
        return this.stub.moveInstanceOperationCallable();
    }

    public final UnaryCallable<MoveInstanceRequest, Operation> moveInstanceCallable() {
        return this.stub.moveInstanceCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListInstanceConfigsPagedResponse
    extends AbstractPagedListResponse<ListInstanceConfigsRequest, ListInstanceConfigsResponse, InstanceConfig, ListInstanceConfigsPage, ListInstanceConfigsFixedSizeCollection> {
        public static ApiFuture<ListInstanceConfigsPagedResponse> createAsync(PageContext<ListInstanceConfigsRequest, ListInstanceConfigsResponse, InstanceConfig> context, ApiFuture<ListInstanceConfigsResponse> futureResponse) {
            ApiFuture<ListInstanceConfigsPage> futurePage = ListInstanceConfigsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListInstanceConfigsPagedResponse((ListInstanceConfigsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListInstanceConfigsPagedResponse(ListInstanceConfigsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListInstanceConfigsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListInstanceConfigOperationsPagedResponse
    extends AbstractPagedListResponse<ListInstanceConfigOperationsRequest, ListInstanceConfigOperationsResponse, Operation, ListInstanceConfigOperationsPage, ListInstanceConfigOperationsFixedSizeCollection> {
        public static ApiFuture<ListInstanceConfigOperationsPagedResponse> createAsync(PageContext<ListInstanceConfigOperationsRequest, ListInstanceConfigOperationsResponse, Operation> context, ApiFuture<ListInstanceConfigOperationsResponse> futureResponse) {
            ApiFuture<ListInstanceConfigOperationsPage> futurePage = ListInstanceConfigOperationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListInstanceConfigOperationsPagedResponse((ListInstanceConfigOperationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListInstanceConfigOperationsPagedResponse(ListInstanceConfigOperationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListInstanceConfigOperationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListInstancesPagedResponse
    extends AbstractPagedListResponse<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage, ListInstancesFixedSizeCollection> {
        public static ApiFuture<ListInstancesPagedResponse> createAsync(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ApiFuture<ListInstancesResponse> futureResponse) {
            ApiFuture<ListInstancesPage> futurePage = ListInstancesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListInstancesPagedResponse((ListInstancesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListInstancesPagedResponse(ListInstancesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListInstancesFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListInstancePartitionsPagedResponse
    extends AbstractPagedListResponse<ListInstancePartitionsRequest, ListInstancePartitionsResponse, InstancePartition, ListInstancePartitionsPage, ListInstancePartitionsFixedSizeCollection> {
        public static ApiFuture<ListInstancePartitionsPagedResponse> createAsync(PageContext<ListInstancePartitionsRequest, ListInstancePartitionsResponse, InstancePartition> context, ApiFuture<ListInstancePartitionsResponse> futureResponse) {
            ApiFuture<ListInstancePartitionsPage> futurePage = ListInstancePartitionsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListInstancePartitionsPagedResponse((ListInstancePartitionsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListInstancePartitionsPagedResponse(ListInstancePartitionsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListInstancePartitionsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListInstancePartitionOperationsPagedResponse
    extends AbstractPagedListResponse<ListInstancePartitionOperationsRequest, ListInstancePartitionOperationsResponse, Operation, ListInstancePartitionOperationsPage, ListInstancePartitionOperationsFixedSizeCollection> {
        public static ApiFuture<ListInstancePartitionOperationsPagedResponse> createAsync(PageContext<ListInstancePartitionOperationsRequest, ListInstancePartitionOperationsResponse, Operation> context, ApiFuture<ListInstancePartitionOperationsResponse> futureResponse) {
            ApiFuture<ListInstancePartitionOperationsPage> futurePage = ListInstancePartitionOperationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListInstancePartitionOperationsPagedResponse((ListInstancePartitionOperationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListInstancePartitionOperationsPagedResponse(ListInstancePartitionOperationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListInstancePartitionOperationsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListInstancePartitionOperationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInstancePartitionOperationsRequest, ListInstancePartitionOperationsResponse, Operation, ListInstancePartitionOperationsPage, ListInstancePartitionOperationsFixedSizeCollection> {
        private ListInstancePartitionOperationsFixedSizeCollection(List<ListInstancePartitionOperationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListInstancePartitionOperationsFixedSizeCollection createEmptyCollection() {
            return new ListInstancePartitionOperationsFixedSizeCollection(null, 0);
        }

        protected ListInstancePartitionOperationsFixedSizeCollection createCollection(List<ListInstancePartitionOperationsPage> pages, int collectionSize) {
            return new ListInstancePartitionOperationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListInstancePartitionOperationsPage
    extends AbstractPage<ListInstancePartitionOperationsRequest, ListInstancePartitionOperationsResponse, Operation, ListInstancePartitionOperationsPage> {
        private ListInstancePartitionOperationsPage(PageContext<ListInstancePartitionOperationsRequest, ListInstancePartitionOperationsResponse, Operation> context, ListInstancePartitionOperationsResponse response) {
            super(context, (Object)response);
        }

        private static ListInstancePartitionOperationsPage createEmptyPage() {
            return new ListInstancePartitionOperationsPage(null, null);
        }

        protected ListInstancePartitionOperationsPage createPage(PageContext<ListInstancePartitionOperationsRequest, ListInstancePartitionOperationsResponse, Operation> context, ListInstancePartitionOperationsResponse response) {
            return new ListInstancePartitionOperationsPage(context, response);
        }

        public ApiFuture<ListInstancePartitionOperationsPage> createPageAsync(PageContext<ListInstancePartitionOperationsRequest, ListInstancePartitionOperationsResponse, Operation> context, ApiFuture<ListInstancePartitionOperationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListInstancePartitionsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInstancePartitionsRequest, ListInstancePartitionsResponse, InstancePartition, ListInstancePartitionsPage, ListInstancePartitionsFixedSizeCollection> {
        private ListInstancePartitionsFixedSizeCollection(List<ListInstancePartitionsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListInstancePartitionsFixedSizeCollection createEmptyCollection() {
            return new ListInstancePartitionsFixedSizeCollection(null, 0);
        }

        protected ListInstancePartitionsFixedSizeCollection createCollection(List<ListInstancePartitionsPage> pages, int collectionSize) {
            return new ListInstancePartitionsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListInstancePartitionsPage
    extends AbstractPage<ListInstancePartitionsRequest, ListInstancePartitionsResponse, InstancePartition, ListInstancePartitionsPage> {
        private ListInstancePartitionsPage(PageContext<ListInstancePartitionsRequest, ListInstancePartitionsResponse, InstancePartition> context, ListInstancePartitionsResponse response) {
            super(context, (Object)response);
        }

        private static ListInstancePartitionsPage createEmptyPage() {
            return new ListInstancePartitionsPage(null, null);
        }

        protected ListInstancePartitionsPage createPage(PageContext<ListInstancePartitionsRequest, ListInstancePartitionsResponse, InstancePartition> context, ListInstancePartitionsResponse response) {
            return new ListInstancePartitionsPage(context, response);
        }

        public ApiFuture<ListInstancePartitionsPage> createPageAsync(PageContext<ListInstancePartitionsRequest, ListInstancePartitionsResponse, InstancePartition> context, ApiFuture<ListInstancePartitionsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListInstancesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage, ListInstancesFixedSizeCollection> {
        private ListInstancesFixedSizeCollection(List<ListInstancesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListInstancesFixedSizeCollection createEmptyCollection() {
            return new ListInstancesFixedSizeCollection(null, 0);
        }

        protected ListInstancesFixedSizeCollection createCollection(List<ListInstancesPage> pages, int collectionSize) {
            return new ListInstancesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListInstancesPage
    extends AbstractPage<ListInstancesRequest, ListInstancesResponse, Instance, ListInstancesPage> {
        private ListInstancesPage(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ListInstancesResponse response) {
            super(context, (Object)response);
        }

        private static ListInstancesPage createEmptyPage() {
            return new ListInstancesPage(null, null);
        }

        protected ListInstancesPage createPage(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ListInstancesResponse response) {
            return new ListInstancesPage(context, response);
        }

        public ApiFuture<ListInstancesPage> createPageAsync(PageContext<ListInstancesRequest, ListInstancesResponse, Instance> context, ApiFuture<ListInstancesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListInstanceConfigOperationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInstanceConfigOperationsRequest, ListInstanceConfigOperationsResponse, Operation, ListInstanceConfigOperationsPage, ListInstanceConfigOperationsFixedSizeCollection> {
        private ListInstanceConfigOperationsFixedSizeCollection(List<ListInstanceConfigOperationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListInstanceConfigOperationsFixedSizeCollection createEmptyCollection() {
            return new ListInstanceConfigOperationsFixedSizeCollection(null, 0);
        }

        protected ListInstanceConfigOperationsFixedSizeCollection createCollection(List<ListInstanceConfigOperationsPage> pages, int collectionSize) {
            return new ListInstanceConfigOperationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListInstanceConfigOperationsPage
    extends AbstractPage<ListInstanceConfigOperationsRequest, ListInstanceConfigOperationsResponse, Operation, ListInstanceConfigOperationsPage> {
        private ListInstanceConfigOperationsPage(PageContext<ListInstanceConfigOperationsRequest, ListInstanceConfigOperationsResponse, Operation> context, ListInstanceConfigOperationsResponse response) {
            super(context, (Object)response);
        }

        private static ListInstanceConfigOperationsPage createEmptyPage() {
            return new ListInstanceConfigOperationsPage(null, null);
        }

        protected ListInstanceConfigOperationsPage createPage(PageContext<ListInstanceConfigOperationsRequest, ListInstanceConfigOperationsResponse, Operation> context, ListInstanceConfigOperationsResponse response) {
            return new ListInstanceConfigOperationsPage(context, response);
        }

        public ApiFuture<ListInstanceConfigOperationsPage> createPageAsync(PageContext<ListInstanceConfigOperationsRequest, ListInstanceConfigOperationsResponse, Operation> context, ApiFuture<ListInstanceConfigOperationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListInstanceConfigsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListInstanceConfigsRequest, ListInstanceConfigsResponse, InstanceConfig, ListInstanceConfigsPage, ListInstanceConfigsFixedSizeCollection> {
        private ListInstanceConfigsFixedSizeCollection(List<ListInstanceConfigsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListInstanceConfigsFixedSizeCollection createEmptyCollection() {
            return new ListInstanceConfigsFixedSizeCollection(null, 0);
        }

        protected ListInstanceConfigsFixedSizeCollection createCollection(List<ListInstanceConfigsPage> pages, int collectionSize) {
            return new ListInstanceConfigsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListInstanceConfigsPage
    extends AbstractPage<ListInstanceConfigsRequest, ListInstanceConfigsResponse, InstanceConfig, ListInstanceConfigsPage> {
        private ListInstanceConfigsPage(PageContext<ListInstanceConfigsRequest, ListInstanceConfigsResponse, InstanceConfig> context, ListInstanceConfigsResponse response) {
            super(context, (Object)response);
        }

        private static ListInstanceConfigsPage createEmptyPage() {
            return new ListInstanceConfigsPage(null, null);
        }

        protected ListInstanceConfigsPage createPage(PageContext<ListInstanceConfigsRequest, ListInstanceConfigsResponse, InstanceConfig> context, ListInstanceConfigsResponse response) {
            return new ListInstanceConfigsPage(context, response);
        }

        public ApiFuture<ListInstanceConfigsPage> createPageAsync(PageContext<ListInstanceConfigsRequest, ListInstanceConfigsResponse, InstanceConfig> context, ApiFuture<ListInstanceConfigsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }
}

