// Code generated by smithy-go-codegen DO NOT EDIT.

package bcmpricingcalculator

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bcmpricingcalculator/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

//	Create a Bill estimate from a Bill scenario. In the Bill scenario you can
//
// model usage addition, usage changes, and usage removal. You can also model
// commitment addition and commitment removal. After all changes in a Bill scenario
// is made satisfactorily, you can call this API with a Bill scenario ID to
// generate the Bill estimate. Bill estimate calculates the pre-tax cost for your
// consolidated billing family, incorporating all modeled usage and commitments
// alongside existing usage and commitments from your most recent completed
// anniversary bill, with any applicable discounts applied.
func (c *Client) CreateBillEstimate(ctx context.Context, params *CreateBillEstimateInput, optFns ...func(*Options)) (*CreateBillEstimateOutput, error) {
	if params == nil {
		params = &CreateBillEstimateInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateBillEstimate", params, optFns, c.addOperationCreateBillEstimateMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateBillEstimateOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateBillEstimateInput struct {

	//  The ID of the Bill Scenario for which you want to create a Bill estimate.
	//
	// This member is required.
	BillScenarioId *string

	//  The name of the Bill estimate that will be created. Names must be unique for
	// an account.
	//
	// This member is required.
	Name *string

	//  A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string

	//  An optional list of tags to associate with the specified BillEstimate. You can
	// use resource tags to control access to your BillEstimate using IAM policies.
	// Each tag consists of a key and a value, and each key must be unique for the
	// resource. The following restrictions apply to resource tags:
	//
	//   - Although the maximum number of array members is 200, you can assign a
	//   maximum of 50 user-tags to one resource. The remaining are reserved for Amazon
	//   Web Services.
	//
	//   - The maximum length of a key is 128 characters.
	//
	//   - The maximum length of a value is 256 characters.
	//
	//   - Keys and values can only contain alphanumeric characters, spaces, and any
	//   of the following: _.:/=+@- .
	//
	//   - Keys and values are case sensitive.
	//
	//   - Keys and values are trimmed for any leading or trailing whitespaces.
	//
	//   - Don't use aws: as a prefix for your keys. This prefix is reserved for Amazon
	//   Web Services.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateBillEstimateOutput struct {

	//  The unique identifier of your newly created Bill estimate.
	//
	// This member is required.
	Id *string

	//  The bill month start and end timestamp that was used to create the Bill
	// estimate. This is set to the last complete anniversary bill month start and end
	// timestamp.
	BillInterval *types.BillInterval

	//  Returns summary-level cost information once a Bill estimate is successfully
	// generated. This summary includes: 1) the total cost difference, showing the
	// pre-tax cost change for the consolidated billing family between the completed
	// anniversary bill and the estimated bill, and 2) total cost differences per
	// service, detailing the pre-tax cost of each service, comparing the completed
	// anniversary bill to the estimated bill on a per-service basis.
	CostSummary *types.BillEstimateCostSummary

	//  The timestamp of when the Bill estimate create process was started (not when
	// it successfully completed or failed).
	CreatedAt *time.Time

	//  The timestamp of when the Bill estimate will expire. A Bill estimate becomes
	// inaccessible after expiration.
	ExpiresAt *time.Time

	//  This attribute provides the reason if a Bill estimate result generation fails.
	FailureMessage *string

	//  The name of your newly created Bill estimate.
	Name *string

	//  The status of your newly created Bill estimate. Bill estimate creation can
	// take anywhere between 8 to 12 hours. The status will allow you to identify when
	// the Bill estimate is complete or has failed.
	Status types.BillEstimateStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateBillEstimateMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpCreateBillEstimate{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpCreateBillEstimate{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateBillEstimate"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateBillEstimateMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateBillEstimateValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateBillEstimate(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateBillEstimate struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateBillEstimate) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateBillEstimate) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateBillEstimateInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateBillEstimateInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateBillEstimateMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateBillEstimate{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateBillEstimate(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateBillEstimate",
	}
}
