// Code generated by smithy-go-codegen DO NOT EDIT.

package datazone

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datazone/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists child domain units for the specified parent domain unit.
func (c *Client) ListDomainUnitsForParent(ctx context.Context, params *ListDomainUnitsForParentInput, optFns ...func(*Options)) (*ListDomainUnitsForParentOutput, error) {
	if params == nil {
		params = &ListDomainUnitsForParentInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListDomainUnitsForParent", params, optFns, c.addOperationListDomainUnitsForParentMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListDomainUnitsForParentOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListDomainUnitsForParentInput struct {

	// The ID of the domain in which you want to list domain units for a parent domain
	// unit.
	//
	// This member is required.
	DomainIdentifier *string

	// The ID of the parent domain unit.
	//
	// This member is required.
	ParentDomainUnitIdentifier *string

	// The maximum number of domain units to return in a single call to
	// ListDomainUnitsForParent. When the number of domain units to be listed is
	// greater than the value of MaxResults, the response contains a NextToken value
	// that you can use in a subsequent call to ListDomainUnitsForParent to list the
	// next set of domain units.
	MaxResults *int32

	// When the number of domain units is greater than the default value for the
	// MaxResults parameter, or if you explicitly specify a value for MaxResults that
	// is less than the number of domain units, the response includes a pagination
	// token named NextToken. You can specify this NextToken value in a subsequent call
	// to ListDomainUnitsForParent to list the next set of domain units.
	NextToken *string

	noSmithyDocumentSerde
}

type ListDomainUnitsForParentOutput struct {

	// The results returned by this action.
	//
	// This member is required.
	Items []types.DomainUnitSummary

	// When the number of domain units is greater than the default value for the
	// MaxResults parameter, or if you explicitly specify a value for MaxResults that
	// is less than the number of domain units, the response includes a pagination
	// token named NextToken. You can specify this NextToken value in a subsequent call
	// to ListDomainUnitsForParent to list the next set of domain units.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListDomainUnitsForParentMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListDomainUnitsForParent{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListDomainUnitsForParent{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListDomainUnitsForParent"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListDomainUnitsForParentValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListDomainUnitsForParent(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListDomainUnitsForParentPaginatorOptions is the paginator options for
// ListDomainUnitsForParent
type ListDomainUnitsForParentPaginatorOptions struct {
	// The maximum number of domain units to return in a single call to
	// ListDomainUnitsForParent. When the number of domain units to be listed is
	// greater than the value of MaxResults, the response contains a NextToken value
	// that you can use in a subsequent call to ListDomainUnitsForParent to list the
	// next set of domain units.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListDomainUnitsForParentPaginator is a paginator for ListDomainUnitsForParent
type ListDomainUnitsForParentPaginator struct {
	options   ListDomainUnitsForParentPaginatorOptions
	client    ListDomainUnitsForParentAPIClient
	params    *ListDomainUnitsForParentInput
	nextToken *string
	firstPage bool
}

// NewListDomainUnitsForParentPaginator returns a new
// ListDomainUnitsForParentPaginator
func NewListDomainUnitsForParentPaginator(client ListDomainUnitsForParentAPIClient, params *ListDomainUnitsForParentInput, optFns ...func(*ListDomainUnitsForParentPaginatorOptions)) *ListDomainUnitsForParentPaginator {
	if params == nil {
		params = &ListDomainUnitsForParentInput{}
	}

	options := ListDomainUnitsForParentPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListDomainUnitsForParentPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListDomainUnitsForParentPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListDomainUnitsForParent page.
func (p *ListDomainUnitsForParentPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListDomainUnitsForParentOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListDomainUnitsForParent(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListDomainUnitsForParentAPIClient is a client that implements the
// ListDomainUnitsForParent operation.
type ListDomainUnitsForParentAPIClient interface {
	ListDomainUnitsForParent(context.Context, *ListDomainUnitsForParentInput, ...func(*Options)) (*ListDomainUnitsForParentOutput, error)
}

var _ ListDomainUnitsForParentAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListDomainUnitsForParent(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListDomainUnitsForParent",
	}
}
