// Code generated by smithy-go-codegen DO NOT EDIT.

package workspacesinstances

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/workspacesinstances/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"path"
)

type awsAwsjson10_serializeOpAssociateVolume struct {
}

func (*awsAwsjson10_serializeOpAssociateVolume) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpAssociateVolume) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateVolumeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("EUCMIFrontendAPIService.AssociateVolume")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentAssociateVolumeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpCreateVolume struct {
}

func (*awsAwsjson10_serializeOpCreateVolume) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpCreateVolume) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateVolumeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("EUCMIFrontendAPIService.CreateVolume")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentCreateVolumeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpCreateWorkspaceInstance struct {
}

func (*awsAwsjson10_serializeOpCreateWorkspaceInstance) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpCreateWorkspaceInstance) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateWorkspaceInstanceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("EUCMIFrontendAPIService.CreateWorkspaceInstance")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentCreateWorkspaceInstanceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpDeleteVolume struct {
}

func (*awsAwsjson10_serializeOpDeleteVolume) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpDeleteVolume) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteVolumeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("EUCMIFrontendAPIService.DeleteVolume")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentDeleteVolumeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpDeleteWorkspaceInstance struct {
}

func (*awsAwsjson10_serializeOpDeleteWorkspaceInstance) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpDeleteWorkspaceInstance) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteWorkspaceInstanceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("EUCMIFrontendAPIService.DeleteWorkspaceInstance")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentDeleteWorkspaceInstanceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpDisassociateVolume struct {
}

func (*awsAwsjson10_serializeOpDisassociateVolume) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpDisassociateVolume) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateVolumeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("EUCMIFrontendAPIService.DisassociateVolume")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentDisassociateVolumeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpGetWorkspaceInstance struct {
}

func (*awsAwsjson10_serializeOpGetWorkspaceInstance) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpGetWorkspaceInstance) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetWorkspaceInstanceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("EUCMIFrontendAPIService.GetWorkspaceInstance")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentGetWorkspaceInstanceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpListInstanceTypes struct {
}

func (*awsAwsjson10_serializeOpListInstanceTypes) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpListInstanceTypes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListInstanceTypesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("EUCMIFrontendAPIService.ListInstanceTypes")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentListInstanceTypesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpListRegions struct {
}

func (*awsAwsjson10_serializeOpListRegions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpListRegions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListRegionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("EUCMIFrontendAPIService.ListRegions")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentListRegionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpListTagsForResource struct {
}

func (*awsAwsjson10_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("EUCMIFrontendAPIService.ListTagsForResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentListTagsForResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpListWorkspaceInstances struct {
}

func (*awsAwsjson10_serializeOpListWorkspaceInstances) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpListWorkspaceInstances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListWorkspaceInstancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("EUCMIFrontendAPIService.ListWorkspaceInstances")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentListWorkspaceInstancesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpTagResource struct {
}

func (*awsAwsjson10_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("EUCMIFrontendAPIService.TagResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpUntagResource struct {
}

func (*awsAwsjson10_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("EUCMIFrontendAPIService.UntagResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentUntagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsAwsjson10_serializeDocumentBlockDeviceMappingRequest(v *types.BlockDeviceMappingRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeviceName != nil {
		ok := object.Key("DeviceName")
		ok.String(*v.DeviceName)
	}

	if v.Ebs != nil {
		ok := object.Key("Ebs")
		if err := awsAwsjson10_serializeDocumentEbsBlockDevice(v.Ebs, ok); err != nil {
			return err
		}
	}

	if v.NoDevice != nil {
		ok := object.Key("NoDevice")
		ok.String(*v.NoDevice)
	}

	if v.VirtualName != nil {
		ok := object.Key("VirtualName")
		ok.String(*v.VirtualName)
	}

	return nil
}

func awsAwsjson10_serializeDocumentBlockDeviceMappings(v []types.BlockDeviceMappingRequest, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson10_serializeDocumentBlockDeviceMappingRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentCapacityReservationSpecification(v *types.CapacityReservationSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.CapacityReservationPreference) > 0 {
		ok := object.Key("CapacityReservationPreference")
		ok.String(string(v.CapacityReservationPreference))
	}

	if v.CapacityReservationTarget != nil {
		ok := object.Key("CapacityReservationTarget")
		if err := awsAwsjson10_serializeDocumentCapacityReservationTarget(v.CapacityReservationTarget, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeDocumentCapacityReservationTarget(v *types.CapacityReservationTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CapacityReservationId != nil {
		ok := object.Key("CapacityReservationId")
		ok.String(*v.CapacityReservationId)
	}

	if v.CapacityReservationResourceGroupArn != nil {
		ok := object.Key("CapacityReservationResourceGroupArn")
		ok.String(*v.CapacityReservationResourceGroupArn)
	}

	return nil
}

func awsAwsjson10_serializeDocumentConnectionTrackingSpecificationRequest(v *types.ConnectionTrackingSpecificationRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TcpEstablishedTimeout != nil {
		ok := object.Key("TcpEstablishedTimeout")
		ok.Integer(*v.TcpEstablishedTimeout)
	}

	if v.UdpStreamTimeout != nil {
		ok := object.Key("UdpStreamTimeout")
		ok.Integer(*v.UdpStreamTimeout)
	}

	if v.UdpTimeout != nil {
		ok := object.Key("UdpTimeout")
		ok.Integer(*v.UdpTimeout)
	}

	return nil
}

func awsAwsjson10_serializeDocumentCpuOptionsRequest(v *types.CpuOptionsRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AmdSevSnp) > 0 {
		ok := object.Key("AmdSevSnp")
		ok.String(string(v.AmdSevSnp))
	}

	if v.CoreCount != nil {
		ok := object.Key("CoreCount")
		ok.Integer(*v.CoreCount)
	}

	if v.ThreadsPerCore != nil {
		ok := object.Key("ThreadsPerCore")
		ok.Integer(*v.ThreadsPerCore)
	}

	return nil
}

func awsAwsjson10_serializeDocumentCreditSpecificationRequest(v *types.CreditSpecificationRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.CpuCredits) > 0 {
		ok := object.Key("CpuCredits")
		ok.String(string(v.CpuCredits))
	}

	return nil
}

func awsAwsjson10_serializeDocumentEbsBlockDevice(v *types.EbsBlockDevice, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Encrypted != nil {
		ok := object.Key("Encrypted")
		ok.Boolean(*v.Encrypted)
	}

	if v.Iops != nil {
		ok := object.Key("Iops")
		ok.Integer(*v.Iops)
	}

	if v.KmsKeyId != nil {
		ok := object.Key("KmsKeyId")
		ok.String(*v.KmsKeyId)
	}

	if v.Throughput != nil {
		ok := object.Key("Throughput")
		ok.Integer(*v.Throughput)
	}

	if v.VolumeSize != nil {
		ok := object.Key("VolumeSize")
		ok.Integer(*v.VolumeSize)
	}

	if len(v.VolumeType) > 0 {
		ok := object.Key("VolumeType")
		ok.String(string(v.VolumeType))
	}

	return nil
}

func awsAwsjson10_serializeDocumentEnaSrdSpecificationRequest(v *types.EnaSrdSpecificationRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EnaSrdEnabled != nil {
		ok := object.Key("EnaSrdEnabled")
		ok.Boolean(*v.EnaSrdEnabled)
	}

	if v.EnaSrdUdpSpecification != nil {
		ok := object.Key("EnaSrdUdpSpecification")
		if err := awsAwsjson10_serializeDocumentEnaSrdUdpSpecificationRequest(v.EnaSrdUdpSpecification, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeDocumentEnaSrdUdpSpecificationRequest(v *types.EnaSrdUdpSpecificationRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EnaSrdUdpEnabled != nil {
		ok := object.Key("EnaSrdUdpEnabled")
		ok.Boolean(*v.EnaSrdUdpEnabled)
	}

	return nil
}

func awsAwsjson10_serializeDocumentEnclaveOptionsRequest(v *types.EnclaveOptionsRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Enabled != nil {
		ok := object.Key("Enabled")
		ok.Boolean(*v.Enabled)
	}

	return nil
}

func awsAwsjson10_serializeDocumentHibernationOptionsRequest(v *types.HibernationOptionsRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Configured != nil {
		ok := object.Key("Configured")
		ok.Boolean(*v.Configured)
	}

	return nil
}

func awsAwsjson10_serializeDocumentIamInstanceProfileSpecification(v *types.IamInstanceProfileSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arn != nil {
		ok := object.Key("Arn")
		ok.String(*v.Arn)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	return nil
}

func awsAwsjson10_serializeDocumentInstanceIpv6Address(v *types.InstanceIpv6Address, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Ipv6Address != nil {
		ok := object.Key("Ipv6Address")
		ok.String(*v.Ipv6Address)
	}

	if v.IsPrimaryIpv6 != nil {
		ok := object.Key("IsPrimaryIpv6")
		ok.Boolean(*v.IsPrimaryIpv6)
	}

	return nil
}

func awsAwsjson10_serializeDocumentInstanceMaintenanceOptionsRequest(v *types.InstanceMaintenanceOptionsRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AutoRecovery) > 0 {
		ok := object.Key("AutoRecovery")
		ok.String(string(v.AutoRecovery))
	}

	return nil
}

func awsAwsjson10_serializeDocumentInstanceMarketOptionsRequest(v *types.InstanceMarketOptionsRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.MarketType) > 0 {
		ok := object.Key("MarketType")
		ok.String(string(v.MarketType))
	}

	if v.SpotOptions != nil {
		ok := object.Key("SpotOptions")
		if err := awsAwsjson10_serializeDocumentSpotMarketOptions(v.SpotOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeDocumentInstanceMetadataOptionsRequest(v *types.InstanceMetadataOptionsRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.HttpEndpoint) > 0 {
		ok := object.Key("HttpEndpoint")
		ok.String(string(v.HttpEndpoint))
	}

	if len(v.HttpProtocolIpv6) > 0 {
		ok := object.Key("HttpProtocolIpv6")
		ok.String(string(v.HttpProtocolIpv6))
	}

	if v.HttpPutResponseHopLimit != nil {
		ok := object.Key("HttpPutResponseHopLimit")
		ok.Integer(*v.HttpPutResponseHopLimit)
	}

	if len(v.HttpTokens) > 0 {
		ok := object.Key("HttpTokens")
		ok.String(string(v.HttpTokens))
	}

	if len(v.InstanceMetadataTags) > 0 {
		ok := object.Key("InstanceMetadataTags")
		ok.String(string(v.InstanceMetadataTags))
	}

	return nil
}

func awsAwsjson10_serializeDocumentInstanceNetworkInterfaceSpecification(v *types.InstanceNetworkInterfaceSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AssociateCarrierIpAddress != nil {
		ok := object.Key("AssociateCarrierIpAddress")
		ok.Boolean(*v.AssociateCarrierIpAddress)
	}

	if v.AssociatePublicIpAddress != nil {
		ok := object.Key("AssociatePublicIpAddress")
		ok.Boolean(*v.AssociatePublicIpAddress)
	}

	if v.ConnectionTrackingSpecification != nil {
		ok := object.Key("ConnectionTrackingSpecification")
		if err := awsAwsjson10_serializeDocumentConnectionTrackingSpecificationRequest(v.ConnectionTrackingSpecification, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.DeviceIndex != nil {
		ok := object.Key("DeviceIndex")
		ok.Integer(*v.DeviceIndex)
	}

	if v.EnaSrdSpecification != nil {
		ok := object.Key("EnaSrdSpecification")
		if err := awsAwsjson10_serializeDocumentEnaSrdSpecificationRequest(v.EnaSrdSpecification, ok); err != nil {
			return err
		}
	}

	if v.Groups != nil {
		ok := object.Key("Groups")
		if err := awsAwsjson10_serializeDocumentSecurityGroupIds(v.Groups, ok); err != nil {
			return err
		}
	}

	if len(v.InterfaceType) > 0 {
		ok := object.Key("InterfaceType")
		ok.String(string(v.InterfaceType))
	}

	if v.Ipv4PrefixCount != nil {
		ok := object.Key("Ipv4PrefixCount")
		ok.Integer(*v.Ipv4PrefixCount)
	}

	if v.Ipv4Prefixes != nil {
		ok := object.Key("Ipv4Prefixes")
		if err := awsAwsjson10_serializeDocumentIpv4Prefixes(v.Ipv4Prefixes, ok); err != nil {
			return err
		}
	}

	if v.Ipv6AddressCount != nil {
		ok := object.Key("Ipv6AddressCount")
		ok.Integer(*v.Ipv6AddressCount)
	}

	if v.Ipv6Addresses != nil {
		ok := object.Key("Ipv6Addresses")
		if err := awsAwsjson10_serializeDocumentIpv6Addresses(v.Ipv6Addresses, ok); err != nil {
			return err
		}
	}

	if v.Ipv6PrefixCount != nil {
		ok := object.Key("Ipv6PrefixCount")
		ok.Integer(*v.Ipv6PrefixCount)
	}

	if v.Ipv6Prefixes != nil {
		ok := object.Key("Ipv6Prefixes")
		if err := awsAwsjson10_serializeDocumentIpv6Prefixes(v.Ipv6Prefixes, ok); err != nil {
			return err
		}
	}

	if v.NetworkCardIndex != nil {
		ok := object.Key("NetworkCardIndex")
		ok.Integer(*v.NetworkCardIndex)
	}

	if v.NetworkInterfaceId != nil {
		ok := object.Key("NetworkInterfaceId")
		ok.String(*v.NetworkInterfaceId)
	}

	if v.PrimaryIpv6 != nil {
		ok := object.Key("PrimaryIpv6")
		ok.Boolean(*v.PrimaryIpv6)
	}

	if v.PrivateIpAddress != nil {
		ok := object.Key("PrivateIpAddress")
		ok.String(*v.PrivateIpAddress)
	}

	if v.PrivateIpAddresses != nil {
		ok := object.Key("PrivateIpAddresses")
		if err := awsAwsjson10_serializeDocumentPrivateIpAddresses(v.PrivateIpAddresses, ok); err != nil {
			return err
		}
	}

	if v.SecondaryPrivateIpAddressCount != nil {
		ok := object.Key("SecondaryPrivateIpAddressCount")
		ok.Integer(*v.SecondaryPrivateIpAddressCount)
	}

	if v.SubnetId != nil {
		ok := object.Key("SubnetId")
		ok.String(*v.SubnetId)
	}

	return nil
}

func awsAwsjson10_serializeDocumentInstanceNetworkPerformanceOptionsRequest(v *types.InstanceNetworkPerformanceOptionsRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.BandwidthWeighting) > 0 {
		ok := object.Key("BandwidthWeighting")
		ok.String(string(v.BandwidthWeighting))
	}

	return nil
}

func awsAwsjson10_serializeDocumentIpv4Prefixes(v []types.Ipv4PrefixSpecificationRequest, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson10_serializeDocumentIpv4PrefixSpecificationRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentIpv4PrefixSpecificationRequest(v *types.Ipv4PrefixSpecificationRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Ipv4Prefix != nil {
		ok := object.Key("Ipv4Prefix")
		ok.String(*v.Ipv4Prefix)
	}

	return nil
}

func awsAwsjson10_serializeDocumentIpv6Addresses(v []types.InstanceIpv6Address, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson10_serializeDocumentInstanceIpv6Address(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentIpv6Prefixes(v []types.Ipv6PrefixSpecificationRequest, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson10_serializeDocumentIpv6PrefixSpecificationRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentIpv6PrefixSpecificationRequest(v *types.Ipv6PrefixSpecificationRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Ipv6Prefix != nil {
		ok := object.Key("Ipv6Prefix")
		ok.String(*v.Ipv6Prefix)
	}

	return nil
}

func awsAwsjson10_serializeDocumentLicenseConfigurationRequest(v *types.LicenseConfigurationRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LicenseConfigurationArn != nil {
		ok := object.Key("LicenseConfigurationArn")
		ok.String(*v.LicenseConfigurationArn)
	}

	return nil
}

func awsAwsjson10_serializeDocumentLicenseSpecifications(v []types.LicenseConfigurationRequest, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson10_serializeDocumentLicenseConfigurationRequest(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentManagedInstanceRequest(v *types.ManagedInstanceRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BlockDeviceMappings != nil {
		ok := object.Key("BlockDeviceMappings")
		if err := awsAwsjson10_serializeDocumentBlockDeviceMappings(v.BlockDeviceMappings, ok); err != nil {
			return err
		}
	}

	if v.CapacityReservationSpecification != nil {
		ok := object.Key("CapacityReservationSpecification")
		if err := awsAwsjson10_serializeDocumentCapacityReservationSpecification(v.CapacityReservationSpecification, ok); err != nil {
			return err
		}
	}

	if v.CpuOptions != nil {
		ok := object.Key("CpuOptions")
		if err := awsAwsjson10_serializeDocumentCpuOptionsRequest(v.CpuOptions, ok); err != nil {
			return err
		}
	}

	if v.CreditSpecification != nil {
		ok := object.Key("CreditSpecification")
		if err := awsAwsjson10_serializeDocumentCreditSpecificationRequest(v.CreditSpecification, ok); err != nil {
			return err
		}
	}

	if v.DisableApiStop != nil {
		ok := object.Key("DisableApiStop")
		ok.Boolean(*v.DisableApiStop)
	}

	if v.EbsOptimized != nil {
		ok := object.Key("EbsOptimized")
		ok.Boolean(*v.EbsOptimized)
	}

	if v.EnablePrimaryIpv6 != nil {
		ok := object.Key("EnablePrimaryIpv6")
		ok.Boolean(*v.EnablePrimaryIpv6)
	}

	if v.EnclaveOptions != nil {
		ok := object.Key("EnclaveOptions")
		if err := awsAwsjson10_serializeDocumentEnclaveOptionsRequest(v.EnclaveOptions, ok); err != nil {
			return err
		}
	}

	if v.HibernationOptions != nil {
		ok := object.Key("HibernationOptions")
		if err := awsAwsjson10_serializeDocumentHibernationOptionsRequest(v.HibernationOptions, ok); err != nil {
			return err
		}
	}

	if v.IamInstanceProfile != nil {
		ok := object.Key("IamInstanceProfile")
		if err := awsAwsjson10_serializeDocumentIamInstanceProfileSpecification(v.IamInstanceProfile, ok); err != nil {
			return err
		}
	}

	if v.ImageId != nil {
		ok := object.Key("ImageId")
		ok.String(*v.ImageId)
	}

	if v.InstanceMarketOptions != nil {
		ok := object.Key("InstanceMarketOptions")
		if err := awsAwsjson10_serializeDocumentInstanceMarketOptionsRequest(v.InstanceMarketOptions, ok); err != nil {
			return err
		}
	}

	if v.InstanceType != nil {
		ok := object.Key("InstanceType")
		ok.String(*v.InstanceType)
	}

	if v.Ipv6AddressCount != nil {
		ok := object.Key("Ipv6AddressCount")
		ok.Integer(*v.Ipv6AddressCount)
	}

	if v.Ipv6Addresses != nil {
		ok := object.Key("Ipv6Addresses")
		if err := awsAwsjson10_serializeDocumentIpv6Addresses(v.Ipv6Addresses, ok); err != nil {
			return err
		}
	}

	if v.KernelId != nil {
		ok := object.Key("KernelId")
		ok.String(*v.KernelId)
	}

	if v.KeyName != nil {
		ok := object.Key("KeyName")
		ok.String(*v.KeyName)
	}

	if v.LicenseSpecifications != nil {
		ok := object.Key("LicenseSpecifications")
		if err := awsAwsjson10_serializeDocumentLicenseSpecifications(v.LicenseSpecifications, ok); err != nil {
			return err
		}
	}

	if v.MaintenanceOptions != nil {
		ok := object.Key("MaintenanceOptions")
		if err := awsAwsjson10_serializeDocumentInstanceMaintenanceOptionsRequest(v.MaintenanceOptions, ok); err != nil {
			return err
		}
	}

	if v.MetadataOptions != nil {
		ok := object.Key("MetadataOptions")
		if err := awsAwsjson10_serializeDocumentInstanceMetadataOptionsRequest(v.MetadataOptions, ok); err != nil {
			return err
		}
	}

	if v.Monitoring != nil {
		ok := object.Key("Monitoring")
		if err := awsAwsjson10_serializeDocumentRunInstancesMonitoringEnabled(v.Monitoring, ok); err != nil {
			return err
		}
	}

	if v.NetworkInterfaces != nil {
		ok := object.Key("NetworkInterfaces")
		if err := awsAwsjson10_serializeDocumentNetworkInterfaces(v.NetworkInterfaces, ok); err != nil {
			return err
		}
	}

	if v.NetworkPerformanceOptions != nil {
		ok := object.Key("NetworkPerformanceOptions")
		if err := awsAwsjson10_serializeDocumentInstanceNetworkPerformanceOptionsRequest(v.NetworkPerformanceOptions, ok); err != nil {
			return err
		}
	}

	if v.Placement != nil {
		ok := object.Key("Placement")
		if err := awsAwsjson10_serializeDocumentPlacement(v.Placement, ok); err != nil {
			return err
		}
	}

	if v.PrivateDnsNameOptions != nil {
		ok := object.Key("PrivateDnsNameOptions")
		if err := awsAwsjson10_serializeDocumentPrivateDnsNameOptionsRequest(v.PrivateDnsNameOptions, ok); err != nil {
			return err
		}
	}

	if v.PrivateIpAddress != nil {
		ok := object.Key("PrivateIpAddress")
		ok.String(*v.PrivateIpAddress)
	}

	if v.RamdiskId != nil {
		ok := object.Key("RamdiskId")
		ok.String(*v.RamdiskId)
	}

	if v.SecurityGroupIds != nil {
		ok := object.Key("SecurityGroupIds")
		if err := awsAwsjson10_serializeDocumentSecurityGroupIds(v.SecurityGroupIds, ok); err != nil {
			return err
		}
	}

	if v.SecurityGroups != nil {
		ok := object.Key("SecurityGroups")
		if err := awsAwsjson10_serializeDocumentSecurityGroupNames(v.SecurityGroups, ok); err != nil {
			return err
		}
	}

	if v.SubnetId != nil {
		ok := object.Key("SubnetId")
		ok.String(*v.SubnetId)
	}

	if v.TagSpecifications != nil {
		ok := object.Key("TagSpecifications")
		if err := awsAwsjson10_serializeDocumentTagSpecifications(v.TagSpecifications, ok); err != nil {
			return err
		}
	}

	if v.UserData != nil {
		ok := object.Key("UserData")
		ok.String(*v.UserData)
	}

	return nil
}

func awsAwsjson10_serializeDocumentNetworkInterfaces(v []types.InstanceNetworkInterfaceSpecification, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson10_serializeDocumentInstanceNetworkInterfaceSpecification(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentPlacement(v *types.Placement, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Affinity != nil {
		ok := object.Key("Affinity")
		ok.String(*v.Affinity)
	}

	if v.AvailabilityZone != nil {
		ok := object.Key("AvailabilityZone")
		ok.String(*v.AvailabilityZone)
	}

	if v.GroupId != nil {
		ok := object.Key("GroupId")
		ok.String(*v.GroupId)
	}

	if v.GroupName != nil {
		ok := object.Key("GroupName")
		ok.String(*v.GroupName)
	}

	if v.HostId != nil {
		ok := object.Key("HostId")
		ok.String(*v.HostId)
	}

	if v.HostResourceGroupArn != nil {
		ok := object.Key("HostResourceGroupArn")
		ok.String(*v.HostResourceGroupArn)
	}

	if v.PartitionNumber != nil {
		ok := object.Key("PartitionNumber")
		ok.Integer(*v.PartitionNumber)
	}

	if len(v.Tenancy) > 0 {
		ok := object.Key("Tenancy")
		ok.String(string(v.Tenancy))
	}

	return nil
}

func awsAwsjson10_serializeDocumentPrivateDnsNameOptionsRequest(v *types.PrivateDnsNameOptionsRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EnableResourceNameDnsAAAARecord != nil {
		ok := object.Key("EnableResourceNameDnsAAAARecord")
		ok.Boolean(*v.EnableResourceNameDnsAAAARecord)
	}

	if v.EnableResourceNameDnsARecord != nil {
		ok := object.Key("EnableResourceNameDnsARecord")
		ok.Boolean(*v.EnableResourceNameDnsARecord)
	}

	if len(v.HostnameType) > 0 {
		ok := object.Key("HostnameType")
		ok.String(string(v.HostnameType))
	}

	return nil
}

func awsAwsjson10_serializeDocumentPrivateIpAddresses(v []types.PrivateIpAddressSpecification, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson10_serializeDocumentPrivateIpAddressSpecification(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentPrivateIpAddressSpecification(v *types.PrivateIpAddressSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Primary != nil {
		ok := object.Key("Primary")
		ok.Boolean(*v.Primary)
	}

	if v.PrivateIpAddress != nil {
		ok := object.Key("PrivateIpAddress")
		ok.String(*v.PrivateIpAddress)
	}

	return nil
}

func awsAwsjson10_serializeDocumentProvisionStates(v []types.ProvisionStateEnum, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson10_serializeDocumentRunInstancesMonitoringEnabled(v *types.RunInstancesMonitoringEnabled, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Enabled != nil {
		ok := object.Key("Enabled")
		ok.Boolean(*v.Enabled)
	}

	return nil
}

func awsAwsjson10_serializeDocumentSecurityGroupIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson10_serializeDocumentSecurityGroupNames(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson10_serializeDocumentSpotMarketOptions(v *types.SpotMarketOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BlockDurationMinutes != nil {
		ok := object.Key("BlockDurationMinutes")
		ok.Integer(*v.BlockDurationMinutes)
	}

	if len(v.InstanceInterruptionBehavior) > 0 {
		ok := object.Key("InstanceInterruptionBehavior")
		ok.String(string(v.InstanceInterruptionBehavior))
	}

	if v.MaxPrice != nil {
		ok := object.Key("MaxPrice")
		ok.String(*v.MaxPrice)
	}

	if len(v.SpotInstanceType) > 0 {
		ok := object.Key("SpotInstanceType")
		ok.String(string(v.SpotInstanceType))
	}

	if v.ValidUntilUtc != nil {
		ok := object.Key("ValidUntilUtc")
		ok.Double(smithytime.FormatEpochSeconds(*v.ValidUntilUtc))
	}

	return nil
}

func awsAwsjson10_serializeDocumentTag(v *types.Tag, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson10_serializeDocumentTagKeyList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson10_serializeDocumentTagList(v []types.Tag, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson10_serializeDocumentTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentTagSpecification(v *types.TagSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ResourceType) > 0 {
		ok := object.Key("ResourceType")
		ok.String(string(v.ResourceType))
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson10_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeDocumentTagSpecifications(v []types.TagSpecification, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson10_serializeDocumentTagSpecification(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeOpDocumentAssociateVolumeInput(v *AssociateVolumeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Device != nil {
		ok := object.Key("Device")
		ok.String(*v.Device)
	}

	if v.VolumeId != nil {
		ok := object.Key("VolumeId")
		ok.String(*v.VolumeId)
	}

	if v.WorkspaceInstanceId != nil {
		ok := object.Key("WorkspaceInstanceId")
		ok.String(*v.WorkspaceInstanceId)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentCreateVolumeInput(v *CreateVolumeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AvailabilityZone != nil {
		ok := object.Key("AvailabilityZone")
		ok.String(*v.AvailabilityZone)
	}

	if v.ClientToken != nil {
		ok := object.Key("ClientToken")
		ok.String(*v.ClientToken)
	}

	if v.Encrypted != nil {
		ok := object.Key("Encrypted")
		ok.Boolean(*v.Encrypted)
	}

	if v.Iops != nil {
		ok := object.Key("Iops")
		ok.Integer(*v.Iops)
	}

	if v.KmsKeyId != nil {
		ok := object.Key("KmsKeyId")
		ok.String(*v.KmsKeyId)
	}

	if v.SizeInGB != nil {
		ok := object.Key("SizeInGB")
		ok.Integer(*v.SizeInGB)
	}

	if v.SnapshotId != nil {
		ok := object.Key("SnapshotId")
		ok.String(*v.SnapshotId)
	}

	if v.TagSpecifications != nil {
		ok := object.Key("TagSpecifications")
		if err := awsAwsjson10_serializeDocumentTagSpecifications(v.TagSpecifications, ok); err != nil {
			return err
		}
	}

	if v.Throughput != nil {
		ok := object.Key("Throughput")
		ok.Integer(*v.Throughput)
	}

	if len(v.VolumeType) > 0 {
		ok := object.Key("VolumeType")
		ok.String(string(v.VolumeType))
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentCreateWorkspaceInstanceInput(v *CreateWorkspaceInstanceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("ClientToken")
		ok.String(*v.ClientToken)
	}

	if v.ManagedInstance != nil {
		ok := object.Key("ManagedInstance")
		if err := awsAwsjson10_serializeDocumentManagedInstanceRequest(v.ManagedInstance, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson10_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentDeleteVolumeInput(v *DeleteVolumeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.VolumeId != nil {
		ok := object.Key("VolumeId")
		ok.String(*v.VolumeId)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentDeleteWorkspaceInstanceInput(v *DeleteWorkspaceInstanceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.WorkspaceInstanceId != nil {
		ok := object.Key("WorkspaceInstanceId")
		ok.String(*v.WorkspaceInstanceId)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentDisassociateVolumeInput(v *DisassociateVolumeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Device != nil {
		ok := object.Key("Device")
		ok.String(*v.Device)
	}

	if len(v.DisassociateMode) > 0 {
		ok := object.Key("DisassociateMode")
		ok.String(string(v.DisassociateMode))
	}

	if v.VolumeId != nil {
		ok := object.Key("VolumeId")
		ok.String(*v.VolumeId)
	}

	if v.WorkspaceInstanceId != nil {
		ok := object.Key("WorkspaceInstanceId")
		ok.String(*v.WorkspaceInstanceId)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentGetWorkspaceInstanceInput(v *GetWorkspaceInstanceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.WorkspaceInstanceId != nil {
		ok := object.Key("WorkspaceInstanceId")
		ok.String(*v.WorkspaceInstanceId)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentListInstanceTypesInput(v *ListInstanceTypesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentListRegionsInput(v *ListRegionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentListTagsForResourceInput(v *ListTagsForResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.WorkspaceInstanceId != nil {
		ok := object.Key("WorkspaceInstanceId")
		ok.String(*v.WorkspaceInstanceId)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentListWorkspaceInstancesInput(v *ListWorkspaceInstancesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.ProvisionStates != nil {
		ok := object.Key("ProvisionStates")
		if err := awsAwsjson10_serializeDocumentProvisionStates(v.ProvisionStates, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson10_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.WorkspaceInstanceId != nil {
		ok := object.Key("WorkspaceInstanceId")
		ok.String(*v.WorkspaceInstanceId)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentUntagResourceInput(v *UntagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TagKeys != nil {
		ok := object.Key("TagKeys")
		if err := awsAwsjson10_serializeDocumentTagKeyList(v.TagKeys, ok); err != nil {
			return err
		}
	}

	if v.WorkspaceInstanceId != nil {
		ok := object.Key("WorkspaceInstanceId")
		ok.String(*v.WorkspaceInstanceId)
	}

	return nil
}
