package common

import (
	"github.com/spf13/cobra"
)

func AddTLSAndSSLOptions(cmd *cobra.Command) {
	cmd.Flags().BoolS("allow_no_dhe_kex", "allow_no_dhe_kex", false, "In TLSv1.3 allow non-(ec)dhe based key exchange on resumption")
	cmd.Flags().BoolS("bugs", "bugs", false, "Turn on SSL bug compatibility")
	cmd.Flags().StringS("cipher", "cipher", "", "Specify TLSv1.2 and below cipher list to be used")
	cmd.Flags().StringS("ciphersuites", "ciphersuites", "", "Specify TLSv1.3 ciphersuites to be used")
	cmd.Flags().BoolS("client_renegotiation", "client_renegotiation", false, "Allow client-initiated renegotiation")
	cmd.Flags().StringS("client_sigalgs", "client_sigalgs", "", "Signature algorithms to support for client certificate authentication (colon-separated list)")
	cmd.Flags().BoolS("comp", "comp", false, "Use SSL/TLS-level compression")
	cmd.Flags().StringS("curves", "curves", "", "Groups to advertise (colon-separated list)")
	cmd.Flags().BoolS("debug_broken_protocol", "debug_broken_protocol", false, "Perform all sorts of protocol violations for testing purposes")
	cmd.Flags().StringS("groups", "groups", "", "Groups to advertise (colon-separated list)")
	cmd.Flags().BoolS("legacy_renegotiation", "legacy_renegotiation", false, "Enable use of legacy renegotiation (dangerous)")
	cmd.Flags().BoolS("legacy_server_connect", "legacy_server_connect", false, "Allow initial connection to servers that don't support RI")
	cmd.Flags().StringS("max_protocol", "max_protocol", "", "Specify the maximum protocol version to be used")
	cmd.Flags().StringS("min_protocol", "min_protocol", "", "Specify the minimum protocol version to be used")
	cmd.Flags().StringS("named_curve", "named_curve", "", "Elliptic curve used for ECDHE (server-side only)")
	cmd.Flags().BoolS("no_comp", "no_comp", false, "Disable SSL/TLS compression (default)")
	cmd.Flags().BoolS("no_ems", "no_ems", false, "Disable Extended master secret extension")
	cmd.Flags().BoolS("no_etm", "no_etm", false, "Disable Encrypt-then-Mac extension")
	cmd.Flags().BoolS("no_legacy_server_connect", "no_legacy_server_connect", false, "Disallow initial connection to servers that don't support RI")
	cmd.Flags().BoolS("no_middlebox", "no_middlebox", false, "Disable TLSv1.3 middlebox compat mode")
	cmd.Flags().BoolS("no_renegotiation", "no_renegotiation", false, "Disable all renegotiation.")
	cmd.Flags().BoolS("no_resumption_on_reneg", "no_resumption_on_reneg", false, "Disallow session resumption on renegotiation")
	cmd.Flags().BoolS("no_rx_cert_comp", "no_rx_cert_comp", false, "Disable receiving TLSv1.3 compressed certificates")
	cmd.Flags().BoolS("no_ssl3", "no_ssl3", false, "Just disable SSLv3")
	cmd.Flags().BoolS("no_ticket", "no_ticket", false, "Disable use of TLS session tickets")
	cmd.Flags().BoolS("no_tls1", "no_tls1", false, "Just disable TLSv1")
	cmd.Flags().BoolS("no_tls1_1", "no_tls1_1", false, "Just disable TLSv1.1")
	cmd.Flags().BoolS("no_tls1_2", "no_tls1_2", false, "Just disable TLSv1.2")
	cmd.Flags().BoolS("no_tls1_3", "no_tls1_3", false, "Just disable TLSv1.3")
	cmd.Flags().BoolS("no_tx_cert_comp", "no_tx_cert_comp", false, "Disable sending TLSv1.3 compressed certificates")
	cmd.Flags().BoolS("prefer_no_dhe_kex", "prefer_no_dhe_kex", false, "In TLSv1.3 prefer non-(ec)dhe over (ec)dhe-based key exchange on resumption")
	cmd.Flags().BoolS("prioritize_chacha", "prioritize_chacha", false, "Prioritize ChaCha ciphers when preferred by clients")
	cmd.Flags().StringS("record_padding", "record_padding", "", "Block size to pad TLS 1.3 records to.")
	cmd.Flags().BoolS("serverpref", "serverpref", false, "Use server's cipher preferences")
	cmd.Flags().StringS("sigalgs", "sigalgs", "", "Signature algorithms to support (colon-separated list)")
	cmd.Flags().BoolS("strict", "strict", false, "Enforce strict certificate checks as per TLS standard")
}
