# v0.29 - Art Exchange

![](./v0.29/banner.png)

One step further to exchange completions between commands.

## carapace.sh

Registered the domain [carapace.sh](https://carapace.sh).

## Root Command

Restructured the `carapace` root command which was (and still is) a bit of a mess.
Some *flags* (subcommands) were renamed/changed for consistency.

- `--list=json` -> `--list --format json`
- `--macros` -> `--macro`
- `--scrape [spec]` -> `--codegen [spec]`

## Specs

The [JSON Schema](http://json-schema.org/) is now hosted at [https://carapace.sh/schemas/command.json](https://carapace.sh/schemas/command.json).

```yaml
# yaml-language-server: $schema=https://carapace.sh/schemas/command.json
```

> `~/.config/carapace/schema.json` is now deprecated and can be removed.

## Macro

`$_` prefix in specs is now deprecated and needs to be replaced with `$carapace.`

If a macro name contains `.` the first segment is handled as command that will be invoked.

```sh
$carapace.color.HexColors
# invokes `carapace _carapace macro color.HexColors ""`

$carapace-spec.Spec(example.yaml)
# invokes `carapace-spec _carapace macro "Spec(example.yaml)" ""`
```

> This behaviour will change slightly in the future to support custom macros.

With the `--in-place` flag of `sed` the specs can be updated directly.
```sh
sed 's/$_/$carapace./g' ~/.config/carapace/specs/*.yaml
```

## Inshellisense

Added a bridge for [inshellisense](https://github.com/microsoft/inshellisense) (which uses [fig](https://fig.io) under the hood).

## Nushell

Support for colored completion (requires [nushell#11442](https://github.com/nushell/nushell/pull/11442)).

![](./v0.29/nushell.png)

## Xonsh

Support for colored completion.

![](./v0.29/xonsh.png)

