# Related software

## Editor integration

### [`github.com/andre-kotake/nvim-chezmoi`](https://github.com/andre-kotake/nvim-chezmoi) { id="andre-kotake/nvim-chezmoi" }

A NeoVim plugin that integrates with chezmoi.

### [`github.com/alker0/chezmoi.vim`](https://github.com/alker0/chezmoi.vim) { id="alker0/chezmoi.vim" }

Intelligent VIM syntax highlighting when editing files in your source directory.
Works with both `chezmoi edit` and editing files directly.

### [`github.com/tuh8888/chezmoi.el`](https://github.com/tuh8888/chezmoi.el) { id="tuh8888/chezmoi.el" }

Convenience functions for interacting with chezmoi in Emacs.

### [`github.com/Lilja/vim-chezmoi`](https://github.com/Lilja/vim-chezmoi) { id="lilja/vim-chezmoi" }

A plugin for VIM to apply the dotfile you are editing on `:w`.

### [`github.com/xvzc/chezmoi.nvim`](https://github.com/xvzc/chezmoi.nvim) { id="xvzc/chezmoi.nvim" }

Edit your chezmoi-managed files and automatically apply.

### [`github.com/GianniBYoung/chezmoi-telescope.nvim`](https://github.com/GianniBYoung/chezmoi-telescope.nvim) { id="GianniBYoung/chezmoi-telescope.nvim" }

Custom Telescope Picker for Chez Moi Managed Dot files.

## Other

### [`atuin.sh`](https://atuin.sh/) { id="atuin" }

Sync, search and backup shell history.

### [`github.com/b3nj5m1n/xdg-ninja`](https://github.com/b3nj5m1n/xdg-ninja) { id="xdg-ninja" }

A shell script which checks your $HOME for unwanted files and directories.

### [`github.com/hussainweb/ansible-role-chezmoi`](https://github.com/hussainweb/ansible-role-chezmoi) { id="hussainweb/ansible-role-chezmoi" }

Installs chezmoi on Ubuntu and Debian servers.

### [`github.com/johan-weitner/chezmoi-ui`](https://github.com/johan-weitner/chezmoi-ui) { id="johan-weitner/chezmoi-ui" }

A web UI for managing a list of apps to seed/feed a chezmoi setup.

### [`github.com/joke/asdf-chezmoi`](https://github.com/joke/asdf-chezmoi) { id="joke/asdf-chezmoi" }

chezmoi plugin for asdf version manager.

### [`github.com/mass8326/zsh-chezmoi`](https://github.com/mass8326/zsh-chezmoi) { id="mass8326/zsh-chezmoi" }

Add completion and aliases for chezmoi to make managing dotfiles easier to zsh.

### [`github.com/matmaer/chezmoi-mousse`](https://github.com/matmaer/chezmoi-mousse) { id="matmaer/chezmoi-mousse" }

Visual interface in the terminal for the chezmoi dotfile managar, with a wink to the mouse.

### [Chezetc](https://silverrainz.me/chezetc/) { id="silverrainz.me/chezetc" }

Extending chezmoi to manage files under /etc and other root-owned directories.

### [`github.com/tcaxle/drapeau`](https://github.com/tcaxle/drapeau) { id="tcaxle/drapeau" }

An add-on to synchronize your colorschemes across systems and allow easy
colorscheme switching using chezmoi templates.

### [`github.com/VorpalBlade/chezmoi_modify_manager`](https://github.com/VorpalBlade/chezmoi_modify_manager) { id="vorpalblade/chezmoi_modify_manager" }

An add-on to deal with config files that contain a mix of settings and transient
state, such as with GUI program settings files also containing recently used
files and window positions.

### [`install.doctor`](https://install.doctor) { id="install.doctor" }

Desktop provisioning system.

### [`github.com/halostatue/fish-chezmoi`](https://github.com/halostatue/fish-chezmoi)

A plug-in for the Fish shell that ensures that completions are always loaded and
a function that wraps `chezmoi cd` to not create a sub-shell.
