/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	gentype "k8s.io/client-go/gentype"
	kops "k8s.io/kops/pkg/apis/kops"
	internalversion "k8s.io/kops/pkg/client/clientset_generated/clientset/typed/kops/internalversion"
)

// fakeKeysets implements KeysetInterface
type fakeKeysets struct {
	*gentype.FakeClientWithList[*kops.Keyset, *kops.KeysetList]
	Fake *FakeKops
}

func newFakeKeysets(fake *FakeKops, namespace string) internalversion.KeysetInterface {
	return &fakeKeysets{
		gentype.NewFakeClientWithList[*kops.Keyset, *kops.KeysetList](
			fake.Fake,
			namespace,
			kops.SchemeGroupVersion.WithResource("keysets"),
			kops.SchemeGroupVersion.WithKind("Keyset"),
			func() *kops.Keyset { return &kops.Keyset{} },
			func() *kops.KeysetList { return &kops.KeysetList{} },
			func(dst, src *kops.KeysetList) { dst.ListMeta = src.ListMeta },
			func(list *kops.KeysetList) []*kops.Keyset { return gentype.ToPointerSlice(list.Items) },
			func(list *kops.KeysetList, items []*kops.Keyset) { list.Items = gentype.FromPointerSlice(items) },
		),
		fake,
	}
}
