// Copyright 2024-2025 Andres Morey
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        v5.29.3
// source: cluster_agent.proto

package clusteragentpb

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type FollowFrom int32

const (
	FollowFrom_NOOP    FollowFrom = 0
	FollowFrom_DEFAULT FollowFrom = 1 // Use default behavior for follow
	FollowFrom_END     FollowFrom = 2 // Follow from the end of the log
)

// Enum value maps for FollowFrom.
var (
	FollowFrom_name = map[int32]string{
		0: "NOOP",
		1: "DEFAULT",
		2: "END",
	}
	FollowFrom_value = map[string]int32{
		"NOOP":    0,
		"DEFAULT": 1,
		"END":     2,
	}
)

func (x FollowFrom) Enum() *FollowFrom {
	p := new(FollowFrom)
	*p = x
	return p
}

func (x FollowFrom) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FollowFrom) Descriptor() protoreflect.EnumDescriptor {
	return file_cluster_agent_proto_enumTypes[0].Descriptor()
}

func (FollowFrom) Type() protoreflect.EnumType {
	return &file_cluster_agent_proto_enumTypes[0]
}

func (x FollowFrom) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FollowFrom.Descriptor instead.
func (FollowFrom) EnumDescriptor() ([]byte, []int) {
	return file_cluster_agent_proto_rawDescGZIP(), []int{0}
}

type LogMetadata struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Id            string                 `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Spec          *LogMetadataSpec       `protobuf:"bytes,2,opt,name=spec,proto3" json:"spec,omitempty"`
	FileInfo      *LogMetadataFileInfo   `protobuf:"bytes,3,opt,name=fileInfo,proto3" json:"fileInfo,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LogMetadata) Reset() {
	*x = LogMetadata{}
	mi := &file_cluster_agent_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogMetadata) ProtoMessage() {}

func (x *LogMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_agent_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogMetadata.ProtoReflect.Descriptor instead.
func (*LogMetadata) Descriptor() ([]byte, []int) {
	return file_cluster_agent_proto_rawDescGZIP(), []int{0}
}

func (x *LogMetadata) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *LogMetadata) GetSpec() *LogMetadataSpec {
	if x != nil {
		return x.Spec
	}
	return nil
}

func (x *LogMetadata) GetFileInfo() *LogMetadataFileInfo {
	if x != nil {
		return x.FileInfo
	}
	return nil
}

type LogMetadataFileInfo struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	Size           int64                  `protobuf:"varint,1,opt,name=size,proto3" json:"size,omitempty"`
	LastModifiedAt *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=last_modified_at,json=lastModifiedAt,proto3" json:"last_modified_at,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *LogMetadataFileInfo) Reset() {
	*x = LogMetadataFileInfo{}
	mi := &file_cluster_agent_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogMetadataFileInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogMetadataFileInfo) ProtoMessage() {}

func (x *LogMetadataFileInfo) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_agent_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogMetadataFileInfo.ProtoReflect.Descriptor instead.
func (*LogMetadataFileInfo) Descriptor() ([]byte, []int) {
	return file_cluster_agent_proto_rawDescGZIP(), []int{1}
}

func (x *LogMetadataFileInfo) GetSize() int64 {
	if x != nil {
		return x.Size
	}
	return 0
}

func (x *LogMetadataFileInfo) GetLastModifiedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.LastModifiedAt
	}
	return nil
}

type LogMetadataSpec struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	NodeName      string                 `protobuf:"bytes,1,opt,name=node_name,json=nodeName,proto3" json:"node_name,omitempty"`
	Namespace     string                 `protobuf:"bytes,2,opt,name=namespace,proto3" json:"namespace,omitempty"`
	PodName       string                 `protobuf:"bytes,3,opt,name=pod_name,json=podName,proto3" json:"pod_name,omitempty"`
	ContainerName string                 `protobuf:"bytes,4,opt,name=container_name,json=containerName,proto3" json:"container_name,omitempty"`
	ContainerId   string                 `protobuf:"bytes,5,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LogMetadataSpec) Reset() {
	*x = LogMetadataSpec{}
	mi := &file_cluster_agent_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogMetadataSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogMetadataSpec) ProtoMessage() {}

func (x *LogMetadataSpec) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_agent_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogMetadataSpec.ProtoReflect.Descriptor instead.
func (*LogMetadataSpec) Descriptor() ([]byte, []int) {
	return file_cluster_agent_proto_rawDescGZIP(), []int{2}
}

func (x *LogMetadataSpec) GetNodeName() string {
	if x != nil {
		return x.NodeName
	}
	return ""
}

func (x *LogMetadataSpec) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *LogMetadataSpec) GetPodName() string {
	if x != nil {
		return x.PodName
	}
	return ""
}

func (x *LogMetadataSpec) GetContainerName() string {
	if x != nil {
		return x.ContainerName
	}
	return ""
}

func (x *LogMetadataSpec) GetContainerId() string {
	if x != nil {
		return x.ContainerId
	}
	return ""
}

type LogMetadataList struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Items         []*LogMetadata         `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LogMetadataList) Reset() {
	*x = LogMetadataList{}
	mi := &file_cluster_agent_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogMetadataList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogMetadataList) ProtoMessage() {}

func (x *LogMetadataList) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_agent_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogMetadataList.ProtoReflect.Descriptor instead.
func (*LogMetadataList) Descriptor() ([]byte, []int) {
	return file_cluster_agent_proto_rawDescGZIP(), []int{3}
}

func (x *LogMetadataList) GetItems() []*LogMetadata {
	if x != nil {
		return x.Items
	}
	return nil
}

type LogMetadataListRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Namespaces    []string               `protobuf:"bytes,1,rep,name=namespaces,proto3" json:"namespaces,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LogMetadataListRequest) Reset() {
	*x = LogMetadataListRequest{}
	mi := &file_cluster_agent_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogMetadataListRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogMetadataListRequest) ProtoMessage() {}

func (x *LogMetadataListRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_agent_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogMetadataListRequest.ProtoReflect.Descriptor instead.
func (*LogMetadataListRequest) Descriptor() ([]byte, []int) {
	return file_cluster_agent_proto_rawDescGZIP(), []int{4}
}

func (x *LogMetadataListRequest) GetNamespaces() []string {
	if x != nil {
		return x.Namespaces
	}
	return nil
}

type LogMetadataWatchRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Namespaces    []string               `protobuf:"bytes,1,rep,name=namespaces,proto3" json:"namespaces,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LogMetadataWatchRequest) Reset() {
	*x = LogMetadataWatchRequest{}
	mi := &file_cluster_agent_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogMetadataWatchRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogMetadataWatchRequest) ProtoMessage() {}

func (x *LogMetadataWatchRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_agent_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogMetadataWatchRequest.ProtoReflect.Descriptor instead.
func (*LogMetadataWatchRequest) Descriptor() ([]byte, []int) {
	return file_cluster_agent_proto_rawDescGZIP(), []int{5}
}

func (x *LogMetadataWatchRequest) GetNamespaces() []string {
	if x != nil {
		return x.Namespaces
	}
	return nil
}

type LogMetadataWatchEvent struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Type          string                 `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	Object        *LogMetadata           `protobuf:"bytes,2,opt,name=object,proto3" json:"object,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LogMetadataWatchEvent) Reset() {
	*x = LogMetadataWatchEvent{}
	mi := &file_cluster_agent_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogMetadataWatchEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogMetadataWatchEvent) ProtoMessage() {}

func (x *LogMetadataWatchEvent) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_agent_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogMetadataWatchEvent.ProtoReflect.Descriptor instead.
func (*LogMetadataWatchEvent) Descriptor() ([]byte, []int) {
	return file_cluster_agent_proto_rawDescGZIP(), []int{6}
}

func (x *LogMetadataWatchEvent) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *LogMetadataWatchEvent) GetObject() *LogMetadata {
	if x != nil {
		return x.Object
	}
	return nil
}

type LogRecordsStreamRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Namespace     string                 `protobuf:"bytes,1,opt,name=namespace,proto3" json:"namespace,omitempty"`
	PodName       string                 `protobuf:"bytes,2,opt,name=pod_name,json=podName,proto3" json:"pod_name,omitempty"`
	ContainerName string                 `protobuf:"bytes,3,opt,name=container_name,json=containerName,proto3" json:"container_name,omitempty"`
	ContainerId   string                 `protobuf:"bytes,4,opt,name=container_id,json=containerId,proto3" json:"container_id,omitempty"`
	StartTime     string                 `protobuf:"bytes,5,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	StopTime      string                 `protobuf:"bytes,6,opt,name=stop_time,json=stopTime,proto3" json:"stop_time,omitempty"`
	Grep          string                 `protobuf:"bytes,7,opt,name=grep,proto3" json:"grep,omitempty"`
	FollowFrom    FollowFrom             `protobuf:"varint,8,opt,name=follow_from,json=followFrom,proto3,enum=cluster_agent.FollowFrom" json:"follow_from,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LogRecordsStreamRequest) Reset() {
	*x = LogRecordsStreamRequest{}
	mi := &file_cluster_agent_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogRecordsStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogRecordsStreamRequest) ProtoMessage() {}

func (x *LogRecordsStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_agent_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogRecordsStreamRequest.ProtoReflect.Descriptor instead.
func (*LogRecordsStreamRequest) Descriptor() ([]byte, []int) {
	return file_cluster_agent_proto_rawDescGZIP(), []int{7}
}

func (x *LogRecordsStreamRequest) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *LogRecordsStreamRequest) GetPodName() string {
	if x != nil {
		return x.PodName
	}
	return ""
}

func (x *LogRecordsStreamRequest) GetContainerName() string {
	if x != nil {
		return x.ContainerName
	}
	return ""
}

func (x *LogRecordsStreamRequest) GetContainerId() string {
	if x != nil {
		return x.ContainerId
	}
	return ""
}

func (x *LogRecordsStreamRequest) GetStartTime() string {
	if x != nil {
		return x.StartTime
	}
	return ""
}

func (x *LogRecordsStreamRequest) GetStopTime() string {
	if x != nil {
		return x.StopTime
	}
	return ""
}

func (x *LogRecordsStreamRequest) GetGrep() string {
	if x != nil {
		return x.Grep
	}
	return ""
}

func (x *LogRecordsStreamRequest) GetFollowFrom() FollowFrom {
	if x != nil {
		return x.FollowFrom
	}
	return FollowFrom_NOOP
}

type LogRecord struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Timestamp     *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	Message       string                 `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *LogRecord) Reset() {
	*x = LogRecord{}
	mi := &file_cluster_agent_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogRecord) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogRecord) ProtoMessage() {}

func (x *LogRecord) ProtoReflect() protoreflect.Message {
	mi := &file_cluster_agent_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogRecord.ProtoReflect.Descriptor instead.
func (*LogRecord) Descriptor() ([]byte, []int) {
	return file_cluster_agent_proto_rawDescGZIP(), []int{8}
}

func (x *LogRecord) GetTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.Timestamp
	}
	return nil
}

func (x *LogRecord) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

var File_cluster_agent_proto protoreflect.FileDescriptor

const file_cluster_agent_proto_rawDesc = "" +
	"\n" +
	"\x13cluster_agent.proto\x12\rcluster_agent\x1a\x1fgoogle/protobuf/timestamp.proto\"\x91\x01\n" +
	"\vLogMetadata\x12\x0e\n" +
	"\x02id\x18\x01 \x01(\tR\x02id\x122\n" +
	"\x04spec\x18\x02 \x01(\v2\x1e.cluster_agent.LogMetadataSpecR\x04spec\x12>\n" +
	"\bfileInfo\x18\x03 \x01(\v2\".cluster_agent.LogMetadataFileInfoR\bfileInfo\"o\n" +
	"\x13LogMetadataFileInfo\x12\x12\n" +
	"\x04size\x18\x01 \x01(\x03R\x04size\x12D\n" +
	"\x10last_modified_at\x18\x02 \x01(\v2\x1a.google.protobuf.TimestampR\x0elastModifiedAt\"\xb1\x01\n" +
	"\x0fLogMetadataSpec\x12\x1b\n" +
	"\tnode_name\x18\x01 \x01(\tR\bnodeName\x12\x1c\n" +
	"\tnamespace\x18\x02 \x01(\tR\tnamespace\x12\x19\n" +
	"\bpod_name\x18\x03 \x01(\tR\apodName\x12%\n" +
	"\x0econtainer_name\x18\x04 \x01(\tR\rcontainerName\x12!\n" +
	"\fcontainer_id\x18\x05 \x01(\tR\vcontainerId\"C\n" +
	"\x0fLogMetadataList\x120\n" +
	"\x05items\x18\x01 \x03(\v2\x1a.cluster_agent.LogMetadataR\x05items\"8\n" +
	"\x16LogMetadataListRequest\x12\x1e\n" +
	"\n" +
	"namespaces\x18\x01 \x03(\tR\n" +
	"namespaces\"9\n" +
	"\x17LogMetadataWatchRequest\x12\x1e\n" +
	"\n" +
	"namespaces\x18\x01 \x03(\tR\n" +
	"namespaces\"_\n" +
	"\x15LogMetadataWatchEvent\x12\x12\n" +
	"\x04type\x18\x01 \x01(\tR\x04type\x122\n" +
	"\x06object\x18\x02 \x01(\v2\x1a.cluster_agent.LogMetadataR\x06object\"\xa8\x02\n" +
	"\x17LogRecordsStreamRequest\x12\x1c\n" +
	"\tnamespace\x18\x01 \x01(\tR\tnamespace\x12\x19\n" +
	"\bpod_name\x18\x02 \x01(\tR\apodName\x12%\n" +
	"\x0econtainer_name\x18\x03 \x01(\tR\rcontainerName\x12!\n" +
	"\fcontainer_id\x18\x04 \x01(\tR\vcontainerId\x12\x1d\n" +
	"\n" +
	"start_time\x18\x05 \x01(\tR\tstartTime\x12\x1b\n" +
	"\tstop_time\x18\x06 \x01(\tR\bstopTime\x12\x12\n" +
	"\x04grep\x18\a \x01(\tR\x04grep\x12:\n" +
	"\vfollow_from\x18\b \x01(\x0e2\x19.cluster_agent.FollowFromR\n" +
	"followFrom\"_\n" +
	"\tLogRecord\x128\n" +
	"\ttimestamp\x18\x01 \x01(\v2\x1a.google.protobuf.TimestampR\ttimestamp\x12\x18\n" +
	"\amessage\x18\x02 \x01(\tR\amessage*,\n" +
	"\n" +
	"FollowFrom\x12\b\n" +
	"\x04NOOP\x10\x00\x12\v\n" +
	"\aDEFAULT\x10\x01\x12\a\n" +
	"\x03END\x10\x022\xbc\x01\n" +
	"\x12LogMetadataService\x12M\n" +
	"\x04List\x12%.cluster_agent.LogMetadataListRequest\x1a\x1e.cluster_agent.LogMetadataList\x12W\n" +
	"\x05Watch\x12&.cluster_agent.LogMetadataWatchRequest\x1a$.cluster_agent.LogMetadataWatchEvent0\x012\xbe\x01\n" +
	"\x11LogRecordsService\x12S\n" +
	"\rStreamForward\x12&.cluster_agent.LogRecordsStreamRequest\x1a\x18.cluster_agent.LogRecord0\x01\x12T\n" +
	"\x0eStreamBackward\x12&.cluster_agent.LogRecordsStreamRequest\x1a\x18.cluster_agent.LogRecord0\x01B\x17Z\x15shared/clusteragentpbb\x06proto3"

var (
	file_cluster_agent_proto_rawDescOnce sync.Once
	file_cluster_agent_proto_rawDescData []byte
)

func file_cluster_agent_proto_rawDescGZIP() []byte {
	file_cluster_agent_proto_rawDescOnce.Do(func() {
		file_cluster_agent_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_cluster_agent_proto_rawDesc), len(file_cluster_agent_proto_rawDesc)))
	})
	return file_cluster_agent_proto_rawDescData
}

var file_cluster_agent_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_cluster_agent_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_cluster_agent_proto_goTypes = []any{
	(FollowFrom)(0),                 // 0: cluster_agent.FollowFrom
	(*LogMetadata)(nil),             // 1: cluster_agent.LogMetadata
	(*LogMetadataFileInfo)(nil),     // 2: cluster_agent.LogMetadataFileInfo
	(*LogMetadataSpec)(nil),         // 3: cluster_agent.LogMetadataSpec
	(*LogMetadataList)(nil),         // 4: cluster_agent.LogMetadataList
	(*LogMetadataListRequest)(nil),  // 5: cluster_agent.LogMetadataListRequest
	(*LogMetadataWatchRequest)(nil), // 6: cluster_agent.LogMetadataWatchRequest
	(*LogMetadataWatchEvent)(nil),   // 7: cluster_agent.LogMetadataWatchEvent
	(*LogRecordsStreamRequest)(nil), // 8: cluster_agent.LogRecordsStreamRequest
	(*LogRecord)(nil),               // 9: cluster_agent.LogRecord
	(*timestamppb.Timestamp)(nil),   // 10: google.protobuf.Timestamp
}
var file_cluster_agent_proto_depIdxs = []int32{
	3,  // 0: cluster_agent.LogMetadata.spec:type_name -> cluster_agent.LogMetadataSpec
	2,  // 1: cluster_agent.LogMetadata.fileInfo:type_name -> cluster_agent.LogMetadataFileInfo
	10, // 2: cluster_agent.LogMetadataFileInfo.last_modified_at:type_name -> google.protobuf.Timestamp
	1,  // 3: cluster_agent.LogMetadataList.items:type_name -> cluster_agent.LogMetadata
	1,  // 4: cluster_agent.LogMetadataWatchEvent.object:type_name -> cluster_agent.LogMetadata
	0,  // 5: cluster_agent.LogRecordsStreamRequest.follow_from:type_name -> cluster_agent.FollowFrom
	10, // 6: cluster_agent.LogRecord.timestamp:type_name -> google.protobuf.Timestamp
	5,  // 7: cluster_agent.LogMetadataService.List:input_type -> cluster_agent.LogMetadataListRequest
	6,  // 8: cluster_agent.LogMetadataService.Watch:input_type -> cluster_agent.LogMetadataWatchRequest
	8,  // 9: cluster_agent.LogRecordsService.StreamForward:input_type -> cluster_agent.LogRecordsStreamRequest
	8,  // 10: cluster_agent.LogRecordsService.StreamBackward:input_type -> cluster_agent.LogRecordsStreamRequest
	4,  // 11: cluster_agent.LogMetadataService.List:output_type -> cluster_agent.LogMetadataList
	7,  // 12: cluster_agent.LogMetadataService.Watch:output_type -> cluster_agent.LogMetadataWatchEvent
	9,  // 13: cluster_agent.LogRecordsService.StreamForward:output_type -> cluster_agent.LogRecord
	9,  // 14: cluster_agent.LogRecordsService.StreamBackward:output_type -> cluster_agent.LogRecord
	11, // [11:15] is the sub-list for method output_type
	7,  // [7:11] is the sub-list for method input_type
	7,  // [7:7] is the sub-list for extension type_name
	7,  // [7:7] is the sub-list for extension extendee
	0,  // [0:7] is the sub-list for field type_name
}

func init() { file_cluster_agent_proto_init() }
func file_cluster_agent_proto_init() {
	if File_cluster_agent_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_cluster_agent_proto_rawDesc), len(file_cluster_agent_proto_rawDesc)),
			NumEnums:      1,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   2,
		},
		GoTypes:           file_cluster_agent_proto_goTypes,
		DependencyIndexes: file_cluster_agent_proto_depIdxs,
		EnumInfos:         file_cluster_agent_proto_enumTypes,
		MessageInfos:      file_cluster_agent_proto_msgTypes,
	}.Build()
	File_cluster_agent_proto = out.File
	file_cluster_agent_proto_goTypes = nil
	file_cluster_agent_proto_depIdxs = nil
}
