package types_test

import (
	"regexp"
	"testing"

	"github.com/lmorg/murex/lang/types"
	"github.com/lmorg/murex/test/count"
)

func TestFloatToString(t *testing.T) {
	tests := []float64{
		0,

		0.0000000001,
		0.000000001,
		0.00000001,
		0.0000001,
		0.000001,
		0.00001,
		0.0001,
		0.001,
		0.01,
		0.1,
		1,
		1.1,
		1.01,
		1.001,
		1.0001,
		1.00001,
		1.000001,
		1.0000001,
		1.00000001,
		1.000000001,
		1.0000000001,

		-0.0000000001,
		-0.000000001,
		-0.00000001,
		-0.0000001,
		-0.000001,
		-0.00001,
		-0.0001,
		-0.001,
		-0.01,
		-0.1,
		-1,
		-1.1,
		-1.01,
		-1.001,
		-1.0001,
		-1.00001,
		-1.000001,
		-1.0000001,
		-1.00000001,
		-1.000000001,
		-1.0000000001,

		42.0000000001,
		42.000000001,
		42.00000001,
		42.0000001,
		42.000001,
		42.00001,
		42.0001,
		42.001,
		42.01,
		42.1,
		42,
		10000000000,
		10000000000.1,
		10000000000.01,
		10000000000.001,
		10000000000.0001,
		10000000000.00001,
		10000000000.000001,
		10000000000.0000001,
		10000000000.00000001,
		10000000000.000000001,
		10000000000.0000000001,

		-42.0000000001,
		-42.000000001,
		-42.00000001,
		-42.0000001,
		-42.000001,
		-42.00001,
		-42.0001,
		-42.001,
		-42.01,
		-42.1,
		-42,
		-10000000000,
		-10000000000.1,
		-10000000000.01,
		-10000000000.001,
		-10000000000.0001,
		-10000000000.00001,
		-10000000000.000001,
		-10000000000.0000001,
		-10000000000.00000001,
		-10000000000.000000001,
		-10000000000.0000000001,

		1234567890,
		-1234567890,

		1234567890.1234567890,
		-1234567890.1234567890,

		0.123456789,
		-0.123456789,
	}

	count.Tests(t, len(tests))
	rx := regexp.MustCompile(`^(-)?[0-9]+(\.[0-9]+)?$`)

	for _, f := range tests {
		s := types.FloatToString(f)
		if !rx.MatchString(s) {
			t.Errorf(`FloatToString(%f) == "%s"`, f, s)
		}
	}
}
