// Code generated by moq; DO NOT EDIT.
// github.com/matryer/moq

package mocks

import (
	"sync"

	"github.com/umputun/spot/pkg/config"
)

// PlaybookMock is a mock implementation of runner.Playbook.
//
//	func TestSomethingThatUsesPlaybook(t *testing.T) {
//
//		// make and configure a mocked runner.Playbook
//		mockedPlaybook := &PlaybookMock{
//			AllSecretValuesFunc: func() []string {
//				panic("mock out the AllSecretValues method")
//			},
//			AllTasksFunc: func() []config.Task {
//				panic("mock out the AllTasks method")
//			},
//			TargetHostsFunc: func(name string) ([]config.Destination, error) {
//				panic("mock out the TargetHosts method")
//			},
//			TaskFunc: func(name string) (*config.Task, error) {
//				panic("mock out the Task method")
//			},
//			UpdateRegisteredVarsFunc: func(vars map[string]string)  {
//				panic("mock out the UpdateRegisteredVars method")
//			},
//			UpdateTasksTargetsFunc: func(vars map[string]string)  {
//				panic("mock out the UpdateTasksTargets method")
//			},
//		}
//
//		// use mockedPlaybook in code that requires runner.Playbook
//		// and then make assertions.
//
//	}
type PlaybookMock struct {
	// AllSecretValuesFunc mocks the AllSecretValues method.
	AllSecretValuesFunc func() []string

	// AllTasksFunc mocks the AllTasks method.
	AllTasksFunc func() []config.Task

	// TargetHostsFunc mocks the TargetHosts method.
	TargetHostsFunc func(name string) ([]config.Destination, error)

	// TaskFunc mocks the Task method.
	TaskFunc func(name string) (*config.Task, error)

	// UpdateRegisteredVarsFunc mocks the UpdateRegisteredVars method.
	UpdateRegisteredVarsFunc func(vars map[string]string)

	// UpdateTasksTargetsFunc mocks the UpdateTasksTargets method.
	UpdateTasksTargetsFunc func(vars map[string]string)

	// calls tracks calls to the methods.
	calls struct {
		// AllSecretValues holds details about calls to the AllSecretValues method.
		AllSecretValues []struct {
		}
		// AllTasks holds details about calls to the AllTasks method.
		AllTasks []struct {
		}
		// TargetHosts holds details about calls to the TargetHosts method.
		TargetHosts []struct {
			// Name is the name argument value.
			Name string
		}
		// Task holds details about calls to the Task method.
		Task []struct {
			// Name is the name argument value.
			Name string
		}
		// UpdateRegisteredVars holds details about calls to the UpdateRegisteredVars method.
		UpdateRegisteredVars []struct {
			// Vars is the vars argument value.
			Vars map[string]string
		}
		// UpdateTasksTargets holds details about calls to the UpdateTasksTargets method.
		UpdateTasksTargets []struct {
			// Vars is the vars argument value.
			Vars map[string]string
		}
	}
	lockAllSecretValues      sync.RWMutex
	lockAllTasks             sync.RWMutex
	lockTargetHosts          sync.RWMutex
	lockTask                 sync.RWMutex
	lockUpdateRegisteredVars sync.RWMutex
	lockUpdateTasksTargets   sync.RWMutex
}

// AllSecretValues calls AllSecretValuesFunc.
func (mock *PlaybookMock) AllSecretValues() []string {
	if mock.AllSecretValuesFunc == nil {
		panic("PlaybookMock.AllSecretValuesFunc: method is nil but Playbook.AllSecretValues was just called")
	}
	callInfo := struct {
	}{}
	mock.lockAllSecretValues.Lock()
	mock.calls.AllSecretValues = append(mock.calls.AllSecretValues, callInfo)
	mock.lockAllSecretValues.Unlock()
	return mock.AllSecretValuesFunc()
}

// AllSecretValuesCalls gets all the calls that were made to AllSecretValues.
// Check the length with:
//
//	len(mockedPlaybook.AllSecretValuesCalls())
func (mock *PlaybookMock) AllSecretValuesCalls() []struct {
} {
	var calls []struct {
	}
	mock.lockAllSecretValues.RLock()
	calls = mock.calls.AllSecretValues
	mock.lockAllSecretValues.RUnlock()
	return calls
}

// AllTasks calls AllTasksFunc.
func (mock *PlaybookMock) AllTasks() []config.Task {
	if mock.AllTasksFunc == nil {
		panic("PlaybookMock.AllTasksFunc: method is nil but Playbook.AllTasks was just called")
	}
	callInfo := struct {
	}{}
	mock.lockAllTasks.Lock()
	mock.calls.AllTasks = append(mock.calls.AllTasks, callInfo)
	mock.lockAllTasks.Unlock()
	return mock.AllTasksFunc()
}

// AllTasksCalls gets all the calls that were made to AllTasks.
// Check the length with:
//
//	len(mockedPlaybook.AllTasksCalls())
func (mock *PlaybookMock) AllTasksCalls() []struct {
} {
	var calls []struct {
	}
	mock.lockAllTasks.RLock()
	calls = mock.calls.AllTasks
	mock.lockAllTasks.RUnlock()
	return calls
}

// TargetHosts calls TargetHostsFunc.
func (mock *PlaybookMock) TargetHosts(name string) ([]config.Destination, error) {
	if mock.TargetHostsFunc == nil {
		panic("PlaybookMock.TargetHostsFunc: method is nil but Playbook.TargetHosts was just called")
	}
	callInfo := struct {
		Name string
	}{
		Name: name,
	}
	mock.lockTargetHosts.Lock()
	mock.calls.TargetHosts = append(mock.calls.TargetHosts, callInfo)
	mock.lockTargetHosts.Unlock()
	return mock.TargetHostsFunc(name)
}

// TargetHostsCalls gets all the calls that were made to TargetHosts.
// Check the length with:
//
//	len(mockedPlaybook.TargetHostsCalls())
func (mock *PlaybookMock) TargetHostsCalls() []struct {
	Name string
} {
	var calls []struct {
		Name string
	}
	mock.lockTargetHosts.RLock()
	calls = mock.calls.TargetHosts
	mock.lockTargetHosts.RUnlock()
	return calls
}

// Task calls TaskFunc.
func (mock *PlaybookMock) Task(name string) (*config.Task, error) {
	if mock.TaskFunc == nil {
		panic("PlaybookMock.TaskFunc: method is nil but Playbook.Task was just called")
	}
	callInfo := struct {
		Name string
	}{
		Name: name,
	}
	mock.lockTask.Lock()
	mock.calls.Task = append(mock.calls.Task, callInfo)
	mock.lockTask.Unlock()
	return mock.TaskFunc(name)
}

// TaskCalls gets all the calls that were made to Task.
// Check the length with:
//
//	len(mockedPlaybook.TaskCalls())
func (mock *PlaybookMock) TaskCalls() []struct {
	Name string
} {
	var calls []struct {
		Name string
	}
	mock.lockTask.RLock()
	calls = mock.calls.Task
	mock.lockTask.RUnlock()
	return calls
}

// UpdateRegisteredVars calls UpdateRegisteredVarsFunc.
func (mock *PlaybookMock) UpdateRegisteredVars(vars map[string]string) {
	if mock.UpdateRegisteredVarsFunc == nil {
		panic("PlaybookMock.UpdateRegisteredVarsFunc: method is nil but Playbook.UpdateRegisteredVars was just called")
	}
	callInfo := struct {
		Vars map[string]string
	}{
		Vars: vars,
	}
	mock.lockUpdateRegisteredVars.Lock()
	mock.calls.UpdateRegisteredVars = append(mock.calls.UpdateRegisteredVars, callInfo)
	mock.lockUpdateRegisteredVars.Unlock()
	mock.UpdateRegisteredVarsFunc(vars)
}

// UpdateRegisteredVarsCalls gets all the calls that were made to UpdateRegisteredVars.
// Check the length with:
//
//	len(mockedPlaybook.UpdateRegisteredVarsCalls())
func (mock *PlaybookMock) UpdateRegisteredVarsCalls() []struct {
	Vars map[string]string
} {
	var calls []struct {
		Vars map[string]string
	}
	mock.lockUpdateRegisteredVars.RLock()
	calls = mock.calls.UpdateRegisteredVars
	mock.lockUpdateRegisteredVars.RUnlock()
	return calls
}

// UpdateTasksTargets calls UpdateTasksTargetsFunc.
func (mock *PlaybookMock) UpdateTasksTargets(vars map[string]string) {
	if mock.UpdateTasksTargetsFunc == nil {
		panic("PlaybookMock.UpdateTasksTargetsFunc: method is nil but Playbook.UpdateTasksTargets was just called")
	}
	callInfo := struct {
		Vars map[string]string
	}{
		Vars: vars,
	}
	mock.lockUpdateTasksTargets.Lock()
	mock.calls.UpdateTasksTargets = append(mock.calls.UpdateTasksTargets, callInfo)
	mock.lockUpdateTasksTargets.Unlock()
	mock.UpdateTasksTargetsFunc(vars)
}

// UpdateTasksTargetsCalls gets all the calls that were made to UpdateTasksTargets.
// Check the length with:
//
//	len(mockedPlaybook.UpdateTasksTargetsCalls())
func (mock *PlaybookMock) UpdateTasksTargetsCalls() []struct {
	Vars map[string]string
} {
	var calls []struct {
		Vars map[string]string
	}
	mock.lockUpdateTasksTargets.RLock()
	calls = mock.calls.UpdateTasksTargets
	mock.lockUpdateTasksTargets.RUnlock()
	return calls
}
