package tfmigrate

import (
	"context"

	"github.com/minamijoyo/tfmigrate/tfexec"
)

// StateRmAction implements the StateAction interface.
// StateRmAction removes resources from state at given addresses.
type StateRmAction struct {
	// addresses is a list of address to be removed from state.
	addresses []string
}

var _ StateAction = (*StateRmAction)(nil)

// NewStateRmAction returns a new StateRmAction instance.
func NewStateRmAction(addresses []string) *StateRmAction {
	return &StateRmAction{
		addresses: addresses,
	}
}

// StateUpdate updates a given state and returns a new state.
// It removes resources from state at given addresses.
func (a *StateRmAction) StateUpdate(ctx context.Context, tf tfexec.TerraformCLI, state *tfexec.State) (*tfexec.State, error) {
	// Disable unnecessary state backup here,
	// because we never restore state from the backup generated by each state action.
	// The state rm command doesn't provide a way to disable it, so we backup to /dev/null.
	return tf.StateRm(ctx, state, a.addresses, "-backup=/dev/null")
}
