<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/dnsmasq_dhcp/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/dnsmasq_dhcp/metadata.yaml"
sidebar_label: "Dnsmasq DHCP"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/DNS and DHCP Servers"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Dnsmasq DHCP


<img src="https://netdata.cloud/img/dnsmasq.svg" width="150"/>


Plugin: go.d.plugin
Module: dnsmasq_dhcp

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors  Dnsmasq DHCP leases databases, depending on your configuration.

By default, it uses:

- `/var/lib/misc/dnsmasq.leases` to read leases.
- `/etc/dnsmasq.conf` to detect dhcp-ranges.
- `/etc/dnsmasq.d` to find additional configurations.




This collector is only supported on the following platforms:

- Linux

This collector only supports collecting metrics from a single instance of this integration.


### Default Behavior

#### Auto-Detection

All configured dhcp-ranges are detected automatically


#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.

## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per Dnsmasq DHCP instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| dnsmasq_dhcp.dhcp_ranges | ipv4, ipv6 | ranges |
| dnsmasq_dhcp.dhcp_hosts | ipv4, ipv6 | hosts |

### Per dhcp range

These metrics refer to the DHCP range.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| dhcp_range | DHCP range in `START_IP:END_IP` format |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| dnsmasq_dhcp.dhcp_range_utilization | used | percentage |
| dnsmasq_dhcp.dhcp_range_allocated_leases | allocated | leases |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ dnsmasq_dhcp_dhcp_range_utilization ](https://github.com/netdata/netdata/blob/master/src/health/health.d/dnsmasq_dhcp.conf) | dnsmasq_dhcp.dhcp_range_utilization | DHCP range utilization |


## Setup


You can configure the **dnsmasq_dhcp** collector in two ways:

| Method                | Best for                                                                                 | How to                                                                                                                                 |
|-----------------------|------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------|
| [**UI**](#via-ui)     | Fast setup without editing files                                                         | Go to **Nodes → Configure this node → Collectors → Jobs**, search for **dnsmasq_dhcp**, then click **+** to add a job. |
| [**File**](#via-file) | If you prefer configuring via file, or need to automate deployments (e.g., with Ansible) | Edit `go.d/dnsmasq_dhcp.conf` and add a job.                                                                        |

:::important

UI configuration requires paid Netdata Cloud plan.

:::


### Prerequisites

No action required.

### Configuration

#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details open><summary>Config options</summary>



| Group | Option | Description | Default | Required |
|:------|:-----|:------------|:--------|:---------:|
| **Collection** | update_every | Data collection interval (seconds). | 1 | no |
|  | autodetection_retry | Autodetection retry interval (seconds). Set 0 to disable. | 0 | no |
| **Target** | leases_path | Path to dnsmasq DHCP leases file. | /var/lib/misc/dnsmasq.leases | no |
|  | conf_path | Path to dnsmasq configuration file (used to extract configured DHCP pools). | /etc/dnsmasq.conf | no |
|  | conf_dir | Path to dnsmasq configuration directory (used to extract configured DHCP pools). | /etc/dnsmasq.d,.dpkg-dist,.dpkg-old,.dpkg-new | no |


</details>


#### via UI

Configure the **dnsmasq_dhcp** collector from the Netdata web interface:

1. Go to **Nodes**.
2. Select the node **where you want the dnsmasq_dhcp data-collection job to run** and click the :gear: (**Configure this node**). That node will run the data collection.
3. The **Collectors → Jobs** view opens by default.
4. In the Search box, type _dnsmasq_dhcp_ (or scroll the list) to locate the **dnsmasq_dhcp** collector.
5. Click the **+** next to the **dnsmasq_dhcp** collector to add a new job.
6. Fill in the job fields, then click **Test** to verify the configuration and **Submit** to save.
    - **Test** runs the job with the provided settings and shows whether data can be collected.
    - If it fails, an error message appears with details (for example, connection refused, timeout, or command execution errors), so you can adjust and retest.


#### via File

The configuration file name for this integration is `go.d/dnsmasq_dhcp.conf`.

The file format is YAML. Generally, the structure is:

```yaml
update_every: 1
autodetection_retry: 0
jobs:
  - name: some_name1
  - name: some_name2
```
You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/dnsmasq_dhcp.conf
```

##### Examples

###### Basic

An example configuration.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: dnsmasq_dhcp
    leases_path: /var/lib/misc/dnsmasq.leases
    conf_path: /etc/dnsmasq.conf
    conf_dir: /etc/dnsmasq.d

```
</details>

###### Pi-hole

Dnsmasq DHCP on Pi-hole.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: dnsmasq_dhcp
    leases_path: /etc/pihole/dhcp.leases
    conf_path: /etc/dnsmasq.conf
    conf_dir: /etc/dnsmasq.d

```
</details>



## Troubleshooting

### Debug Mode

**Important**: Debug mode is not supported for data collection jobs created via the UI using the Dyncfg feature.

To troubleshoot issues with the `dnsmasq_dhcp` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m dnsmasq_dhcp
  ```

  To debug a specific job:

  ```bash
  ./go.d.plugin -d -m dnsmasq_dhcp -j jobName
  ```

### Getting Logs

If you're encountering problems with the `dnsmasq_dhcp` collector, follow these steps to retrieve logs and identify potential issues:

- **Run the command** specific to your system (systemd, non-systemd, or Docker container).
- **Examine the output** for any warnings or error messages that might indicate issues.  These messages should provide clues about the root cause of the problem.

#### System with systemd

Use the following command to view logs generated since the last Netdata service restart:

```bash
journalctl _SYSTEMD_INVOCATION_ID="$(systemctl show --value --property=InvocationID netdata)" --namespace=netdata --grep dnsmasq_dhcp
```

#### System without systemd

Locate the collector log file, typically at `/var/log/netdata/collector.log`, and use `grep` to filter for collector's name:

```bash
grep dnsmasq_dhcp /var/log/netdata/collector.log
```

**Note**: This method shows logs from all restarts. Focus on the **latest entries** for troubleshooting current issues.

#### Docker Container

If your Netdata runs in a Docker container named "netdata" (replace if different), use this command:

```bash
docker logs netdata 2>&1 | grep dnsmasq_dhcp
```


