/*!

Tutorials, overviews, and etc... for the `mutatis` crate.

All the documentation that isn't API reference.

# Table of Contents

* [The `#[derive(Mutate)]` Macro][derive_macro]
* [Integrating Your Mutator with a Fuzzer][fuzzer_integration]
* [Shrinking Test Cases][shrinking]
* [Cargo Features][cargo_features]
* [Comparisons to Other Libraries and Approaches][comparisons]
* [Minimum Supported Rust Version][msrv]

 */

pub mod cargo_features;
pub mod comparisons;
pub mod derive_macro;
pub mod fuzzer_integration;
pub mod msrv;
pub mod shrinking;
