
[//000000001]: # (tcllib\_ip \- Domain Name Service)
[//000000002]: # (Generated from file 'tcllib\_ip\.man' by tcllib/doctools with format 'markdown')
[//000000003]: # (Copyright &copy; 2004, Pat Thoyts)
[//000000004]: # (Copyright &copy; 2005 Aamer Akhter <aakhter@cisco\.com>)
[//000000005]: # (tcllib\_ip\(n\) 1\.5\.1 tcllib "Domain Name Service")

<hr> [ <a href="../../../../toc.md">Main Table Of Contents</a> &#124; <a
href="../../../toc.md">Table Of Contents</a> &#124; <a
href="../../../../index.md">Keyword Index</a> &#124; <a
href="../../../../toc0.md">Categories</a> &#124; <a
href="../../../../toc1.md">Modules</a> &#124; <a
href="../../../../toc2.md">Applications</a> ] <hr>

# NAME

tcllib\_ip \- IPv4 and IPv6 address manipulation

# <a name='toc'></a>Table Of Contents

  - [Table Of Contents](#toc)

  - [Synopsis](#synopsis)

  - [Description](#section1)

  - [COMMANDS](#section2)

  - [EXAMPLES](#section3)

  - [REFERENCES](#section4)

  - [AUTHORS](#section5)

  - [Bugs, Ideas, Feedback](#section6)

  - [See Also](#seealso)

  - [Keywords](#keywords)

  - [Category](#category)

  - [Copyright](#copyright)

# <a name='synopsis'></a>SYNOPSIS

package require Tcl 8\.5 9  
package require ip ?1\.5\.1?  

[__::ip::version__ *address*](#1)  
[__::ip::is__ *class* *address*](#2)  
[__::ip::equal__ *address* *address*](#3)  
[__::ip::normalize__ *address*](#4)  
[__::ip::contract__ *address*](#5)  
[__::ip::distance__ *ipaddr1* *ipaddr2*](#6)  
[__::ip::nextIp__ *ipaddr* ?*offset*?](#7)  
[__::ip::prefix__ *address*](#8)  
[__::ip::type__ *address*](#9)  
[__::ip::mask__ *address*](#10)  
[__::ip::prefixToNative__ *prefix*](#11)  
[__::ip::nativeToPrefix__ *nativeList*&#124;*native* ?__\-ipv4__?](#12)  
[__::ip::intToString__ *number* ?__\-ipv4__?](#13)  
[__::ip::toInteger__ *ipaddr*](#14)  
[__::ip::toHex__ *ipaddr*](#15)  
[__::ip::maskToInt__ *ipmask*](#16)  
[__::ip::broadcastAddress__ *prefix* ?__\-ipv4__?](#17)  
[__::ip::maskToLength__ *dottedMask*&#124;*integerMask*&#124;*hexMask* ?__\-ipv4__?](#18)  
[__::ip::lengthToMask__ *maskLength* ?__\-ipv4__?](#19)  
[__::ip::nextNet__ *ipaddr* *ipmask* ?*count*? ?__\-ipv4__?](#20)  
[__::ip::isOverlap__ *prefix* *prefix*\.\.\.](#21)  
[__::ip::isOverlapNative__ ?__\-all__? ?__\-inline__? ?__\-ipv4__? *hexipaddr* *hexipmask* *hexiplist*](#22)  
[__::ip::ipToLayer2Multicast__ *ipaddr*](#23)  
[__::ip::ipHostFromPrefix__ *prefix* ?__\-exclude__ *prefixExcludeList*?](#24)  
[__::ip::reduceToAggregates__ *prefixlist*](#25)  
[__::ip::longestPrefixMatch__ *ipaddr* *prefixlist* ?__\-ipv4__?](#26)  
[__::ip::collapse__ *prefixlist*](#27)  
[__::ip::subtract__ *prefixlist*](#28)  

# <a name='description'></a>DESCRIPTION

This package provides a set of commands to help in parsing, displaying and
comparing internet addresses\. The package can handle both IPv4 \(1\) and IPv6 \(2\)
address types\.

# <a name='section2'></a>COMMANDS

  - <a name='1'></a>__::ip::version__ *address*

    Returns the protocol version of the address \(__4__ or __6__\), or
    __\-1__ if the address is neither IPv4 or IPv6\.

  - <a name='2'></a>__::ip::is__ *class* *address*

    Returns true if the address is a member of the given protocol class\. The
    class parameter may be either __ipv4__ or __ipv6__ This is
    effectively a boolean equivalent of the __version__ command\. The
    *class* argument may be shortened to __4__ or __6__\.

  - <a name='3'></a>__::ip::equal__ *address* *address*

    Compare two address specifications for equivalence\. The arguments are
    normalized and the address prefix determined \(if a mask is supplied\)\. The
    normalized addresses are then compared bit\-by\-bit and the procedure returns
    true if they match\.

  - <a name='4'></a>__::ip::normalize__ *address*

    Convert an IPv4 or IPv6 address into a fully expanded version\. There are
    various shorthand ways to write internet addresses, missing out redundant
    parts or digits\. This procedure is the opposite of __contract__\.

  - <a name='5'></a>__::ip::contract__ *address*

    Convert a __normalize__d internet address into a more compact form
    suitable for displaying to users\.

  - <a name='6'></a>__::ip::distance__ *ipaddr1* *ipaddr2*

    This command computes the \(integer\) distance from IPv4 address *ipaddr1*
    to IPv4 address *ipaddr2*, i\.e\. "ipaddr2 \- ipaddr1"

        % ::ip::distance 1.1.1.1  1.1.1.5
        4

  - <a name='7'></a>__::ip::nextIp__ *ipaddr* ?*offset*?

    This command adds the integer *offset* to the IPv4 address *ipaddr* and
    returns the new IPv4 address\.

        % ::ip::distance 1.1.1.1  4
        1.1.1.5

  - <a name='8'></a>__::ip::prefix__ *address*

    Returns the address prefix generated by masking the address part with the
    mask if provided\. If there is no mask then it is equivalent to calling
    __normalize__

  - <a name='9'></a>__::ip::type__ *address*

  - <a name='10'></a>__::ip::mask__ *address*

    If the address supplied includes a mask then this is returned otherwise
    returns an empty string\.

  - <a name='11'></a>__::ip::prefixToNative__ *prefix*

    This command converts the string *prefix* from dotted form
    \(<ipaddr>/<mask> format\) to native \(hex\) form\. Returns a list containing two
    elements, ipaddress and mask, in this order, in hexadecimal notation\.

        % ip::prefixToNative 1.1.1.0/24
        0x01010100 0xffffff00

  - <a name='12'></a>__::ip::nativeToPrefix__ *nativeList*&#124;*native* ?__\-ipv4__?

    This command converts from native \(hex\) form to dotted form\. It is the
    complement of __::ip::prefixToNative__\.

      * list *nativeList* \(in\)

        List of several ip addresses in native form\. The native form is a list
        as returned by __::ip::prefixToNative__\.

      * list *native* \(in\)

        A list as returned by __::ip::prefixToNative__\.

    The command returns a list of addresses in dotted form if it was called with
    a list of addresses\. Otherwise a single address in dotted form is returned\.

        % ip::nativeToPrefix {0x01010100 0xffffff00} -ipv4
        1.1.1.0/24

  - <a name='13'></a>__::ip::intToString__ *number* ?__\-ipv4__?

    This command converts from an ip address specified as integer number to
    dotted form\.

        ip::intToString 4294967295
        255.255.255.255

  - <a name='14'></a>__::ip::toInteger__ *ipaddr*

    This command converts a dotted form ip into an integer number\.

        % ::ip::toInteger 1.1.1.0
        16843008

  - <a name='15'></a>__::ip::toHex__ *ipaddr*

    This command converts dotted form ip into a hexadecimal number\.

        % ::ip::toHex 1.1.1.0
        0x01010100

  - <a name='16'></a>__::ip::maskToInt__ *ipmask*

    This command convert an ipmask in either dotted \(255\.255\.255\.0\) form or mask
    length form \(24\) into an integer number\.

        ::ip::maskToInt 24
        4294967040

  - <a name='17'></a>__::ip::broadcastAddress__ *prefix* ?__\-ipv4__?

    This commands returns a broadcast address in dotted form for the given route
    *prefix*, either in the form "addr/mask", or in native form\. The result is
    in dotted form\.

        ::ip::broadcastAddress 1.1.1.0/24
        1.1.1.255

        ::ip::broadcastAddress {0x01010100 0xffffff00}
        0x010101ff

  - <a name='18'></a>__::ip::maskToLength__ *dottedMask*&#124;*integerMask*&#124;*hexMask* ?__\-ipv4__?

    This command converts the dotted or integer form of an ipmask to the mask
    length form\.

        ::ip::maskToLength 0xffffff00 -ipv4
        24

        % ::ip::maskToLength 255.255.255.0
        24

  - <a name='19'></a>__::ip::lengthToMask__ *maskLength* ?__\-ipv4__?

    This command converts an ipmask in mask length form to its dotted form\.

        ::ip::lengthToMask 24
        255.255.255.0

  - <a name='20'></a>__::ip::nextNet__ *ipaddr* *ipmask* ?*count*? ?__\-ipv4__?

    This command returns an ipaddress in the same position in the *count* next
    network\. The default value for *count* is __1__\.

    The address can be specified as either integer number or in dotted form\. The
    mask can be specified as either integer number, dotted form, or mask length
    form\.

    The result is in hex form\.

  - <a name='21'></a>__::ip::isOverlap__ *prefix* *prefix*\.\.\.

    This command checks if the given ip prefixes overlap\. All arguments are in
    dotted "addr/mask" form\. All arguments after the first prefix are compared
    against the first prefix\. The result is a boolean value\. It is true if an
    overlap was found for any of the prefixes\.

        % ::ip::isOverlap 1.1.1.0/24 2.1.0.1/32
        0

        ::ip::isOverlap 1.1.1.0/24 2.1.0.1/32 1.1.1.1/32
        1

  - <a name='22'></a>__::ip::isOverlapNative__ ?__\-all__? ?__\-inline__? ?__\-ipv4__? *hexipaddr* *hexipmask* *hexiplist*

    This command is similar to __::ip::isOverlap__, however the arguments
    are in the native form, and the form of the result is under greater control
    of the caller\. If the option __\-all__ is specified it checks all
    addresses for overlap, not only until the first one is found\. If the option
    __\-inline__ is specified the command returns the overlapping prefix
    instead of index values\.

    The result of the command is, depending on the specified options,

      * no options

        The index of the first overlap found, or 0 if there is none\.

      * \-all

        A list containing the indices of all overlaps found, or an empty list if
        there are none\.

      * \-inline

        The first overlapping prefix, or an empoty string if there is none\.

      * \-all \-inline

        A list containing the prefixes of all overlaps found, or an empty list
        if there are none\.

        % ::ip::isOverlapNative 0x01010100 0xffffff00 {{0x02010001 0xffffffff}}
        0

        % ::ip::isOverlapNative 0x01010100 0xffffff00 {{0x02010001 0xffffffff} {0x01010101 0xffffffff}}
        2

  - <a name='23'></a>__::ip::ipToLayer2Multicast__ *ipaddr*

    This command an converts ipv4 address in dotted form into a layer 2
    multicast address, also in dotted form\.

        % ::ip::ipToLayer2Multicast 224.0.0.2
        01.00.5e.00.00.02

  - <a name='24'></a>__::ip::ipHostFromPrefix__ *prefix* ?__\-exclude__ *prefixExcludeList*?

    This command returns a host address from a prefix in the form
    "ipaddr/masklen", also making sure that the result is not an address found
    in the *prefixExcludeList*\. The result is an ip address in dotted form\.

        %::ip::ipHostFromPrefix  1.1.1.5/24
        1.1.1.1

        %::ip::ipHostFromPrefix  1.1.1.1/32
        1.1.1.1

  - <a name='25'></a>__::ip::reduceToAggregates__ *prefixlist*

    This command finds nets that overlap and filters out the more specific nets\.
    The prefixes are in either addr/mask form or in native format\. The result is
    a list containing the non\-overlapping ip prefixes from the input\.

        % ::ip::reduceToAggregates {1.1.1.0/24 1.1.0.0/8  2.1.1.0/24 1.1.1.1/32 }
        1.0.0.0/8 2.1.1.0/24

  - <a name='26'></a>__::ip::longestPrefixMatch__ *ipaddr* *prefixlist* ?__\-ipv4__?

    This command finds longest prefix match from set of prefixes, given a
    specific host address\. The prefixes in the list are in either native or
    dotted form, whereas the host address is in either ipprefix format, dotted
    form, or integer form\. The result is the prefix which is the most specific
    match to the host address\.

        % ::ip::longestPrefixMatch 1.1.1.1 {1.1.1.0/24 1.0.0.0/8  2.1.1.0/24 1.1.1.0/28 }
        1.1.1.0/28

  - <a name='27'></a>__::ip::collapse__ *prefixlist*

    This commands takes a list of prefixes and returns a list prefixes with the
    largest possible subnet masks covering the input, in this manner collapsing
    adjacent prefixes into larger ranges\.

    This is different from __::ip::reduceToAggregates__ in that the latter
    only removes specific nets from a list when they are covered by other
    elements of the input whereas this command actively merges nets into larger
    ranges when they are adjacent to each other\.

        % ::ip::collapse {1.2.2.0/24 1.2.3.0/24}
        1.2.2.0/23

  - <a name='28'></a>__::ip::subtract__ *prefixlist*

    This command takes a list of prefixes, some of which are prefixed by a dash\.
    These latter *negative* prefixes are used to punch holes into the ranges
    described by the other, *positive*, prefixes\. I\.e\. the negative prefixes
    are subtracted frrom the positive ones, resulting in a larger list of
    describes describing the covered ranges only as positives\.

# <a name='section3'></a>EXAMPLES

    % ip::version ::1
    6
    % ip::version 127.0.0.1
    4

    % ip::normalize 127/8
    127.0.0.0/8
    % ip::contract 192.168.0.0
    192.168
    %
    % ip::normalize fec0::1
    fec0:0000:0000:0000:0000:0000:0000:0001
    % ip::contract fec0:0000:0000:0000:0000:0000:0000:0001
    fec0::1

    % ip::equal 192.168.0.4/16 192.168.0.0/16
    1
    % ip::equal fec0::1/10 fec0::fe01/10
    1

# <a name='section4'></a>REFERENCES

  1. Postel, J\. "Internet Protocol\." RFC 791, September 1981,
     \([http://www\.ietf\.org/rfc/rfc791\.txt](http://www\.ietf\.org/rfc/rfc791\.txt)\)

  1. Hinden, R\. and Deering, S\., "Internet Protocol Version 6 \(IPv6\) Addressing
     Architecture", RFC 3513, April 2003
     \([http://www\.ietf\.org/rfc/rfc3513\.txt](http://www\.ietf\.org/rfc/rfc3513\.txt)\)

# <a name='section5'></a>AUTHORS

Pat Thoyts

# <a name='section6'></a>Bugs, Ideas, Feedback

This document, and the package it describes, will undoubtedly contain bugs and
other problems\. Please report such in the category *dns* of the [Tcllib
Trackers](http://core\.tcl\.tk/tcllib/reportlist)\. Please also report any ideas
for enhancements you may have for either package and/or documentation\.

When proposing code changes, please provide *unified diffs*, i\.e the output of
__diff \-u__\.

Note further that *attachments* are strongly preferred over inlined patches\.
Attachments can be made by going to the __Edit__ form of the ticket
immediately after its creation, and then using the left\-most button in the
secondary navigation bar\.

# <a name='seealso'></a>SEE ALSO

inet\(3\), ip\(7\), ipv6\(7\)

# <a name='keywords'></a>KEYWORDS

[internet address](\.\./\.\./\.\./\.\./index\.md\#internet\_address),
[ip](\.\./\.\./\.\./\.\./index\.md\#ip), [ipv4](\.\./\.\./\.\./\.\./index\.md\#ipv4),
[ipv6](\.\./\.\./\.\./\.\./index\.md\#ipv6), [rfc
3513](\.\./\.\./\.\./\.\./index\.md\#rfc\_3513)

# <a name='category'></a>CATEGORY

Networking

# <a name='copyright'></a>COPYRIGHT

Copyright &copy; 2004, Pat Thoyts  
Copyright &copy; 2005 Aamer Akhter <aakhter@cisco\.com>
