'\"
'\" Generated from file 'tcllib_ip\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2004, Pat Thoyts
'\" Copyright (c) 2005 Aamer Akhter <aakhter@cisco\&.com>
'\"
.TH "tcllib_ip" n 1\&.5\&.1 tcllib "Domain Name Service"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
tcllib_ip \- IPv4 and IPv6 address manipulation
.SH SYNOPSIS
package require \fBTcl 8\&.5 9\fR
.sp
package require \fBip ?1\&.5\&.1?\fR
.sp
\fB::ip::version\fR \fIaddress\fR
.sp
\fB::ip::is\fR \fIclass\fR \fIaddress\fR
.sp
\fB::ip::equal\fR \fIaddress\fR \fIaddress\fR
.sp
\fB::ip::normalize\fR \fIaddress\fR
.sp
\fB::ip::contract\fR \fIaddress\fR
.sp
\fB::ip::distance\fR \fIipaddr1\fR \fIipaddr2\fR
.sp
\fB::ip::nextIp\fR \fIipaddr\fR ?\fIoffset\fR?
.sp
\fB::ip::prefix\fR \fIaddress\fR
.sp
\fB::ip::type\fR \fIaddress\fR
.sp
\fB::ip::mask\fR \fIaddress\fR
.sp
\fB::ip::prefixToNative\fR \fIprefix\fR
.sp
\fB::ip::nativeToPrefix\fR \fInativeList\fR|\fInative\fR ?\fB-ipv4\fR?
.sp
\fB::ip::intToString\fR \fInumber\fR ?\fB-ipv4\fR?
.sp
\fB::ip::toInteger\fR \fIipaddr\fR
.sp
\fB::ip::toHex\fR \fIipaddr\fR
.sp
\fB::ip::maskToInt\fR \fIipmask\fR
.sp
\fB::ip::broadcastAddress\fR \fIprefix\fR ?\fB-ipv4\fR?
.sp
\fB::ip::maskToLength\fR \fIdottedMask\fR|\fIintegerMask\fR|\fIhexMask\fR ?\fB-ipv4\fR?
.sp
\fB::ip::lengthToMask\fR \fImaskLength\fR ?\fB-ipv4\fR?
.sp
\fB::ip::nextNet\fR \fIipaddr\fR \fIipmask\fR ?\fIcount\fR? ?\fB-ipv4\fR?
.sp
\fB::ip::isOverlap\fR \fIprefix\fR \fIprefix\fR\&.\&.\&.
.sp
\fB::ip::isOverlapNative\fR ?\fB-all\fR? ?\fB-inline\fR? ?\fB-ipv4\fR? \fIhexipaddr\fR \fIhexipmask\fR \fIhexiplist\fR
.sp
\fB::ip::ipToLayer2Multicast\fR \fIipaddr\fR
.sp
\fB::ip::ipHostFromPrefix\fR \fIprefix\fR ?\fB-exclude\fR \fIprefixExcludeList\fR?
.sp
\fB::ip::reduceToAggregates\fR \fIprefixlist\fR
.sp
\fB::ip::longestPrefixMatch\fR \fIipaddr\fR \fIprefixlist\fR ?\fB-ipv4\fR?
.sp
\fB::ip::collapse\fR \fIprefixlist\fR
.sp
\fB::ip::subtract\fR \fIprefixlist\fR
.sp
.BE
.SH DESCRIPTION
.PP
This package provides a set of commands to help in parsing, displaying
and comparing internet addresses\&. The package can handle both IPv4 (1)
and IPv6 (2) address types\&.
.SH COMMANDS
.TP
\fB::ip::version\fR \fIaddress\fR
Returns the protocol version of the address (\fB4\fR or \fB6\fR),
or \fB-1\fR if the address is neither IPv4 or IPv6\&.
.TP
\fB::ip::is\fR \fIclass\fR \fIaddress\fR
Returns true if the address is a member of the given protocol
class\&. The class parameter may be either \fBipv4\fR or \fBipv6\fR
This is effectively a boolean equivalent of the \fBversion\fR
command\&. The \fIclass\fR argument may be shortened to \fB4\fR or
\fB6\fR\&.
.TP
\fB::ip::equal\fR \fIaddress\fR \fIaddress\fR
Compare two address specifications for equivalence\&. The arguments are
normalized and the address prefix determined (if a mask is
supplied)\&. The normalized addresses are then compared bit-by-bit and
the procedure returns true if they match\&.
.TP
\fB::ip::normalize\fR \fIaddress\fR
Convert an IPv4 or IPv6 address into a fully expanded version\&. There
are various shorthand ways to write internet addresses, missing out
redundant parts or digits\&. This procedure is the opposite of
\fBcontract\fR\&.
.TP
\fB::ip::contract\fR \fIaddress\fR
Convert a \fBnormalize\fRd internet address into a more compact form
suitable for displaying to users\&.
.TP
\fB::ip::distance\fR \fIipaddr1\fR \fIipaddr2\fR
This command computes the (integer) distance from IPv4 address
\fIipaddr1\fR to IPv4 address \fIipaddr2\fR, i\&.e\&. "ipaddr2 - ipaddr1"
.sp
.CS


   % ::ip::distance 1\&.1\&.1\&.1  1\&.1\&.1\&.5
   4

.CE
.TP
\fB::ip::nextIp\fR \fIipaddr\fR ?\fIoffset\fR?
This command adds the integer \fIoffset\fR to the IPv4 address \fIipaddr\fR
and returns the new IPv4 address\&.
.sp
.CS


   % ::ip::distance 1\&.1\&.1\&.1  4
   1\&.1\&.1\&.5

.CE
.TP
\fB::ip::prefix\fR \fIaddress\fR
Returns the address prefix generated by masking the address part with
the mask if provided\&. If there is no mask then it is equivalent to
calling \fBnormalize\fR
.TP
\fB::ip::type\fR \fIaddress\fR
.TP
\fB::ip::mask\fR \fIaddress\fR
If the address supplied includes a mask then this is returned
otherwise returns an empty string\&.
.TP
\fB::ip::prefixToNative\fR \fIprefix\fR
This command converts the string \fIprefix\fR from dotted form
(<ipaddr>/<mask> format) to native (hex) form\&. Returns a list
containing two elements, ipaddress and mask, in this order, in
hexadecimal notation\&.
.sp
.CS


   % ip::prefixToNative 1\&.1\&.1\&.0/24
   0x01010100 0xffffff00

.CE
.TP
\fB::ip::nativeToPrefix\fR \fInativeList\fR|\fInative\fR ?\fB-ipv4\fR?
This command converts from native (hex) form to dotted form\&.
It is the complement of \fB::ip::prefixToNative\fR\&.
.sp
.RS
.TP
list \fInativeList\fR (in)
List of several ip addresses in native form\&. The native form is a list
as returned by \fB::ip::prefixToNative\fR\&.
.TP
list \fInative\fR (in)
A list as returned by \fB::ip::prefixToNative\fR\&.
.RE
.sp
The command returns a list of addresses in dotted form if it was
called with a list of addresses\&. Otherwise a single address in dotted
form is returned\&.
.sp
.CS


   % ip::nativeToPrefix {0x01010100 0xffffff00} -ipv4
   1\&.1\&.1\&.0/24

.CE
.TP
\fB::ip::intToString\fR \fInumber\fR ?\fB-ipv4\fR?
This command converts from an ip address specified as integer number
to dotted form\&.
.sp
.CS


       ip::intToString 4294967295
       255\&.255\&.255\&.255

.CE
.TP
\fB::ip::toInteger\fR \fIipaddr\fR
This command converts a dotted form ip into an integer number\&.
.sp
.CS


   % ::ip::toInteger 1\&.1\&.1\&.0
   16843008

.CE
.TP
\fB::ip::toHex\fR \fIipaddr\fR
This command converts dotted form ip into a hexadecimal number\&.
.sp
.CS


   % ::ip::toHex 1\&.1\&.1\&.0
   0x01010100

.CE
.TP
\fB::ip::maskToInt\fR \fIipmask\fR
This command convert an ipmask in either dotted (255\&.255\&.255\&.0) form
or mask length form (24) into an integer number\&.
.sp
.CS


   ::ip::maskToInt 24
   4294967040

.CE
.TP
\fB::ip::broadcastAddress\fR \fIprefix\fR ?\fB-ipv4\fR?
This commands returns a broadcast address in dotted form for the given
route \fIprefix\fR, either in the form "addr/mask", or in native
form\&. The result is in dotted form\&.
.sp
.CS


   ::ip::broadcastAddress 1\&.1\&.1\&.0/24
   1\&.1\&.1\&.255

   ::ip::broadcastAddress {0x01010100 0xffffff00}
   0x010101ff

.CE
.TP
\fB::ip::maskToLength\fR \fIdottedMask\fR|\fIintegerMask\fR|\fIhexMask\fR ?\fB-ipv4\fR?
This command converts the dotted or integer form of an ipmask to
the mask length form\&.
.sp
.CS


   ::ip::maskToLength 0xffffff00 -ipv4
   24

   % ::ip::maskToLength 255\&.255\&.255\&.0
   24

.CE
.TP
\fB::ip::lengthToMask\fR \fImaskLength\fR ?\fB-ipv4\fR?
This command converts an ipmask in mask length form to its dotted
form\&.
.sp
.CS


   ::ip::lengthToMask 24
   255\&.255\&.255\&.0

.CE
.TP
\fB::ip::nextNet\fR \fIipaddr\fR \fIipmask\fR ?\fIcount\fR? ?\fB-ipv4\fR?
This command returns an ipaddress in the same position in the
\fIcount\fR next network\&. The default value for \fIcount\fR is
\fB1\fR\&.
.sp
The address can be specified as either integer number or in dotted
form\&. The mask can be specified as either integer number, dotted form,
or mask length form\&.
.sp
The result is in hex form\&.
.TP
\fB::ip::isOverlap\fR \fIprefix\fR \fIprefix\fR\&.\&.\&.
This command checks if the given ip prefixes overlap\&.  All arguments
are in dotted "addr/mask" form\&. All arguments after the first prefix
are compared against the first prefix\&. The result is a boolean
value\&. It is true if an overlap was found for any of the prefixes\&.
.sp
.CS


  % ::ip::isOverlap 1\&.1\&.1\&.0/24 2\&.1\&.0\&.1/32
  0

  ::ip::isOverlap 1\&.1\&.1\&.0/24 2\&.1\&.0\&.1/32 1\&.1\&.1\&.1/32
  1

.CE
.TP
\fB::ip::isOverlapNative\fR ?\fB-all\fR? ?\fB-inline\fR? ?\fB-ipv4\fR? \fIhexipaddr\fR \fIhexipmask\fR \fIhexiplist\fR
This command is similar to \fB::ip::isOverlap\fR, however the
arguments are in the native form, and the form of the result is under
greater control of the caller\&.
If the option \fB-all\fR is specified it checks all addresses for
overlap, not only until the first one is found\&.
If the option \fB-inline\fR is specified the command returns the
overlapping prefix instead of index values\&.
.sp
The result of the command is, depending on the specified options,
.RS
.TP
no options
The index of the first overlap found, or 0 if there is none\&.
.TP
-all
A list containing the indices of all overlaps found, or an empty list
if there are none\&.
.TP
-inline
The first overlapping prefix, or an empoty string if there is none\&.
.TP
-all -inline
A list containing the prefixes of all overlaps found, or an empty list
if there are none\&.
.RE
.sp
.CS


  % ::ip::isOverlapNative 0x01010100 0xffffff00 {{0x02010001 0xffffffff}}
  0

  % ::ip::isOverlapNative 0x01010100 0xffffff00 {{0x02010001 0xffffffff} {0x01010101 0xffffffff}}
  2

.CE
.TP
\fB::ip::ipToLayer2Multicast\fR \fIipaddr\fR
This command an converts ipv4 address in dotted form into a layer 2
multicast address, also in dotted form\&.
.sp
.CS


  % ::ip::ipToLayer2Multicast 224\&.0\&.0\&.2
  01\&.00\&.5e\&.00\&.00\&.02

.CE
.TP
\fB::ip::ipHostFromPrefix\fR \fIprefix\fR ?\fB-exclude\fR \fIprefixExcludeList\fR?
This command returns a host address from a prefix in the form
"ipaddr/masklen", also making sure that the result is not an address
found in the \fIprefixExcludeList\fR\&.
The result is an ip address in dotted form\&.
.sp
.CS


  %::ip::ipHostFromPrefix  1\&.1\&.1\&.5/24
  1\&.1\&.1\&.1

  %::ip::ipHostFromPrefix  1\&.1\&.1\&.1/32
  1\&.1\&.1\&.1

.CE
.TP
\fB::ip::reduceToAggregates\fR \fIprefixlist\fR
This command finds nets that overlap and filters out the more specific
nets\&. The prefixes are in either addr/mask form or in native format\&.
The result is a list containing the non-overlapping ip prefixes from
the input\&.
.sp
.CS


  % ::ip::reduceToAggregates {1\&.1\&.1\&.0/24 1\&.1\&.0\&.0/8  2\&.1\&.1\&.0/24 1\&.1\&.1\&.1/32 }
  1\&.0\&.0\&.0/8 2\&.1\&.1\&.0/24

.CE
.TP
\fB::ip::longestPrefixMatch\fR \fIipaddr\fR \fIprefixlist\fR ?\fB-ipv4\fR?
This command finds longest prefix match from set of prefixes, given a
specific host address\&. The prefixes in the list are in either native
or dotted form, whereas the host address is in either ipprefix format,
dotted form, or integer form\&.
The result is the prefix which is the most specific match to the host
address\&.
.sp
.CS


  % ::ip::longestPrefixMatch 1\&.1\&.1\&.1 {1\&.1\&.1\&.0/24 1\&.0\&.0\&.0/8  2\&.1\&.1\&.0/24 1\&.1\&.1\&.0/28 }
  1\&.1\&.1\&.0/28

.CE
.TP
\fB::ip::collapse\fR \fIprefixlist\fR
This commands takes a list of prefixes and returns a list prefixes
with the largest possible subnet masks covering the input, in this
manner collapsing adjacent prefixes into larger ranges\&.
.sp
This is different from \fB::ip::reduceToAggregates\fR in that
the latter only removes specific nets from a list when they are
covered by other elements of the input whereas this command actively
merges nets into larger ranges when they are adjacent to each other\&.
.sp
.CS


% ::ip::collapse {1\&.2\&.2\&.0/24 1\&.2\&.3\&.0/24}
1\&.2\&.2\&.0/23

.CE
.TP
\fB::ip::subtract\fR \fIprefixlist\fR
This command takes a list of prefixes, some of which are prefixed by a
dash\&. These latter \fInegative\fR prefixes are used to punch holes
into the ranges described by the other, \fIpositive\fR,
prefixes\&. I\&.e\&. the negative prefixes are subtracted frrom the positive
ones, resulting in a larger list of describes describing the covered
ranges only as positives\&.
.PP
.SH EXAMPLES
.PP
.CS


% ip::version ::1
6
% ip::version 127\&.0\&.0\&.1
4

.CE
.CS


% ip::normalize 127/8
127\&.0\&.0\&.0/8
% ip::contract 192\&.168\&.0\&.0
192\&.168
%
% ip::normalize fec0::1
fec0:0000:0000:0000:0000:0000:0000:0001
% ip::contract fec0:0000:0000:0000:0000:0000:0000:0001
fec0::1

.CE
.CS


% ip::equal 192\&.168\&.0\&.4/16 192\&.168\&.0\&.0/16
1
% ip::equal fec0::1/10 fec0::fe01/10
1

.CE
.SH REFERENCES
.IP [1]
Postel, J\&. "Internet Protocol\&." RFC 791,  September 1981,
(\fIhttp://www\&.ietf\&.org/rfc/rfc791\&.txt\fR)
.IP [2]
Hinden, R\&. and Deering, S\&.,
"Internet Protocol Version 6 (IPv6) Addressing Architecture",
RFC 3513, April 2003
(\fIhttp://www\&.ietf\&.org/rfc/rfc3513\&.txt\fR)
.PP
.SH AUTHORS
Pat Thoyts
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fIdns\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.PP
When proposing code changes, please provide \fIunified diffs\fR,
i\&.e the output of \fBdiff -u\fR\&.
.PP
Note further that \fIattachments\fR are strongly preferred over
inlined patches\&. Attachments can be made by going to the \fBEdit\fR
form of the ticket immediately after its creation, and then using the
left-most button in the secondary navigation bar\&.
.SH "SEE ALSO"
inet(3), ip(7), ipv6(7)
.SH KEYWORDS
internet address, ip, ipv4, ipv6, rfc 3513
.SH CATEGORY
Networking
.SH COPYRIGHT
.nf
Copyright (c) 2004, Pat Thoyts
Copyright (c) 2005 Aamer Akhter <aakhter@cisco\&.com>

.fi
