% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monad.R
\name{functor-laws}
\alias{functor-laws}
\title{Functor Laws}
\arguments{
\item{m}{A functor object.}

\item{f, g}{Functions.}
}
\description{
Classes implementing \code{\link[=fmap]{fmap()}} are expected to satisfy two functor laws:
preservation of identity and preservation of composition.
}
\details{
The Haskell functor laws can be translated into R as follows:

\describe{
\item{Preservation of identity:}{\code{m \%>>\% identity} is equal to \code{m |> identity()}.}
\item{Preservation of composition:}{\code{m \%>>\% (f \%.\% g)} is equal to \code{m \%>>\% g \%>>\% f}.}
}

Where above \verb{\%.\%} denotes function composition \verb{\\(f, g) \\(x) f(g(x))}.
}
\references{
\url{https://wiki.haskell.org/Functor#Functor_Laws}
}
\seealso{
Other implementation laws: 
\code{\link{monad-laws}}
}
\concept{implementation laws}
