% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_id.R
\name{time_id}
\alias{time_id}
\title{Time ID}
\usage{
time_id(
  x,
  time_by = NULL,
  g = NULL,
  na_skip = TRUE,
  time_type = getOption("timeplyr.time_type", "auto"),
  shift = 1L
)
}
\arguments{
\item{x}{Time variable. \cr
Can be a \code{Date}, \code{POSIXt}, \code{numeric}, \code{integer}, \code{yearmon}, or \code{yearqtr}.}

\item{time_by}{Time unit. \cr
This signifies the granularity of the time data with which to measure gaps
in the sequence.
If your data is daily for example, supply \code{time_by = "days"}.
If weekly, supply \code{time_by = "week"}.
Must be one of the three:
\itemize{
\item string, specifying either the unit or the number and unit, e.g
\code{time_by = "days"} or \code{time_by = "2 weeks"}
\item named list of length one, the unit being the name, and
the number the value of the list, e.g. \code{list("days" = 7)}.
For the vectorized time functions, you can supply multiple values,
e.g. \code{list("days" = 1:10)}.
\item Numeric vector. If time_by is a numeric vector and x is not a date/datetime,
then arithmetic is used, e.g \code{time_by = 1}.
}}

\item{g}{Object used for grouping x.
This can for example be a vector or data frame.
\code{g} is passed directly to \code{collapse::GRP()}.}

\item{na_skip}{Should \code{NA} values be skipped? Default is \code{TRUE}.}

\item{time_type}{If "auto", \code{periods} are used for
the time expansion when days, weeks, months or years are specified,
and \code{durations} are used otherwise.}

\item{shift}{Value used to shift the time IDs. Typically this is 1 to ensure the
IDs start at 1 but can be 0 or even negative if for example
your time values are going backwards in time.}
}
\value{
An integer vector the same length as \code{x}.
}
\description{
Generate a time ID that signifies how many time steps away
a time value is from the starting time point or more intuitively,
this is the time passed since
the first time point.
}
\details{
This is heavily inspired by \code{collapse::timeid} but differs in 3 ways:
\itemize{
\item The time steps need not be the greatest common divisor of successive
differences
\item The starting time point may not necessarily
be the earliest chronologically and thus \code{time_id} can generate negative IDs.
\item \code{g} can be supplied to calculate IDs by group.
}

\code{time_id(c(3, 2, 1))} is not the same as \code{collapse::timeid(c(3, 2, 1))}.
In general \code{time_id(sort(x))}
should be equal to  \code{collapse::timeid(sort(x))}.
The time difference GCD is always calculated using all the data and not
by-group.
}
\seealso{
\link{time_elapsed} \link{time_seq_id}
}
