/** @file RNAeval_cmdl.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.23
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt */

#ifndef RNAEVAL_CMDL_H
#define RNAEVAL_CMDL_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef RNAEVAL_CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define RNAEVAL_CMDLINE_PARSER_PACKAGE "RNAeval"
#endif

#ifndef RNAEVAL_CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#define RNAEVAL_CMDLINE_PARSER_PACKAGE_NAME "RNAeval"
#endif

#ifndef RNAEVAL_CMDLINE_PARSER_VERSION
/** @brief the program version */
#define RNAEVAL_CMDLINE_PARSER_VERSION VERSION
#endif

/** @brief Where the command line options are stored */
struct RNAeval_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *detailed_help_help; /**< @brief Print help, including all details and hidden options, and exit help description.  */
  const char *full_help_help; /**< @brief Print help, including hidden options, and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  int verbose_flag;	/**< @brief Be verbose and print out energy contribution of each loop in the structure.
 (default=off).  */
  const char *verbose_help; /**< @brief Be verbose and print out energy contribution of each loop in the structure.
 help description.  */
  char ** infile_arg;	/**< @brief Read a file instead of reading from stdin.
.  */
  char ** infile_orig;	/**< @brief Read a file instead of reading from stdin.
 original value given at command line.  */
  unsigned int infile_min; /**< @brief Read a file instead of reading from stdin.
's minimum occurreces */
  unsigned int infile_max; /**< @brief Read a file instead of reading from stdin.
's maximum occurreces */
  const char *infile_help; /**< @brief Read a file instead of reading from stdin.
 help description.  */
  int msa_flag;	/**< @brief Input is multiple sequence alignment in Stockholm 1.0 format.
 (default=off).  */
  const char *msa_help; /**< @brief Input is multiple sequence alignment in Stockholm 1.0 format.
 help description.  */
  int mis_flag;	/**< @brief Output \"most informative sequence\" instead of simple consensus: For each column of the alignment output the set of nucleotides with frequency greater than average in IUPAC notation.
  
 (default=off).  */
  const char *mis_help; /**< @brief Output \"most informative sequence\" instead of simple consensus: For each column of the alignment output the set of nucleotides with frequency greater than average in IUPAC notation.
  
 help description.  */
  int jobs_arg;	/**< @brief Split batch input into jobs and start processing in parallel using multiple threads. A value of 0 indicates to use as many parallel threads as computation cores are available.
 (default='0').  */
  char * jobs_orig;	/**< @brief Split batch input into jobs and start processing in parallel using multiple threads. A value of 0 indicates to use as many parallel threads as computation cores are available.
 original value given at command line.  */
  const char *jobs_help; /**< @brief Split batch input into jobs and start processing in parallel using multiple threads. A value of 0 indicates to use as many parallel threads as computation cores are available.
 help description.  */
  int unordered_flag;	/**< @brief Do not try to keep output in order with input while parallel processing is in place.
 (default=off).  */
  const char *unordered_help; /**< @brief Do not try to keep output in order with input while parallel processing is in place.
 help description.  */
  int noconv_flag;	/**< @brief Do not automatically substitute nucleotide \"T\" with \"U\".
  
 (default=off).  */
  const char *noconv_help; /**< @brief Do not automatically substitute nucleotide \"T\" with \"U\".
  
 help description.  */
  int auto_id_flag;	/**< @brief Automatically generate an ID for each sequence.
 (default=off).  */
  const char *auto_id_help; /**< @brief Automatically generate an ID for each sequence.
 help description.  */
  char * id_prefix_arg;	/**< @brief Prefix for automatically generated IDs (as used in output file names).
 (default='sequence').  */
  char * id_prefix_orig;	/**< @brief Prefix for automatically generated IDs (as used in output file names).
 original value given at command line.  */
  const char *id_prefix_help; /**< @brief Prefix for automatically generated IDs (as used in output file names).
 help description.  */
  char * id_delim_arg;	/**< @brief Change the delimiter between prefix and increasing number for automatically generated IDs (as used in output file names).
 (default='_').  */
  char * id_delim_orig;	/**< @brief Change the delimiter between prefix and increasing number for automatically generated IDs (as used in output file names).
 original value given at command line.  */
  const char *id_delim_help; /**< @brief Change the delimiter between prefix and increasing number for automatically generated IDs (as used in output file names).
 help description.  */
  int id_digits_arg;	/**< @brief Specify the number of digits of the counter in automatically generated alignment IDs.
 (default='4').  */
  char * id_digits_orig;	/**< @brief Specify the number of digits of the counter in automatically generated alignment IDs.
 original value given at command line.  */
  const char *id_digits_help; /**< @brief Specify the number of digits of the counter in automatically generated alignment IDs.
 help description.  */
  long id_start_arg;	/**< @brief Specify the first number in automatically generated IDs.
 (default='1').  */
  char * id_start_orig;	/**< @brief Specify the first number in automatically generated IDs.
 original value given at command line.  */
  const char *id_start_help; /**< @brief Specify the first number in automatically generated IDs.
 help description.  */
  int log_level_arg;	/**< @brief Set log level threshold.
 (default='2').  */
  char * log_level_orig;	/**< @brief Set log level threshold.
 original value given at command line.  */
  const char *log_level_help; /**< @brief Set log level threshold.
 help description.  */
  char * log_file_arg;	/**< @brief Print log messages to a file instead of stderr.
 (default='RNAeval.log').  */
  char * log_file_orig;	/**< @brief Print log messages to a file instead of stderr.
 original value given at command line.  */
  const char *log_file_help; /**< @brief Print log messages to a file instead of stderr.
 help description.  */
  int log_time_flag;	/**< @brief Include time stamp in log messages.
  
 (default=off).  */
  const char *log_time_help; /**< @brief Include time stamp in log messages.
  
 help description.  */
  int log_call_flag;	/**< @brief Include file and line of log calling function.
  
 (default=off).  */
  const char *log_call_help; /**< @brief Include file and line of log calling function.
  
 help description.  */
  int circ_flag;	/**< @brief Assume a circular (instead of linear) RNA molecule.
  
 (default=off).  */
  const char *circ_help; /**< @brief Assume a circular (instead of linear) RNA molecule.
  
 help description.  */
  int gquad_flag;	/**< @brief Incoorporate G-Quadruplex formation into the structure prediction algorithm.
  
 (default=off).  */
  const char *gquad_help; /**< @brief Incoorporate G-Quadruplex formation into the structure prediction algorithm.
  
 help description.  */
  char * shape_arg;	/**< @brief Use SHAPE reactivity data to guide structure predictions.
  
.  */
  char * shape_orig;	/**< @brief Use SHAPE reactivity data to guide structure predictions.
  
 original value given at command line.  */
  const char *shape_help; /**< @brief Use SHAPE reactivity data to guide structure predictions.
  
 help description.  */
  char * shapeMethod_arg;	/**< @brief Select SHAPE reactivity data incorporation strategy.
  
 (default='D').  */
  char * shapeMethod_orig;	/**< @brief Select SHAPE reactivity data incorporation strategy.
  
 original value given at command line.  */
  const char *shapeMethod_help; /**< @brief Select SHAPE reactivity data incorporation strategy.
  
 help description.  */
  char * shapeConversion_arg;	/**< @brief Select method for SHAPE reactivity conversion.
  
 (default='O').  */
  char * shapeConversion_orig;	/**< @brief Select method for SHAPE reactivity conversion.
  
 original value given at command line.  */
  const char *shapeConversion_help; /**< @brief Select method for SHAPE reactivity conversion.
  
 help description.  */
  double temp_arg;	/**< @brief Rescale energy parameters to a temperature of temp C. Default is 37C.
  
 (default='37.0').  */
  char * temp_orig;	/**< @brief Rescale energy parameters to a temperature of temp C. Default is 37C.
  
 original value given at command line.  */
  const char *temp_help; /**< @brief Rescale energy parameters to a temperature of temp C. Default is 37C.
  
 help description.  */
  char * paramFile_arg;	/**< @brief Read energy parameters from paramfile, instead of using the default parameter set.
.  */
  char * paramFile_orig;	/**< @brief Read energy parameters from paramfile, instead of using the default parameter set.
 original value given at command line.  */
  const char *paramFile_help; /**< @brief Read energy parameters from paramfile, instead of using the default parameter set.
 help description.  */
  int noTetra_flag;	/**< @brief Do not include special tabulated stabilizing energies for tri-, tetra- and hexaloop hairpins.
 (default=off).  */
  const char *noTetra_help; /**< @brief Do not include special tabulated stabilizing energies for tri-, tetra- and hexaloop hairpins.
 help description.  */
  double salt_arg;	/**< @brief Set salt concentration in molar (M). Default is 1.021M.
  
.  */
  char * salt_orig;	/**< @brief Set salt concentration in molar (M). Default is 1.021M.
  
 original value given at command line.  */
  const char *salt_help; /**< @brief Set salt concentration in molar (M). Default is 1.021M.
  
 help description.  */
  int dangles_arg;	/**< @brief How to treat \"dangling end\" energies for bases adjacent to helices in free ends and multi-loops.
 (default='2').  */
  char * dangles_orig;	/**< @brief How to treat \"dangling end\" energies for bases adjacent to helices in free ends and multi-loops.
 original value given at command line.  */
  const char *dangles_help; /**< @brief How to treat \"dangling end\" energies for bases adjacent to helices in free ends and multi-loops.
 help description.  */
  char * nsp_arg;	/**< @brief Allow other pairs in addition to the usual AU,GC,and GU pairs.
.  */
  char * nsp_orig;	/**< @brief Allow other pairs in addition to the usual AU,GC,and GU pairs.
 original value given at command line.  */
  const char *nsp_help; /**< @brief Allow other pairs in addition to the usual AU,GC,and GU pairs.
 help description.  */
  int energyModel_arg;	/**< @brief Set energy model.
.  */
  char * energyModel_orig;	/**< @brief Set energy model.
 original value given at command line.  */
  const char *energyModel_help; /**< @brief Set energy model.
 help description.  */
  int logML_flag;	/**< @brief Recalculate energies of structures using a logarithmic energy function for multi-loops before output.
 (default=off).  */
  const char *logML_help; /**< @brief Recalculate energies of structures using a logarithmic energy function for multi-loops before output.
 help description.  */
  double cfactor_arg;	/**< @brief Set the weight of the covariance term in the energy function
  
 (default='1.0').  */
  char * cfactor_orig;	/**< @brief Set the weight of the covariance term in the energy function
  
 original value given at command line.  */
  const char *cfactor_help; /**< @brief Set the weight of the covariance term in the energy function
  
 help description.  */
  double nfactor_arg;	/**< @brief Set the penalty for non-compatible sequences in the covariance term of the energy function
  
 (default='1.0').  */
  char * nfactor_orig;	/**< @brief Set the penalty for non-compatible sequences in the covariance term of the energy function
  
 original value given at command line.  */
  const char *nfactor_help; /**< @brief Set the penalty for non-compatible sequences in the covariance term of the energy function
  
 help description.  */
  char * ribosum_file_arg;	/**< @brief use specified Ribosum Matrix instead of normal energy model.
.  */
  char * ribosum_file_orig;	/**< @brief use specified Ribosum Matrix instead of normal energy model.
 original value given at command line.  */
  const char *ribosum_file_help; /**< @brief use specified Ribosum Matrix instead of normal energy model.
 help description.  */
  int ribosum_scoring_flag;	/**< @brief use ribosum scoring matrix.
 (default=off).  */
  const char *ribosum_scoring_help; /**< @brief use ribosum scoring matrix.
 help description.  */
  int old_flag;	/**< @brief use old energy evaluation, treating gaps as characters.
  
 (default=off).  */
  const char *old_help; /**< @brief use old energy evaluation, treating gaps as characters.
  
 help description.  */
  float helical_rise_arg;	/**< @brief Set the helical rise of the helix in units of Angstrom.
 (default='2.8').  */
  char * helical_rise_orig;	/**< @brief Set the helical rise of the helix in units of Angstrom.
 original value given at command line.  */
  const char *helical_rise_help; /**< @brief Set the helical rise of the helix in units of Angstrom.
 help description.  */
  float backbone_length_arg;	/**< @brief Set the average backbone length for looped regions in units of Angstrom.
 (default='6.0').  */
  char * backbone_length_orig;	/**< @brief Set the average backbone length for looped regions in units of Angstrom.
 original value given at command line.  */
  const char *backbone_length_help; /**< @brief Set the average backbone length for looped regions in units of Angstrom.
 help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int detailed_help_given ;	/**< @brief Whether detailed-help was given.  */
  unsigned int full_help_given ;	/**< @brief Whether full-help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int verbose_given ;	/**< @brief Whether verbose was given.  */
  unsigned int infile_given ;	/**< @brief Whether infile was given.  */
  unsigned int msa_given ;	/**< @brief Whether msa was given.  */
  unsigned int mis_given ;	/**< @brief Whether mis was given.  */
  unsigned int jobs_given ;	/**< @brief Whether jobs was given.  */
  unsigned int unordered_given ;	/**< @brief Whether unordered was given.  */
  unsigned int noconv_given ;	/**< @brief Whether noconv was given.  */
  unsigned int auto_id_given ;	/**< @brief Whether auto-id was given.  */
  unsigned int id_prefix_given ;	/**< @brief Whether id-prefix was given.  */
  unsigned int id_delim_given ;	/**< @brief Whether id-delim was given.  */
  unsigned int id_digits_given ;	/**< @brief Whether id-digits was given.  */
  unsigned int id_start_given ;	/**< @brief Whether id-start was given.  */
  unsigned int log_level_given ;	/**< @brief Whether log-level was given.  */
  unsigned int log_file_given ;	/**< @brief Whether log-file was given.  */
  unsigned int log_time_given ;	/**< @brief Whether log-time was given.  */
  unsigned int log_call_given ;	/**< @brief Whether log-call was given.  */
  unsigned int circ_given ;	/**< @brief Whether circ was given.  */
  unsigned int gquad_given ;	/**< @brief Whether gquad was given.  */
  unsigned int shape_given ;	/**< @brief Whether shape was given.  */
  unsigned int shapeMethod_given ;	/**< @brief Whether shapeMethod was given.  */
  unsigned int shapeConversion_given ;	/**< @brief Whether shapeConversion was given.  */
  unsigned int temp_given ;	/**< @brief Whether temp was given.  */
  unsigned int paramFile_given ;	/**< @brief Whether paramFile was given.  */
  unsigned int noTetra_given ;	/**< @brief Whether noTetra was given.  */
  unsigned int salt_given ;	/**< @brief Whether salt was given.  */
  unsigned int dangles_given ;	/**< @brief Whether dangles was given.  */
  unsigned int nsp_given ;	/**< @brief Whether nsp was given.  */
  unsigned int energyModel_given ;	/**< @brief Whether energyModel was given.  */
  unsigned int logML_given ;	/**< @brief Whether logML was given.  */
  unsigned int cfactor_given ;	/**< @brief Whether cfactor was given.  */
  unsigned int nfactor_given ;	/**< @brief Whether nfactor was given.  */
  unsigned int ribosum_file_given ;	/**< @brief Whether ribosum_file was given.  */
  unsigned int ribosum_scoring_given ;	/**< @brief Whether ribosum_scoring was given.  */
  unsigned int old_given ;	/**< @brief Whether old was given.  */
  unsigned int helical_rise_given ;	/**< @brief Whether helical-rise was given.  */
  unsigned int backbone_length_given ;	/**< @brief Whether backbone-length was given.  */

  char **inputs ; /**< @brief unnamed options (options without names) */
  unsigned inputs_num ; /**< @brief unnamed options number */
} ;

/** @brief The additional parameters to pass to parser functions */
struct RNAeval_cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure RNAeval_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure RNAeval_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *RNAeval_args_info_purpose;
/** @brief the usage string of the program */
extern const char *RNAeval_args_info_usage;
/** @brief the description string of the program */
extern const char *RNAeval_args_info_description;
/** @brief all the lines making the help output */
extern const char *RNAeval_args_info_help[];
/** @brief all the lines making the full help output (including hidden options) */
extern const char *RNAeval_args_info_full_help[];
/** @brief all the lines making the detailed help output (including hidden options and details) */
extern const char *RNAeval_args_info_detailed_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int RNAeval_cmdline_parser (int argc, char **argv,
  struct RNAeval_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use RNAeval_cmdline_parser_ext() instead
 */
int RNAeval_cmdline_parser2 (int argc, char **argv,
  struct RNAeval_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int RNAeval_cmdline_parser_ext (int argc, char **argv,
  struct RNAeval_args_info *args_info,
  struct RNAeval_cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int RNAeval_cmdline_parser_dump(FILE *outfile,
  struct RNAeval_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int RNAeval_cmdline_parser_file_save(const char *filename,
  struct RNAeval_args_info *args_info);

/**
 * Print the help
 */
void RNAeval_cmdline_parser_print_help(void);
/**
 * Print the full help (including hidden options)
 */
void RNAeval_cmdline_parser_print_full_help(void);
/**
 * Print the detailed help (including hidden options and details)
 */
void RNAeval_cmdline_parser_print_detailed_help(void);
/**
 * Print the version
 */
void RNAeval_cmdline_parser_print_version(void);

/**
 * Initializes all the fields a RNAeval_cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void RNAeval_cmdline_parser_params_init(struct RNAeval_cmdline_parser_params *params);

/**
 * Allocates dynamically a RNAeval_cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized RNAeval_cmdline_parser_params structure
 */
struct RNAeval_cmdline_parser_params *RNAeval_cmdline_parser_params_create(void);

/**
 * Initializes the passed RNAeval_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void RNAeval_cmdline_parser_init (struct RNAeval_args_info *args_info);
/**
 * Deallocates the string fields of the RNAeval_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void RNAeval_cmdline_parser_free (struct RNAeval_args_info *args_info);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int RNAeval_cmdline_parser_required (struct RNAeval_args_info *args_info,
  const char *prog_name);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* RNAEVAL_CMDL_H */
