/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.build;

import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.D8;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.DesugarGraphConsumer;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.utils.FlagFile;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CustomD8 {
    private static String parseAndRemoveArg(List<String> args, String name) throws CompilationFailedException {
        int idx = args.indexOf(name);
        if (idx == -1) {
            return null;
        }
        if (idx == args.size() - 1) {
            throw new CompilationFailedException("Missing argument to '" + name + "'");
        }
        String value = args.get(idx + 1);
        args.subList(idx, idx + 2).clear();
        return value;
    }

    public static void main(String[] args) throws CompilationFailedException, IOException {
        String[] expandedArgs = FlagFile.expandFlagFiles((String[])args, null);
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(expandedArgs));
        String desugarDependenciesPath = CustomD8.parseAndRemoveArg(argList, "--desugar-dependencies");
        final String fileTmpPrefix = CustomD8.parseAndRemoveArg(argList, "--file-tmp-prefix");
        D8Command.Builder builder = D8Command.parse((String[])argList.toArray(new String[0]), (Origin)new CommandLineOrigin());
        if (desugarDependenciesPath != null) {
            Path desugarDependencies = Paths.get(desugarDependenciesPath, new String[0]);
            final PrintWriter desugarDependenciesPrintWriter = new PrintWriter(Files.newOutputStream(desugarDependencies, new OpenOption[0]));
            if (builder.getDesugarGraphConsumer() != null) {
                throw new CompilationFailedException("Too many desugar graph consumers.");
            }
            builder.setDesugarGraphConsumer(new DesugarGraphConsumer(){

                private String formatOrigin(Origin origin) {
                    String path = origin.toString();
                    if (fileTmpPrefix != null && path.startsWith(fileTmpPrefix)) {
                        return path.substring(fileTmpPrefix.length());
                    }
                    return path;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void accept(Origin dependent, Origin dependency) {
                    String dependentPath = this.formatOrigin(dependent);
                    String dependencyPath = this.formatOrigin(dependency);
                    PrintWriter printWriter = desugarDependenciesPrintWriter;
                    synchronized (printWriter) {
                        desugarDependenciesPrintWriter.println(dependentPath + " -> " + dependencyPath);
                    }
                }

                public void finished() {
                    desugarDependenciesPrintWriter.close();
                }
            });
        }
        D8.run((D8Command)((D8Command)builder.build()));
    }

    private static class CommandLineOrigin
    extends Origin {
        private CommandLineOrigin() {
            super(CommandLineOrigin.root());
        }

        public String part() {
            return "Command line";
        }
    }
}

