// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml and gl_angle_ext.xml.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// capture_gles_3_0_autogen.cpp:
//   Capture functions for the OpenGL ES 3.0 entry points.

#include "libANGLE/capture/capture_gles_3_0_autogen.h"

#include "common/gl_enum_utils.h"
#include "libANGLE/Context.h"
#include "libANGLE/capture/FrameCapture.h"
#include "libANGLE/validationES3.h"

using namespace angle;

namespace gl
{
CallCapture CaptureBeginQuery(const State &glState,
                              bool isCallValid,
                              QueryType targetPacked,
                              QueryID idPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TQueryType, targetPacked);
    paramBuffer.addValueParam("idPacked", ParamType::TQueryID, idPacked);

    return CallCapture(angle::EntryPoint::GLBeginQuery, std::move(paramBuffer));
}

CallCapture CaptureBeginTransformFeedback(const State &glState,
                                          bool isCallValid,
                                          PrimitiveMode primitiveModePacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("primitiveModePacked", ParamType::TPrimitiveMode,
                              primitiveModePacked);

    return CallCapture(angle::EntryPoint::GLBeginTransformFeedback, std::move(paramBuffer));
}

CallCapture CaptureBindBufferBase(const State &glState,
                                  bool isCallValid,
                                  BufferBinding targetPacked,
                                  GLuint index,
                                  BufferID bufferPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);

    return CallCapture(angle::EntryPoint::GLBindBufferBase, std::move(paramBuffer));
}

CallCapture CaptureBindBufferRange(const State &glState,
                                   bool isCallValid,
                                   BufferBinding targetPacked,
                                   GLuint index,
                                   BufferID bufferPacked,
                                   GLintptr offset,
                                   GLsizeiptr size)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("bufferPacked", ParamType::TBufferID, bufferPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);
    paramBuffer.addValueParam("size", ParamType::TGLsizeiptr, size);

    return CallCapture(angle::EntryPoint::GLBindBufferRange, std::move(paramBuffer));
}

CallCapture CaptureBindSampler(const State &glState,
                               bool isCallValid,
                               GLuint unit,
                               SamplerID samplerPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("unit", ParamType::TGLuint, unit);
    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);

    return CallCapture(angle::EntryPoint::GLBindSampler, std::move(paramBuffer));
}

CallCapture CaptureBindTransformFeedback(const State &glState,
                                         bool isCallValid,
                                         GLenum target,
                                         TransformFeedbackID idPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::BindTransformFeedbackTarget, ParamType::TGLenum,
                             target);
    paramBuffer.addValueParam("idPacked", ParamType::TTransformFeedbackID, idPacked);

    return CallCapture(angle::EntryPoint::GLBindTransformFeedback, std::move(paramBuffer));
}

CallCapture CaptureBindVertexArray(const State &glState,
                                   bool isCallValid,
                                   VertexArrayID arrayPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("arrayPacked", ParamType::TVertexArrayID, arrayPacked);

    return CallCapture(angle::EntryPoint::GLBindVertexArray, std::move(paramBuffer));
}

CallCapture CaptureBlitFramebuffer(const State &glState,
                                   bool isCallValid,
                                   GLint srcX0,
                                   GLint srcY0,
                                   GLint srcX1,
                                   GLint srcY1,
                                   GLint dstX0,
                                   GLint dstY0,
                                   GLint dstX1,
                                   GLint dstY1,
                                   GLbitfield mask,
                                   GLenum filter)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("srcX0", ParamType::TGLint, srcX0);
    paramBuffer.addValueParam("srcY0", ParamType::TGLint, srcY0);
    paramBuffer.addValueParam("srcX1", ParamType::TGLint, srcX1);
    paramBuffer.addValueParam("srcY1", ParamType::TGLint, srcY1);
    paramBuffer.addValueParam("dstX0", ParamType::TGLint, dstX0);
    paramBuffer.addValueParam("dstY0", ParamType::TGLint, dstY0);
    paramBuffer.addValueParam("dstX1", ParamType::TGLint, dstX1);
    paramBuffer.addValueParam("dstY1", ParamType::TGLint, dstY1);
    paramBuffer.addEnumParam("mask", GLESEnum::ClearBufferMask, ParamType::TGLbitfield, mask);
    paramBuffer.addEnumParam("filter", GLESEnum::BlitFramebufferFilter, ParamType::TGLenum, filter);

    return CallCapture(angle::EntryPoint::GLBlitFramebuffer, std::move(paramBuffer));
}

CallCapture CaptureClearBufferfi(const State &glState,
                                 bool isCallValid,
                                 GLenum buffer,
                                 GLint drawbuffer,
                                 GLfloat depth,
                                 GLint stencil)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("buffer", GLESEnum::Buffer, ParamType::TGLenum, buffer);
    paramBuffer.addValueParam("drawbuffer", ParamType::TGLint, drawbuffer);
    paramBuffer.addValueParam("depth", ParamType::TGLfloat, depth);
    paramBuffer.addValueParam("stencil", ParamType::TGLint, stencil);

    return CallCapture(angle::EntryPoint::GLClearBufferfi, std::move(paramBuffer));
}

CallCapture CaptureClearBufferfv(const State &glState,
                                 bool isCallValid,
                                 GLenum buffer,
                                 GLint drawbuffer,
                                 const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("buffer", GLESEnum::Buffer, ParamType::TGLenum, buffer);
    paramBuffer.addValueParam("drawbuffer", ParamType::TGLint, drawbuffer);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
        CaptureClearBufferfv_value(glState, buffer, drawbuffer, value, &valueParam);
    }
    else
    {
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valueParam.value);
    }
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(angle::EntryPoint::GLClearBufferfv, std::move(paramBuffer));
}

CallCapture CaptureClearBufferiv(const State &glState,
                                 bool isCallValid,
                                 GLenum buffer,
                                 GLint drawbuffer,
                                 const GLint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("buffer", GLESEnum::Buffer, ParamType::TGLenum, buffer);
    paramBuffer.addValueParam("drawbuffer", ParamType::TGLint, drawbuffer);

    ParamCapture valueParam("value", ParamType::TGLintConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLintConstPointer, value, &valueParam.value);
        CaptureClearBufferiv_value(glState, buffer, drawbuffer, value, &valueParam);
    }
    else
    {
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &valueParam.value);
    }
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(angle::EntryPoint::GLClearBufferiv, std::move(paramBuffer));
}

CallCapture CaptureClearBufferuiv(const State &glState,
                                  bool isCallValid,
                                  GLenum buffer,
                                  GLint drawbuffer,
                                  const GLuint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("buffer", GLESEnum::Buffer, ParamType::TGLenum, buffer);
    paramBuffer.addValueParam("drawbuffer", ParamType::TGLint, drawbuffer);

    ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLuintConstPointer, value, &valueParam.value);
        CaptureClearBufferuiv_value(glState, buffer, drawbuffer, value, &valueParam);
    }
    else
    {
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &valueParam.value);
    }
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(angle::EntryPoint::GLClearBufferuiv, std::move(paramBuffer));
}

CallCapture CaptureClientWaitSync(const State &glState,
                                  bool isCallValid,
                                  SyncID syncPacked,
                                  GLbitfield flags,
                                  GLuint64 timeout,
                                  GLenum returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("syncPacked", ParamType::TSyncID, syncPacked);
    paramBuffer.addEnumParam("flags", GLESEnum::SyncObjectMask, ParamType::TGLbitfield, flags);
    paramBuffer.addValueParam("timeout", ParamType::TGLuint64, timeout);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLenum);
    InitParamValue(ParamType::TGLenum, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLClientWaitSync, std::move(paramBuffer));
}

CallCapture CaptureCompressedTexImage3D(const State &glState,
                                        bool isCallValid,
                                        TextureTarget targetPacked,
                                        GLint level,
                                        GLenum internalformat,
                                        GLsizei width,
                                        GLsizei height,
                                        GLsizei depth,
                                        GLint border,
                                        GLsizei imageSize,
                                        const void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addEnumParam("internalformat", GLESEnum::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);
    paramBuffer.addValueParam("imageSize", ParamType::TGLsizei, imageSize);

    ParamCapture dataParam("data", ParamType::TvoidConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
        CaptureCompressedTexImage3D_data(glState, targetPacked, level, internalformat, width,
                                         height, depth, border, imageSize, data, &dataParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &dataParam.value);
    }
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture(angle::EntryPoint::GLCompressedTexImage3D, std::move(paramBuffer));
}

CallCapture CaptureCompressedTexSubImage3D(const State &glState,
                                           bool isCallValid,
                                           TextureTarget targetPacked,
                                           GLint level,
                                           GLint xoffset,
                                           GLint yoffset,
                                           GLint zoffset,
                                           GLsizei width,
                                           GLsizei height,
                                           GLsizei depth,
                                           GLenum format,
                                           GLsizei imageSize,
                                           const void *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addEnumParam("format", GLESEnum::InternalFormat, ParamType::TGLenum, format);
    paramBuffer.addValueParam("imageSize", ParamType::TGLsizei, imageSize);

    ParamCapture dataParam("data", ParamType::TvoidConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidConstPointer, data, &dataParam.value);
        CaptureCompressedTexSubImage3D_data(glState, targetPacked, level, xoffset, yoffset, zoffset,
                                            width, height, depth, format, imageSize, data,
                                            &dataParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &dataParam.value);
    }
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture(angle::EntryPoint::GLCompressedTexSubImage3D, std::move(paramBuffer));
}

CallCapture CaptureCopyBufferSubData(const State &glState,
                                     bool isCallValid,
                                     BufferBinding readTargetPacked,
                                     BufferBinding writeTargetPacked,
                                     GLintptr readOffset,
                                     GLintptr writeOffset,
                                     GLsizeiptr size)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("readTargetPacked", ParamType::TBufferBinding, readTargetPacked);
    paramBuffer.addValueParam("writeTargetPacked", ParamType::TBufferBinding, writeTargetPacked);
    paramBuffer.addValueParam("readOffset", ParamType::TGLintptr, readOffset);
    paramBuffer.addValueParam("writeOffset", ParamType::TGLintptr, writeOffset);
    paramBuffer.addValueParam("size", ParamType::TGLsizeiptr, size);

    return CallCapture(angle::EntryPoint::GLCopyBufferSubData, std::move(paramBuffer));
}

CallCapture CaptureCopyTexSubImage3D(const State &glState,
                                     bool isCallValid,
                                     TextureTarget targetPacked,
                                     GLint level,
                                     GLint xoffset,
                                     GLint yoffset,
                                     GLint zoffset,
                                     GLint x,
                                     GLint y,
                                     GLsizei width,
                                     GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);
    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture(angle::EntryPoint::GLCopyTexSubImage3D, std::move(paramBuffer));
}

CallCapture CaptureDeleteQueries(const State &glState,
                                 bool isCallValid,
                                 GLsizei n,
                                 const QueryID *idsPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture idsPackedParam("idsPacked", ParamType::TQueryIDConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TQueryIDConstPointer, idsPacked, &idsPackedParam.value);
        CaptureDeleteQueries_idsPacked(glState, n, idsPacked, &idsPackedParam);
    }
    else
    {
        InitParamValue(ParamType::TQueryIDConstPointer, static_cast<const QueryID *>(nullptr),
                       &idsPackedParam.value);
    }
    paramBuffer.addParam(std::move(idsPackedParam));

    return CallCapture(angle::EntryPoint::GLDeleteQueries, std::move(paramBuffer));
}

CallCapture CaptureDeleteSamplers(const State &glState,
                                  bool isCallValid,
                                  GLsizei count,
                                  const SamplerID *samplersPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture samplersPackedParam("samplersPacked", ParamType::TSamplerIDConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TSamplerIDConstPointer, samplersPacked,
                       &samplersPackedParam.value);
        CaptureDeleteSamplers_samplersPacked(glState, count, samplersPacked, &samplersPackedParam);
    }
    else
    {
        InitParamValue(ParamType::TSamplerIDConstPointer, static_cast<const SamplerID *>(nullptr),
                       &samplersPackedParam.value);
    }
    paramBuffer.addParam(std::move(samplersPackedParam));

    return CallCapture(angle::EntryPoint::GLDeleteSamplers, std::move(paramBuffer));
}

CallCapture CaptureDeleteSync(const State &glState, bool isCallValid, SyncID syncPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("syncPacked", ParamType::TSyncID, syncPacked);

    return CallCapture(angle::EntryPoint::GLDeleteSync, std::move(paramBuffer));
}

CallCapture CaptureDeleteTransformFeedbacks(const State &glState,
                                            bool isCallValid,
                                            GLsizei n,
                                            const TransformFeedbackID *idsPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture idsPackedParam("idsPacked", ParamType::TTransformFeedbackIDConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TTransformFeedbackIDConstPointer, idsPacked,
                       &idsPackedParam.value);
        CaptureDeleteTransformFeedbacks_idsPacked(glState, n, idsPacked, &idsPackedParam);
    }
    else
    {
        InitParamValue(ParamType::TTransformFeedbackIDConstPointer,
                       static_cast<const TransformFeedbackID *>(nullptr), &idsPackedParam.value);
    }
    paramBuffer.addParam(std::move(idsPackedParam));

    return CallCapture(angle::EntryPoint::GLDeleteTransformFeedbacks, std::move(paramBuffer));
}

CallCapture CaptureDeleteVertexArrays(const State &glState,
                                      bool isCallValid,
                                      GLsizei n,
                                      const VertexArrayID *arraysPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture arraysPackedParam("arraysPacked", ParamType::TVertexArrayIDConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TVertexArrayIDConstPointer, arraysPacked,
                       &arraysPackedParam.value);
        CaptureDeleteVertexArrays_arraysPacked(glState, n, arraysPacked, &arraysPackedParam);
    }
    else
    {
        InitParamValue(ParamType::TVertexArrayIDConstPointer,
                       static_cast<const VertexArrayID *>(nullptr), &arraysPackedParam.value);
    }
    paramBuffer.addParam(std::move(arraysPackedParam));

    return CallCapture(angle::EntryPoint::GLDeleteVertexArrays, std::move(paramBuffer));
}

CallCapture CaptureDrawArraysInstanced(const State &glState,
                                       bool isCallValid,
                                       PrimitiveMode modePacked,
                                       GLint first,
                                       GLsizei count,
                                       GLsizei instancecount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("first", ParamType::TGLint, first);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("instancecount", ParamType::TGLsizei, instancecount);

    return CallCapture(angle::EntryPoint::GLDrawArraysInstanced, std::move(paramBuffer));
}

CallCapture CaptureDrawBuffers(const State &glState,
                               bool isCallValid,
                               GLsizei n,
                               const GLenum *bufs)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture bufsParam("bufs", ParamType::TGLenumConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLenumConstPointer, bufs, &bufsParam.value);
        CaptureDrawBuffers_bufs(glState, n, bufs, &bufsParam);
    }
    else
    {
        InitParamValue(ParamType::TGLenumConstPointer, static_cast<const GLenum *>(nullptr),
                       &bufsParam.value);
    }
    paramBuffer.addParam(std::move(bufsParam));

    return CallCapture(angle::EntryPoint::GLDrawBuffers, std::move(paramBuffer));
}

CallCapture CaptureDrawElementsInstanced(const State &glState,
                                         bool isCallValid,
                                         PrimitiveMode modePacked,
                                         GLsizei count,
                                         DrawElementsType typePacked,
                                         const void *indices,
                                         GLsizei instancecount)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidConstPointer, indices, &indicesParam.value);
        CaptureDrawElementsInstanced_indices(glState, modePacked, count, typePacked, indices,
                                             instancecount, &indicesParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &indicesParam.value);
    }
    paramBuffer.addParam(std::move(indicesParam));

    paramBuffer.addValueParam("instancecount", ParamType::TGLsizei, instancecount);

    return CallCapture(angle::EntryPoint::GLDrawElementsInstanced, std::move(paramBuffer));
}

CallCapture CaptureDrawRangeElements(const State &glState,
                                     bool isCallValid,
                                     PrimitiveMode modePacked,
                                     GLuint start,
                                     GLuint end,
                                     GLsizei count,
                                     DrawElementsType typePacked,
                                     const void *indices)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("modePacked", ParamType::TPrimitiveMode, modePacked);
    paramBuffer.addValueParam("start", ParamType::TGLuint, start);
    paramBuffer.addValueParam("end", ParamType::TGLuint, end);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("typePacked", ParamType::TDrawElementsType, typePacked);

    ParamCapture indicesParam("indices", ParamType::TvoidConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidConstPointer, indices, &indicesParam.value);
        CaptureDrawRangeElements_indices(glState, modePacked, start, end, count, typePacked,
                                         indices, &indicesParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &indicesParam.value);
    }
    paramBuffer.addParam(std::move(indicesParam));

    return CallCapture(angle::EntryPoint::GLDrawRangeElements, std::move(paramBuffer));
}

CallCapture CaptureEndQuery(const State &glState, bool isCallValid, QueryType targetPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TQueryType, targetPacked);

    return CallCapture(angle::EntryPoint::GLEndQuery, std::move(paramBuffer));
}

CallCapture CaptureEndTransformFeedback(const State &glState, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture(angle::EntryPoint::GLEndTransformFeedback, std::move(paramBuffer));
}

CallCapture CaptureFenceSync(const State &glState,
                             bool isCallValid,
                             GLenum condition,
                             GLbitfield flags,
                             GLsync returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("condition", GLESEnum::SyncCondition, ParamType::TGLenum, condition);
    paramBuffer.addEnumParam("flags", GLESEnum::SyncBehaviorFlags, ParamType::TGLbitfield, flags);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLsync);
    InitParamValue(ParamType::TGLsync, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLFenceSync, std::move(paramBuffer));
}

CallCapture CaptureFlushMappedBufferRange(const State &glState,
                                          bool isCallValid,
                                          BufferBinding targetPacked,
                                          GLintptr offset,
                                          GLsizeiptr length)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);
    paramBuffer.addValueParam("length", ParamType::TGLsizeiptr, length);

    return CallCapture(angle::EntryPoint::GLFlushMappedBufferRange, std::move(paramBuffer));
}

CallCapture CaptureFramebufferTextureLayer(const State &glState,
                                           bool isCallValid,
                                           GLenum target,
                                           GLenum attachment,
                                           TextureID texturePacked,
                                           GLint level,
                                           GLint layer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("attachment", GLESEnum::FramebufferAttachment, ParamType::TGLenum,
                             attachment);
    paramBuffer.addValueParam("texturePacked", ParamType::TTextureID, texturePacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("layer", ParamType::TGLint, layer);

    return CallCapture(angle::EntryPoint::GLFramebufferTextureLayer, std::move(paramBuffer));
}

CallCapture CaptureGenQueries(const State &glState, bool isCallValid, GLsizei n, QueryID *idsPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture idsPackedParam("idsPacked", ParamType::TQueryIDPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TQueryIDPointer, idsPacked, &idsPackedParam.value);
        CaptureGenQueries_idsPacked(glState, n, idsPacked, &idsPackedParam);
    }
    else
    {
        InitParamValue(ParamType::TQueryIDPointer, static_cast<QueryID *>(nullptr),
                       &idsPackedParam.value);
    }
    paramBuffer.addParam(std::move(idsPackedParam));

    return CallCapture(angle::EntryPoint::GLGenQueries, std::move(paramBuffer));
}

CallCapture CaptureGenSamplers(const State &glState,
                               bool isCallValid,
                               GLsizei count,
                               SamplerID *samplersPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture samplersPackedParam("samplersPacked", ParamType::TSamplerIDPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TSamplerIDPointer, samplersPacked, &samplersPackedParam.value);
        CaptureGenSamplers_samplersPacked(glState, count, samplersPacked, &samplersPackedParam);
    }
    else
    {
        InitParamValue(ParamType::TSamplerIDPointer, static_cast<SamplerID *>(nullptr),
                       &samplersPackedParam.value);
    }
    paramBuffer.addParam(std::move(samplersPackedParam));

    return CallCapture(angle::EntryPoint::GLGenSamplers, std::move(paramBuffer));
}

CallCapture CaptureGenTransformFeedbacks(const State &glState,
                                         bool isCallValid,
                                         GLsizei n,
                                         TransformFeedbackID *idsPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture idsPackedParam("idsPacked", ParamType::TTransformFeedbackIDPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TTransformFeedbackIDPointer, idsPacked, &idsPackedParam.value);
        CaptureGenTransformFeedbacks_idsPacked(glState, n, idsPacked, &idsPackedParam);
    }
    else
    {
        InitParamValue(ParamType::TTransformFeedbackIDPointer,
                       static_cast<TransformFeedbackID *>(nullptr), &idsPackedParam.value);
    }
    paramBuffer.addParam(std::move(idsPackedParam));

    return CallCapture(angle::EntryPoint::GLGenTransformFeedbacks, std::move(paramBuffer));
}

CallCapture CaptureGenVertexArrays(const State &glState,
                                   bool isCallValid,
                                   GLsizei n,
                                   VertexArrayID *arraysPacked)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("n", ParamType::TGLsizei, n);

    ParamCapture arraysPackedParam("arraysPacked", ParamType::TVertexArrayIDPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TVertexArrayIDPointer, arraysPacked, &arraysPackedParam.value);
        CaptureGenVertexArrays_arraysPacked(glState, n, arraysPacked, &arraysPackedParam);
    }
    else
    {
        InitParamValue(ParamType::TVertexArrayIDPointer, static_cast<VertexArrayID *>(nullptr),
                       &arraysPackedParam.value);
    }
    paramBuffer.addParam(std::move(arraysPackedParam));

    return CallCapture(angle::EntryPoint::GLGenVertexArrays, std::move(paramBuffer));
}

CallCapture CaptureGetActiveUniformBlockName(const State &glState,
                                             bool isCallValid,
                                             ShaderProgramID programPacked,
                                             UniformBlockIndex uniformBlockIndexPacked,
                                             GLsizei bufSize,
                                             GLsizei *length,
                                             GLchar *uniformBlockName)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("uniformBlockIndexPacked", ParamType::TUniformBlockIndex,
                              uniformBlockIndexPacked);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetActiveUniformBlockName_length(glState, programPacked, uniformBlockIndexPacked,
                                                bufSize, length, uniformBlockName, &lengthParam);
    }
    else
    {
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
    }
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture uniformBlockNameParam("uniformBlockName", ParamType::TGLcharPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLcharPointer, uniformBlockName, &uniformBlockNameParam.value);
        CaptureGetActiveUniformBlockName_uniformBlockName(glState, programPacked,
                                                          uniformBlockIndexPacked, bufSize, length,
                                                          uniformBlockName, &uniformBlockNameParam);
    }
    else
    {
        InitParamValue(ParamType::TGLcharPointer, static_cast<GLchar *>(nullptr),
                       &uniformBlockNameParam.value);
    }
    paramBuffer.addParam(std::move(uniformBlockNameParam));

    return CallCapture(angle::EntryPoint::GLGetActiveUniformBlockName, std::move(paramBuffer));
}

CallCapture CaptureGetActiveUniformBlockiv(const State &glState,
                                           bool isCallValid,
                                           ShaderProgramID programPacked,
                                           UniformBlockIndex uniformBlockIndexPacked,
                                           GLenum pname,
                                           GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("uniformBlockIndexPacked", ParamType::TUniformBlockIndex,
                              uniformBlockIndexPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::UniformBlockPName, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetActiveUniformBlockiv_params(glState, programPacked, uniformBlockIndexPacked,
                                              pname, params, &paramsParam);
    }
    else
    {
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
    }
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(angle::EntryPoint::GLGetActiveUniformBlockiv, std::move(paramBuffer));
}

CallCapture CaptureGetActiveUniformsiv(const State &glState,
                                       bool isCallValid,
                                       ShaderProgramID programPacked,
                                       GLsizei uniformCount,
                                       const GLuint *uniformIndices,
                                       GLenum pname,
                                       GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("uniformCount", ParamType::TGLsizei, uniformCount);

    ParamCapture uniformIndicesParam("uniformIndices", ParamType::TGLuintConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLuintConstPointer, uniformIndices, &uniformIndicesParam.value);
        CaptureGetActiveUniformsiv_uniformIndices(glState, programPacked, uniformCount,
                                                  uniformIndices, pname, params,
                                                  &uniformIndicesParam);
    }
    else
    {
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &uniformIndicesParam.value);
    }
    paramBuffer.addParam(std::move(uniformIndicesParam));

    paramBuffer.addEnumParam("pname", GLESEnum::UniformPName, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetActiveUniformsiv_params(glState, programPacked, uniformCount, uniformIndices,
                                          pname, params, &paramsParam);
    }
    else
    {
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
    }
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(angle::EntryPoint::GLGetActiveUniformsiv, std::move(paramBuffer));
}

CallCapture CaptureGetBufferParameteri64v(const State &glState,
                                          bool isCallValid,
                                          BufferBinding targetPacked,
                                          GLenum pname,
                                          GLint64 *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLint64Pointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLint64Pointer, params, &paramsParam.value);
        CaptureGetBufferParameteri64v_params(glState, targetPacked, pname, params, &paramsParam);
    }
    else
    {
        InitParamValue(ParamType::TGLint64Pointer, static_cast<GLint64 *>(nullptr),
                       &paramsParam.value);
    }
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(angle::EntryPoint::GLGetBufferParameteri64v, std::move(paramBuffer));
}

CallCapture CaptureGetBufferPointerv(const State &glState,
                                     bool isCallValid,
                                     BufferBinding targetPacked,
                                     GLenum pname,
                                     void **params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::AllEnums, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TvoidPointerPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointerPointer, params, &paramsParam.value);
        CaptureGetBufferPointerv_params(glState, targetPacked, pname, params, &paramsParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointerPointer, static_cast<void **>(nullptr),
                       &paramsParam.value);
    }
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(angle::EntryPoint::GLGetBufferPointerv, std::move(paramBuffer));
}

CallCapture CaptureGetFragDataLocation(const State &glState,
                                       bool isCallValid,
                                       ShaderProgramID programPacked,
                                       const GLchar *name,
                                       GLint returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);

    ParamCapture nameParam("name", ParamType::TGLcharConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLcharConstPointer, name, &nameParam.value);
        CaptureGetFragDataLocation_name(glState, programPacked, name, &nameParam);
    }
    else
    {
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &nameParam.value);
    }
    paramBuffer.addParam(std::move(nameParam));

    ParamCapture returnValueCapture("returnValue", ParamType::TGLint);
    InitParamValue(ParamType::TGLint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLGetFragDataLocation, std::move(paramBuffer));
}

CallCapture CaptureGetInteger64i_v(const State &glState,
                                   bool isCallValid,
                                   GLenum target,
                                   GLuint index,
                                   GLint64 *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::GetPName, ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    ParamCapture dataParam("data", ParamType::TGLint64Pointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLint64Pointer, data, &dataParam.value);
        CaptureGetInteger64i_v_data(glState, target, index, data, &dataParam);
    }
    else
    {
        InitParamValue(ParamType::TGLint64Pointer, static_cast<GLint64 *>(nullptr),
                       &dataParam.value);
    }
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture(angle::EntryPoint::GLGetInteger64i_v, std::move(paramBuffer));
}

CallCapture CaptureGetInteger64v(const State &glState,
                                 bool isCallValid,
                                 GLenum pname,
                                 GLint64 *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("pname", GLESEnum::GetPName, ParamType::TGLenum, pname);

    ParamCapture dataParam("data", ParamType::TGLint64Pointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLint64Pointer, data, &dataParam.value);
        CaptureGetInteger64v_data(glState, pname, data, &dataParam);
    }
    else
    {
        InitParamValue(ParamType::TGLint64Pointer, static_cast<GLint64 *>(nullptr),
                       &dataParam.value);
    }
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture(angle::EntryPoint::GLGetInteger64v, std::move(paramBuffer));
}

CallCapture CaptureGetIntegeri_v(const State &glState,
                                 bool isCallValid,
                                 GLenum target,
                                 GLuint index,
                                 GLint *data)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::GetPName, ParamType::TGLenum, target);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    ParamCapture dataParam("data", ParamType::TGLintPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLintPointer, data, &dataParam.value);
        CaptureGetIntegeri_v_data(glState, target, index, data, &dataParam);
    }
    else
    {
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &dataParam.value);
    }
    paramBuffer.addParam(std::move(dataParam));

    return CallCapture(angle::EntryPoint::GLGetIntegeri_v, std::move(paramBuffer));
}

CallCapture CaptureGetInternalformativ(const State &glState,
                                       bool isCallValid,
                                       GLenum target,
                                       GLenum internalformat,
                                       GLenum pname,
                                       GLsizei count,
                                       GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::TextureTarget, ParamType::TGLenum, target);
    paramBuffer.addEnumParam("internalformat", GLESEnum::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addEnumParam("pname", GLESEnum::InternalFormatPName, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetInternalformativ_params(glState, target, internalformat, pname, count, params,
                                          &paramsParam);
    }
    else
    {
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
    }
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(angle::EntryPoint::GLGetInternalformativ, std::move(paramBuffer));
}

CallCapture CaptureGetProgramBinary(const State &glState,
                                    bool isCallValid,
                                    ShaderProgramID programPacked,
                                    GLsizei bufSize,
                                    GLsizei *length,
                                    GLenum *binaryFormat,
                                    void *binary)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetProgramBinary_length(glState, programPacked, bufSize, length, binaryFormat,
                                       binary, &lengthParam);
    }
    else
    {
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
    }
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture binaryFormatParam("binaryFormat", ParamType::TGLenumPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLenumPointer, binaryFormat, &binaryFormatParam.value);
        CaptureGetProgramBinary_binaryFormat(glState, programPacked, bufSize, length, binaryFormat,
                                             binary, &binaryFormatParam);
    }
    else
    {
        InitParamValue(ParamType::TGLenumPointer, static_cast<GLenum *>(nullptr),
                       &binaryFormatParam.value);
    }
    paramBuffer.addParam(std::move(binaryFormatParam));

    ParamCapture binaryParam("binary", ParamType::TvoidPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidPointer, binary, &binaryParam.value);
        CaptureGetProgramBinary_binary(glState, programPacked, bufSize, length, binaryFormat,
                                       binary, &binaryParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidPointer, static_cast<void *>(nullptr), &binaryParam.value);
    }
    paramBuffer.addParam(std::move(binaryParam));

    return CallCapture(angle::EntryPoint::GLGetProgramBinary, std::move(paramBuffer));
}

CallCapture CaptureGetQueryObjectuiv(const State &glState,
                                     bool isCallValid,
                                     QueryID idPacked,
                                     GLenum pname,
                                     GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("idPacked", ParamType::TQueryID, idPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::QueryObjectParameterName, ParamType::TGLenum,
                             pname);

    ParamCapture paramsParam("params", ParamType::TGLuintPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
        CaptureGetQueryObjectuiv_params(glState, idPacked, pname, params, &paramsParam);
    }
    else
    {
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &paramsParam.value);
    }
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(angle::EntryPoint::GLGetQueryObjectuiv, std::move(paramBuffer));
}

CallCapture CaptureGetQueryiv(const State &glState,
                              bool isCallValid,
                              QueryType targetPacked,
                              GLenum pname,
                              GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TQueryType, targetPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::QueryParameterName, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetQueryiv_params(glState, targetPacked, pname, params, &paramsParam);
    }
    else
    {
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
    }
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(angle::EntryPoint::GLGetQueryiv, std::move(paramBuffer));
}

CallCapture CaptureGetSamplerParameterfv(const State &glState,
                                         bool isCallValid,
                                         SamplerID samplerPacked,
                                         GLenum pname,
                                         GLfloat *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::SamplerParameterF, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLfloatPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLfloatPointer, params, &paramsParam.value);
        CaptureGetSamplerParameterfv_params(glState, samplerPacked, pname, params, &paramsParam);
    }
    else
    {
        InitParamValue(ParamType::TGLfloatPointer, static_cast<GLfloat *>(nullptr),
                       &paramsParam.value);
    }
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(angle::EntryPoint::GLGetSamplerParameterfv, std::move(paramBuffer));
}

CallCapture CaptureGetSamplerParameteriv(const State &glState,
                                         bool isCallValid,
                                         SamplerID samplerPacked,
                                         GLenum pname,
                                         GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::SamplerParameterI, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetSamplerParameteriv_params(glState, samplerPacked, pname, params, &paramsParam);
    }
    else
    {
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
    }
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(angle::EntryPoint::GLGetSamplerParameteriv, std::move(paramBuffer));
}

CallCapture CaptureGetStringi(const State &glState,
                              bool isCallValid,
                              GLenum name,
                              GLuint index,
                              const GLubyte *returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("name", GLESEnum::StringName, ParamType::TGLenum, name);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLubyteConstPointer);
    InitParamValue(ParamType::TGLubyteConstPointer, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLGetStringi, std::move(paramBuffer));
}

CallCapture CaptureGetSynciv(const State &glState,
                             bool isCallValid,
                             SyncID syncPacked,
                             GLenum pname,
                             GLsizei count,
                             GLsizei *length,
                             GLint *values)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("syncPacked", ParamType::TSyncID, syncPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::SyncParameterName, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetSynciv_length(glState, syncPacked, pname, count, length, values, &lengthParam);
    }
    else
    {
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
    }
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture valuesParam("values", ParamType::TGLintPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLintPointer, values, &valuesParam.value);
        CaptureGetSynciv_values(glState, syncPacked, pname, count, length, values, &valuesParam);
    }
    else
    {
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &valuesParam.value);
    }
    paramBuffer.addParam(std::move(valuesParam));

    return CallCapture(angle::EntryPoint::GLGetSynciv, std::move(paramBuffer));
}

CallCapture CaptureGetTransformFeedbackVarying(const State &glState,
                                               bool isCallValid,
                                               ShaderProgramID programPacked,
                                               GLuint index,
                                               GLsizei bufSize,
                                               GLsizei *length,
                                               GLsizei *size,
                                               GLenum *type,
                                               GLchar *name)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("bufSize", ParamType::TGLsizei, bufSize);

    ParamCapture lengthParam("length", ParamType::TGLsizeiPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLsizeiPointer, length, &lengthParam.value);
        CaptureGetTransformFeedbackVarying_length(glState, programPacked, index, bufSize, length,
                                                  size, type, name, &lengthParam);
    }
    else
    {
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &lengthParam.value);
    }
    paramBuffer.addParam(std::move(lengthParam));

    ParamCapture sizeParam("size", ParamType::TGLsizeiPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLsizeiPointer, size, &sizeParam.value);
        CaptureGetTransformFeedbackVarying_size(glState, programPacked, index, bufSize, length,
                                                size, type, name, &sizeParam);
    }
    else
    {
        InitParamValue(ParamType::TGLsizeiPointer, static_cast<GLsizei *>(nullptr),
                       &sizeParam.value);
    }
    paramBuffer.addParam(std::move(sizeParam));

    ParamCapture typeParam("type", ParamType::TGLenumPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLenumPointer, type, &typeParam.value);
        CaptureGetTransformFeedbackVarying_type(glState, programPacked, index, bufSize, length,
                                                size, type, name, &typeParam);
    }
    else
    {
        InitParamValue(ParamType::TGLenumPointer, static_cast<GLenum *>(nullptr), &typeParam.value);
    }
    paramBuffer.addParam(std::move(typeParam));

    ParamCapture nameParam("name", ParamType::TGLcharPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLcharPointer, name, &nameParam.value);
        CaptureGetTransformFeedbackVarying_name(glState, programPacked, index, bufSize, length,
                                                size, type, name, &nameParam);
    }
    else
    {
        InitParamValue(ParamType::TGLcharPointer, static_cast<GLchar *>(nullptr), &nameParam.value);
    }
    paramBuffer.addParam(std::move(nameParam));

    return CallCapture(angle::EntryPoint::GLGetTransformFeedbackVarying, std::move(paramBuffer));
}

CallCapture CaptureGetUniformBlockIndex(const State &glState,
                                        bool isCallValid,
                                        ShaderProgramID programPacked,
                                        const GLchar *uniformBlockName,
                                        GLuint returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);

    ParamCapture uniformBlockNameParam("uniformBlockName", ParamType::TGLcharConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLcharConstPointer, uniformBlockName,
                       &uniformBlockNameParam.value);
        CaptureGetUniformBlockIndex_uniformBlockName(glState, programPacked, uniformBlockName,
                                                     &uniformBlockNameParam);
    }
    else
    {
        InitParamValue(ParamType::TGLcharConstPointer, static_cast<const GLchar *>(nullptr),
                       &uniformBlockNameParam.value);
    }
    paramBuffer.addParam(std::move(uniformBlockNameParam));

    ParamCapture returnValueCapture("returnValue", ParamType::TGLuint);
    InitParamValue(ParamType::TGLuint, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLGetUniformBlockIndex, std::move(paramBuffer));
}

CallCapture CaptureGetUniformIndices(const State &glState,
                                     bool isCallValid,
                                     ShaderProgramID programPacked,
                                     GLsizei uniformCount,
                                     const GLchar *const *uniformNames,
                                     GLuint *uniformIndices)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("uniformCount", ParamType::TGLsizei, uniformCount);

    ParamCapture uniformNamesParam("uniformNames", ParamType::TGLcharConstPointerPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLcharConstPointerPointer, uniformNames,
                       &uniformNamesParam.value);
        CaptureGetUniformIndices_uniformNames(glState, programPacked, uniformCount, uniformNames,
                                              uniformIndices, &uniformNamesParam);
    }
    else
    {
        InitParamValue(ParamType::TGLcharConstPointerPointer,
                       static_cast<const GLchar *const *>(nullptr), &uniformNamesParam.value);
    }
    paramBuffer.addParam(std::move(uniformNamesParam));

    ParamCapture uniformIndicesParam("uniformIndices", ParamType::TGLuintPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLuintPointer, uniformIndices, &uniformIndicesParam.value);
        CaptureGetUniformIndices_uniformIndices(glState, programPacked, uniformCount, uniformNames,
                                                uniformIndices, &uniformIndicesParam);
    }
    else
    {
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &uniformIndicesParam.value);
    }
    paramBuffer.addParam(std::move(uniformIndicesParam));

    return CallCapture(angle::EntryPoint::GLGetUniformIndices, std::move(paramBuffer));
}

CallCapture CaptureGetUniformuiv(const State &glState,
                                 bool isCallValid,
                                 ShaderProgramID programPacked,
                                 UniformLocation locationPacked,
                                 GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);

    ParamCapture paramsParam("params", ParamType::TGLuintPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
        CaptureGetUniformuiv_params(glState, programPacked, locationPacked, params, &paramsParam);
    }
    else
    {
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &paramsParam.value);
    }
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(angle::EntryPoint::GLGetUniformuiv, std::move(paramBuffer));
}

CallCapture CaptureGetVertexAttribIiv(const State &glState,
                                      bool isCallValid,
                                      GLuint index,
                                      GLenum pname,
                                      GLint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addEnumParam("pname", GLESEnum::VertexAttribEnum, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLintPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLintPointer, params, &paramsParam.value);
        CaptureGetVertexAttribIiv_params(glState, index, pname, params, &paramsParam);
    }
    else
    {
        InitParamValue(ParamType::TGLintPointer, static_cast<GLint *>(nullptr), &paramsParam.value);
    }
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(angle::EntryPoint::GLGetVertexAttribIiv, std::move(paramBuffer));
}

CallCapture CaptureGetVertexAttribIuiv(const State &glState,
                                       bool isCallValid,
                                       GLuint index,
                                       GLenum pname,
                                       GLuint *params)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addEnumParam("pname", GLESEnum::VertexAttribEnum, ParamType::TGLenum, pname);

    ParamCapture paramsParam("params", ParamType::TGLuintPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLuintPointer, params, &paramsParam.value);
        CaptureGetVertexAttribIuiv_params(glState, index, pname, params, &paramsParam);
    }
    else
    {
        InitParamValue(ParamType::TGLuintPointer, static_cast<GLuint *>(nullptr),
                       &paramsParam.value);
    }
    paramBuffer.addParam(std::move(paramsParam));

    return CallCapture(angle::EntryPoint::GLGetVertexAttribIuiv, std::move(paramBuffer));
}

CallCapture CaptureInvalidateFramebuffer(const State &glState,
                                         bool isCallValid,
                                         GLenum target,
                                         GLsizei numAttachments,
                                         const GLenum *attachments)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("numAttachments", ParamType::TGLsizei, numAttachments);

    ParamCapture attachmentsParam("attachments", ParamType::TGLenumConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLenumConstPointer, attachments, &attachmentsParam.value);
        CaptureInvalidateFramebuffer_attachments(glState, target, numAttachments, attachments,
                                                 &attachmentsParam);
    }
    else
    {
        InitParamValue(ParamType::TGLenumConstPointer, static_cast<const GLenum *>(nullptr),
                       &attachmentsParam.value);
    }
    paramBuffer.addParam(std::move(attachmentsParam));

    return CallCapture(angle::EntryPoint::GLInvalidateFramebuffer, std::move(paramBuffer));
}

CallCapture CaptureInvalidateSubFramebuffer(const State &glState,
                                            bool isCallValid,
                                            GLenum target,
                                            GLsizei numAttachments,
                                            const GLenum *attachments,
                                            GLint x,
                                            GLint y,
                                            GLsizei width,
                                            GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::FramebufferTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("numAttachments", ParamType::TGLsizei, numAttachments);

    ParamCapture attachmentsParam("attachments", ParamType::TGLenumConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLenumConstPointer, attachments, &attachmentsParam.value);
        CaptureInvalidateSubFramebuffer_attachments(glState, target, numAttachments, attachments, x,
                                                    y, width, height, &attachmentsParam);
    }
    else
    {
        InitParamValue(ParamType::TGLenumConstPointer, static_cast<const GLenum *>(nullptr),
                       &attachmentsParam.value);
    }
    paramBuffer.addParam(std::move(attachmentsParam));

    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture(angle::EntryPoint::GLInvalidateSubFramebuffer, std::move(paramBuffer));
}

CallCapture CaptureIsQuery(const State &glState,
                           bool isCallValid,
                           QueryID idPacked,
                           GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("idPacked", ParamType::TQueryID, idPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLIsQuery, std::move(paramBuffer));
}

CallCapture CaptureIsSampler(const State &glState,
                             bool isCallValid,
                             SamplerID samplerPacked,
                             GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLIsSampler, std::move(paramBuffer));
}

CallCapture CaptureIsSync(const State &glState,
                          bool isCallValid,
                          SyncID syncPacked,
                          GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("syncPacked", ParamType::TSyncID, syncPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLIsSync, std::move(paramBuffer));
}

CallCapture CaptureIsTransformFeedback(const State &glState,
                                       bool isCallValid,
                                       TransformFeedbackID idPacked,
                                       GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("idPacked", ParamType::TTransformFeedbackID, idPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLIsTransformFeedback, std::move(paramBuffer));
}

CallCapture CaptureIsVertexArray(const State &glState,
                                 bool isCallValid,
                                 VertexArrayID arrayPacked,
                                 GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("arrayPacked", ParamType::TVertexArrayID, arrayPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLIsVertexArray, std::move(paramBuffer));
}

CallCapture CaptureMapBufferRange(const State &glState,
                                  bool isCallValid,
                                  BufferBinding targetPacked,
                                  GLintptr offset,
                                  GLsizeiptr length,
                                  GLbitfield access,
                                  void *returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);
    paramBuffer.addValueParam("offset", ParamType::TGLintptr, offset);
    paramBuffer.addValueParam("length", ParamType::TGLsizeiptr, length);
    paramBuffer.addEnumParam("access", GLESEnum::MapBufferAccessMask, ParamType::TGLbitfield,
                             access);

    ParamCapture returnValueCapture("returnValue", ParamType::TvoidPointer);
    InitParamValue(ParamType::TvoidPointer, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLMapBufferRange, std::move(paramBuffer));
}

CallCapture CapturePauseTransformFeedback(const State &glState, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture(angle::EntryPoint::GLPauseTransformFeedback, std::move(paramBuffer));
}

CallCapture CaptureProgramBinary(const State &glState,
                                 bool isCallValid,
                                 ShaderProgramID programPacked,
                                 GLenum binaryFormat,
                                 const void *binary,
                                 GLsizei length)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addEnumParam("binaryFormat", GLESEnum::AllEnums, ParamType::TGLenum, binaryFormat);

    ParamCapture binaryParam("binary", ParamType::TvoidConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidConstPointer, binary, &binaryParam.value);
        CaptureProgramBinary_binary(glState, programPacked, binaryFormat, binary, length,
                                    &binaryParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &binaryParam.value);
    }
    paramBuffer.addParam(std::move(binaryParam));

    paramBuffer.addValueParam("length", ParamType::TGLsizei, length);

    return CallCapture(angle::EntryPoint::GLProgramBinary, std::move(paramBuffer));
}

CallCapture CaptureProgramParameteri(const State &glState,
                                     bool isCallValid,
                                     ShaderProgramID programPacked,
                                     GLenum pname,
                                     GLint value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::ProgramParameterPName, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("value", ParamType::TGLint, value);

    return CallCapture(angle::EntryPoint::GLProgramParameteri, std::move(paramBuffer));
}

CallCapture CaptureReadBuffer(const State &glState, bool isCallValid, GLenum src)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("src", GLESEnum::ReadBufferMode, ParamType::TGLenum, src);

    return CallCapture(angle::EntryPoint::GLReadBuffer, std::move(paramBuffer));
}

CallCapture CaptureRenderbufferStorageMultisample(const State &glState,
                                                  bool isCallValid,
                                                  GLenum target,
                                                  GLsizei samples,
                                                  GLenum internalformat,
                                                  GLsizei width,
                                                  GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addEnumParam("target", GLESEnum::RenderbufferTarget, ParamType::TGLenum, target);
    paramBuffer.addValueParam("samples", ParamType::TGLsizei, samples);
    paramBuffer.addEnumParam("internalformat", GLESEnum::InternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture(angle::EntryPoint::GLRenderbufferStorageMultisample, std::move(paramBuffer));
}

CallCapture CaptureResumeTransformFeedback(const State &glState, bool isCallValid)
{
    ParamBuffer paramBuffer;

    return CallCapture(angle::EntryPoint::GLResumeTransformFeedback, std::move(paramBuffer));
}

CallCapture CaptureSamplerParameterf(const State &glState,
                                     bool isCallValid,
                                     SamplerID samplerPacked,
                                     GLenum pname,
                                     GLfloat param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::SamplerParameterF, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLfloat, param);

    return CallCapture(angle::EntryPoint::GLSamplerParameterf, std::move(paramBuffer));
}

CallCapture CaptureSamplerParameterfv(const State &glState,
                                      bool isCallValid,
                                      SamplerID samplerPacked,
                                      GLenum pname,
                                      const GLfloat *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::SamplerParameterF, ParamType::TGLenum, pname);

    ParamCapture paramParam("param", ParamType::TGLfloatConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLfloatConstPointer, param, &paramParam.value);
        CaptureSamplerParameterfv_param(glState, samplerPacked, pname, param, &paramParam);
    }
    else
    {
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &paramParam.value);
    }
    paramBuffer.addParam(std::move(paramParam));

    return CallCapture(angle::EntryPoint::GLSamplerParameterfv, std::move(paramBuffer));
}

CallCapture CaptureSamplerParameteri(const State &glState,
                                     bool isCallValid,
                                     SamplerID samplerPacked,
                                     GLenum pname,
                                     GLint param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::SamplerParameterI, ParamType::TGLenum, pname);
    paramBuffer.addValueParam("param", ParamType::TGLint, param);

    return CallCapture(angle::EntryPoint::GLSamplerParameteri, std::move(paramBuffer));
}

CallCapture CaptureSamplerParameteriv(const State &glState,
                                      bool isCallValid,
                                      SamplerID samplerPacked,
                                      GLenum pname,
                                      const GLint *param)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("samplerPacked", ParamType::TSamplerID, samplerPacked);
    paramBuffer.addEnumParam("pname", GLESEnum::SamplerParameterI, ParamType::TGLenum, pname);

    ParamCapture paramParam("param", ParamType::TGLintConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLintConstPointer, param, &paramParam.value);
        CaptureSamplerParameteriv_param(glState, samplerPacked, pname, param, &paramParam);
    }
    else
    {
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &paramParam.value);
    }
    paramBuffer.addParam(std::move(paramParam));

    return CallCapture(angle::EntryPoint::GLSamplerParameteriv, std::move(paramBuffer));
}

CallCapture CaptureTexImage3D(const State &glState,
                              bool isCallValid,
                              TextureTarget targetPacked,
                              GLint level,
                              GLint internalformat,
                              GLsizei width,
                              GLsizei height,
                              GLsizei depth,
                              GLint border,
                              GLenum format,
                              GLenum type,
                              const void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("internalformat", ParamType::TGLint, internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addValueParam("border", ParamType::TGLint, border);
    paramBuffer.addEnumParam("format", GLESEnum::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLESEnum::PixelType, ParamType::TGLenum, type);

    ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidConstPointer, pixels, &pixelsParam.value);
        CaptureTexImage3D_pixels(glState, targetPacked, level, internalformat, width, height, depth,
                                 border, format, type, pixels, &pixelsParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &pixelsParam.value);
    }
    paramBuffer.addParam(std::move(pixelsParam));

    return CallCapture(angle::EntryPoint::GLTexImage3D, std::move(paramBuffer));
}

CallCapture CaptureTexStorage2D(const State &glState,
                                bool isCallValid,
                                TextureType targetPacked,
                                GLsizei levels,
                                GLenum internalformat,
                                GLsizei width,
                                GLsizei height)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("levels", ParamType::TGLsizei, levels);
    paramBuffer.addEnumParam("internalformat", GLESEnum::SizedInternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);

    return CallCapture(angle::EntryPoint::GLTexStorage2D, std::move(paramBuffer));
}

CallCapture CaptureTexStorage3D(const State &glState,
                                bool isCallValid,
                                TextureType targetPacked,
                                GLsizei levels,
                                GLenum internalformat,
                                GLsizei width,
                                GLsizei height,
                                GLsizei depth)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureType, targetPacked);
    paramBuffer.addValueParam("levels", ParamType::TGLsizei, levels);
    paramBuffer.addEnumParam("internalformat", GLESEnum::SizedInternalFormat, ParamType::TGLenum,
                             internalformat);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);

    return CallCapture(angle::EntryPoint::GLTexStorage3D, std::move(paramBuffer));
}

CallCapture CaptureTexSubImage3D(const State &glState,
                                 bool isCallValid,
                                 TextureTarget targetPacked,
                                 GLint level,
                                 GLint xoffset,
                                 GLint yoffset,
                                 GLint zoffset,
                                 GLsizei width,
                                 GLsizei height,
                                 GLsizei depth,
                                 GLenum format,
                                 GLenum type,
                                 const void *pixels)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TTextureTarget, targetPacked);
    paramBuffer.addValueParam("level", ParamType::TGLint, level);
    paramBuffer.addValueParam("xoffset", ParamType::TGLint, xoffset);
    paramBuffer.addValueParam("yoffset", ParamType::TGLint, yoffset);
    paramBuffer.addValueParam("zoffset", ParamType::TGLint, zoffset);
    paramBuffer.addValueParam("width", ParamType::TGLsizei, width);
    paramBuffer.addValueParam("height", ParamType::TGLsizei, height);
    paramBuffer.addValueParam("depth", ParamType::TGLsizei, depth);
    paramBuffer.addEnumParam("format", GLESEnum::PixelFormat, ParamType::TGLenum, format);
    paramBuffer.addEnumParam("type", GLESEnum::PixelType, ParamType::TGLenum, type);

    ParamCapture pixelsParam("pixels", ParamType::TvoidConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidConstPointer, pixels, &pixelsParam.value);
        CaptureTexSubImage3D_pixels(glState, targetPacked, level, xoffset, yoffset, zoffset, width,
                                    height, depth, format, type, pixels, &pixelsParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &pixelsParam.value);
    }
    paramBuffer.addParam(std::move(pixelsParam));

    return CallCapture(angle::EntryPoint::GLTexSubImage3D, std::move(paramBuffer));
}

CallCapture CaptureTransformFeedbackVaryings(const State &glState,
                                             bool isCallValid,
                                             ShaderProgramID programPacked,
                                             GLsizei count,
                                             const GLchar *const *varyings,
                                             GLenum bufferMode)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture varyingsParam("varyings", ParamType::TGLcharConstPointerPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLcharConstPointerPointer, varyings, &varyingsParam.value);
        CaptureTransformFeedbackVaryings_varyings(glState, programPacked, count, varyings,
                                                  bufferMode, &varyingsParam);
    }
    else
    {
        InitParamValue(ParamType::TGLcharConstPointerPointer,
                       static_cast<const GLchar *const *>(nullptr), &varyingsParam.value);
    }
    paramBuffer.addParam(std::move(varyingsParam));

    paramBuffer.addEnumParam("bufferMode", GLESEnum::TransformFeedbackBufferMode,
                             ParamType::TGLenum, bufferMode);

    return CallCapture(angle::EntryPoint::GLTransformFeedbackVaryings, std::move(paramBuffer));
}

CallCapture CaptureUniform1ui(const State &glState,
                              bool isCallValid,
                              UniformLocation locationPacked,
                              GLuint v0)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("v0", ParamType::TGLuint, v0);

    return CallCapture(angle::EntryPoint::GLUniform1ui, std::move(paramBuffer));
}

CallCapture CaptureUniform1uiv(const State &glState,
                               bool isCallValid,
                               UniformLocation locationPacked,
                               GLsizei count,
                               const GLuint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLuintConstPointer, value, &valueParam.value);
        CaptureUniform1uiv_value(glState, locationPacked, count, value, &valueParam);
    }
    else
    {
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &valueParam.value);
    }
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(angle::EntryPoint::GLUniform1uiv, std::move(paramBuffer));
}

CallCapture CaptureUniform2ui(const State &glState,
                              bool isCallValid,
                              UniformLocation locationPacked,
                              GLuint v0,
                              GLuint v1)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("v0", ParamType::TGLuint, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLuint, v1);

    return CallCapture(angle::EntryPoint::GLUniform2ui, std::move(paramBuffer));
}

CallCapture CaptureUniform2uiv(const State &glState,
                               bool isCallValid,
                               UniformLocation locationPacked,
                               GLsizei count,
                               const GLuint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLuintConstPointer, value, &valueParam.value);
        CaptureUniform2uiv_value(glState, locationPacked, count, value, &valueParam);
    }
    else
    {
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &valueParam.value);
    }
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(angle::EntryPoint::GLUniform2uiv, std::move(paramBuffer));
}

CallCapture CaptureUniform3ui(const State &glState,
                              bool isCallValid,
                              UniformLocation locationPacked,
                              GLuint v0,
                              GLuint v1,
                              GLuint v2)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("v0", ParamType::TGLuint, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLuint, v1);
    paramBuffer.addValueParam("v2", ParamType::TGLuint, v2);

    return CallCapture(angle::EntryPoint::GLUniform3ui, std::move(paramBuffer));
}

CallCapture CaptureUniform3uiv(const State &glState,
                               bool isCallValid,
                               UniformLocation locationPacked,
                               GLsizei count,
                               const GLuint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLuintConstPointer, value, &valueParam.value);
        CaptureUniform3uiv_value(glState, locationPacked, count, value, &valueParam);
    }
    else
    {
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &valueParam.value);
    }
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(angle::EntryPoint::GLUniform3uiv, std::move(paramBuffer));
}

CallCapture CaptureUniform4ui(const State &glState,
                              bool isCallValid,
                              UniformLocation locationPacked,
                              GLuint v0,
                              GLuint v1,
                              GLuint v2,
                              GLuint v3)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("v0", ParamType::TGLuint, v0);
    paramBuffer.addValueParam("v1", ParamType::TGLuint, v1);
    paramBuffer.addValueParam("v2", ParamType::TGLuint, v2);
    paramBuffer.addValueParam("v3", ParamType::TGLuint, v3);

    return CallCapture(angle::EntryPoint::GLUniform4ui, std::move(paramBuffer));
}

CallCapture CaptureUniform4uiv(const State &glState,
                               bool isCallValid,
                               UniformLocation locationPacked,
                               GLsizei count,
                               const GLuint *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);

    ParamCapture valueParam("value", ParamType::TGLuintConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLuintConstPointer, value, &valueParam.value);
        CaptureUniform4uiv_value(glState, locationPacked, count, value, &valueParam);
    }
    else
    {
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &valueParam.value);
    }
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(angle::EntryPoint::GLUniform4uiv, std::move(paramBuffer));
}

CallCapture CaptureUniformBlockBinding(const State &glState,
                                       bool isCallValid,
                                       ShaderProgramID programPacked,
                                       UniformBlockIndex uniformBlockIndexPacked,
                                       GLuint uniformBlockBinding)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("programPacked", ParamType::TShaderProgramID, programPacked);
    paramBuffer.addValueParam("uniformBlockIndexPacked", ParamType::TUniformBlockIndex,
                              uniformBlockIndexPacked);
    paramBuffer.addValueParam("uniformBlockBinding", ParamType::TGLuint, uniformBlockBinding);

    return CallCapture(angle::EntryPoint::GLUniformBlockBinding, std::move(paramBuffer));
}

CallCapture CaptureUniformMatrix2x3fv(const State &glState,
                                      bool isCallValid,
                                      UniformLocation locationPacked,
                                      GLsizei count,
                                      GLboolean transpose,
                                      const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
        CaptureUniformMatrix2x3fv_value(glState, locationPacked, count, transpose, value,
                                        &valueParam);
    }
    else
    {
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valueParam.value);
    }
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(angle::EntryPoint::GLUniformMatrix2x3fv, std::move(paramBuffer));
}

CallCapture CaptureUniformMatrix2x4fv(const State &glState,
                                      bool isCallValid,
                                      UniformLocation locationPacked,
                                      GLsizei count,
                                      GLboolean transpose,
                                      const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
        CaptureUniformMatrix2x4fv_value(glState, locationPacked, count, transpose, value,
                                        &valueParam);
    }
    else
    {
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valueParam.value);
    }
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(angle::EntryPoint::GLUniformMatrix2x4fv, std::move(paramBuffer));
}

CallCapture CaptureUniformMatrix3x2fv(const State &glState,
                                      bool isCallValid,
                                      UniformLocation locationPacked,
                                      GLsizei count,
                                      GLboolean transpose,
                                      const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
        CaptureUniformMatrix3x2fv_value(glState, locationPacked, count, transpose, value,
                                        &valueParam);
    }
    else
    {
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valueParam.value);
    }
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(angle::EntryPoint::GLUniformMatrix3x2fv, std::move(paramBuffer));
}

CallCapture CaptureUniformMatrix3x4fv(const State &glState,
                                      bool isCallValid,
                                      UniformLocation locationPacked,
                                      GLsizei count,
                                      GLboolean transpose,
                                      const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
        CaptureUniformMatrix3x4fv_value(glState, locationPacked, count, transpose, value,
                                        &valueParam);
    }
    else
    {
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valueParam.value);
    }
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(angle::EntryPoint::GLUniformMatrix3x4fv, std::move(paramBuffer));
}

CallCapture CaptureUniformMatrix4x2fv(const State &glState,
                                      bool isCallValid,
                                      UniformLocation locationPacked,
                                      GLsizei count,
                                      GLboolean transpose,
                                      const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
        CaptureUniformMatrix4x2fv_value(glState, locationPacked, count, transpose, value,
                                        &valueParam);
    }
    else
    {
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valueParam.value);
    }
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(angle::EntryPoint::GLUniformMatrix4x2fv, std::move(paramBuffer));
}

CallCapture CaptureUniformMatrix4x3fv(const State &glState,
                                      bool isCallValid,
                                      UniformLocation locationPacked,
                                      GLsizei count,
                                      GLboolean transpose,
                                      const GLfloat *value)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("locationPacked", ParamType::TUniformLocation, locationPacked);
    paramBuffer.addValueParam("count", ParamType::TGLsizei, count);
    paramBuffer.addValueParam("transpose", ParamType::TGLboolean, transpose);

    ParamCapture valueParam("value", ParamType::TGLfloatConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLfloatConstPointer, value, &valueParam.value);
        CaptureUniformMatrix4x3fv_value(glState, locationPacked, count, transpose, value,
                                        &valueParam);
    }
    else
    {
        InitParamValue(ParamType::TGLfloatConstPointer, static_cast<const GLfloat *>(nullptr),
                       &valueParam.value);
    }
    paramBuffer.addParam(std::move(valueParam));

    return CallCapture(angle::EntryPoint::GLUniformMatrix4x3fv, std::move(paramBuffer));
}

CallCapture CaptureUnmapBuffer(const State &glState,
                               bool isCallValid,
                               BufferBinding targetPacked,
                               GLboolean returnValue)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("targetPacked", ParamType::TBufferBinding, targetPacked);

    ParamCapture returnValueCapture("returnValue", ParamType::TGLboolean);
    InitParamValue(ParamType::TGLboolean, returnValue, &returnValueCapture.value);
    paramBuffer.addReturnValue(std::move(returnValueCapture));

    return CallCapture(angle::EntryPoint::GLUnmapBuffer, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribDivisor(const State &glState,
                                       bool isCallValid,
                                       GLuint index,
                                       GLuint divisor)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("divisor", ParamType::TGLuint, divisor);

    return CallCapture(angle::EntryPoint::GLVertexAttribDivisor, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribI4i(const State &glState,
                                   bool isCallValid,
                                   GLuint index,
                                   GLint x,
                                   GLint y,
                                   GLint z,
                                   GLint w)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("x", ParamType::TGLint, x);
    paramBuffer.addValueParam("y", ParamType::TGLint, y);
    paramBuffer.addValueParam("z", ParamType::TGLint, z);
    paramBuffer.addValueParam("w", ParamType::TGLint, w);

    return CallCapture(angle::EntryPoint::GLVertexAttribI4i, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribI4iv(const State &glState,
                                    bool isCallValid,
                                    GLuint index,
                                    const GLint *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    ParamCapture vParam("v", ParamType::TGLintConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLintConstPointer, v, &vParam.value);
        CaptureVertexAttribI4iv_v(glState, index, v, &vParam);
    }
    else
    {
        InitParamValue(ParamType::TGLintConstPointer, static_cast<const GLint *>(nullptr),
                       &vParam.value);
    }
    paramBuffer.addParam(std::move(vParam));

    return CallCapture(angle::EntryPoint::GLVertexAttribI4iv, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribI4ui(const State &glState,
                                    bool isCallValid,
                                    GLuint index,
                                    GLuint x,
                                    GLuint y,
                                    GLuint z,
                                    GLuint w)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("x", ParamType::TGLuint, x);
    paramBuffer.addValueParam("y", ParamType::TGLuint, y);
    paramBuffer.addValueParam("z", ParamType::TGLuint, z);
    paramBuffer.addValueParam("w", ParamType::TGLuint, w);

    return CallCapture(angle::EntryPoint::GLVertexAttribI4ui, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribI4uiv(const State &glState,
                                     bool isCallValid,
                                     GLuint index,
                                     const GLuint *v)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);

    ParamCapture vParam("v", ParamType::TGLuintConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TGLuintConstPointer, v, &vParam.value);
        CaptureVertexAttribI4uiv_v(glState, index, v, &vParam);
    }
    else
    {
        InitParamValue(ParamType::TGLuintConstPointer, static_cast<const GLuint *>(nullptr),
                       &vParam.value);
    }
    paramBuffer.addParam(std::move(vParam));

    return CallCapture(angle::EntryPoint::GLVertexAttribI4uiv, std::move(paramBuffer));
}

CallCapture CaptureVertexAttribIPointer(const State &glState,
                                        bool isCallValid,
                                        GLuint index,
                                        GLint size,
                                        VertexAttribType typePacked,
                                        GLsizei stride,
                                        const void *pointer)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("index", ParamType::TGLuint, index);
    paramBuffer.addValueParam("size", ParamType::TGLint, size);
    paramBuffer.addValueParam("typePacked", ParamType::TVertexAttribType, typePacked);
    paramBuffer.addValueParam("stride", ParamType::TGLsizei, stride);

    ParamCapture pointerParam("pointer", ParamType::TvoidConstPointer);
    if (isCallValid)
    {
        InitParamValue(ParamType::TvoidConstPointer, pointer, &pointerParam.value);
        CaptureVertexAttribIPointer_pointer(glState, index, size, typePacked, stride, pointer,
                                            &pointerParam);
    }
    else
    {
        InitParamValue(ParamType::TvoidConstPointer, static_cast<const void *>(nullptr),
                       &pointerParam.value);
    }
    paramBuffer.addParam(std::move(pointerParam));

    return CallCapture(angle::EntryPoint::GLVertexAttribIPointer, std::move(paramBuffer));
}

CallCapture CaptureWaitSync(const State &glState,
                            bool isCallValid,
                            SyncID syncPacked,
                            GLbitfield flags,
                            GLuint64 timeout)
{
    ParamBuffer paramBuffer;

    paramBuffer.addValueParam("syncPacked", ParamType::TSyncID, syncPacked);
    paramBuffer.addEnumParam("flags", GLESEnum::SyncBehaviorFlags, ParamType::TGLbitfield, flags);
    paramBuffer.addValueParam("timeout", ParamType::TGLuint64, timeout);

    return CallCapture(angle::EntryPoint::GLWaitSync, std::move(paramBuffer));
}

}  // namespace gl
