// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// entry_points_gles_2_0_autogen.cpp:
//   Defines the GLES 2.0 entry points.

#include "libGLESv2/entry_points_gles_2_0_autogen.h"

#include "common/entry_points_enum_autogen.h"
#include "common/gl_enum_utils.h"
#include "libANGLE/Context.h"
#include "libANGLE/Context.inl.h"
#include "libANGLE/capture/capture_gles_2_0_autogen.h"
#include "libANGLE/context_private_call.inl.h"
#include "libANGLE/context_private_call_autogen.h"
#include "libANGLE/entry_points_utils.h"
#include "libANGLE/validationES2.h"
#include "libGLESv2/global_state.h"

using namespace gl;

extern "C" {
void GL_APIENTRY GL_ActiveTexture(GLenum texture)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLActiveTexture, "context = %d, texture = %s", CID(context),
                            GLenumToString(GLESEnum::TextureUnit, texture)));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateActiveTexture(context->getPrivateState(),
                                                    context->getMutableErrorSetForValidation(),
                                                    angle::EntryPoint::GLActiveTexture, texture);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateActiveTexture(context->getMutablePrivateState(),
                                        context->getMutablePrivateStateCache(), texture);
        }
        ANGLE_CAPTURE_GL(ActiveTexture, isCallValid, context, texture);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLActiveTexture);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_AttachShader(GLuint program, GLuint shader)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLAttachShader, "context = %d, program = %u, shader = %u",
                            CID(context), program, shader));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked = PackParam<ShaderProgramID>(program);
        ShaderProgramID shaderPacked  = PackParam<ShaderProgramID>(shader);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateAttachShader(context, angle::EntryPoint::GLAttachShader,
                                                   programPacked, shaderPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLAttachShader);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->attachShader(programPacked, shaderPacked);
        }
        ANGLE_CAPTURE_GL(AttachShader, isCallValid, context, programPacked, shaderPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLAttachShader);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_BindAttribLocation(GLuint program, GLuint index, const GLchar *name)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLBindAttribLocation,
                            "context = %d, program = %u, index = %u, name = 0x%016" PRIxPTR "",
                            CID(context), program, index, (uintptr_t)name));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateBindAttribLocation(
                    context, angle::EntryPoint::GLBindAttribLocation, programPacked, index, name);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLBindAttribLocation);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->bindAttribLocation(programPacked, index, name);
        }
        ANGLE_CAPTURE_GL(BindAttribLocation, isCallValid, context, programPacked, index, name);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLBindAttribLocation);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_BindBuffer(GLenum target, GLuint buffer)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLBindBuffer, "context = %d, target = %s, buffer = %u",
                            CID(context), GLenumToString(GLESEnum::BufferTargetARB, target),
                            buffer));

    if (ANGLE_LIKELY(context != nullptr))
    {
        BufferBinding targetPacked = PackParam<BufferBinding>(target);
        BufferID bufferPacked      = PackParam<BufferID>(buffer);

        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateBindBuffer(context, angle::EntryPoint::GLBindBuffer,
                                                 targetPacked, bufferPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->bindBuffer(targetPacked, bufferPacked);
        }
        ANGLE_CAPTURE_GL(BindBuffer, isCallValid, context, targetPacked, bufferPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLBindBuffer);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_BindFramebuffer(GLenum target, GLuint framebuffer)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLBindFramebuffer,
                            "context = %d, target = %s, framebuffer = %u", CID(context),
                            GLenumToString(GLESEnum::FramebufferTarget, target), framebuffer));

    if (ANGLE_LIKELY(context != nullptr))
    {
        FramebufferID framebufferPacked = PackParam<FramebufferID>(framebuffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        if (context->getState().getPixelLocalStorageActivePlanes() != 0)
        {
            context->endPixelLocalStorageImplicit();
        }
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateBindFramebuffer(context, angle::EntryPoint::GLBindFramebuffer,
                                                      target, framebufferPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLBindFramebuffer);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->bindFramebuffer(target, framebufferPacked);
        }
        ANGLE_CAPTURE_GL(BindFramebuffer, isCallValid, context, target, framebufferPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLBindFramebuffer);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_BindRenderbuffer(GLenum target, GLuint renderbuffer)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLBindRenderbuffer,
                            "context = %d, target = %s, renderbuffer = %u", CID(context),
                            GLenumToString(GLESEnum::RenderbufferTarget, target), renderbuffer));

    if (ANGLE_LIKELY(context != nullptr))
    {
        RenderbufferID renderbufferPacked = PackParam<RenderbufferID>(renderbuffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateBindRenderbuffer(
                    context, angle::EntryPoint::GLBindRenderbuffer, target, renderbufferPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLBindRenderbuffer);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->bindRenderbuffer(target, renderbufferPacked);
        }
        ANGLE_CAPTURE_GL(BindRenderbuffer, isCallValid, context, target, renderbufferPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLBindRenderbuffer);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_BindTexture(GLenum target, GLuint texture)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLBindTexture, "context = %d, target = %s, texture = %u",
                            CID(context), GLenumToString(GLESEnum::TextureTarget, target),
                            texture));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        TextureID texturePacked  = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateBindTexture(context, angle::EntryPoint::GLBindTexture,
                                                  targetPacked, texturePacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->bindTexture(targetPacked, texturePacked);
        }
        ANGLE_CAPTURE_GL(BindTexture, isCallValid, context, targetPacked, texturePacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLBindTexture);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_BlendColor(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLBlendColor,
                            "context = %d, red = %f, green = %f, blue = %f, alpha = %f",
                            CID(context), red, green, blue, alpha));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateBlendColor(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLBlendColor, red, green, blue, alpha);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLBlendColor);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateBlendColor(context->getMutablePrivateState(),
                                     context->getMutablePrivateStateCache(), red, green, blue,
                                     alpha);
        }
        ANGLE_CAPTURE_GL(BlendColor, isCallValid, context, red, green, blue, alpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLBlendColor);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_BlendEquation(GLenum mode)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLBlendEquation, "context = %d, mode = %s", CID(context),
                            GLenumToString(GLESEnum::BlendEquationModeEXT, mode)));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateBlendEquation(context->getPrivateState(),
                                                    context->getMutableErrorSetForValidation(),
                                                    angle::EntryPoint::GLBlendEquation, mode);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLBlendEquation);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateBlendEquation(context->getMutablePrivateState(),
                                        context->getMutablePrivateStateCache(), mode);
        }
        ANGLE_CAPTURE_GL(BlendEquation, isCallValid, context, mode);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLBlendEquation);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_BlendEquationSeparate(GLenum modeRGB, GLenum modeAlpha)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLBlendEquationSeparate,
                            "context = %d, modeRGB = %s, modeAlpha = %s", CID(context),
                            GLenumToString(GLESEnum::BlendEquationModeEXT, modeRGB),
                            GLenumToString(GLESEnum::BlendEquationModeEXT, modeAlpha)));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateBlendEquationSeparate(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLBlendEquationSeparate, modeRGB, modeAlpha);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLBlendEquationSeparate);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateBlendEquationSeparate(context->getMutablePrivateState(),
                                                context->getMutablePrivateStateCache(), modeRGB,
                                                modeAlpha);
        }
        ANGLE_CAPTURE_GL(BlendEquationSeparate, isCallValid, context, modeRGB, modeAlpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLBlendEquationSeparate);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_BlendFunc(GLenum sfactor, GLenum dfactor)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLBlendFunc, "context = %d, sfactor = %s, dfactor = %s",
                            CID(context), GLenumToString(GLESEnum::BlendingFactor, sfactor),
                            GLenumToString(GLESEnum::BlendingFactor, dfactor)));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateBlendFunc(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLBlendFunc, sfactor, dfactor);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateBlendFunc(context->getMutablePrivateState(),
                                    context->getMutablePrivateStateCache(), sfactor, dfactor);
        }
        ANGLE_CAPTURE_GL(BlendFunc, isCallValid, context, sfactor, dfactor);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLBlendFunc);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_BlendFuncSeparate(GLenum sfactorRGB,
                                      GLenum dfactorRGB,
                                      GLenum sfactorAlpha,
                                      GLenum dfactorAlpha)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(
        context, GLBlendFuncSeparate,
        "context = %d, sfactorRGB = %s, dfactorRGB = %s, sfactorAlpha = %s, dfactorAlpha = %s",
        CID(context), GLenumToString(GLESEnum::BlendingFactor, sfactorRGB),
        GLenumToString(GLESEnum::BlendingFactor, dfactorRGB),
        GLenumToString(GLESEnum::BlendingFactor, sfactorAlpha),
        GLenumToString(GLESEnum::BlendingFactor, dfactorAlpha)));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateBlendFuncSeparate(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLBlendFuncSeparate, sfactorRGB, dfactorRGB, sfactorAlpha,
                    dfactorAlpha);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLBlendFuncSeparate);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateBlendFuncSeparate(context->getMutablePrivateState(),
                                            context->getMutablePrivateStateCache(), sfactorRGB,
                                            dfactorRGB, sfactorAlpha, dfactorAlpha);
        }
        ANGLE_CAPTURE_GL(BlendFuncSeparate, isCallValid, context, sfactorRGB, dfactorRGB,
                         sfactorAlpha, dfactorAlpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLBlendFuncSeparate);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_BufferData(GLenum target, GLsizeiptr size, const void *data, GLenum usage)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLBufferData,
                            "context = %d, target = %s, size = %llu, data = 0x%016" PRIxPTR
                            ", usage = %s",
                            CID(context), GLenumToString(GLESEnum::BufferTargetARB, target),
                            static_cast<unsigned long long>(size), (uintptr_t)data,
                            GLenumToString(GLESEnum::BufferUsageARB, usage)));

    if (ANGLE_LIKELY(context != nullptr))
    {
        BufferBinding targetPacked = PackParam<BufferBinding>(target);
        BufferUsage usagePacked    = PackParam<BufferUsage>(usage);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateBufferData(context, angle::EntryPoint::GLBufferData,
                                                 targetPacked, size, data, usagePacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->bufferData(targetPacked, size, data, usagePacked);
        }
        ANGLE_CAPTURE_GL(BufferData, isCallValid, context, targetPacked, size, data, usagePacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLBufferData);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_BufferSubData(GLenum target, GLintptr offset, GLsizeiptr size, const void *data)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLBufferSubData,
              "context = %d, target = %s, offset = %llu, size = %llu, data = 0x%016" PRIxPTR "",
              CID(context), GLenumToString(GLESEnum::BufferTargetARB, target),
              static_cast<unsigned long long>(offset), static_cast<unsigned long long>(size),
              (uintptr_t)data));

    if (ANGLE_LIKELY(context != nullptr))
    {
        BufferBinding targetPacked = PackParam<BufferBinding>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateBufferSubData(context, angle::EntryPoint::GLBufferSubData,
                                                    targetPacked, offset, size, data);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->bufferSubData(targetPacked, offset, size, data);
        }
        ANGLE_CAPTURE_GL(BufferSubData, isCallValid, context, targetPacked, offset, size, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLBufferSubData);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

GLenum GL_APIENTRY GL_CheckFramebufferStatus(GLenum target)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLCheckFramebufferStatus, "context = %d, target = %s",
                            CID(context), GLenumToString(GLESEnum::FramebufferTarget, target)));

    GLenum returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateCheckFramebufferStatus(
                    context, angle::EntryPoint::GLCheckFramebufferStatus, target);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLCheckFramebufferStatus);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue = context->checkFramebufferStatus(target);
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLCheckFramebufferStatus, GLenum>();
        }
        ANGLE_CAPTURE_GL(CheckFramebufferStatus, isCallValid, context, target, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLCheckFramebufferStatus);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLCheckFramebufferStatus, GLenum>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

void GL_APIENTRY GL_Clear(GLbitfield mask)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLClear, "context = %d, mask = %s", CID(context),
                            GLbitfieldToString(GLESEnum::ClearBufferMask, mask).c_str()));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateClear(context, angle::EntryPoint::GLClear, mask);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->clear(mask);
        }
        ANGLE_CAPTURE_GL(Clear, isCallValid, context, mask);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLClear);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ClearColor(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLClearColor,
                            "context = %d, red = %f, green = %f, blue = %f, alpha = %f",
                            CID(context), red, green, blue, alpha));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateClearColor(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLClearColor, red, green, blue, alpha);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateClearColor(context->getMutablePrivateState(),
                                     context->getMutablePrivateStateCache(), red, green, blue,
                                     alpha);
        }
        ANGLE_CAPTURE_GL(ClearColor, isCallValid, context, red, green, blue, alpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLClearColor);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ClearDepthf(GLfloat d)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLClearDepthf, "context = %d, d = %f", CID(context), d));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateClearDepthf(context->getPrivateState(),
                                                  context->getMutableErrorSetForValidation(),
                                                  angle::EntryPoint::GLClearDepthf, d);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateClearDepthf(context->getMutablePrivateState(),
                                      context->getMutablePrivateStateCache(), d);
        }
        ANGLE_CAPTURE_GL(ClearDepthf, isCallValid, context, d);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLClearDepthf);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ClearStencil(GLint s)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLClearStencil, "context = %d, s = %d", CID(context), s));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateClearStencil(context->getPrivateState(),
                                                   context->getMutableErrorSetForValidation(),
                                                   angle::EntryPoint::GLClearStencil, s);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateClearStencil(context->getMutablePrivateState(),
                                       context->getMutablePrivateStateCache(), s);
        }
        ANGLE_CAPTURE_GL(ClearStencil, isCallValid, context, s);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLClearStencil);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ColorMask(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLColorMask,
                            "context = %d, red = %s, green = %s, blue = %s, alpha = %s",
                            CID(context), GLbooleanToString(red), GLbooleanToString(green),
                            GLbooleanToString(blue), GLbooleanToString(alpha)));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateColorMask(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLColorMask, red, green, blue, alpha);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateColorMask(context->getMutablePrivateState(),
                                    context->getMutablePrivateStateCache(), red, green, blue,
                                    alpha);
        }
        ANGLE_CAPTURE_GL(ColorMask, isCallValid, context, red, green, blue, alpha);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLColorMask);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_CompileShader(GLuint shader)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLCompileShader, "context = %d, shader = %u", CID(context), shader));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID shaderPacked = PackParam<ShaderProgramID>(shader);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateCompileShader(context, angle::EntryPoint::GLCompileShader,
                                                    shaderPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLCompileShader);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->compileShader(shaderPacked);
        }
        ANGLE_CAPTURE_GL(CompileShader, isCallValid, context, shaderPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLCompileShader);
    }
    egl::Display::GetCurrentThreadUnlockedTailCall()->run(nullptr);
}

void GL_APIENTRY GL_CompressedTexImage2D(GLenum target,
                                         GLint level,
                                         GLenum internalformat,
                                         GLsizei width,
                                         GLsizei height,
                                         GLint border,
                                         GLsizei imageSize,
                                         const void *data)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLCompressedTexImage2D,
                            "context = %d, target = %s, level = %d, internalformat = %s, width = "
                            "%d, height = %d, border = %d, imageSize = %d, data = 0x%016" PRIxPTR
                            "",
                            CID(context), GLenumToString(GLESEnum::TextureTarget, target), level,
                            GLenumToString(GLESEnum::InternalFormat, internalformat), width, height,
                            border, imageSize, (uintptr_t)data));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureTarget targetPacked = PackParam<TextureTarget>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateCompressedTexImage2D(
                    context, angle::EntryPoint::GLCompressedTexImage2D, targetPacked, level,
                    internalformat, width, height, border, imageSize, data);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->compressedTexImage2D(targetPacked, level, internalformat, width, height,
                                          border, imageSize, data);
        }
        ANGLE_CAPTURE_GL(CompressedTexImage2D, isCallValid, context, targetPacked, level,
                         internalformat, width, height, border, imageSize, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLCompressedTexImage2D);
    }
    egl::Display::GetCurrentThreadUnlockedTailCall()->run(nullptr);
}

void GL_APIENTRY GL_CompressedTexSubImage2D(GLenum target,
                                            GLint level,
                                            GLint xoffset,
                                            GLint yoffset,
                                            GLsizei width,
                                            GLsizei height,
                                            GLenum format,
                                            GLsizei imageSize,
                                            const void *data)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLCompressedTexSubImage2D,
              "context = %d, target = %s, level = %d, xoffset = %d, yoffset = %d, width = %d, "
              "height = %d, format = %s, imageSize = %d, data = 0x%016" PRIxPTR "",
              CID(context), GLenumToString(GLESEnum::TextureTarget, target), level, xoffset,
              yoffset, width, height, GLenumToString(GLESEnum::InternalFormat, format), imageSize,
              (uintptr_t)data));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureTarget targetPacked = PackParam<TextureTarget>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateCompressedTexSubImage2D(
                    context, angle::EntryPoint::GLCompressedTexSubImage2D, targetPacked, level,
                    xoffset, yoffset, width, height, format, imageSize, data);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->compressedTexSubImage2D(targetPacked, level, xoffset, yoffset, width, height,
                                             format, imageSize, data);
        }
        ANGLE_CAPTURE_GL(CompressedTexSubImage2D, isCallValid, context, targetPacked, level,
                         xoffset, yoffset, width, height, format, imageSize, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLCompressedTexSubImage2D);
    }
    egl::Display::GetCurrentThreadUnlockedTailCall()->run(nullptr);
}

void GL_APIENTRY GL_CopyTexImage2D(GLenum target,
                                   GLint level,
                                   GLenum internalformat,
                                   GLint x,
                                   GLint y,
                                   GLsizei width,
                                   GLsizei height,
                                   GLint border)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLCopyTexImage2D,
                            "context = %d, target = %s, level = %d, internalformat = %s, x = %d, y "
                            "= %d, width = %d, height = %d, border = %d",
                            CID(context), GLenumToString(GLESEnum::TextureTarget, target), level,
                            GLenumToString(GLESEnum::InternalFormat, internalformat), x, y, width,
                            height, border));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureTarget targetPacked = PackParam<TextureTarget>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        if (context->getState().getPixelLocalStorageActivePlanes() != 0)
        {
            context->endPixelLocalStorageImplicit();
        }
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateCopyTexImage2D(context, angle::EntryPoint::GLCopyTexImage2D,
                                                     targetPacked, level, internalformat, x, y,
                                                     width, height, border);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->copyTexImage2D(targetPacked, level, internalformat, x, y, width, height,
                                    border);
        }
        ANGLE_CAPTURE_GL(CopyTexImage2D, isCallValid, context, targetPacked, level, internalformat,
                         x, y, width, height, border);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLCopyTexImage2D);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_CopyTexSubImage2D(GLenum target,
                                      GLint level,
                                      GLint xoffset,
                                      GLint yoffset,
                                      GLint x,
                                      GLint y,
                                      GLsizei width,
                                      GLsizei height)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLCopyTexSubImage2D,
                            "context = %d, target = %s, level = %d, xoffset = %d, yoffset = %d, x "
                            "= %d, y = %d, width = %d, height = %d",
                            CID(context), GLenumToString(GLESEnum::TextureTarget, target), level,
                            xoffset, yoffset, x, y, width, height));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureTarget targetPacked = PackParam<TextureTarget>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        if (context->getState().getPixelLocalStorageActivePlanes() != 0)
        {
            context->endPixelLocalStorageImplicit();
        }
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateCopyTexSubImage2D(
                    context, angle::EntryPoint::GLCopyTexSubImage2D, targetPacked, level, xoffset,
                    yoffset, x, y, width, height);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->copyTexSubImage2D(targetPacked, level, xoffset, yoffset, x, y, width, height);
        }
        ANGLE_CAPTURE_GL(CopyTexSubImage2D, isCallValid, context, targetPacked, level, xoffset,
                         yoffset, x, y, width, height);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLCopyTexSubImage2D);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

GLuint GL_APIENTRY GL_CreateProgram()
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLCreateProgram, "context = %d", CID(context)));

    GLuint returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateCreateProgram(context, angle::EntryPoint::GLCreateProgram);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLCreateProgram);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue = context->createProgram();
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLCreateProgram, GLuint>();
        }
        ANGLE_CAPTURE_GL(CreateProgram, isCallValid, context, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLCreateProgram);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLCreateProgram, GLuint>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

GLuint GL_APIENTRY GL_CreateShader(GLenum type)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLCreateShader, "context = %d, type = %s", CID(context),
                            GLenumToString(GLESEnum::ShaderType, type)));

    GLuint returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderType typePacked = PackParam<ShaderType>(type);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateCreateShader(context, angle::EntryPoint::GLCreateShader, typePacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLCreateShader);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue = context->createShader(typePacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLCreateShader, GLuint>();
        }
        ANGLE_CAPTURE_GL(CreateShader, isCallValid, context, typePacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLCreateShader);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLCreateShader, GLuint>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

void GL_APIENTRY GL_CullFace(GLenum mode)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLCullFace, "context = %d, mode = %s", CID(context),
                            GLenumToString(GLESEnum::TriangleFace, mode)));

    if (ANGLE_LIKELY(context != nullptr))
    {
        CullFaceMode modePacked = PackParam<CullFaceMode>(mode);
        bool isCallValid        = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateCullFace(context->getPrivateState(),
                                               context->getMutableErrorSetForValidation(),
                                               angle::EntryPoint::GLCullFace, modePacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateCullFace(context->getMutablePrivateState(),
                                   context->getMutablePrivateStateCache(), modePacked);
        }
        ANGLE_CAPTURE_GL(CullFace, isCallValid, context, modePacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLCullFace);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DeleteBuffers(GLsizei n, const GLuint *buffers)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLDeleteBuffers,
                            "context = %d, n = %d, buffers = 0x%016" PRIxPTR "", CID(context), n,
                            (uintptr_t)buffers));

    if (ANGLE_LIKELY(context != nullptr))
    {
        const BufferID *buffersPacked = PackParam<const BufferID *>(buffers);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDeleteBuffers(context, angle::EntryPoint::GLDeleteBuffers, n,
                                                    buffersPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->deleteBuffers(n, buffersPacked);
        }
        ANGLE_CAPTURE_GL(DeleteBuffers, isCallValid, context, n, buffersPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDeleteBuffers);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DeleteFramebuffers(GLsizei n, const GLuint *framebuffers)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLDeleteFramebuffers,
                            "context = %d, n = %d, framebuffers = 0x%016" PRIxPTR "", CID(context),
                            n, (uintptr_t)framebuffers));

    if (ANGLE_LIKELY(context != nullptr))
    {
        const FramebufferID *framebuffersPacked = PackParam<const FramebufferID *>(framebuffers);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDeleteFramebuffers(
                    context, angle::EntryPoint::GLDeleteFramebuffers, n, framebuffersPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLDeleteFramebuffers);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->deleteFramebuffers(n, framebuffersPacked);
        }
        ANGLE_CAPTURE_GL(DeleteFramebuffers, isCallValid, context, n, framebuffersPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDeleteFramebuffers);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DeleteProgram(GLuint program)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLDeleteProgram, "context = %d, program = %u", CID(context), program));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDeleteProgram(context, angle::EntryPoint::GLDeleteProgram,
                                                    programPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLDeleteProgram);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->deleteProgram(programPacked);
        }
        ANGLE_CAPTURE_GL(DeleteProgram, isCallValid, context, programPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDeleteProgram);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DeleteRenderbuffers(GLsizei n, const GLuint *renderbuffers)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLDeleteRenderbuffers,
                            "context = %d, n = %d, renderbuffers = 0x%016" PRIxPTR "", CID(context),
                            n, (uintptr_t)renderbuffers));

    if (ANGLE_LIKELY(context != nullptr))
    {
        const RenderbufferID *renderbuffersPacked =
            PackParam<const RenderbufferID *>(renderbuffers);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDeleteRenderbuffers(
                    context, angle::EntryPoint::GLDeleteRenderbuffers, n, renderbuffersPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLDeleteRenderbuffers);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->deleteRenderbuffers(n, renderbuffersPacked);
        }
        ANGLE_CAPTURE_GL(DeleteRenderbuffers, isCallValid, context, n, renderbuffersPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDeleteRenderbuffers);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DeleteShader(GLuint shader)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLDeleteShader, "context = %d, shader = %u", CID(context), shader));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID shaderPacked = PackParam<ShaderProgramID>(shader);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateDeleteShader(context, angle::EntryPoint::GLDeleteShader, shaderPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLDeleteShader);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->deleteShader(shaderPacked);
        }
        ANGLE_CAPTURE_GL(DeleteShader, isCallValid, context, shaderPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDeleteShader);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DeleteTextures(GLsizei n, const GLuint *textures)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLDeleteTextures,
                            "context = %d, n = %d, textures = 0x%016" PRIxPTR "", CID(context), n,
                            (uintptr_t)textures));

    if (ANGLE_LIKELY(context != nullptr))
    {
        const TextureID *texturesPacked = PackParam<const TextureID *>(textures);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDeleteTextures(context, angle::EntryPoint::GLDeleteTextures,
                                                     n, texturesPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->deleteTextures(n, texturesPacked);
        }
        ANGLE_CAPTURE_GL(DeleteTextures, isCallValid, context, n, texturesPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDeleteTextures);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DepthFunc(GLenum func)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLDepthFunc, "context = %d, func = %s", CID(context),
                            GLenumToString(GLESEnum::DepthFunction, func)));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDepthFunc(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLDepthFunc, func);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateDepthFunc(context->getMutablePrivateState(),
                                    context->getMutablePrivateStateCache(), func);
        }
        ANGLE_CAPTURE_GL(DepthFunc, isCallValid, context, func);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDepthFunc);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DepthMask(GLboolean flag)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLDepthMask, "context = %d, flag = %s", CID(context),
                            GLbooleanToString(flag)));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDepthMask(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLDepthMask, flag);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateDepthMask(context->getMutablePrivateState(),
                                    context->getMutablePrivateStateCache(), flag);
        }
        ANGLE_CAPTURE_GL(DepthMask, isCallValid, context, flag);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDepthMask);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DepthRangef(GLfloat n, GLfloat f)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLDepthRangef, "context = %d, n = %f, f = %f", CID(context), n, f));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDepthRangef(context->getPrivateState(),
                                                  context->getMutableErrorSetForValidation(),
                                                  angle::EntryPoint::GLDepthRangef, n, f);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateDepthRangef(context->getMutablePrivateState(),
                                      context->getMutablePrivateStateCache(), n, f);
        }
        ANGLE_CAPTURE_GL(DepthRangef, isCallValid, context, n, f);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDepthRangef);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DetachShader(GLuint program, GLuint shader)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLDetachShader, "context = %d, program = %u, shader = %u",
                            CID(context), program, shader));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked = PackParam<ShaderProgramID>(program);
        ShaderProgramID shaderPacked  = PackParam<ShaderProgramID>(shader);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDetachShader(context, angle::EntryPoint::GLDetachShader,
                                                   programPacked, shaderPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLDetachShader);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->detachShader(programPacked, shaderPacked);
        }
        ANGLE_CAPTURE_GL(DetachShader, isCallValid, context, programPacked, shaderPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDetachShader);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Disable(GLenum cap)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLDisable, "context = %d, cap = %s", CID(context),
                            GLenumToString(GLESEnum::EnableCap, cap)));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDisable(context->getPrivateState(),
                                              context->getMutableErrorSetForValidation(),
                                              angle::EntryPoint::GLDisable, cap);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateDisable(context->getMutablePrivateState(),
                                  context->getMutablePrivateStateCache(), cap);
        }
        ANGLE_CAPTURE_GL(Disable, isCallValid, context, cap);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDisable);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DisableVertexAttribArray(GLuint index)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLDisableVertexAttribArray, "context = %d, index = %u",
                            CID(context), index));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDisableVertexAttribArray(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLDisableVertexAttribArray, index);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLDisableVertexAttribArray);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateDisableVertexAttribArray(context->getMutablePrivateState(),
                                                   context->getMutablePrivateStateCache(), index);
        }
        ANGLE_CAPTURE_GL(DisableVertexAttribArray, isCallValid, context, index);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLDisableVertexAttribArray);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DrawArrays(GLenum mode, GLint first, GLsizei count)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLDrawArrays,
                            "context = %d, mode = %s, first = %d, count = %d", CID(context),
                            GLenumToString(GLESEnum::PrimitiveType, mode), first, count));

    if (ANGLE_LIKELY(context != nullptr))
    {
        PrimitiveMode modePacked = PackParam<PrimitiveMode>(mode);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDrawArrays(context, angle::EntryPoint::GLDrawArrays,
                                                 modePacked, first, count);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->drawArrays(modePacked, first, count);
        }
        ANGLE_CAPTURE_GL(DrawArrays, isCallValid, context, modePacked, first, count);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDrawArrays);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DrawElements(GLenum mode, GLsizei count, GLenum type, const void *indices)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLDrawElements,
              "context = %d, mode = %s, count = %d, type = %s, indices = 0x%016" PRIxPTR "",
              CID(context), GLenumToString(GLESEnum::PrimitiveType, mode), count,
              GLenumToString(GLESEnum::DrawElementsType, type), (uintptr_t)indices));

    if (ANGLE_LIKELY(context != nullptr))
    {
        PrimitiveMode modePacked    = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked = PackParam<DrawElementsType>(type);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDrawElements(context, angle::EntryPoint::GLDrawElements,
                                                   modePacked, count, typePacked, indices);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->drawElements(modePacked, count, typePacked, indices);
        }
        ANGLE_CAPTURE_GL(DrawElements, isCallValid, context, modePacked, count, typePacked,
                         indices);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDrawElements);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Enable(GLenum cap)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLEnable, "context = %d, cap = %s", CID(context),
                            GLenumToString(GLESEnum::EnableCap, cap)));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateEnable(context->getPrivateState(),
                                             context->getMutableErrorSetForValidation(),
                                             angle::EntryPoint::GLEnable, cap);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateEnable(context->getMutablePrivateState(),
                                 context->getMutablePrivateStateCache(), cap);
        }
        ANGLE_CAPTURE_GL(Enable, isCallValid, context, cap);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLEnable);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_EnableVertexAttribArray(GLuint index)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLEnableVertexAttribArray, "context = %d, index = %u", CID(context), index));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateEnableVertexAttribArray(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLEnableVertexAttribArray, index);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLEnableVertexAttribArray);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateEnableVertexAttribArray(context->getMutablePrivateState(),
                                                  context->getMutablePrivateStateCache(), index);
        }
        ANGLE_CAPTURE_GL(EnableVertexAttribArray, isCallValid, context, index);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLEnableVertexAttribArray);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Finish()
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLFinish, "context = %d", CID(context)));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateFinish(context, angle::EntryPoint::GLFinish);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->finish();
        }
        ANGLE_CAPTURE_GL(Finish, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLFinish);
    }
    egl::Display::GetCurrentThreadUnlockedTailCall()->run(nullptr);
}

void GL_APIENTRY GL_Flush()
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLFlush, "context = %d", CID(context)));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateFlush(context, angle::EntryPoint::GLFlush);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->flush();
        }
        ANGLE_CAPTURE_GL(Flush, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLFlush);
    }
    egl::Display::GetCurrentThreadUnlockedTailCall()->run(nullptr);
}

void GL_APIENTRY GL_FramebufferRenderbuffer(GLenum target,
                                            GLenum attachment,
                                            GLenum renderbuffertarget,
                                            GLuint renderbuffer)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(
        context, GLFramebufferRenderbuffer,
        "context = %d, target = %s, attachment = %s, renderbuffertarget = %s, renderbuffer = %u",
        CID(context), GLenumToString(GLESEnum::FramebufferTarget, target),
        GLenumToString(GLESEnum::FramebufferAttachment, attachment),
        GLenumToString(GLESEnum::RenderbufferTarget, renderbuffertarget), renderbuffer));

    if (ANGLE_LIKELY(context != nullptr))
    {
        RenderbufferID renderbufferPacked = PackParam<RenderbufferID>(renderbuffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        if (context->getState().getPixelLocalStorageActivePlanes() != 0)
        {
            context->endPixelLocalStorageImplicit();
        }
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateFramebufferRenderbuffer(
                    context, angle::EntryPoint::GLFramebufferRenderbuffer, target, attachment,
                    renderbuffertarget, renderbufferPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLFramebufferRenderbuffer);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->framebufferRenderbuffer(target, attachment, renderbuffertarget,
                                             renderbufferPacked);
        }
        ANGLE_CAPTURE_GL(FramebufferRenderbuffer, isCallValid, context, target, attachment,
                         renderbuffertarget, renderbufferPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLFramebufferRenderbuffer);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_FramebufferTexture2D(GLenum target,
                                         GLenum attachment,
                                         GLenum textarget,
                                         GLuint texture,
                                         GLint level)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(
        context, GLFramebufferTexture2D,
        "context = %d, target = %s, attachment = %s, textarget = %s, texture = %u, level = %d",
        CID(context), GLenumToString(GLESEnum::FramebufferTarget, target),
        GLenumToString(GLESEnum::FramebufferAttachment, attachment),
        GLenumToString(GLESEnum::TextureTarget, textarget), texture, level));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureTarget textargetPacked = PackParam<TextureTarget>(textarget);
        TextureID texturePacked       = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        if (context->getState().getPixelLocalStorageActivePlanes() != 0)
        {
            context->endPixelLocalStorageImplicit();
        }
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateFramebufferTexture2D(
                    context, angle::EntryPoint::GLFramebufferTexture2D, target, attachment,
                    textargetPacked, texturePacked, level);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLFramebufferTexture2D);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->framebufferTexture2D(target, attachment, textargetPacked, texturePacked,
                                          level);
        }
        ANGLE_CAPTURE_GL(FramebufferTexture2D, isCallValid, context, target, attachment,
                         textargetPacked, texturePacked, level);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLFramebufferTexture2D);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_FrontFace(GLenum mode)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLFrontFace, "context = %d, mode = %s", CID(context),
                            GLenumToString(GLESEnum::FrontFaceDirection, mode)));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateFrontFace(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLFrontFace, mode);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateFrontFace(context->getMutablePrivateState(),
                                    context->getMutablePrivateStateCache(), mode);
        }
        ANGLE_CAPTURE_GL(FrontFace, isCallValid, context, mode);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLFrontFace);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GenBuffers(GLsizei n, GLuint *buffers)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLGenBuffers,
                            "context = %d, n = %d, buffers = 0x%016" PRIxPTR "", CID(context), n,
                            (uintptr_t)buffers));

    if (ANGLE_LIKELY(context != nullptr))
    {
        BufferID *buffersPacked = PackParam<BufferID *>(buffers);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateGenBuffers(context, angle::EntryPoint::GLGenBuffers, n, buffersPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->genBuffers(n, buffersPacked);
        }
        ANGLE_CAPTURE_GL(GenBuffers, isCallValid, context, n, buffersPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGenBuffers);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GenFramebuffers(GLsizei n, GLuint *framebuffers)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLGenFramebuffers,
                            "context = %d, n = %d, framebuffers = 0x%016" PRIxPTR "", CID(context),
                            n, (uintptr_t)framebuffers));

    if (ANGLE_LIKELY(context != nullptr))
    {
        FramebufferID *framebuffersPacked = PackParam<FramebufferID *>(framebuffers);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGenFramebuffers(context, angle::EntryPoint::GLGenFramebuffers,
                                                      n, framebuffersPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLGenFramebuffers);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->genFramebuffers(n, framebuffersPacked);
        }
        ANGLE_CAPTURE_GL(GenFramebuffers, isCallValid, context, n, framebuffersPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGenFramebuffers);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GenRenderbuffers(GLsizei n, GLuint *renderbuffers)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLGenRenderbuffers,
                            "context = %d, n = %d, renderbuffers = 0x%016" PRIxPTR "", CID(context),
                            n, (uintptr_t)renderbuffers));

    if (ANGLE_LIKELY(context != nullptr))
    {
        RenderbufferID *renderbuffersPacked = PackParam<RenderbufferID *>(renderbuffers);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGenRenderbuffers(
                    context, angle::EntryPoint::GLGenRenderbuffers, n, renderbuffersPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLGenRenderbuffers);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->genRenderbuffers(n, renderbuffersPacked);
        }
        ANGLE_CAPTURE_GL(GenRenderbuffers, isCallValid, context, n, renderbuffersPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGenRenderbuffers);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GenTextures(GLsizei n, GLuint *textures)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLGenTextures,
                            "context = %d, n = %d, textures = 0x%016" PRIxPTR "", CID(context), n,
                            (uintptr_t)textures));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureID *texturesPacked = PackParam<TextureID *>(textures);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGenTextures(context, angle::EntryPoint::GLGenTextures, n,
                                                  texturesPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->genTextures(n, texturesPacked);
        }
        ANGLE_CAPTURE_GL(GenTextures, isCallValid, context, n, texturesPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGenTextures);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GenerateMipmap(GLenum target)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLGenerateMipmap, "context = %d, target = %s", CID(context),
                            GLenumToString(GLESEnum::TextureTarget, target)));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGenerateMipmap(context, angle::EntryPoint::GLGenerateMipmap,
                                                     targetPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLGenerateMipmap);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->generateMipmap(targetPacked);
        }
        ANGLE_CAPTURE_GL(GenerateMipmap, isCallValid, context, targetPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGenerateMipmap);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetActiveAttrib(GLuint program,
                                    GLuint index,
                                    GLsizei bufSize,
                                    GLsizei *length,
                                    GLint *size,
                                    GLenum *type,
                                    GLchar *name)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLGetActiveAttrib,
              "context = %d, program = %u, index = %u, bufSize = %d, length = 0x%016" PRIxPTR
              ", size = 0x%016" PRIxPTR ", type = 0x%016" PRIxPTR ", name = 0x%016" PRIxPTR "",
              CID(context), program, index, bufSize, (uintptr_t)length, (uintptr_t)size,
              (uintptr_t)type, (uintptr_t)name));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetActiveAttrib(context, angle::EntryPoint::GLGetActiveAttrib,
                                                      programPacked, index, bufSize, length, size,
                                                      type, name);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLGetActiveAttrib);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getActiveAttrib(programPacked, index, bufSize, length, size, type, name);
        }
        ANGLE_CAPTURE_GL(GetActiveAttrib, isCallValid, context, programPacked, index, bufSize,
                         length, size, type, name);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetActiveAttrib);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetActiveUniform(GLuint program,
                                     GLuint index,
                                     GLsizei bufSize,
                                     GLsizei *length,
                                     GLint *size,
                                     GLenum *type,
                                     GLchar *name)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLGetActiveUniform,
              "context = %d, program = %u, index = %u, bufSize = %d, length = 0x%016" PRIxPTR
              ", size = 0x%016" PRIxPTR ", type = 0x%016" PRIxPTR ", name = 0x%016" PRIxPTR "",
              CID(context), program, index, bufSize, (uintptr_t)length, (uintptr_t)size,
              (uintptr_t)type, (uintptr_t)name));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetActiveUniform(
                    context, angle::EntryPoint::GLGetActiveUniform, programPacked, index, bufSize,
                    length, size, type, name);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLGetActiveUniform);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getActiveUniform(programPacked, index, bufSize, length, size, type, name);
        }
        ANGLE_CAPTURE_GL(GetActiveUniform, isCallValid, context, programPacked, index, bufSize,
                         length, size, type, name);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetActiveUniform);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetAttachedShaders(GLuint program,
                                       GLsizei maxCount,
                                       GLsizei *count,
                                       GLuint *shaders)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLGetAttachedShaders,
                            "context = %d, program = %u, maxCount = %d, count = 0x%016" PRIxPTR
                            ", shaders = 0x%016" PRIxPTR "",
                            CID(context), program, maxCount, (uintptr_t)count, (uintptr_t)shaders));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        ShaderProgramID *shadersPacked = PackParam<ShaderProgramID *>(shaders);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateGetAttachedShaders(context, angle::EntryPoint::GLGetAttachedShaders,
                                               programPacked, maxCount, count, shadersPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLGetAttachedShaders);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getAttachedShaders(programPacked, maxCount, count, shadersPacked);
        }
        ANGLE_CAPTURE_GL(GetAttachedShaders, isCallValid, context, programPacked, maxCount, count,
                         shadersPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetAttachedShaders);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

GLint GL_APIENTRY GL_GetAttribLocation(GLuint program, const GLchar *name)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLGetAttribLocation,
                            "context = %d, program = %u, name = 0x%016" PRIxPTR "", CID(context),
                            program, (uintptr_t)name));

    GLint returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetAttribLocation(
                    context, angle::EntryPoint::GLGetAttribLocation, programPacked, name);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLGetAttribLocation);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue = context->getAttribLocation(programPacked, name);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetAttribLocation, GLint>();
        }
        ANGLE_CAPTURE_GL(GetAttribLocation, isCallValid, context, programPacked, name, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetAttribLocation);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetAttribLocation, GLint>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

void GL_APIENTRY GL_GetBooleanv(GLenum pname, GLboolean *data)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLGetBooleanv,
                            "context = %d, pname = %s, data = 0x%016" PRIxPTR "", CID(context),
                            GLenumToString(GLESEnum::GetPName, pname), (uintptr_t)data));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateGetBooleanv(context, angle::EntryPoint::GLGetBooleanv, pname, data);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getBooleanv(pname, data);
        }
        ANGLE_CAPTURE_GL(GetBooleanv, isCallValid, context, pname, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetBooleanv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetBufferParameteriv(GLenum target, GLenum pname, GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLGetBufferParameteriv,
                            "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "",
                            CID(context), GLenumToString(GLESEnum::BufferTargetARB, target),
                            GLenumToString(GLESEnum::AllEnums, pname), (uintptr_t)params));

    if (ANGLE_LIKELY(context != nullptr))
    {
        BufferBinding targetPacked = PackParam<BufferBinding>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateGetBufferParameteriv(context, angle::EntryPoint::GLGetBufferParameteriv,
                                                 targetPacked, pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getBufferParameteriv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetBufferParameteriv, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetBufferParameteriv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

GLenum GL_APIENTRY GL_GetError()
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLGetError, "context = %d", CID(context)));

    GLenum returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetError(context, angle::EntryPoint::GLGetError);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue = context->getError();
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetError, GLenum>();
        }
        ANGLE_CAPTURE_GL(GetError, isCallValid, context, returnValue);
    }
    else
    {

        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetError, GLenum>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

void GL_APIENTRY GL_GetFloatv(GLenum pname, GLfloat *data)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLGetFloatv,
                            "context = %d, pname = %s, data = 0x%016" PRIxPTR "", CID(context),
                            GLenumToString(GLESEnum::GetPName, pname), (uintptr_t)data));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateGetFloatv(context, angle::EntryPoint::GLGetFloatv, pname, data);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getFloatv(pname, data);
        }
        ANGLE_CAPTURE_GL(GetFloatv, isCallValid, context, pname, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetFloatv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetFramebufferAttachmentParameteriv(GLenum target,
                                                        GLenum attachment,
                                                        GLenum pname,
                                                        GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(
        context, GLGetFramebufferAttachmentParameteriv,
        "context = %d, target = %s, attachment = %s, pname = %s, params = 0x%016" PRIxPTR "",
        CID(context), GLenumToString(GLESEnum::FramebufferTarget, target),
        GLenumToString(GLESEnum::FramebufferAttachment, attachment),
        GLenumToString(GLESEnum::FramebufferAttachmentParameterName, pname), (uintptr_t)params));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetFramebufferAttachmentParameteriv(
                    context, angle::EntryPoint::GLGetFramebufferAttachmentParameteriv, target,
                    attachment, pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context,
                                       angle::EntryPoint::GLGetFramebufferAttachmentParameteriv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getFramebufferAttachmentParameteriv(target, attachment, pname, params);
        }
        ANGLE_CAPTURE_GL(GetFramebufferAttachmentParameteriv, isCallValid, context, target,
                         attachment, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetFramebufferAttachmentParameteriv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetIntegerv(GLenum pname, GLint *data)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLGetIntegerv,
                            "context = %d, pname = %s, data = 0x%016" PRIxPTR "", CID(context),
                            GLenumToString(GLESEnum::GetPName, pname), (uintptr_t)data));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateGetIntegerv(context, angle::EntryPoint::GLGetIntegerv, pname, data);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getIntegerv(pname, data);
        }
        ANGLE_CAPTURE_GL(GetIntegerv, isCallValid, context, pname, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetIntegerv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetProgramInfoLog(GLuint program,
                                      GLsizei bufSize,
                                      GLsizei *length,
                                      GLchar *infoLog)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLGetProgramInfoLog,
                            "context = %d, program = %u, bufSize = %d, length = 0x%016" PRIxPTR
                            ", infoLog = 0x%016" PRIxPTR "",
                            CID(context), program, bufSize, (uintptr_t)length, (uintptr_t)infoLog));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateGetProgramInfoLog(context, angle::EntryPoint::GLGetProgramInfoLog,
                                              programPacked, bufSize, length, infoLog);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLGetProgramInfoLog);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getProgramInfoLog(programPacked, bufSize, length, infoLog);
        }
        ANGLE_CAPTURE_GL(GetProgramInfoLog, isCallValid, context, programPacked, bufSize, length,
                         infoLog);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetProgramInfoLog);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetProgramiv(GLuint program, GLenum pname, GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLGetProgramiv,
              "context = %d, program = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
              program, GLenumToString(GLESEnum::ProgramPropertyARB, pname), (uintptr_t)params));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetProgramiv(context, angle::EntryPoint::GLGetProgramiv,
                                                   programPacked, pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLGetProgramiv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getProgramiv(programPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetProgramiv, isCallValid, context, programPacked, pname, params);
    }
    else
    {
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetRenderbufferParameteriv(GLenum target, GLenum pname, GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLGetRenderbufferParameteriv,
                            "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "",
                            CID(context), GLenumToString(GLESEnum::RenderbufferTarget, target),
                            GLenumToString(GLESEnum::RenderbufferParameterName, pname),
                            (uintptr_t)params));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetRenderbufferParameteriv(
                    context, angle::EntryPoint::GLGetRenderbufferParameteriv, target, pname,
                    params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLGetRenderbufferParameteriv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getRenderbufferParameteriv(target, pname, params);
        }
        ANGLE_CAPTURE_GL(GetRenderbufferParameteriv, isCallValid, context, target, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetRenderbufferParameteriv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetShaderInfoLog(GLuint shader,
                                     GLsizei bufSize,
                                     GLsizei *length,
                                     GLchar *infoLog)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLGetShaderInfoLog,
                            "context = %d, shader = %u, bufSize = %d, length = 0x%016" PRIxPTR
                            ", infoLog = 0x%016" PRIxPTR "",
                            CID(context), shader, bufSize, (uintptr_t)length, (uintptr_t)infoLog));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID shaderPacked = PackParam<ShaderProgramID>(shader);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateGetShaderInfoLog(context, angle::EntryPoint::GLGetShaderInfoLog,
                                             shaderPacked, bufSize, length, infoLog);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLGetShaderInfoLog);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getShaderInfoLog(shaderPacked, bufSize, length, infoLog);
        }
        ANGLE_CAPTURE_GL(GetShaderInfoLog, isCallValid, context, shaderPacked, bufSize, length,
                         infoLog);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetShaderInfoLog);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetShaderPrecisionFormat(GLenum shadertype,
                                             GLenum precisiontype,
                                             GLint *range,
                                             GLint *precision)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLGetShaderPrecisionFormat,
              "context = %d, shadertype = %s, precisiontype = %s, range = 0x%016" PRIxPTR
              ", precision = 0x%016" PRIxPTR "",
              CID(context), GLenumToString(GLESEnum::ShaderType, shadertype),
              GLenumToString(GLESEnum::PrecisionType, precisiontype), (uintptr_t)range,
              (uintptr_t)precision));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetShaderPrecisionFormat(
                    context, angle::EntryPoint::GLGetShaderPrecisionFormat, shadertype,
                    precisiontype, range, precision);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLGetShaderPrecisionFormat);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getShaderPrecisionFormat(shadertype, precisiontype, range, precision);
        }
        ANGLE_CAPTURE_GL(GetShaderPrecisionFormat, isCallValid, context, shadertype, precisiontype,
                         range, precision);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetShaderPrecisionFormat);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetShaderSource(GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *source)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLGetShaderSource,
                            "context = %d, shader = %u, bufSize = %d, length = 0x%016" PRIxPTR
                            ", source = 0x%016" PRIxPTR "",
                            CID(context), shader, bufSize, (uintptr_t)length, (uintptr_t)source));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID shaderPacked = PackParam<ShaderProgramID>(shader);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetShaderSource(context, angle::EntryPoint::GLGetShaderSource,
                                                      shaderPacked, bufSize, length, source);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLGetShaderSource);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getShaderSource(shaderPacked, bufSize, length, source);
        }
        ANGLE_CAPTURE_GL(GetShaderSource, isCallValid, context, shaderPacked, bufSize, length,
                         source);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetShaderSource);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetShaderiv(GLuint shader, GLenum pname, GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLGetShaderiv,
              "context = %d, shader = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
              shader, GLenumToString(GLESEnum::ShaderParameterName, pname), (uintptr_t)params));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID shaderPacked = PackParam<ShaderProgramID>(shader);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetShaderiv(context, angle::EntryPoint::GLGetShaderiv,
                                                  shaderPacked, pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLGetShaderiv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getShaderiv(shaderPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetShaderiv, isCallValid, context, shaderPacked, pname, params);
    }
    else
    {
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

const GLubyte *GL_APIENTRY GL_GetString(GLenum name)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLGetString, "context = %d, name = %s", CID(context),
                            GLenumToString(GLESEnum::StringName, name)));

    const GLubyte *returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetString(context, angle::EntryPoint::GLGetString, name);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue = context->getString(name);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetString, const GLubyte *>();
        }
        ANGLE_CAPTURE_GL(GetString, isCallValid, context, name, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetString);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetString, const GLubyte *>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

void GL_APIENTRY GL_GetTexParameterfv(GLenum target, GLenum pname, GLfloat *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLGetTexParameterfv,
                            "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "",
                            CID(context), GLenumToString(GLESEnum::TextureTarget, target),
                            GLenumToString(GLESEnum::GetTextureParameter, pname),
                            (uintptr_t)params));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetTexParameterfv(
                    context, angle::EntryPoint::GLGetTexParameterfv, targetPacked, pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getTexParameterfv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetTexParameterfv, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetTexParameterfv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetTexParameteriv(GLenum target, GLenum pname, GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLGetTexParameteriv,
                            "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "",
                            CID(context), GLenumToString(GLESEnum::TextureTarget, target),
                            GLenumToString(GLESEnum::GetTextureParameter, pname),
                            (uintptr_t)params));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetTexParameteriv(
                    context, angle::EntryPoint::GLGetTexParameteriv, targetPacked, pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getTexParameteriv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetTexParameteriv, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetTexParameteriv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

GLint GL_APIENTRY GL_GetUniformLocation(GLuint program, const GLchar *name)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLGetUniformLocation,
                            "context = %d, program = %u, name = 0x%016" PRIxPTR "", CID(context),
                            program, (uintptr_t)name));

    GLint returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetUniformLocation(
                    context, angle::EntryPoint::GLGetUniformLocation, programPacked, name);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLGetUniformLocation);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue = context->getUniformLocation(programPacked, name);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetUniformLocation, GLint>();
        }
        ANGLE_CAPTURE_GL(GetUniformLocation, isCallValid, context, programPacked, name,
                         returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetUniformLocation);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetUniformLocation, GLint>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

void GL_APIENTRY GL_GetUniformfv(GLuint program, GLint location, GLfloat *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLGetUniformfv,
                            "context = %d, program = %u, location = %d, params = 0x%016" PRIxPTR "",
                            CID(context), program, location, (uintptr_t)params));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetUniformfv(context, angle::EntryPoint::GLGetUniformfv,
                                                   programPacked, locationPacked, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLGetUniformfv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getUniformfv(programPacked, locationPacked, params);
        }
        ANGLE_CAPTURE_GL(GetUniformfv, isCallValid, context, programPacked, locationPacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetUniformfv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetUniformiv(GLuint program, GLint location, GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLGetUniformiv,
                            "context = %d, program = %u, location = %d, params = 0x%016" PRIxPTR "",
                            CID(context), program, location, (uintptr_t)params));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetUniformiv(context, angle::EntryPoint::GLGetUniformiv,
                                                   programPacked, locationPacked, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLGetUniformiv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getUniformiv(programPacked, locationPacked, params);
        }
        ANGLE_CAPTURE_GL(GetUniformiv, isCallValid, context, programPacked, locationPacked, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetUniformiv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetVertexAttribPointerv(GLuint index, GLenum pname, void **pointer)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLGetVertexAttribPointerv,
                            "context = %d, index = %u, pname = %s, pointer = 0x%016" PRIxPTR "",
                            CID(context), index, GLenumToString(GLESEnum::AllEnums, pname),
                            (uintptr_t)pointer));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetVertexAttribPointerv(
                    context, angle::EntryPoint::GLGetVertexAttribPointerv, index, pname, pointer);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLGetVertexAttribPointerv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getVertexAttribPointerv(index, pname, pointer);
        }
        ANGLE_CAPTURE_GL(GetVertexAttribPointerv, isCallValid, context, index, pname, pointer);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetVertexAttribPointerv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetVertexAttribfv(GLuint index, GLenum pname, GLfloat *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLGetVertexAttribfv,
                            "context = %d, index = %u, pname = %s, params = 0x%016" PRIxPTR "",
                            CID(context), index, GLenumToString(GLESEnum::AllEnums, pname),
                            (uintptr_t)params));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetVertexAttribfv(
                    context, angle::EntryPoint::GLGetVertexAttribfv, index, pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLGetVertexAttribfv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getVertexAttribfv(index, pname, params);
        }
        ANGLE_CAPTURE_GL(GetVertexAttribfv, isCallValid, context, index, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetVertexAttribfv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetVertexAttribiv(GLuint index, GLenum pname, GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLGetVertexAttribiv,
                            "context = %d, index = %u, pname = %s, params = 0x%016" PRIxPTR "",
                            CID(context), index, GLenumToString(GLESEnum::AllEnums, pname),
                            (uintptr_t)params));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetVertexAttribiv(
                    context, angle::EntryPoint::GLGetVertexAttribiv, index, pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLGetVertexAttribiv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getVertexAttribiv(index, pname, params);
        }
        ANGLE_CAPTURE_GL(GetVertexAttribiv, isCallValid, context, index, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetVertexAttribiv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Hint(GLenum target, GLenum mode)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLHint, "context = %d, target = %s, mode = %s", CID(context),
                            GLenumToString(GLESEnum::HintTarget, target),
                            GLenumToString(GLESEnum::HintMode, mode)));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateHint(context->getPrivateState(),
                                           context->getMutableErrorSetForValidation(),
                                           angle::EntryPoint::GLHint, target, mode);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateHint(context->getMutablePrivateState(),
                               context->getMutablePrivateStateCache(), target, mode);
        }
        ANGLE_CAPTURE_GL(Hint, isCallValid, context, target, mode);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLHint);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

GLboolean GL_APIENTRY GL_IsBuffer(GLuint buffer)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLIsBuffer, "context = %d, buffer = %u", CID(context), buffer));

    GLboolean returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        BufferID bufferPacked = PackParam<BufferID>(buffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateIsBuffer(context, angle::EntryPoint::GLIsBuffer, bufferPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue = context->isBuffer(bufferPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsBuffer, GLboolean>();
        }
        ANGLE_CAPTURE_GL(IsBuffer, isCallValid, context, bufferPacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLIsBuffer);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsBuffer, GLboolean>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

GLboolean GL_APIENTRY GL_IsEnabled(GLenum cap)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLIsEnabled, "context = %d, cap = %s", CID(context),
                            GLenumToString(GLESEnum::EnableCap, cap)));

    GLboolean returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateIsEnabled(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLIsEnabled, cap);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue = ContextPrivateIsEnabled(context->getMutablePrivateState(),
                                                  context->getMutablePrivateStateCache(), cap);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsEnabled, GLboolean>();
        }
        ANGLE_CAPTURE_GL(IsEnabled, isCallValid, context, cap, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLIsEnabled);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsEnabled, GLboolean>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

GLboolean GL_APIENTRY GL_IsFramebuffer(GLuint framebuffer)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLIsFramebuffer, "context = %d, framebuffer = %u",
                            CID(context), framebuffer));

    GLboolean returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        FramebufferID framebufferPacked = PackParam<FramebufferID>(framebuffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateIsFramebuffer(context, angle::EntryPoint::GLIsFramebuffer,
                                                    framebufferPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLIsFramebuffer);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue = context->isFramebuffer(framebufferPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsFramebuffer, GLboolean>();
        }
        ANGLE_CAPTURE_GL(IsFramebuffer, isCallValid, context, framebufferPacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLIsFramebuffer);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsFramebuffer, GLboolean>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

GLboolean GL_APIENTRY GL_IsProgram(GLuint program)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLIsProgram, "context = %d, program = %u", CID(context), program));

    GLboolean returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateIsProgram(context, angle::EntryPoint::GLIsProgram, programPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLIsProgram);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue = context->isProgram(programPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsProgram, GLboolean>();
        }
        ANGLE_CAPTURE_GL(IsProgram, isCallValid, context, programPacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLIsProgram);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsProgram, GLboolean>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

GLboolean GL_APIENTRY GL_IsRenderbuffer(GLuint renderbuffer)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLIsRenderbuffer, "context = %d, renderbuffer = %u",
                            CID(context), renderbuffer));

    GLboolean returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        RenderbufferID renderbufferPacked = PackParam<RenderbufferID>(renderbuffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateIsRenderbuffer(context, angle::EntryPoint::GLIsRenderbuffer,
                                                     renderbufferPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLIsRenderbuffer);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue = context->isRenderbuffer(renderbufferPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsRenderbuffer, GLboolean>();
        }
        ANGLE_CAPTURE_GL(IsRenderbuffer, isCallValid, context, renderbufferPacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLIsRenderbuffer);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsRenderbuffer, GLboolean>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

GLboolean GL_APIENTRY GL_IsShader(GLuint shader)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLIsShader, "context = %d, shader = %u", CID(context), shader));

    GLboolean returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID shaderPacked = PackParam<ShaderProgramID>(shader);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateIsShader(context, angle::EntryPoint::GLIsShader, shaderPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLIsShader);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue = context->isShader(shaderPacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsShader, GLboolean>();
        }
        ANGLE_CAPTURE_GL(IsShader, isCallValid, context, shaderPacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLIsShader);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsShader, GLboolean>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

GLboolean GL_APIENTRY GL_IsTexture(GLuint texture)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLIsTexture, "context = %d, texture = %u", CID(context), texture));

    GLboolean returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateIsTexture(context, angle::EntryPoint::GLIsTexture, texturePacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue = context->isTexture(texturePacked);
        }
        else
        {
            returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsTexture, GLboolean>();
        }
        ANGLE_CAPTURE_GL(IsTexture, isCallValid, context, texturePacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLIsTexture);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsTexture, GLboolean>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

void GL_APIENTRY GL_LineWidth(GLfloat width)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLLineWidth, "context = %d, width = %f", CID(context), width));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateLineWidth(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLLineWidth, width);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateLineWidth(context->getMutablePrivateState(),
                                    context->getMutablePrivateStateCache(), width);
        }
        ANGLE_CAPTURE_GL(LineWidth, isCallValid, context, width);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLLineWidth);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_LinkProgram(GLuint program)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLLinkProgram, "context = %d, program = %u", CID(context), program));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateLinkProgram(context, angle::EntryPoint::GLLinkProgram, programPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLLinkProgram);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->linkProgram(programPacked);
        }
        ANGLE_CAPTURE_GL(LinkProgram, isCallValid, context, programPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLLinkProgram);
    }
    egl::Display::GetCurrentThreadUnlockedTailCall()->run(nullptr);
}

void GL_APIENTRY GL_PixelStorei(GLenum pname, GLint param)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLPixelStorei, "context = %d, pname = %s, param = %d",
                            CID(context), GLenumToString(GLESEnum::PixelStoreParameter, pname),
                            param));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidatePixelStorei(context->getPrivateState(),
                                                  context->getMutableErrorSetForValidation(),
                                                  angle::EntryPoint::GLPixelStorei, pname, param);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivatePixelStorei(context->getMutablePrivateState(),
                                      context->getMutablePrivateStateCache(), pname, param);
        }
        ANGLE_CAPTURE_GL(PixelStorei, isCallValid, context, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLPixelStorei);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_PolygonOffset(GLfloat factor, GLfloat units)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLPolygonOffset, "context = %d, factor = %f, units = %f",
                            CID(context), factor, units));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidatePolygonOffset(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLPolygonOffset, factor, units);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivatePolygonOffset(context->getMutablePrivateState(),
                                        context->getMutablePrivateStateCache(), factor, units);
        }
        ANGLE_CAPTURE_GL(PolygonOffset, isCallValid, context, factor, units);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLPolygonOffset);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ReadPixels(GLint x,
                               GLint y,
                               GLsizei width,
                               GLsizei height,
                               GLenum format,
                               GLenum type,
                               void *pixels)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLReadPixels,
                            "context = %d, x = %d, y = %d, width = %d, height = %d, format = %s, "
                            "type = %s, pixels = 0x%016" PRIxPTR "",
                            CID(context), x, y, width, height,
                            GLenumToString(GLESEnum::PixelFormat, format),
                            GLenumToString(GLESEnum::PixelType, type), (uintptr_t)pixels));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        if (context->getState().getPixelLocalStorageActivePlanes() != 0)
        {
            context->endPixelLocalStorageImplicit();
        }
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateReadPixels(context, angle::EntryPoint::GLReadPixels, x, y,
                                                 width, height, format, type, pixels);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->readPixels(x, y, width, height, format, type, pixels);
        }
        ANGLE_CAPTURE_GL(ReadPixels, isCallValid, context, x, y, width, height, format, type,
                         pixels);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLReadPixels);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ReleaseShaderCompiler()
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLReleaseShaderCompiler, "context = %d", CID(context)));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateReleaseShaderCompiler(
                    context, angle::EntryPoint::GLReleaseShaderCompiler);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLReleaseShaderCompiler);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->releaseShaderCompiler();
        }
        ANGLE_CAPTURE_GL(ReleaseShaderCompiler, isCallValid, context);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLReleaseShaderCompiler);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_RenderbufferStorage(GLenum target,
                                        GLenum internalformat,
                                        GLsizei width,
                                        GLsizei height)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLRenderbufferStorage,
              "context = %d, target = %s, internalformat = %s, width = %d, height = %d",
              CID(context), GLenumToString(GLESEnum::RenderbufferTarget, target),
              GLenumToString(GLESEnum::InternalFormat, internalformat), width, height));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateRenderbufferStorage(context, angle::EntryPoint::GLRenderbufferStorage,
                                                target, internalformat, width, height);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLRenderbufferStorage);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->renderbufferStorage(target, internalformat, width, height);
        }
        ANGLE_CAPTURE_GL(RenderbufferStorage, isCallValid, context, target, internalformat, width,
                         height);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLRenderbufferStorage);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_SampleCoverage(GLfloat value, GLboolean invert)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLSampleCoverage, "context = %d, value = %f, invert = %s",
                            CID(context), value, GLbooleanToString(invert)));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateSampleCoverage(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLSampleCoverage, value, invert);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateSampleCoverage(context->getMutablePrivateState(),
                                         context->getMutablePrivateStateCache(), value, invert);
        }
        ANGLE_CAPTURE_GL(SampleCoverage, isCallValid, context, value, invert);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLSampleCoverage);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Scissor(GLint x, GLint y, GLsizei width, GLsizei height)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLScissor,
                            "context = %d, x = %d, y = %d, width = %d, height = %d", CID(context),
                            x, y, width, height));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateScissor(context->getPrivateState(),
                                              context->getMutableErrorSetForValidation(),
                                              angle::EntryPoint::GLScissor, x, y, width, height);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateScissor(context->getMutablePrivateState(),
                                  context->getMutablePrivateStateCache(), x, y, width, height);
        }
        ANGLE_CAPTURE_GL(Scissor, isCallValid, context, x, y, width, height);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLScissor);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ShaderBinary(GLsizei count,
                                 const GLuint *shaders,
                                 GLenum binaryFormat,
                                 const void *binary,
                                 GLsizei length)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLShaderBinary,
                            "context = %d, count = %d, shaders = 0x%016" PRIxPTR
                            ", binaryFormat = %s, binary = 0x%016" PRIxPTR ", length = %d",
                            CID(context), count, (uintptr_t)shaders,
                            GLenumToString(GLESEnum::ShaderBinaryFormat, binaryFormat),
                            (uintptr_t)binary, length));

    if (ANGLE_LIKELY(context != nullptr))
    {
        const ShaderProgramID *shadersPacked = PackParam<const ShaderProgramID *>(shaders);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateShaderBinary(context, angle::EntryPoint::GLShaderBinary, count,
                                         shadersPacked, binaryFormat, binary, length);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLShaderBinary);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->shaderBinary(count, shadersPacked, binaryFormat, binary, length);
        }
        ANGLE_CAPTURE_GL(ShaderBinary, isCallValid, context, count, shadersPacked, binaryFormat,
                         binary, length);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLShaderBinary);
    }
    egl::Display::GetCurrentThreadUnlockedTailCall()->run(nullptr);
}

void GL_APIENTRY GL_ShaderSource(GLuint shader,
                                 GLsizei count,
                                 const GLchar *const *string,
                                 const GLint *length)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLShaderSource,
                            "context = %d, shader = %u, count = %d, string = 0x%016" PRIxPTR
                            ", length = 0x%016" PRIxPTR "",
                            CID(context), shader, count, (uintptr_t)string, (uintptr_t)length));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID shaderPacked = PackParam<ShaderProgramID>(shader);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateShaderSource(context, angle::EntryPoint::GLShaderSource,
                                                   shaderPacked, count, string, length);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLShaderSource);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->shaderSource(shaderPacked, count, string, length);
        }
        ANGLE_CAPTURE_GL(ShaderSource, isCallValid, context, shaderPacked, count, string, length);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLShaderSource);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_StencilFunc(GLenum func, GLint ref, GLuint mask)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLStencilFunc, "context = %d, func = %s, ref = %d, mask = %u",
                            CID(context), GLenumToString(GLESEnum::StencilFunction, func), ref,
                            mask));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateStencilFunc(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLStencilFunc, func, ref, mask);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateStencilFunc(context->getMutablePrivateState(),
                                      context->getMutablePrivateStateCache(), func, ref, mask);
        }
        ANGLE_CAPTURE_GL(StencilFunc, isCallValid, context, func, ref, mask);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLStencilFunc);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_StencilFuncSeparate(GLenum face, GLenum func, GLint ref, GLuint mask)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLStencilFuncSeparate,
                            "context = %d, face = %s, func = %s, ref = %d, mask = %u", CID(context),
                            GLenumToString(GLESEnum::TriangleFace, face),
                            GLenumToString(GLESEnum::StencilFunction, func), ref, mask));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateStencilFuncSeparate(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLStencilFuncSeparate, face, func, ref, mask);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLStencilFuncSeparate);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateStencilFuncSeparate(context->getMutablePrivateState(),
                                              context->getMutablePrivateStateCache(), face, func,
                                              ref, mask);
        }
        ANGLE_CAPTURE_GL(StencilFuncSeparate, isCallValid, context, face, func, ref, mask);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLStencilFuncSeparate);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_StencilMask(GLuint mask)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLStencilMask, "context = %d, mask = %u", CID(context), mask));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateStencilMask(context->getPrivateState(),
                                                  context->getMutableErrorSetForValidation(),
                                                  angle::EntryPoint::GLStencilMask, mask);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateStencilMask(context->getMutablePrivateState(),
                                      context->getMutablePrivateStateCache(), mask);
        }
        ANGLE_CAPTURE_GL(StencilMask, isCallValid, context, mask);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLStencilMask);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_StencilMaskSeparate(GLenum face, GLuint mask)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLStencilMaskSeparate, "context = %d, face = %s, mask = %u",
                            CID(context), GLenumToString(GLESEnum::TriangleFace, face), mask));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateStencilMaskSeparate(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLStencilMaskSeparate, face, mask);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLStencilMaskSeparate);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateStencilMaskSeparate(context->getMutablePrivateState(),
                                              context->getMutablePrivateStateCache(), face, mask);
        }
        ANGLE_CAPTURE_GL(StencilMaskSeparate, isCallValid, context, face, mask);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLStencilMaskSeparate);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_StencilOp(GLenum fail, GLenum zfail, GLenum zpass)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLStencilOp, "context = %d, fail = %s, zfail = %s, zpass = %s",
                            CID(context), GLenumToString(GLESEnum::StencilOp, fail),
                            GLenumToString(GLESEnum::StencilOp, zfail),
                            GLenumToString(GLESEnum::StencilOp, zpass)));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateStencilOp(context->getPrivateState(),
                                                context->getMutableErrorSetForValidation(),
                                                angle::EntryPoint::GLStencilOp, fail, zfail, zpass);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateStencilOp(context->getMutablePrivateState(),
                                    context->getMutablePrivateStateCache(), fail, zfail, zpass);
        }
        ANGLE_CAPTURE_GL(StencilOp, isCallValid, context, fail, zfail, zpass);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLStencilOp);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_StencilOpSeparate(GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(
        context, GLStencilOpSeparate,
        "context = %d, face = %s, sfail = %s, dpfail = %s, dppass = %s", CID(context),
        GLenumToString(GLESEnum::TriangleFace, face), GLenumToString(GLESEnum::StencilOp, sfail),
        GLenumToString(GLESEnum::StencilOp, dpfail), GLenumToString(GLESEnum::StencilOp, dppass)));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateStencilOpSeparate(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLStencilOpSeparate, face, sfail, dpfail, dppass);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLStencilOpSeparate);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateStencilOpSeparate(context->getMutablePrivateState(),
                                            context->getMutablePrivateStateCache(), face, sfail,
                                            dpfail, dppass);
        }
        ANGLE_CAPTURE_GL(StencilOpSeparate, isCallValid, context, face, sfail, dpfail, dppass);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLStencilOpSeparate);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexImage2D(GLenum target,
                               GLint level,
                               GLint internalformat,
                               GLsizei width,
                               GLsizei height,
                               GLint border,
                               GLenum format,
                               GLenum type,
                               const void *pixels)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLTexImage2D,
              "context = %d, target = %s, level = %d, internalformat = %d, width = %d, height = "
              "%d, border = %d, format = %s, type = %s, pixels = 0x%016" PRIxPTR "",
              CID(context), GLenumToString(GLESEnum::TextureTarget, target), level, internalformat,
              width, height, border, GLenumToString(GLESEnum::PixelFormat, format),
              GLenumToString(GLESEnum::PixelType, type), (uintptr_t)pixels));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureTarget targetPacked = PackParam<TextureTarget>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexImage2D(context, angle::EntryPoint::GLTexImage2D,
                                                 targetPacked, level, internalformat, width, height,
                                                 border, format, type, pixels);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texImage2D(targetPacked, level, internalformat, width, height, border, format,
                                type, pixels);
        }
        ANGLE_CAPTURE_GL(TexImage2D, isCallValid, context, targetPacked, level, internalformat,
                         width, height, border, format, type, pixels);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLTexImage2D);
    }
    egl::Display::GetCurrentThreadUnlockedTailCall()->run(nullptr);
}

void GL_APIENTRY GL_TexParameterf(GLenum target, GLenum pname, GLfloat param)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLTexParameterf,
                            "context = %d, target = %s, pname = %s, param = %f", CID(context),
                            GLenumToString(GLESEnum::TextureTarget, target),
                            GLenumToString(GLESEnum::TextureParameterName, pname), param));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexParameterf(context, angle::EntryPoint::GLTexParameterf,
                                                    targetPacked, pname, param);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texParameterf(targetPacked, pname, param);
        }
        ANGLE_CAPTURE_GL(TexParameterf, isCallValid, context, targetPacked, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLTexParameterf);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexParameterfv(GLenum target, GLenum pname, const GLfloat *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLTexParameterfv,
                            "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "",
                            CID(context), GLenumToString(GLESEnum::TextureTarget, target),
                            GLenumToString(GLESEnum::TextureParameterName, pname),
                            (uintptr_t)params));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexParameterfv(context, angle::EntryPoint::GLTexParameterfv,
                                                     targetPacked, pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texParameterfv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(TexParameterfv, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLTexParameterfv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexParameteri(GLenum target, GLenum pname, GLint param)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLTexParameteri,
                            "context = %d, target = %s, pname = %s, param = %d", CID(context),
                            GLenumToString(GLESEnum::TextureTarget, target),
                            GLenumToString(GLESEnum::TextureParameterName, pname), param));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexParameteri(context, angle::EntryPoint::GLTexParameteri,
                                                    targetPacked, pname, param);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texParameteri(targetPacked, pname, param);
        }
        ANGLE_CAPTURE_GL(TexParameteri, isCallValid, context, targetPacked, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLTexParameteri);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexParameteriv(GLenum target, GLenum pname, const GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLTexParameteriv,
                            "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "",
                            CID(context), GLenumToString(GLESEnum::TextureTarget, target),
                            GLenumToString(GLESEnum::TextureParameterName, pname),
                            (uintptr_t)params));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexParameteriv(context, angle::EntryPoint::GLTexParameteriv,
                                                     targetPacked, pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texParameteriv(targetPacked, pname, params);
        }
        ANGLE_CAPTURE_GL(TexParameteriv, isCallValid, context, targetPacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLTexParameteriv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexSubImage2D(GLenum target,
                                  GLint level,
                                  GLint xoffset,
                                  GLint yoffset,
                                  GLsizei width,
                                  GLsizei height,
                                  GLenum format,
                                  GLenum type,
                                  const void *pixels)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLTexSubImage2D,
              "context = %d, target = %s, level = %d, xoffset = %d, yoffset = %d, width = %d, "
              "height = %d, format = %s, type = %s, pixels = 0x%016" PRIxPTR "",
              CID(context), GLenumToString(GLESEnum::TextureTarget, target), level, xoffset,
              yoffset, width, height, GLenumToString(GLESEnum::PixelFormat, format),
              GLenumToString(GLESEnum::PixelType, type), (uintptr_t)pixels));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureTarget targetPacked = PackParam<TextureTarget>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexSubImage2D(context, angle::EntryPoint::GLTexSubImage2D,
                                                    targetPacked, level, xoffset, yoffset, width,
                                                    height, format, type, pixels);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texSubImage2D(targetPacked, level, xoffset, yoffset, width, height, format,
                                   type, pixels);
        }
        ANGLE_CAPTURE_GL(TexSubImage2D, isCallValid, context, targetPacked, level, xoffset, yoffset,
                         width, height, format, type, pixels);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLTexSubImage2D);
    }
    egl::Display::GetCurrentThreadUnlockedTailCall()->run(nullptr);
}

void GL_APIENTRY GL_Uniform1f(GLint location, GLfloat v0)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLUniform1f, "context = %d, location = %d, v0 = %f",
                            CID(context), location, v0));

    if (ANGLE_LIKELY(context != nullptr))
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);

        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateUniform1f(context, angle::EntryPoint::GLUniform1f, locationPacked, v0);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLUniform1f);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->uniform1f(locationPacked, v0);
        }
        ANGLE_CAPTURE_GL(Uniform1f, isCallValid, context, locationPacked, v0);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLUniform1f);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Uniform1fv(GLint location, GLsizei count, const GLfloat *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLUniform1fv,
                            "context = %d, location = %d, count = %d, value = 0x%016" PRIxPTR "",
                            CID(context), location, count, (uintptr_t)value));

    if (ANGLE_LIKELY(context != nullptr))
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);

        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateUniform1fv(context, angle::EntryPoint::GLUniform1fv,
                                                 locationPacked, count, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLUniform1fv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->uniform1fv(locationPacked, count, value);
        }
        ANGLE_CAPTURE_GL(Uniform1fv, isCallValid, context, locationPacked, count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLUniform1fv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Uniform1i(GLint location, GLint v0)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLUniform1i, "context = %d, location = %d, v0 = %d",
                            CID(context), location, v0));

    if (ANGLE_LIKELY(context != nullptr))
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateUniform1i(context, angle::EntryPoint::GLUniform1i, locationPacked, v0);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLUniform1i);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->uniform1i(locationPacked, v0);
        }
        ANGLE_CAPTURE_GL(Uniform1i, isCallValid, context, locationPacked, v0);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLUniform1i);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Uniform1iv(GLint location, GLsizei count, const GLint *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLUniform1iv,
                            "context = %d, location = %d, count = %d, value = 0x%016" PRIxPTR "",
                            CID(context), location, count, (uintptr_t)value));

    if (ANGLE_LIKELY(context != nullptr))
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateUniform1iv(context, angle::EntryPoint::GLUniform1iv,
                                                 locationPacked, count, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLUniform1iv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->uniform1iv(locationPacked, count, value);
        }
        ANGLE_CAPTURE_GL(Uniform1iv, isCallValid, context, locationPacked, count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLUniform1iv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Uniform2f(GLint location, GLfloat v0, GLfloat v1)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLUniform2f, "context = %d, location = %d, v0 = %f, v1 = %f",
                            CID(context), location, v0, v1));

    if (ANGLE_LIKELY(context != nullptr))
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);

        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateUniform2f(context, angle::EntryPoint::GLUniform2f,
                                                locationPacked, v0, v1);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLUniform2f);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->uniform2f(locationPacked, v0, v1);
        }
        ANGLE_CAPTURE_GL(Uniform2f, isCallValid, context, locationPacked, v0, v1);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLUniform2f);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Uniform2fv(GLint location, GLsizei count, const GLfloat *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLUniform2fv,
                            "context = %d, location = %d, count = %d, value = 0x%016" PRIxPTR "",
                            CID(context), location, count, (uintptr_t)value));

    if (ANGLE_LIKELY(context != nullptr))
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);

        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateUniform2fv(context, angle::EntryPoint::GLUniform2fv,
                                                 locationPacked, count, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLUniform2fv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->uniform2fv(locationPacked, count, value);
        }
        ANGLE_CAPTURE_GL(Uniform2fv, isCallValid, context, locationPacked, count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLUniform2fv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Uniform2i(GLint location, GLint v0, GLint v1)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLUniform2i, "context = %d, location = %d, v0 = %d, v1 = %d",
                            CID(context), location, v0, v1));

    if (ANGLE_LIKELY(context != nullptr))
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);

        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateUniform2i(context, angle::EntryPoint::GLUniform2i,
                                                locationPacked, v0, v1);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLUniform2i);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->uniform2i(locationPacked, v0, v1);
        }
        ANGLE_CAPTURE_GL(Uniform2i, isCallValid, context, locationPacked, v0, v1);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLUniform2i);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Uniform2iv(GLint location, GLsizei count, const GLint *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLUniform2iv,
                            "context = %d, location = %d, count = %d, value = 0x%016" PRIxPTR "",
                            CID(context), location, count, (uintptr_t)value));

    if (ANGLE_LIKELY(context != nullptr))
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);

        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateUniform2iv(context, angle::EntryPoint::GLUniform2iv,
                                                 locationPacked, count, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLUniform2iv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->uniform2iv(locationPacked, count, value);
        }
        ANGLE_CAPTURE_GL(Uniform2iv, isCallValid, context, locationPacked, count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLUniform2iv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Uniform3f(GLint location, GLfloat v0, GLfloat v1, GLfloat v2)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLUniform3f,
                            "context = %d, location = %d, v0 = %f, v1 = %f, v2 = %f", CID(context),
                            location, v0, v1, v2));

    if (ANGLE_LIKELY(context != nullptr))
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);

        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateUniform3f(context, angle::EntryPoint::GLUniform3f,
                                                locationPacked, v0, v1, v2);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLUniform3f);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->uniform3f(locationPacked, v0, v1, v2);
        }
        ANGLE_CAPTURE_GL(Uniform3f, isCallValid, context, locationPacked, v0, v1, v2);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLUniform3f);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Uniform3fv(GLint location, GLsizei count, const GLfloat *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLUniform3fv,
                            "context = %d, location = %d, count = %d, value = 0x%016" PRIxPTR "",
                            CID(context), location, count, (uintptr_t)value));

    if (ANGLE_LIKELY(context != nullptr))
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);

        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateUniform3fv(context, angle::EntryPoint::GLUniform3fv,
                                                 locationPacked, count, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLUniform3fv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->uniform3fv(locationPacked, count, value);
        }
        ANGLE_CAPTURE_GL(Uniform3fv, isCallValid, context, locationPacked, count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLUniform3fv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Uniform3i(GLint location, GLint v0, GLint v1, GLint v2)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLUniform3i,
                            "context = %d, location = %d, v0 = %d, v1 = %d, v2 = %d", CID(context),
                            location, v0, v1, v2));

    if (ANGLE_LIKELY(context != nullptr))
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);

        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateUniform3i(context, angle::EntryPoint::GLUniform3i,
                                                locationPacked, v0, v1, v2);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLUniform3i);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->uniform3i(locationPacked, v0, v1, v2);
        }
        ANGLE_CAPTURE_GL(Uniform3i, isCallValid, context, locationPacked, v0, v1, v2);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLUniform3i);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Uniform3iv(GLint location, GLsizei count, const GLint *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLUniform3iv,
                            "context = %d, location = %d, count = %d, value = 0x%016" PRIxPTR "",
                            CID(context), location, count, (uintptr_t)value));

    if (ANGLE_LIKELY(context != nullptr))
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);

        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateUniform3iv(context, angle::EntryPoint::GLUniform3iv,
                                                 locationPacked, count, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLUniform3iv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->uniform3iv(locationPacked, count, value);
        }
        ANGLE_CAPTURE_GL(Uniform3iv, isCallValid, context, locationPacked, count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLUniform3iv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Uniform4f(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLUniform4f,
                            "context = %d, location = %d, v0 = %f, v1 = %f, v2 = %f, v3 = %f",
                            CID(context), location, v0, v1, v2, v3));

    if (ANGLE_LIKELY(context != nullptr))
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);

        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateUniform4f(context, angle::EntryPoint::GLUniform4f,
                                                locationPacked, v0, v1, v2, v3);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLUniform4f);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->uniform4f(locationPacked, v0, v1, v2, v3);
        }
        ANGLE_CAPTURE_GL(Uniform4f, isCallValid, context, locationPacked, v0, v1, v2, v3);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLUniform4f);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Uniform4fv(GLint location, GLsizei count, const GLfloat *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLUniform4fv,
                            "context = %d, location = %d, count = %d, value = 0x%016" PRIxPTR "",
                            CID(context), location, count, (uintptr_t)value));

    if (ANGLE_LIKELY(context != nullptr))
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);

        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateUniform4fv(context, angle::EntryPoint::GLUniform4fv,
                                                 locationPacked, count, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLUniform4fv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->uniform4fv(locationPacked, count, value);
        }
        ANGLE_CAPTURE_GL(Uniform4fv, isCallValid, context, locationPacked, count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLUniform4fv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Uniform4i(GLint location, GLint v0, GLint v1, GLint v2, GLint v3)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLUniform4i,
                            "context = %d, location = %d, v0 = %d, v1 = %d, v2 = %d, v3 = %d",
                            CID(context), location, v0, v1, v2, v3));

    if (ANGLE_LIKELY(context != nullptr))
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);

        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateUniform4i(context, angle::EntryPoint::GLUniform4i,
                                                locationPacked, v0, v1, v2, v3);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLUniform4i);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->uniform4i(locationPacked, v0, v1, v2, v3);
        }
        ANGLE_CAPTURE_GL(Uniform4i, isCallValid, context, locationPacked, v0, v1, v2, v3);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLUniform4i);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Uniform4iv(GLint location, GLsizei count, const GLint *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLUniform4iv,
                            "context = %d, location = %d, count = %d, value = 0x%016" PRIxPTR "",
                            CID(context), location, count, (uintptr_t)value));

    if (ANGLE_LIKELY(context != nullptr))
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);

        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateUniform4iv(context, angle::EntryPoint::GLUniform4iv,
                                                 locationPacked, count, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLUniform4iv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->uniform4iv(locationPacked, count, value);
        }
        ANGLE_CAPTURE_GL(Uniform4iv, isCallValid, context, locationPacked, count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLUniform4iv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_UniformMatrix2fv(GLint location,
                                     GLsizei count,
                                     GLboolean transpose,
                                     const GLfloat *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLUniformMatrix2fv,
              "context = %d, location = %d, count = %d, transpose = %s, value = 0x%016" PRIxPTR "",
              CID(context), location, count, GLbooleanToString(transpose), (uintptr_t)value));

    if (ANGLE_LIKELY(context != nullptr))
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);

        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateUniformMatrix2fv(context, angle::EntryPoint::GLUniformMatrix2fv,
                                             locationPacked, count, transpose, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLUniformMatrix2fv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->uniformMatrix2fv(locationPacked, count, transpose, value);
        }
        ANGLE_CAPTURE_GL(UniformMatrix2fv, isCallValid, context, locationPacked, count, transpose,
                         value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLUniformMatrix2fv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_UniformMatrix3fv(GLint location,
                                     GLsizei count,
                                     GLboolean transpose,
                                     const GLfloat *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLUniformMatrix3fv,
              "context = %d, location = %d, count = %d, transpose = %s, value = 0x%016" PRIxPTR "",
              CID(context), location, count, GLbooleanToString(transpose), (uintptr_t)value));

    if (ANGLE_LIKELY(context != nullptr))
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);

        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateUniformMatrix3fv(context, angle::EntryPoint::GLUniformMatrix3fv,
                                             locationPacked, count, transpose, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLUniformMatrix3fv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->uniformMatrix3fv(locationPacked, count, transpose, value);
        }
        ANGLE_CAPTURE_GL(UniformMatrix3fv, isCallValid, context, locationPacked, count, transpose,
                         value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLUniformMatrix3fv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_UniformMatrix4fv(GLint location,
                                     GLsizei count,
                                     GLboolean transpose,
                                     const GLfloat *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLUniformMatrix4fv,
              "context = %d, location = %d, count = %d, transpose = %s, value = 0x%016" PRIxPTR "",
              CID(context), location, count, GLbooleanToString(transpose), (uintptr_t)value));

    if (ANGLE_LIKELY(context != nullptr))
    {
        UniformLocation locationPacked = PackParam<UniformLocation>(location);

        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateUniformMatrix4fv(context, angle::EntryPoint::GLUniformMatrix4fv,
                                             locationPacked, count, transpose, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLUniformMatrix4fv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->uniformMatrix4fv(locationPacked, count, transpose, value);
        }
        ANGLE_CAPTURE_GL(UniformMatrix4fv, isCallValid, context, locationPacked, count, transpose,
                         value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLUniformMatrix4fv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_UseProgram(GLuint program)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLUseProgram, "context = %d, program = %u", CID(context), program));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateUseProgram(context, angle::EntryPoint::GLUseProgram, programPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLUseProgram);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->useProgram(programPacked);
        }
        ANGLE_CAPTURE_GL(UseProgram, isCallValid, context, programPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLUseProgram);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ValidateProgram(GLuint program)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLValidateProgram, "context = %d, program = %u", CID(context), program));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateValidateProgram(context, angle::EntryPoint::GLValidateProgram,
                                                      programPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLValidateProgram);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->validateProgram(programPacked);
        }
        ANGLE_CAPTURE_GL(ValidateProgram, isCallValid, context, programPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLValidateProgram);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexAttrib1f(GLuint index, GLfloat x)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLVertexAttrib1f, "context = %d, index = %u, x = %f",
                            CID(context), index, x));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateVertexAttrib1f(context->getPrivateState(),
                                                     context->getMutableErrorSetForValidation(),
                                                     angle::EntryPoint::GLVertexAttrib1f, index, x);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLVertexAttrib1f);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateVertexAttrib1f(context->getMutablePrivateState(),
                                         context->getMutablePrivateStateCache(), index, x);
        }
        ANGLE_CAPTURE_GL(VertexAttrib1f, isCallValid, context, index, x);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLVertexAttrib1f);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexAttrib1fv(GLuint index, const GLfloat *v)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLVertexAttrib1fv,
                            "context = %d, index = %u, v = 0x%016" PRIxPTR "", CID(context), index,
                            (uintptr_t)v));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateVertexAttrib1fv(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLVertexAttrib1fv, index, v);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLVertexAttrib1fv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateVertexAttrib1fv(context->getMutablePrivateState(),
                                          context->getMutablePrivateStateCache(), index, v);
        }
        ANGLE_CAPTURE_GL(VertexAttrib1fv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLVertexAttrib1fv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexAttrib2f(GLuint index, GLfloat x, GLfloat y)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLVertexAttrib2f, "context = %d, index = %u, x = %f, y = %f",
                            CID(context), index, x, y));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateVertexAttrib2f(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLVertexAttrib2f, index, x, y);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLVertexAttrib2f);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateVertexAttrib2f(context->getMutablePrivateState(),
                                         context->getMutablePrivateStateCache(), index, x, y);
        }
        ANGLE_CAPTURE_GL(VertexAttrib2f, isCallValid, context, index, x, y);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLVertexAttrib2f);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexAttrib2fv(GLuint index, const GLfloat *v)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLVertexAttrib2fv,
                            "context = %d, index = %u, v = 0x%016" PRIxPTR "", CID(context), index,
                            (uintptr_t)v));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateVertexAttrib2fv(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLVertexAttrib2fv, index, v);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLVertexAttrib2fv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateVertexAttrib2fv(context->getMutablePrivateState(),
                                          context->getMutablePrivateStateCache(), index, v);
        }
        ANGLE_CAPTURE_GL(VertexAttrib2fv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLVertexAttrib2fv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexAttrib3f(GLuint index, GLfloat x, GLfloat y, GLfloat z)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLVertexAttrib3f,
                            "context = %d, index = %u, x = %f, y = %f, z = %f", CID(context), index,
                            x, y, z));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateVertexAttrib3f(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLVertexAttrib3f, index, x, y, z);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLVertexAttrib3f);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateVertexAttrib3f(context->getMutablePrivateState(),
                                         context->getMutablePrivateStateCache(), index, x, y, z);
        }
        ANGLE_CAPTURE_GL(VertexAttrib3f, isCallValid, context, index, x, y, z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLVertexAttrib3f);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexAttrib3fv(GLuint index, const GLfloat *v)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLVertexAttrib3fv,
                            "context = %d, index = %u, v = 0x%016" PRIxPTR "", CID(context), index,
                            (uintptr_t)v));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateVertexAttrib3fv(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLVertexAttrib3fv, index, v);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLVertexAttrib3fv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateVertexAttrib3fv(context->getMutablePrivateState(),
                                          context->getMutablePrivateStateCache(), index, v);
        }
        ANGLE_CAPTURE_GL(VertexAttrib3fv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLVertexAttrib3fv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexAttrib4f(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLVertexAttrib4f,
                            "context = %d, index = %u, x = %f, y = %f, z = %f, w = %f",
                            CID(context), index, x, y, z, w));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateVertexAttrib4f(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLVertexAttrib4f, index, x, y, z, w);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLVertexAttrib4f);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateVertexAttrib4f(context->getMutablePrivateState(),
                                         context->getMutablePrivateStateCache(), index, x, y, z, w);
        }
        ANGLE_CAPTURE_GL(VertexAttrib4f, isCallValid, context, index, x, y, z, w);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLVertexAttrib4f);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexAttrib4fv(GLuint index, const GLfloat *v)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLVertexAttrib4fv,
                            "context = %d, index = %u, v = 0x%016" PRIxPTR "", CID(context), index,
                            (uintptr_t)v));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateVertexAttrib4fv(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLVertexAttrib4fv, index, v);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLVertexAttrib4fv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateVertexAttrib4fv(context->getMutablePrivateState(),
                                          context->getMutablePrivateStateCache(), index, v);
        }
        ANGLE_CAPTURE_GL(VertexAttrib4fv, isCallValid, context, index, v);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLVertexAttrib4fv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexAttribPointer(GLuint index,
                                        GLint size,
                                        GLenum type,
                                        GLboolean normalized,
                                        GLsizei stride,
                                        const void *pointer)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLVertexAttribPointer,
                            "context = %d, index = %u, size = %d, type = %s, normalized = %s, "
                            "stride = %d, pointer = 0x%016" PRIxPTR "",
                            CID(context), index, size,
                            GLenumToString(GLESEnum::VertexAttribPointerType, type),
                            GLbooleanToString(normalized), stride, (uintptr_t)pointer));

    if (ANGLE_LIKELY(context != nullptr))
    {
        VertexAttribType typePacked = PackParam<VertexAttribType>(type);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_2_0))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateVertexAttribPointer(
                    context, angle::EntryPoint::GLVertexAttribPointer, index, size, typePacked,
                    normalized, stride, pointer);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES20(context, angle::EntryPoint::GLVertexAttribPointer);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->vertexAttribPointer(index, size, typePacked, normalized, stride, pointer);
        }
        ANGLE_CAPTURE_GL(VertexAttribPointer, isCallValid, context, index, size, typePacked,
                         normalized, stride, pointer);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLVertexAttribPointer);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_Viewport(GLint x, GLint y, GLsizei width, GLsizei height)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLViewport,
                            "context = %d, x = %d, y = %d, width = %d, height = %d", CID(context),
                            x, y, width, height));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(true))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateViewport(context->getPrivateState(),
                                               context->getMutableErrorSetForValidation(),
                                               angle::EntryPoint::GLViewport, x, y, width, height);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateViewport(context->getMutablePrivateState(),
                                   context->getMutablePrivateStateCache(), x, y, width, height);
        }
        ANGLE_CAPTURE_GL(Viewport, isCallValid, context, x, y, width, height);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLViewport);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

}  // extern "C"
