// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml.
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// entry_points_gles_3_1_autogen.cpp:
//   Defines the GLES 3.1 entry points.

#include "libGLESv2/entry_points_gles_3_1_autogen.h"

#include "common/entry_points_enum_autogen.h"
#include "common/gl_enum_utils.h"
#include "libANGLE/Context.h"
#include "libANGLE/Context.inl.h"
#include "libANGLE/capture/capture_gles_3_1_autogen.h"
#include "libANGLE/context_private_call.inl.h"
#include "libANGLE/context_private_call_autogen.h"
#include "libANGLE/entry_points_utils.h"
#include "libANGLE/validationES31.h"
#include "libGLESv2/global_state.h"

using namespace gl;

extern "C" {
void GL_APIENTRY GL_ActiveShaderProgram(GLuint pipeline, GLuint program)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLActiveShaderProgram,
                            "context = %d, pipeline = %u, program = %u", CID(context), pipeline,
                            program));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ProgramPipelineID pipelinePacked = PackParam<ProgramPipelineID>(pipeline);
        ShaderProgramID programPacked    = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateActiveShaderProgram(context, angle::EntryPoint::GLActiveShaderProgram,
                                                pipelinePacked, programPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLActiveShaderProgram);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->activeShaderProgram(pipelinePacked, programPacked);
        }
        ANGLE_CAPTURE_GL(ActiveShaderProgram, isCallValid, context, pipelinePacked, programPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLActiveShaderProgram);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_BindImageTexture(GLuint unit,
                                     GLuint texture,
                                     GLint level,
                                     GLboolean layered,
                                     GLint layer,
                                     GLenum access,
                                     GLenum format)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLBindImageTexture,
                            "context = %d, unit = %u, texture = %u, level = %d, layered = %s, "
                            "layer = %d, access = %s, format = %s",
                            CID(context), unit, texture, level, GLbooleanToString(layered), layer,
                            GLenumToString(GLESEnum::BufferAccessARB, access),
                            GLenumToString(GLESEnum::InternalFormat, format)));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureID texturePacked = PackParam<TextureID>(texture);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateBindImageTexture(context, angle::EntryPoint::GLBindImageTexture, unit,
                                             texturePacked, level, layered, layer, access, format);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLBindImageTexture);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->bindImageTexture(unit, texturePacked, level, layered, layer, access, format);
        }
        ANGLE_CAPTURE_GL(BindImageTexture, isCallValid, context, unit, texturePacked, level,
                         layered, layer, access, format);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLBindImageTexture);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_BindProgramPipeline(GLuint pipeline)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLBindProgramPipeline, "context = %d, pipeline = %u",
                            CID(context), pipeline));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ProgramPipelineID pipelinePacked = PackParam<ProgramPipelineID>(pipeline);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateBindProgramPipeline(
                    context, angle::EntryPoint::GLBindProgramPipeline, pipelinePacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLBindProgramPipeline);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->bindProgramPipeline(pipelinePacked);
        }
        ANGLE_CAPTURE_GL(BindProgramPipeline, isCallValid, context, pipelinePacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLBindProgramPipeline);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_BindVertexBuffer(GLuint bindingindex,
                                     GLuint buffer,
                                     GLintptr offset,
                                     GLsizei stride)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLBindVertexBuffer,
              "context = %d, bindingindex = %u, buffer = %u, offset = %llu, stride = %d",
              CID(context), bindingindex, buffer, static_cast<unsigned long long>(offset), stride));

    if (ANGLE_LIKELY(context != nullptr))
    {
        BufferID bufferPacked = PackParam<BufferID>(buffer);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateBindVertexBuffer(context, angle::EntryPoint::GLBindVertexBuffer,
                                             bindingindex, bufferPacked, offset, stride);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLBindVertexBuffer);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->bindVertexBuffer(bindingindex, bufferPacked, offset, stride);
        }
        ANGLE_CAPTURE_GL(BindVertexBuffer, isCallValid, context, bindingindex, bufferPacked, offset,
                         stride);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLBindVertexBuffer);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

GLuint GL_APIENTRY GL_CreateShaderProgramv(GLenum type, GLsizei count, const GLchar *const *strings)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLCreateShaderProgramv,
                            "context = %d, type = %s, count = %d, strings = 0x%016" PRIxPTR "",
                            CID(context), GLenumToString(GLESEnum::ShaderType, type), count,
                            (uintptr_t)strings));

    GLuint returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderType typePacked = PackParam<ShaderType>(type);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateCreateShaderProgramv(
                    context, angle::EntryPoint::GLCreateShaderProgramv, typePacked, count, strings);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLCreateShaderProgramv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue = context->createShaderProgramv(typePacked, count, strings);
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLCreateShaderProgramv, GLuint>();
        }
        ANGLE_CAPTURE_GL(CreateShaderProgramv, isCallValid, context, typePacked, count, strings,
                         returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLCreateShaderProgramv);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLCreateShaderProgramv, GLuint>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

void GL_APIENTRY GL_DeleteProgramPipelines(GLsizei n, const GLuint *pipelines)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLDeleteProgramPipelines,
                            "context = %d, n = %d, pipelines = 0x%016" PRIxPTR "", CID(context), n,
                            (uintptr_t)pipelines));

    if (ANGLE_LIKELY(context != nullptr))
    {
        const ProgramPipelineID *pipelinesPacked = PackParam<const ProgramPipelineID *>(pipelines);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDeleteProgramPipelines(
                    context, angle::EntryPoint::GLDeleteProgramPipelines, n, pipelinesPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLDeleteProgramPipelines);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->deleteProgramPipelines(n, pipelinesPacked);
        }
        ANGLE_CAPTURE_GL(DeleteProgramPipelines, isCallValid, context, n, pipelinesPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDeleteProgramPipelines);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DispatchCompute(GLuint num_groups_x, GLuint num_groups_y, GLuint num_groups_z)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLDispatchCompute,
                            "context = %d, num_groups_x = %u, num_groups_y = %u, num_groups_z = %u",
                            CID(context), num_groups_x, num_groups_y, num_groups_z));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDispatchCompute(context, angle::EntryPoint::GLDispatchCompute,
                                                      num_groups_x, num_groups_y, num_groups_z);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLDispatchCompute);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->dispatchCompute(num_groups_x, num_groups_y, num_groups_z);
        }
        ANGLE_CAPTURE_GL(DispatchCompute, isCallValid, context, num_groups_x, num_groups_y,
                         num_groups_z);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDispatchCompute);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DispatchComputeIndirect(GLintptr indirect)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLDispatchComputeIndirect, "context = %d, indirect = %llu",
                            CID(context), static_cast<unsigned long long>(indirect)));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDispatchComputeIndirect(
                    context, angle::EntryPoint::GLDispatchComputeIndirect, indirect);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLDispatchComputeIndirect);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->dispatchComputeIndirect(indirect);
        }
        ANGLE_CAPTURE_GL(DispatchComputeIndirect, isCallValid, context, indirect);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLDispatchComputeIndirect);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DrawArraysIndirect(GLenum mode, const void *indirect)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLDrawArraysIndirect,
                            "context = %d, mode = %s, indirect = 0x%016" PRIxPTR "", CID(context),
                            GLenumToString(GLESEnum::PrimitiveType, mode), (uintptr_t)indirect));

    if (ANGLE_LIKELY(context != nullptr))
    {
        PrimitiveMode modePacked = PackParam<PrimitiveMode>(mode);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateDrawArraysIndirect(
                    context, angle::EntryPoint::GLDrawArraysIndirect, modePacked, indirect);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLDrawArraysIndirect);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->drawArraysIndirect(modePacked, indirect);
        }
        ANGLE_CAPTURE_GL(DrawArraysIndirect, isCallValid, context, modePacked, indirect);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDrawArraysIndirect);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_DrawElementsIndirect(GLenum mode, GLenum type, const void *indirect)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLDrawElementsIndirect,
                            "context = %d, mode = %s, type = %s, indirect = 0x%016" PRIxPTR "",
                            CID(context), GLenumToString(GLESEnum::PrimitiveType, mode),
                            GLenumToString(GLESEnum::DrawElementsType, type), (uintptr_t)indirect));

    if (ANGLE_LIKELY(context != nullptr))
    {
        PrimitiveMode modePacked    = PackParam<PrimitiveMode>(mode);
        DrawElementsType typePacked = PackParam<DrawElementsType>(type);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateDrawElementsIndirect(context, angle::EntryPoint::GLDrawElementsIndirect,
                                                 modePacked, typePacked, indirect);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLDrawElementsIndirect);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->drawElementsIndirect(modePacked, typePacked, indirect);
        }
        ANGLE_CAPTURE_GL(DrawElementsIndirect, isCallValid, context, modePacked, typePacked,
                         indirect);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLDrawElementsIndirect);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_FramebufferParameteri(GLenum target, GLenum pname, GLint param)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLFramebufferParameteri,
                            "context = %d, target = %s, pname = %s, param = %d", CID(context),
                            GLenumToString(GLESEnum::FramebufferTarget, target),
                            GLenumToString(GLESEnum::FramebufferParameterName, pname), param));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        if (context->getState().getPixelLocalStorageActivePlanes() != 0)
        {
            context->endPixelLocalStorageImplicit();
        }
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateFramebufferParameteri(
                    context, angle::EntryPoint::GLFramebufferParameteri, target, pname, param);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLFramebufferParameteri);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->framebufferParameteri(target, pname, param);
        }
        ANGLE_CAPTURE_GL(FramebufferParameteri, isCallValid, context, target, pname, param);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLFramebufferParameteri);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GenProgramPipelines(GLsizei n, GLuint *pipelines)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLGenProgramPipelines,
                            "context = %d, n = %d, pipelines = 0x%016" PRIxPTR "", CID(context), n,
                            (uintptr_t)pipelines));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ProgramPipelineID *pipelinesPacked = PackParam<ProgramPipelineID *>(pipelines);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGenProgramPipelines(
                    context, angle::EntryPoint::GLGenProgramPipelines, n, pipelinesPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLGenProgramPipelines);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->genProgramPipelines(n, pipelinesPacked);
        }
        ANGLE_CAPTURE_GL(GenProgramPipelines, isCallValid, context, n, pipelinesPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGenProgramPipelines);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetBooleani_v(GLenum target, GLuint index, GLboolean *data)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(
        context, GLGetBooleani_v, "context = %d, target = %s, index = %u, data = 0x%016" PRIxPTR "",
        CID(context), GLenumToString(GLESEnum::BufferTargetARB, target), index, (uintptr_t)data));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetBooleani_v(context, angle::EntryPoint::GLGetBooleani_v,
                                                    target, index, data);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLGetBooleani_v);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getBooleani_v(target, index, data);
        }
        ANGLE_CAPTURE_GL(GetBooleani_v, isCallValid, context, target, index, data);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetBooleani_v);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetFramebufferParameteriv(GLenum target, GLenum pname, GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLGetFramebufferParameteriv,
                            "context = %d, target = %s, pname = %s, params = 0x%016" PRIxPTR "",
                            CID(context), GLenumToString(GLESEnum::FramebufferTarget, target),
                            GLenumToString(GLESEnum::FramebufferAttachmentParameterName, pname),
                            (uintptr_t)params));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetFramebufferParameteriv(
                    context, angle::EntryPoint::GLGetFramebufferParameteriv, target, pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLGetFramebufferParameteriv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getFramebufferParameteriv(target, pname, params);
        }
        ANGLE_CAPTURE_GL(GetFramebufferParameteriv, isCallValid, context, target, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetFramebufferParameteriv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetMultisamplefv(GLenum pname, GLuint index, GLfloat *val)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLGetMultisamplefv,
                            "context = %d, pname = %s, index = %u, val = 0x%016" PRIxPTR "",
                            CID(context), GLenumToString(GLESEnum::AllEnums, pname), index,
                            (uintptr_t)val));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetMultisamplefv(
                    context, angle::EntryPoint::GLGetMultisamplefv, pname, index, val);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLGetMultisamplefv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getMultisamplefv(pname, index, val);
        }
        ANGLE_CAPTURE_GL(GetMultisamplefv, isCallValid, context, pname, index, val);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetMultisamplefv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetProgramInterfaceiv(GLuint program,
                                          GLenum programInterface,
                                          GLenum pname,
                                          GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(
        context, GLGetProgramInterfaceiv,
        "context = %d, program = %u, programInterface = %s, pname = %s, params = 0x%016" PRIxPTR "",
        CID(context), program, GLenumToString(GLESEnum::ProgramInterface, programInterface),
        GLenumToString(GLESEnum::ProgramInterfacePName, pname), (uintptr_t)params));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetProgramInterfaceiv(
                    context, angle::EntryPoint::GLGetProgramInterfaceiv, programPacked,
                    programInterface, pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLGetProgramInterfaceiv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getProgramInterfaceiv(programPacked, programInterface, pname, params);
        }
        ANGLE_CAPTURE_GL(GetProgramInterfaceiv, isCallValid, context, programPacked,
                         programInterface, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetProgramInterfaceiv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetProgramPipelineInfoLog(GLuint pipeline,
                                              GLsizei bufSize,
                                              GLsizei *length,
                                              GLchar *infoLog)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLGetProgramPipelineInfoLog,
                            "context = %d, pipeline = %u, bufSize = %d, length = 0x%016" PRIxPTR
                            ", infoLog = 0x%016" PRIxPTR "",
                            CID(context), pipeline, bufSize, (uintptr_t)length,
                            (uintptr_t)infoLog));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ProgramPipelineID pipelinePacked = PackParam<ProgramPipelineID>(pipeline);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetProgramPipelineInfoLog(
                    context, angle::EntryPoint::GLGetProgramPipelineInfoLog, pipelinePacked,
                    bufSize, length, infoLog);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLGetProgramPipelineInfoLog);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getProgramPipelineInfoLog(pipelinePacked, bufSize, length, infoLog);
        }
        ANGLE_CAPTURE_GL(GetProgramPipelineInfoLog, isCallValid, context, pipelinePacked, bufSize,
                         length, infoLog);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetProgramPipelineInfoLog);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetProgramPipelineiv(GLuint pipeline, GLenum pname, GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLGetProgramPipelineiv,
              "context = %d, pipeline = %u, pname = %s, params = 0x%016" PRIxPTR "", CID(context),
              pipeline, GLenumToString(GLESEnum::PipelineParameterName, pname), (uintptr_t)params));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ProgramPipelineID pipelinePacked = PackParam<ProgramPipelineID>(pipeline);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateGetProgramPipelineiv(context, angle::EntryPoint::GLGetProgramPipelineiv,
                                                 pipelinePacked, pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLGetProgramPipelineiv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getProgramPipelineiv(pipelinePacked, pname, params);
        }
        ANGLE_CAPTURE_GL(GetProgramPipelineiv, isCallValid, context, pipelinePacked, pname, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetProgramPipelineiv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

GLuint GL_APIENTRY GL_GetProgramResourceIndex(GLuint program,
                                              GLenum programInterface,
                                              const GLchar *name)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(
        context, GLGetProgramResourceIndex,
        "context = %d, program = %u, programInterface = %s, name = 0x%016" PRIxPTR "", CID(context),
        program, GLenumToString(GLESEnum::ProgramInterface, programInterface), (uintptr_t)name));

    GLuint returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetProgramResourceIndex(
                    context, angle::EntryPoint::GLGetProgramResourceIndex, programPacked,
                    programInterface, name);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLGetProgramResourceIndex);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue = context->getProgramResourceIndex(programPacked, programInterface, name);
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLGetProgramResourceIndex, GLuint>();
        }
        ANGLE_CAPTURE_GL(GetProgramResourceIndex, isCallValid, context, programPacked,
                         programInterface, name, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetProgramResourceIndex);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLGetProgramResourceIndex, GLuint>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

GLint GL_APIENTRY GL_GetProgramResourceLocation(GLuint program,
                                                GLenum programInterface,
                                                const GLchar *name)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(
        context, GLGetProgramResourceLocation,
        "context = %d, program = %u, programInterface = %s, name = 0x%016" PRIxPTR "", CID(context),
        program, GLenumToString(GLESEnum::ProgramInterface, programInterface), (uintptr_t)name));

    GLint returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetProgramResourceLocation(
                    context, angle::EntryPoint::GLGetProgramResourceLocation, programPacked,
                    programInterface, name);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLGetProgramResourceLocation);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue =
                context->getProgramResourceLocation(programPacked, programInterface, name);
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLGetProgramResourceLocation, GLint>();
        }
        ANGLE_CAPTURE_GL(GetProgramResourceLocation, isCallValid, context, programPacked,
                         programInterface, name, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLGetProgramResourceLocation);
        returnValue =
            GetDefaultReturnValue<angle::EntryPoint::GLGetProgramResourceLocation, GLint>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

void GL_APIENTRY GL_GetProgramResourceName(GLuint program,
                                           GLenum programInterface,
                                           GLuint index,
                                           GLsizei bufSize,
                                           GLsizei *length,
                                           GLchar *name)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLGetProgramResourceName,
                            "context = %d, program = %u, programInterface = %s, index = %u, "
                            "bufSize = %d, length = 0x%016" PRIxPTR ", name = 0x%016" PRIxPTR "",
                            CID(context), program,
                            GLenumToString(GLESEnum::ProgramInterface, programInterface), index,
                            bufSize, (uintptr_t)length, (uintptr_t)name));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetProgramResourceName(
                    context, angle::EntryPoint::GLGetProgramResourceName, programPacked,
                    programInterface, index, bufSize, length, name);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLGetProgramResourceName);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getProgramResourceName(programPacked, programInterface, index, bufSize, length,
                                            name);
        }
        ANGLE_CAPTURE_GL(GetProgramResourceName, isCallValid, context, programPacked,
                         programInterface, index, bufSize, length, name);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetProgramResourceName);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetProgramResourceiv(GLuint program,
                                         GLenum programInterface,
                                         GLuint index,
                                         GLsizei propCount,
                                         const GLenum *props,
                                         GLsizei count,
                                         GLsizei *length,
                                         GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(
        context, GLGetProgramResourceiv,
        "context = %d, program = %u, programInterface = %s, index = %u, propCount = %d, props = "
        "0x%016" PRIxPTR ", count = %d, length = 0x%016" PRIxPTR ", params = 0x%016" PRIxPTR "",
        CID(context), program, GLenumToString(GLESEnum::ProgramInterface, programInterface), index,
        propCount, (uintptr_t)props, count, (uintptr_t)length, (uintptr_t)params));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetProgramResourceiv(
                    context, angle::EntryPoint::GLGetProgramResourceiv, programPacked,
                    programInterface, index, propCount, props, count, length, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLGetProgramResourceiv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getProgramResourceiv(programPacked, programInterface, index, propCount, props,
                                          count, length, params);
        }
        ANGLE_CAPTURE_GL(GetProgramResourceiv, isCallValid, context, programPacked,
                         programInterface, index, propCount, props, count, length, params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetProgramResourceiv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetTexLevelParameterfv(GLenum target,
                                           GLint level,
                                           GLenum pname,
                                           GLfloat *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLGetTexLevelParameterfv,
              "context = %d, target = %s, level = %d, pname = %s, params = 0x%016" PRIxPTR "",
              CID(context), GLenumToString(GLESEnum::TextureTarget, target), level,
              GLenumToString(GLESEnum::GetTextureParameter, pname), (uintptr_t)params));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureTarget targetPacked = PackParam<TextureTarget>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetTexLevelParameterfv(
                    context, angle::EntryPoint::GLGetTexLevelParameterfv, targetPacked, level,
                    pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLGetTexLevelParameterfv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getTexLevelParameterfv(targetPacked, level, pname, params);
        }
        ANGLE_CAPTURE_GL(GetTexLevelParameterfv, isCallValid, context, targetPacked, level, pname,
                         params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetTexLevelParameterfv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_GetTexLevelParameteriv(GLenum target, GLint level, GLenum pname, GLint *params)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLGetTexLevelParameteriv,
              "context = %d, target = %s, level = %d, pname = %s, params = 0x%016" PRIxPTR "",
              CID(context), GLenumToString(GLESEnum::TextureTarget, target), level,
              GLenumToString(GLESEnum::GetTextureParameter, pname), (uintptr_t)params));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureTarget targetPacked = PackParam<TextureTarget>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateGetTexLevelParameteriv(
                    context, angle::EntryPoint::GLGetTexLevelParameteriv, targetPacked, level,
                    pname, params);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLGetTexLevelParameteriv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->getTexLevelParameteriv(targetPacked, level, pname, params);
        }
        ANGLE_CAPTURE_GL(GetTexLevelParameteriv, isCallValid, context, targetPacked, level, pname,
                         params);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLGetTexLevelParameteriv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

GLboolean GL_APIENTRY GL_IsProgramPipeline(GLuint pipeline)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLIsProgramPipeline, "context = %d, pipeline = %u", CID(context), pipeline));

    GLboolean returnValue;
    if (ANGLE_LIKELY(context != nullptr))
    {
        ProgramPipelineID pipelinePacked = PackParam<ProgramPipelineID>(pipeline);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateIsProgramPipeline(
                    context, angle::EntryPoint::GLIsProgramPipeline, pipelinePacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLIsProgramPipeline);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            returnValue = context->isProgramPipeline(pipelinePacked);
        }
        else
        {
            returnValue =
                GetDefaultReturnValue<angle::EntryPoint::GLIsProgramPipeline, GLboolean>();
        }
        ANGLE_CAPTURE_GL(IsProgramPipeline, isCallValid, context, pipelinePacked, returnValue);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLIsProgramPipeline);
        returnValue = GetDefaultReturnValue<angle::EntryPoint::GLIsProgramPipeline, GLboolean>();
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    return returnValue;
}

void GL_APIENTRY GL_MemoryBarrier(GLbitfield barriers)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLMemoryBarrier, "context = %d, barriers = %s", CID(context),
                            GLbitfieldToString(GLESEnum::MemoryBarrierMask, barriers).c_str()));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateMemoryBarrier(context, angle::EntryPoint::GLMemoryBarrier, barriers);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLMemoryBarrier);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->memoryBarrier(barriers);
        }
        ANGLE_CAPTURE_GL(MemoryBarrier, isCallValid, context, barriers);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLMemoryBarrier);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_MemoryBarrierByRegion(GLbitfield barriers)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLMemoryBarrierByRegion, "context = %d, barriers = %s",
                            CID(context),
                            GLbitfieldToString(GLESEnum::MemoryBarrierMask, barriers).c_str()));

    if (ANGLE_LIKELY(context != nullptr))
    {
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateMemoryBarrierByRegion(
                    context, angle::EntryPoint::GLMemoryBarrierByRegion, barriers);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLMemoryBarrierByRegion);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->memoryBarrierByRegion(barriers);
        }
        ANGLE_CAPTURE_GL(MemoryBarrierByRegion, isCallValid, context, barriers);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLMemoryBarrierByRegion);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniform1f(GLuint program, GLint location, GLfloat v0)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLProgramUniform1f,
                            "context = %d, program = %u, location = %d, v0 = %f", CID(context),
                            program, location, v0));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform1f(context, angle::EntryPoint::GLProgramUniform1f,
                                             programPacked, locationPacked, v0);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLProgramUniform1f);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform1f(programPacked, locationPacked, v0);
        }
        ANGLE_CAPTURE_GL(ProgramUniform1f, isCallValid, context, programPacked, locationPacked, v0);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform1f);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniform1fv(GLuint program,
                                      GLint location,
                                      GLsizei count,
                                      const GLfloat *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLProgramUniform1fv,
              "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
              CID(context), program, location, count, (uintptr_t)value));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform1fv(context, angle::EntryPoint::GLProgramUniform1fv,
                                              programPacked, locationPacked, count, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLProgramUniform1fv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform1fv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE_GL(ProgramUniform1fv, isCallValid, context, programPacked, locationPacked,
                         count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform1fv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniform1i(GLuint program, GLint location, GLint v0)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLProgramUniform1i,
                            "context = %d, program = %u, location = %d, v0 = %d", CID(context),
                            program, location, v0));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform1i(context, angle::EntryPoint::GLProgramUniform1i,
                                             programPacked, locationPacked, v0);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLProgramUniform1i);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform1i(programPacked, locationPacked, v0);
        }
        ANGLE_CAPTURE_GL(ProgramUniform1i, isCallValid, context, programPacked, locationPacked, v0);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform1i);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniform1iv(GLuint program,
                                      GLint location,
                                      GLsizei count,
                                      const GLint *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLProgramUniform1iv,
              "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
              CID(context), program, location, count, (uintptr_t)value));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform1iv(context, angle::EntryPoint::GLProgramUniform1iv,
                                              programPacked, locationPacked, count, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLProgramUniform1iv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform1iv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE_GL(ProgramUniform1iv, isCallValid, context, programPacked, locationPacked,
                         count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform1iv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniform1ui(GLuint program, GLint location, GLuint v0)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLProgramUniform1ui,
                            "context = %d, program = %u, location = %d, v0 = %u", CID(context),
                            program, location, v0));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform1ui(context, angle::EntryPoint::GLProgramUniform1ui,
                                              programPacked, locationPacked, v0);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLProgramUniform1ui);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform1ui(programPacked, locationPacked, v0);
        }
        ANGLE_CAPTURE_GL(ProgramUniform1ui, isCallValid, context, programPacked, locationPacked,
                         v0);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform1ui);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniform1uiv(GLuint program,
                                       GLint location,
                                       GLsizei count,
                                       const GLuint *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLProgramUniform1uiv,
              "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
              CID(context), program, location, count, (uintptr_t)value));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform1uiv(context, angle::EntryPoint::GLProgramUniform1uiv,
                                               programPacked, locationPacked, count, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLProgramUniform1uiv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform1uiv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE_GL(ProgramUniform1uiv, isCallValid, context, programPacked, locationPacked,
                         count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform1uiv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniform2f(GLuint program, GLint location, GLfloat v0, GLfloat v1)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLProgramUniform2f,
                            "context = %d, program = %u, location = %d, v0 = %f, v1 = %f",
                            CID(context), program, location, v0, v1));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform2f(context, angle::EntryPoint::GLProgramUniform2f,
                                             programPacked, locationPacked, v0, v1);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLProgramUniform2f);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform2f(programPacked, locationPacked, v0, v1);
        }
        ANGLE_CAPTURE_GL(ProgramUniform2f, isCallValid, context, programPacked, locationPacked, v0,
                         v1);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform2f);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniform2fv(GLuint program,
                                      GLint location,
                                      GLsizei count,
                                      const GLfloat *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLProgramUniform2fv,
              "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
              CID(context), program, location, count, (uintptr_t)value));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform2fv(context, angle::EntryPoint::GLProgramUniform2fv,
                                              programPacked, locationPacked, count, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLProgramUniform2fv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform2fv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE_GL(ProgramUniform2fv, isCallValid, context, programPacked, locationPacked,
                         count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform2fv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniform2i(GLuint program, GLint location, GLint v0, GLint v1)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLProgramUniform2i,
                            "context = %d, program = %u, location = %d, v0 = %d, v1 = %d",
                            CID(context), program, location, v0, v1));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform2i(context, angle::EntryPoint::GLProgramUniform2i,
                                             programPacked, locationPacked, v0, v1);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLProgramUniform2i);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform2i(programPacked, locationPacked, v0, v1);
        }
        ANGLE_CAPTURE_GL(ProgramUniform2i, isCallValid, context, programPacked, locationPacked, v0,
                         v1);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform2i);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniform2iv(GLuint program,
                                      GLint location,
                                      GLsizei count,
                                      const GLint *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLProgramUniform2iv,
              "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
              CID(context), program, location, count, (uintptr_t)value));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform2iv(context, angle::EntryPoint::GLProgramUniform2iv,
                                              programPacked, locationPacked, count, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLProgramUniform2iv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform2iv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE_GL(ProgramUniform2iv, isCallValid, context, programPacked, locationPacked,
                         count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform2iv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniform2ui(GLuint program, GLint location, GLuint v0, GLuint v1)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLProgramUniform2ui,
                            "context = %d, program = %u, location = %d, v0 = %u, v1 = %u",
                            CID(context), program, location, v0, v1));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform2ui(context, angle::EntryPoint::GLProgramUniform2ui,
                                              programPacked, locationPacked, v0, v1);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLProgramUniform2ui);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform2ui(programPacked, locationPacked, v0, v1);
        }
        ANGLE_CAPTURE_GL(ProgramUniform2ui, isCallValid, context, programPacked, locationPacked, v0,
                         v1);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform2ui);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniform2uiv(GLuint program,
                                       GLint location,
                                       GLsizei count,
                                       const GLuint *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLProgramUniform2uiv,
              "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
              CID(context), program, location, count, (uintptr_t)value));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform2uiv(context, angle::EntryPoint::GLProgramUniform2uiv,
                                               programPacked, locationPacked, count, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLProgramUniform2uiv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform2uiv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE_GL(ProgramUniform2uiv, isCallValid, context, programPacked, locationPacked,
                         count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform2uiv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY
GL_ProgramUniform3f(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLProgramUniform3f,
                            "context = %d, program = %u, location = %d, v0 = %f, v1 = %f, v2 = %f",
                            CID(context), program, location, v0, v1, v2));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform3f(context, angle::EntryPoint::GLProgramUniform3f,
                                             programPacked, locationPacked, v0, v1, v2);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLProgramUniform3f);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform3f(programPacked, locationPacked, v0, v1, v2);
        }
        ANGLE_CAPTURE_GL(ProgramUniform3f, isCallValid, context, programPacked, locationPacked, v0,
                         v1, v2);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform3f);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniform3fv(GLuint program,
                                      GLint location,
                                      GLsizei count,
                                      const GLfloat *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLProgramUniform3fv,
              "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
              CID(context), program, location, count, (uintptr_t)value));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform3fv(context, angle::EntryPoint::GLProgramUniform3fv,
                                              programPacked, locationPacked, count, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLProgramUniform3fv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform3fv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE_GL(ProgramUniform3fv, isCallValid, context, programPacked, locationPacked,
                         count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform3fv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniform3i(GLuint program, GLint location, GLint v0, GLint v1, GLint v2)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLProgramUniform3i,
                            "context = %d, program = %u, location = %d, v0 = %d, v1 = %d, v2 = %d",
                            CID(context), program, location, v0, v1, v2));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform3i(context, angle::EntryPoint::GLProgramUniform3i,
                                             programPacked, locationPacked, v0, v1, v2);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLProgramUniform3i);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform3i(programPacked, locationPacked, v0, v1, v2);
        }
        ANGLE_CAPTURE_GL(ProgramUniform3i, isCallValid, context, programPacked, locationPacked, v0,
                         v1, v2);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform3i);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniform3iv(GLuint program,
                                      GLint location,
                                      GLsizei count,
                                      const GLint *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLProgramUniform3iv,
              "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
              CID(context), program, location, count, (uintptr_t)value));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform3iv(context, angle::EntryPoint::GLProgramUniform3iv,
                                              programPacked, locationPacked, count, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLProgramUniform3iv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform3iv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE_GL(ProgramUniform3iv, isCallValid, context, programPacked, locationPacked,
                         count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform3iv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY
GL_ProgramUniform3ui(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLProgramUniform3ui,
                            "context = %d, program = %u, location = %d, v0 = %u, v1 = %u, v2 = %u",
                            CID(context), program, location, v0, v1, v2));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform3ui(context, angle::EntryPoint::GLProgramUniform3ui,
                                              programPacked, locationPacked, v0, v1, v2);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLProgramUniform3ui);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform3ui(programPacked, locationPacked, v0, v1, v2);
        }
        ANGLE_CAPTURE_GL(ProgramUniform3ui, isCallValid, context, programPacked, locationPacked, v0,
                         v1, v2);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform3ui);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniform3uiv(GLuint program,
                                       GLint location,
                                       GLsizei count,
                                       const GLuint *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLProgramUniform3uiv,
              "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
              CID(context), program, location, count, (uintptr_t)value));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform3uiv(context, angle::EntryPoint::GLProgramUniform3uiv,
                                               programPacked, locationPacked, count, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLProgramUniform3uiv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform3uiv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE_GL(ProgramUniform3uiv, isCallValid, context, programPacked, locationPacked,
                         count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform3uiv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY
GL_ProgramUniform4f(GLuint program, GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLProgramUniform4f,
              "context = %d, program = %u, location = %d, v0 = %f, v1 = %f, v2 = %f, v3 = %f",
              CID(context), program, location, v0, v1, v2, v3));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform4f(context, angle::EntryPoint::GLProgramUniform4f,
                                             programPacked, locationPacked, v0, v1, v2, v3);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLProgramUniform4f);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform4f(programPacked, locationPacked, v0, v1, v2, v3);
        }
        ANGLE_CAPTURE_GL(ProgramUniform4f, isCallValid, context, programPacked, locationPacked, v0,
                         v1, v2, v3);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform4f);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniform4fv(GLuint program,
                                      GLint location,
                                      GLsizei count,
                                      const GLfloat *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLProgramUniform4fv,
              "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
              CID(context), program, location, count, (uintptr_t)value));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform4fv(context, angle::EntryPoint::GLProgramUniform4fv,
                                              programPacked, locationPacked, count, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLProgramUniform4fv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform4fv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE_GL(ProgramUniform4fv, isCallValid, context, programPacked, locationPacked,
                         count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform4fv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY
GL_ProgramUniform4i(GLuint program, GLint location, GLint v0, GLint v1, GLint v2, GLint v3)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLProgramUniform4i,
              "context = %d, program = %u, location = %d, v0 = %d, v1 = %d, v2 = %d, v3 = %d",
              CID(context), program, location, v0, v1, v2, v3));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform4i(context, angle::EntryPoint::GLProgramUniform4i,
                                             programPacked, locationPacked, v0, v1, v2, v3);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLProgramUniform4i);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform4i(programPacked, locationPacked, v0, v1, v2, v3);
        }
        ANGLE_CAPTURE_GL(ProgramUniform4i, isCallValid, context, programPacked, locationPacked, v0,
                         v1, v2, v3);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform4i);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniform4iv(GLuint program,
                                      GLint location,
                                      GLsizei count,
                                      const GLint *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLProgramUniform4iv,
              "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
              CID(context), program, location, count, (uintptr_t)value));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform4iv(context, angle::EntryPoint::GLProgramUniform4iv,
                                              programPacked, locationPacked, count, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLProgramUniform4iv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform4iv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE_GL(ProgramUniform4iv, isCallValid, context, programPacked, locationPacked,
                         count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform4iv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY
GL_ProgramUniform4ui(GLuint program, GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLProgramUniform4ui,
              "context = %d, program = %u, location = %d, v0 = %u, v1 = %u, v2 = %u, v3 = %u",
              CID(context), program, location, v0, v1, v2, v3));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform4ui(context, angle::EntryPoint::GLProgramUniform4ui,
                                              programPacked, locationPacked, v0, v1, v2, v3);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLProgramUniform4ui);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform4ui(programPacked, locationPacked, v0, v1, v2, v3);
        }
        ANGLE_CAPTURE_GL(ProgramUniform4ui, isCallValid, context, programPacked, locationPacked, v0,
                         v1, v2, v3);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform4ui);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniform4uiv(GLuint program,
                                       GLint location,
                                       GLsizei count,
                                       const GLuint *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLProgramUniform4uiv,
              "context = %d, program = %u, location = %d, count = %d, value = 0x%016" PRIxPTR "",
              CID(context), program, location, count, (uintptr_t)value));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateProgramUniform4uiv(context, angle::EntryPoint::GLProgramUniform4uiv,
                                               programPacked, locationPacked, count, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLProgramUniform4uiv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniform4uiv(programPacked, locationPacked, count, value);
        }
        ANGLE_CAPTURE_GL(ProgramUniform4uiv, isCallValid, context, programPacked, locationPacked,
                         count, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLProgramUniform4uiv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniformMatrix2fv(GLuint program,
                                            GLint location,
                                            GLsizei count,
                                            GLboolean transpose,
                                            const GLfloat *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLProgramUniformMatrix2fv,
                            "context = %d, program = %u, location = %d, count = %d, transpose = "
                            "%s, value = 0x%016" PRIxPTR "",
                            CID(context), program, location, count, GLbooleanToString(transpose),
                            (uintptr_t)value));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateProgramUniformMatrix2fv(
                    context, angle::EntryPoint::GLProgramUniformMatrix2fv, programPacked,
                    locationPacked, count, transpose, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLProgramUniformMatrix2fv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniformMatrix2fv(programPacked, locationPacked, count, transpose,
                                             value);
        }
        ANGLE_CAPTURE_GL(ProgramUniformMatrix2fv, isCallValid, context, programPacked,
                         locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLProgramUniformMatrix2fv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniformMatrix2x3fv(GLuint program,
                                              GLint location,
                                              GLsizei count,
                                              GLboolean transpose,
                                              const GLfloat *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLProgramUniformMatrix2x3fv,
                            "context = %d, program = %u, location = %d, count = %d, transpose = "
                            "%s, value = 0x%016" PRIxPTR "",
                            CID(context), program, location, count, GLbooleanToString(transpose),
                            (uintptr_t)value));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateProgramUniformMatrix2x3fv(
                    context, angle::EntryPoint::GLProgramUniformMatrix2x3fv, programPacked,
                    locationPacked, count, transpose, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLProgramUniformMatrix2x3fv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniformMatrix2x3fv(programPacked, locationPacked, count, transpose,
                                               value);
        }
        ANGLE_CAPTURE_GL(ProgramUniformMatrix2x3fv, isCallValid, context, programPacked,
                         locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLProgramUniformMatrix2x3fv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniformMatrix2x4fv(GLuint program,
                                              GLint location,
                                              GLsizei count,
                                              GLboolean transpose,
                                              const GLfloat *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLProgramUniformMatrix2x4fv,
                            "context = %d, program = %u, location = %d, count = %d, transpose = "
                            "%s, value = 0x%016" PRIxPTR "",
                            CID(context), program, location, count, GLbooleanToString(transpose),
                            (uintptr_t)value));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateProgramUniformMatrix2x4fv(
                    context, angle::EntryPoint::GLProgramUniformMatrix2x4fv, programPacked,
                    locationPacked, count, transpose, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLProgramUniformMatrix2x4fv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniformMatrix2x4fv(programPacked, locationPacked, count, transpose,
                                               value);
        }
        ANGLE_CAPTURE_GL(ProgramUniformMatrix2x4fv, isCallValid, context, programPacked,
                         locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLProgramUniformMatrix2x4fv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniformMatrix3fv(GLuint program,
                                            GLint location,
                                            GLsizei count,
                                            GLboolean transpose,
                                            const GLfloat *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLProgramUniformMatrix3fv,
                            "context = %d, program = %u, location = %d, count = %d, transpose = "
                            "%s, value = 0x%016" PRIxPTR "",
                            CID(context), program, location, count, GLbooleanToString(transpose),
                            (uintptr_t)value));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateProgramUniformMatrix3fv(
                    context, angle::EntryPoint::GLProgramUniformMatrix3fv, programPacked,
                    locationPacked, count, transpose, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLProgramUniformMatrix3fv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniformMatrix3fv(programPacked, locationPacked, count, transpose,
                                             value);
        }
        ANGLE_CAPTURE_GL(ProgramUniformMatrix3fv, isCallValid, context, programPacked,
                         locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLProgramUniformMatrix3fv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniformMatrix3x2fv(GLuint program,
                                              GLint location,
                                              GLsizei count,
                                              GLboolean transpose,
                                              const GLfloat *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLProgramUniformMatrix3x2fv,
                            "context = %d, program = %u, location = %d, count = %d, transpose = "
                            "%s, value = 0x%016" PRIxPTR "",
                            CID(context), program, location, count, GLbooleanToString(transpose),
                            (uintptr_t)value));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateProgramUniformMatrix3x2fv(
                    context, angle::EntryPoint::GLProgramUniformMatrix3x2fv, programPacked,
                    locationPacked, count, transpose, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLProgramUniformMatrix3x2fv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniformMatrix3x2fv(programPacked, locationPacked, count, transpose,
                                               value);
        }
        ANGLE_CAPTURE_GL(ProgramUniformMatrix3x2fv, isCallValid, context, programPacked,
                         locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLProgramUniformMatrix3x2fv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniformMatrix3x4fv(GLuint program,
                                              GLint location,
                                              GLsizei count,
                                              GLboolean transpose,
                                              const GLfloat *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLProgramUniformMatrix3x4fv,
                            "context = %d, program = %u, location = %d, count = %d, transpose = "
                            "%s, value = 0x%016" PRIxPTR "",
                            CID(context), program, location, count, GLbooleanToString(transpose),
                            (uintptr_t)value));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateProgramUniformMatrix3x4fv(
                    context, angle::EntryPoint::GLProgramUniformMatrix3x4fv, programPacked,
                    locationPacked, count, transpose, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLProgramUniformMatrix3x4fv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniformMatrix3x4fv(programPacked, locationPacked, count, transpose,
                                               value);
        }
        ANGLE_CAPTURE_GL(ProgramUniformMatrix3x4fv, isCallValid, context, programPacked,
                         locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLProgramUniformMatrix3x4fv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniformMatrix4fv(GLuint program,
                                            GLint location,
                                            GLsizei count,
                                            GLboolean transpose,
                                            const GLfloat *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLProgramUniformMatrix4fv,
                            "context = %d, program = %u, location = %d, count = %d, transpose = "
                            "%s, value = 0x%016" PRIxPTR "",
                            CID(context), program, location, count, GLbooleanToString(transpose),
                            (uintptr_t)value));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateProgramUniformMatrix4fv(
                    context, angle::EntryPoint::GLProgramUniformMatrix4fv, programPacked,
                    locationPacked, count, transpose, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLProgramUniformMatrix4fv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniformMatrix4fv(programPacked, locationPacked, count, transpose,
                                             value);
        }
        ANGLE_CAPTURE_GL(ProgramUniformMatrix4fv, isCallValid, context, programPacked,
                         locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLProgramUniformMatrix4fv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniformMatrix4x2fv(GLuint program,
                                              GLint location,
                                              GLsizei count,
                                              GLboolean transpose,
                                              const GLfloat *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLProgramUniformMatrix4x2fv,
                            "context = %d, program = %u, location = %d, count = %d, transpose = "
                            "%s, value = 0x%016" PRIxPTR "",
                            CID(context), program, location, count, GLbooleanToString(transpose),
                            (uintptr_t)value));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateProgramUniformMatrix4x2fv(
                    context, angle::EntryPoint::GLProgramUniformMatrix4x2fv, programPacked,
                    locationPacked, count, transpose, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLProgramUniformMatrix4x2fv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniformMatrix4x2fv(programPacked, locationPacked, count, transpose,
                                               value);
        }
        ANGLE_CAPTURE_GL(ProgramUniformMatrix4x2fv, isCallValid, context, programPacked,
                         locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLProgramUniformMatrix4x2fv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ProgramUniformMatrix4x3fv(GLuint program,
                                              GLint location,
                                              GLsizei count,
                                              GLboolean transpose,
                                              const GLfloat *value)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLProgramUniformMatrix4x3fv,
                            "context = %d, program = %u, location = %d, count = %d, transpose = "
                            "%s, value = 0x%016" PRIxPTR "",
                            CID(context), program, location, count, GLbooleanToString(transpose),
                            (uintptr_t)value));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ShaderProgramID programPacked  = PackParam<ShaderProgramID>(program);
        UniformLocation locationPacked = PackParam<UniformLocation>(location);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateProgramUniformMatrix4x3fv(
                    context, angle::EntryPoint::GLProgramUniformMatrix4x3fv, programPacked,
                    locationPacked, count, transpose, value);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLProgramUniformMatrix4x3fv);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->programUniformMatrix4x3fv(programPacked, locationPacked, count, transpose,
                                               value);
        }
        ANGLE_CAPTURE_GL(ProgramUniformMatrix4x3fv, isCallValid, context, programPacked,
                         locationPacked, count, transpose, value);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLProgramUniformMatrix4x3fv);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_SampleMaski(GLuint maskNumber, GLbitfield mask)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLSampleMaski, "context = %d, maskNumber = %u, mask = %s",
                            CID(context), maskNumber,
                            GLbitfieldToString(GLESEnum::AllEnums, mask).c_str()));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateSampleMaski(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLSampleMaski, maskNumber, mask);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLSampleMaski);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateSampleMaski(context->getMutablePrivateState(),
                                      context->getMutablePrivateStateCache(), maskNumber, mask);
        }
        ANGLE_CAPTURE_GL(SampleMaski, isCallValid, context, maskNumber, mask);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLSampleMaski);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_TexStorage2DMultisample(GLenum target,
                                            GLsizei samples,
                                            GLenum internalformat,
                                            GLsizei width,
                                            GLsizei height,
                                            GLboolean fixedsamplelocations)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLTexStorage2DMultisample,
                            "context = %d, target = %s, samples = %d, internalformat = %s, width = "
                            "%d, height = %d, fixedsamplelocations = %s",
                            CID(context), GLenumToString(GLESEnum::TextureTarget, target), samples,
                            GLenumToString(GLESEnum::SizedInternalFormat, internalformat), width,
                            height, GLbooleanToString(fixedsamplelocations)));

    if (ANGLE_LIKELY(context != nullptr))
    {
        TextureType targetPacked = PackParam<TextureType>(target);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateTexStorage2DMultisample(
                    context, angle::EntryPoint::GLTexStorage2DMultisample, targetPacked, samples,
                    internalformat, width, height, fixedsamplelocations);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLTexStorage2DMultisample);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->texStorage2DMultisample(targetPacked, samples, internalformat, width, height,
                                             fixedsamplelocations);
        }
        ANGLE_CAPTURE_GL(TexStorage2DMultisample, isCallValid, context, targetPacked, samples,
                         internalformat, width, height, fixedsamplelocations);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLTexStorage2DMultisample);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_UseProgramStages(GLuint pipeline, GLbitfield stages, GLuint program)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(
        EVENT(context, GLUseProgramStages, "context = %d, pipeline = %u, stages = %s, program = %u",
              CID(context), pipeline,
              GLbitfieldToString(GLESEnum::UseProgramStageMask, stages).c_str(), program));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ProgramPipelineID pipelinePacked = PackParam<ProgramPipelineID>(pipeline);
        ShaderProgramID programPacked    = PackParam<ShaderProgramID>(program);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid =
                    ValidateUseProgramStages(context, angle::EntryPoint::GLUseProgramStages,
                                             pipelinePacked, stages, programPacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLUseProgramStages);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->useProgramStages(pipelinePacked, stages, programPacked);
        }
        ANGLE_CAPTURE_GL(UseProgramStages, isCallValid, context, pipelinePacked, stages,
                         programPacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLUseProgramStages);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_ValidateProgramPipeline(GLuint pipeline)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLValidateProgramPipeline, "context = %d, pipeline = %u",
                            CID(context), pipeline));

    if (ANGLE_LIKELY(context != nullptr))
    {
        ProgramPipelineID pipelinePacked = PackParam<ProgramPipelineID>(pipeline);
        SCOPED_SHARE_CONTEXT_LOCK(context);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateValidateProgramPipeline(
                    context, angle::EntryPoint::GLValidateProgramPipeline, pipelinePacked);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(context->getPushedErrorCount() - errorCount == (isCallValid ? 0 : 1));
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLValidateProgramPipeline);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            context->validateProgramPipeline(pipelinePacked);
        }
        ANGLE_CAPTURE_GL(ValidateProgramPipeline, isCallValid, context, pipelinePacked);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(
            angle::EntryPoint::GLValidateProgramPipeline);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexAttribBinding(GLuint attribindex, GLuint bindingindex)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLVertexAttribBinding,
                            "context = %d, attribindex = %u, bindingindex = %u", CID(context),
                            attribindex, bindingindex));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateVertexAttribBinding(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLVertexAttribBinding, attribindex, bindingindex);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLVertexAttribBinding);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateVertexAttribBinding(context->getMutablePrivateState(),
                                              context->getMutablePrivateStateCache(), attribindex,
                                              bindingindex);
        }
        ANGLE_CAPTURE_GL(VertexAttribBinding, isCallValid, context, attribindex, bindingindex);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLVertexAttribBinding);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexAttribFormat(GLuint attribindex,
                                       GLint size,
                                       GLenum type,
                                       GLboolean normalized,
                                       GLuint relativeoffset)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLVertexAttribFormat,
                            "context = %d, attribindex = %u, size = %d, type = %s, normalized = "
                            "%s, relativeoffset = %u",
                            CID(context), attribindex, size,
                            GLenumToString(GLESEnum::VertexAttribType, type),
                            GLbooleanToString(normalized), relativeoffset));

    if (ANGLE_LIKELY(context != nullptr))
    {
        VertexAttribType typePacked = PackParam<VertexAttribType>(type);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateVertexAttribFormat(
                    context->getPrivateState(), context->getPrivateStateCache(),
                    context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLVertexAttribFormat, attribindex, size, typePacked,
                    normalized, relativeoffset);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLVertexAttribFormat);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateVertexAttribFormat(context->getMutablePrivateState(),
                                             context->getMutablePrivateStateCache(), attribindex,
                                             size, typePacked, normalized, relativeoffset);
        }
        ANGLE_CAPTURE_GL(VertexAttribFormat, isCallValid, context, attribindex, size, typePacked,
                         normalized, relativeoffset);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLVertexAttribFormat);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexAttribIFormat(GLuint attribindex,
                                        GLint size,
                                        GLenum type,
                                        GLuint relativeoffset)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(
        context, GLVertexAttribIFormat,
        "context = %d, attribindex = %u, size = %d, type = %s, relativeoffset = %u", CID(context),
        attribindex, size, GLenumToString(GLESEnum::VertexAttribIType, type), relativeoffset));

    if (ANGLE_LIKELY(context != nullptr))
    {
        VertexAttribType typePacked = PackParam<VertexAttribType>(type);
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateVertexAttribIFormat(
                    context->getPrivateState(), context->getPrivateStateCache(),
                    context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLVertexAttribIFormat, attribindex, size, typePacked,
                    relativeoffset);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLVertexAttribIFormat);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateVertexAttribIFormat(context->getMutablePrivateState(),
                                              context->getMutablePrivateStateCache(), attribindex,
                                              size, typePacked, relativeoffset);
        }
        ANGLE_CAPTURE_GL(VertexAttribIFormat, isCallValid, context, attribindex, size, typePacked,
                         relativeoffset);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLVertexAttribIFormat);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

void GL_APIENTRY GL_VertexBindingDivisor(GLuint bindingindex, GLuint divisor)
{
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
    Context *context = GetValidGlobalContext();
    ANGLE_UNSAFE_TODO(EVENT(context, GLVertexBindingDivisor,
                            "context = %d, bindingindex = %u, divisor = %u", CID(context),
                            bindingindex, divisor));

    if (ANGLE_LIKELY(context != nullptr))
    {
        bool isCallValid = context->skipValidation();
        if (!isCallValid)
        {
            if (ANGLE_LIKELY(context->getClientVersion() >= ES_3_1))
            {
#if defined(ANGLE_ENABLE_ASSERTS)
                const uint32_t errorCount = context->getPushedErrorCount();
#endif
                isCallValid = ValidateVertexBindingDivisor(
                    context->getPrivateState(), context->getMutableErrorSetForValidation(),
                    angle::EntryPoint::GLVertexBindingDivisor, bindingindex, divisor);
#if defined(ANGLE_ENABLE_ASSERTS)
                ASSERT(isCallValid || context->getPushedErrorCount() != errorCount);
#endif
            }
            else
            {
                RecordVersionErrorES31(context, angle::EntryPoint::GLVertexBindingDivisor);
            }
        }
        if (ANGLE_LIKELY(isCallValid))
        {
            ContextPrivateVertexBindingDivisor(context->getMutablePrivateState(),
                                               context->getMutablePrivateStateCache(), bindingindex,
                                               divisor);
        }
        ANGLE_CAPTURE_GL(VertexBindingDivisor, isCallValid, context, bindingindex, divisor);
    }
    else
    {
        GenerateContextLostErrorOnCurrentGlobalContext(angle::EntryPoint::GLVertexBindingDivisor);
    }
    ASSERT(!egl::Display::GetCurrentThreadUnlockedTailCall()->any());
}

}  // extern "C"
