/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.build;

import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.retrace.MappingSupplier;
import com.android.tools.r8.retrace.ProguardMappingSupplier;
import com.android.tools.r8.retrace.Retrace;
import com.android.tools.r8.retrace.RetraceCommand;
import com.android.tools.r8.retrace.StackTraceSupplier;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.List;
import org.chromium.build.annotations.NullMarked;
import org.chromium.build.annotations.Nullable;

@NullMarked
public class FlushingReTrace {
    private static final String LOGCAT_PREFIX = "(?:[VDIWEF]/.*?\\( *\\d+\\): |\\d\\d-\\d\\d [0-9:. ]+[VDIWEF] .*?: )?";
    private static final String LINE_PARSE_REGEX = "(?:[VDIWEF]/.*?\\( *\\d+\\): |\\d\\d-\\d\\d [0-9:. ]+[VDIWEF] .*?: )?(?:(?:.*?(?::|\\bat)\\s+%c\\.%m\\s*\\(\\s*%s(?:\\s*:\\s*%l\\s*)?\\))|(?:.*?\\(\\s*%s(?:\\s*:\\s*%l\\s*)?\\)\\s*%c\\.%m)|(?:.*?\\(%c\\.%m\\+%l\\))|(?:.*java\\.lang\\.NullPointerException.*[\"']%t\\s*%c\\.(?:%f|%m\\(%a\\))[\"'].*)|(?:java\\.lang\\.VerifyError: %c)|(?:java\\.lang\\.NoSuchFieldError: No instance field %f of type .*? in class L%C;)|(?:.*?Object of type %c .*)|(?:.*L%C;.*)|(?:.*?%c#%m.*?)|(?:.* isTestClass for %c)|(?:Caused by: %c:.*)|(?:.*?%c\\.%m)|(?:.*?\"%c\\.%m\".*)|(?:.*\\b(?:[Cc]lass|[Tt]ype)\\b.*?\"%c\".*)|(?:.*\\b(?:[Cc]lass|[Tt]ype)\\b.*?%c)|(?:%c:.*)|(?:%c))";

    private static void usage() {
        System.err.println("Usage: echo $OBFUSCATED_CLASS | java_deobfuscate Foo.apk.mapping");
        System.err.println("Usage: java_deobfuscate Foo.apk.mapping < foo.log");
        System.err.println("Note: Deobfuscation of symbols outside the context of stack traces will work only when lines match the regular expression defined in FlushingReTrace.java.");
        System.err.println("Also: Deobfuscation of method names without associated line numbers does not seem to work.");
        System.exit(1);
    }

    public static void main(String[] args) {
        if (args.length != 1 || args[0].startsWith("-")) {
            FlushingReTrace.usage();
        }
        try {
            ProguardMappingSupplier mappingSupplier = (ProguardMappingSupplier)ProguardMappingSupplier.builder().setProguardMapProducer(() -> new FileInputStream(args[0])).build();
            mappingSupplier.createRetracer(new DiagnosticsHandler(){});
            RetraceCommand retraceCommand = RetraceCommand.builder().setMappingSupplier((MappingSupplier)mappingSupplier).setRetracedStackTraceConsumer(retraced -> retraced.forEach(System.out::println)).setRegularExpression(LINE_PARSE_REGEX).setStackTrace(new StackTraceSupplier(){
                final BufferedReader mReader = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));

                public @Nullable List<String> get() {
                    try {
                        String line = this.mReader.readLine();
                        if (line == null) {
                            return null;
                        }
                        return Collections.singletonList(line);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            }).build();
            Retrace.run((RetraceCommand)retraceCommand);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

