// This file is part of ICU4X. For terms of use, please see the file
// called LICENSE at the top level of the ICU4X source tree
// (online at: https://github.com/unicode-org/icu4x/blob/main/LICENSE ).

use zerotrie::ZeroTrieSimpleAscii;

/// This constant maps simple cldr unit names to their unique identifiers.
/// Identifiers are immutable; any new unit must be assigned a distinct identifier.
/// NOTE: These identifiers are tied to the units data generation. After adding a new unit,
/// remember to regenerate the units data to reflect changes.
pub const CLDR_IDS_TRIE: ZeroTrieSimpleAscii<[u8; 1341]> =
    ZeroTrieSimpleAscii::from_sorted_str_tuples(&[
        ("acre", 1_usize),
        ("ampere", 2_usize),
        ("arc-minute", 3_usize),
        ("arc-second", 4_usize),
        ("astronomical-unit", 5_usize),
        ("atmosphere", 6_usize),
        ("bar", 7_usize),
        ("barrel", 8_usize),
        ("beaufort", 9_usize),
        ("becquerel", 10_usize),
        ("bit", 11_usize),
        ("british-thermal-unit", 12_usize),
        ("british-thermal-unit-it", 13_usize),
        ("bu-jp", 14_usize),
        ("bushel", 15_usize),
        ("byte", 16_usize),
        ("calorie", 17_usize),
        ("calorie-it", 18_usize),
        ("candela", 19_usize),
        ("carat", 20_usize),
        ("celsius", 21_usize),
        ("century", 22_usize),
        ("chain", 23_usize),
        ("cho", 24_usize),
        ("coulomb", 25_usize),
        ("cup", 26_usize),
        ("cup-imperial", 0_usize),
        ("cup-jp", 27_usize),
        ("cup-metric", 28_usize),
        ("dalton", 29_usize),
        ("day", 30_usize),
        ("day-person", 31_usize),
        ("decade", 32_usize),
        ("degree", 33_usize),
        ("dessert-spoon", 34_usize),
        ("dessert-spoon-imperial", 35_usize),
        ("dot", 36_usize),
        ("dram", 37_usize),
        ("drop", 38_usize),
        ("dunam", 39_usize),
        ("earth-mass", 40_usize),
        ("earth-radius", 41_usize),
        ("electronvolt", 42_usize),
        ("em", 43_usize),
        ("fahrenheit", 44_usize),
        ("farad", 45_usize),
        ("fathom", 46_usize),
        ("fluid-ounce", 47_usize),
        ("fluid-ounce-imperial", 48_usize),
        ("fluid-ounce-metric", 156_usize),
        ("foodcalorie", 49_usize),
        ("foot", 50_usize),
        ("fortnight", 51_usize),
        ("fun", 52_usize),
        ("furlong", 53_usize),
        ("g-force", 54_usize),
        ("gallon", 55_usize),
        ("gallon-imperial", 56_usize),
        ("gasoline-energy-density", 57_usize),
        ("grain", 58_usize),
        ("gram", 59_usize),
        ("gray", 60_usize),
        ("hectare", 61_usize),
        ("henry", 62_usize),
        ("hertz", 63_usize),
        ("horsepower", 64_usize),
        ("hour", 65_usize),
        ("inch", 66_usize),
        ("item", 67_usize),
        ("jigger", 68_usize),
        ("jo-jp", 69_usize),
        ("joule", 70_usize),
        ("karat", 71_usize),
        ("katal", 72_usize),
        ("kelvin", 73_usize),
        ("ken", 74_usize),
        // NOTE: `kilometer` must be removed from CLDR, see https://unicode-org.atlassian.net/browse/CLDR-18736
        ("kilogram", 75_usize),
        ("kilogram-force", 76_usize),
        ("knot", 77_usize),
        ("koku", 78_usize),
        ("kosaji", 79_usize),
        ("light-speed", 80_usize),
        ("light-year", 81_usize),
        ("liter", 82_usize),
        ("lumen", 83_usize),
        ("lux", 84_usize),
        ("meter", 85_usize),
        ("mile", 86_usize),
        ("mile-scandinavian", 87_usize),
        ("minute", 88_usize),
        ("mole", 89_usize),
        ("month", 90_usize),
        ("month-person", 91_usize),
        ("nautical-mile", 92_usize),
        ("newton", 93_usize),
        ("night", 94_usize),
        ("ofglucose", 95_usize),
        ("ofhg", 96_usize),
        ("ohm", 97_usize),
        ("osaji", 98_usize),
        ("ounce", 99_usize),
        ("ounce-troy", 100_usize),
        ("parsec", 101_usize),
        ("part", 155_usize),
        ("pascal", 102_usize),
        ("percent", 103_usize),
        ("permille", 104_usize),
        ("permillion", 105_usize),
        ("permyriad", 106_usize),
        ("pinch", 107_usize),
        ("pint", 108_usize),
        ("pint-imperial", 109_usize),
        ("pint-metric", 110_usize),
        ("pixel", 111_usize),
        ("point", 112_usize),
        ("portion", 113_usize),
        ("pound", 114_usize),
        ("pound-force", 115_usize),
        ("quart", 116_usize),
        ("quart-imperial", 117_usize),
        ("quarter", 118_usize),
        ("radian", 119_usize),
        ("rankine", 120_usize),
        ("revolution", 121_usize),
        ("ri-jp", 122_usize),
        ("rin", 123_usize),
        ("rod", 124_usize),
        ("sai", 125_usize),
        ("se-jp", 126_usize),
        ("second", 127_usize),
        ("shaku", 128_usize),
        ("shaku-cloth", 129_usize),
        ("shaku-length", 130_usize),
        ("siemens", 131_usize),
        ("sievert", 132_usize),
        ("slug", 133_usize),
        ("solar-luminosity", 134_usize),
        ("solar-mass", 135_usize),
        ("solar-radius", 136_usize),
        ("steradian", 137_usize),
        ("stone", 138_usize),
        ("sun", 139_usize),
        ("tablespoon", 140_usize),
        ("teaspoon", 141_usize),
        ("tesla", 142_usize),
        ("therm-us", 143_usize),
        ("to-jp", 144_usize),
        ("ton", 145_usize),
        ("tonne", 146_usize),
        ("volt", 147_usize),
        ("watt", 148_usize),
        ("weber", 149_usize),
        ("week", 150_usize),
        ("week-person", 151_usize),
        ("yard", 152_usize),
        ("year", 153_usize),
        ("year-person", 154_usize),
    ]);
