/*
 *  Copyright (C) 2010 Ryszard Wiśniewski <brut.alll@gmail.com>
 *  Copyright (C) 2010 Connor Tumbleson <connor.tumbleson@gmail.com>
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package brut.androlib;

import java.io.File;

import org.junit.*;
import static org.junit.Assert.*;

public class BuildAndDecodeJarTest extends BaseTest {

    @BeforeClass
    public static void beforeClass() throws Exception {
        sTestOrigDir = new File(sTmpDir, "testjar-orig");
        sTestNewDir = new File(sTmpDir, "testjar-new");

        log("Unpacking testjar...");
        copyResourceDir(BuildAndDecodeJarTest.class, "testjar", sTestOrigDir);

        log("Building testjar.jar...");
        File testJar = new File(sTmpDir, "testjar.jar");
        new ApkBuilder(sTestOrigDir, sConfig).build(testJar);

        log("Decoding testjar.jar...");
        new ApkDecoder(testJar, sConfig).decode(sTestNewDir);
    }

    @Test
    public void buildAndDecodeTest() {
        assertTrue(sTestNewDir.isDirectory());
    }
}
