/*
 *  Copyright (C) 2010 Ryszard Wiśniewski <brut.alll@gmail.com>
 *  Copyright (C) 2010 Connor Tumbleson <connor.tumbleson@gmail.com>
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package brut.androlib;

import brut.androlib.meta.ApkInfo;
import brut.androlib.res.table.ResId;
import brut.androlib.res.table.ResTable;
import brut.androlib.res.table.value.ResArray;
import brut.androlib.res.table.value.ResValue;
import brut.directory.ExtFile;

import org.junit.*;
import static org.junit.Assert.*;

public class DecodeArrayTest extends BaseTest {
    private static ExtFile sTestApk;
    private static ResTable sTable;

    @BeforeClass
    public static void beforeClass() throws Exception {
        copyResourceDir(MissingVersionManifestTest.class, "issue1994", sTmpDir);

        log("Decoding issue1994.apk...");
        sTestApk = new ExtFile(sTmpDir, "issue1994.apk");
        ApkInfo testInfo = new ApkInfo();
        testInfo.setApkFile(sTestApk);
        sTable = new ResTable(testInfo, sConfig);
        sTable.load();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        sTestApk.close();
    }

    @Test
    public void decodeStringArray() throws Exception {
        ResValue value = sTable.resolveEntry(ResId.of(0x7F020001)).getValue();
        assertTrue("Not a ResArray. Found: " + value.getClass(), value instanceof ResArray);
    }

    @Test
    public void decodeArray() throws Exception {
        ResValue value = sTable.resolveEntry(ResId.of(0x7F020000)).getValue();
        assertTrue("Not a ResArray. Found: " + value.getClass(), value instanceof ResArray);
    }
}
