/*
 *  Copyright (C) 2010 Ryszard Wiśniewski <brut.alll@gmail.com>
 *  Copyright (C) 2010 Connor Tumbleson <connor.tumbleson@gmail.com>
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package brut.androlib;

import java.io.File;

import org.junit.*;
import static org.junit.Assert.*;
import static org.custommonkey.xmlunit.XMLAssert.assertXMLEqual;

public class ExternalEntityTest extends BaseTest {

    @BeforeClass
    public static void beforeClass() throws Exception {
        sTestOrigDir = new File(sTmpDir, "doctype-orig");
        sTestNewDir = new File(sTmpDir, "doctype-new");

        log("Unpacking doctype...");
        copyResourceDir(ExternalEntityTest.class, "doctype", sTestOrigDir);

        log("Building doctype.apk...");
        File testApk = new File(sTmpDir, "doctype.apk");
        new ApkBuilder(sTestOrigDir, sConfig).build(testApk);

        log("Decoding doctype.apk...");
        new ApkDecoder(testApk, sConfig).decode(sTestNewDir);
    }

    @Test
    public void doctypeTest() throws Exception {
        String expected =
            "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n"
          + "<manifest hardwareAccelerated=\"true\" package=\"com.ibotpeaches.doctype\" platformBuildVersionCode=\"24\" platformBuildVersionName=\"6.0-2456767\"\n"
          + "  xmlns:android=\"http://schemas.android.com/apk/res/android\">\n"
          + "    <supports-screens android:anyDensity=\"true\" android:smallScreens=\"true\" android:normalScreens=\"true\" android:largeScreens=\"true\" android:resizeable=\"true\" android:xlargeScreens=\"true\" />\n"
          + "</manifest>";

        String obtained = readTextFile(new File(sTestNewDir, "AndroidManifest.xml"));

        assertXMLEqual(expected, obtained);
    }
}
