/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.Calc;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Flt;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;

@FunctionalInterface
interface CalcOpt {
    public static CalcOpt get(SeqType st1, SeqType st2, Calc calc) {
        AtomType type = Calc.numType(st1.type, st2.type);
        if (type.isNumber()) {
            switch (calc) {
                case ADD: {
                    switch (type) {
                        case DOUBLE: {
                            return CalcOpt::addDbl;
                        }
                        case FLOAT: {
                            return CalcOpt::addFlt;
                        }
                        case INTEGER: {
                            return CalcOpt::addInt;
                        }
                    }
                    break;
                }
                case SUBTRACT: {
                    switch (type) {
                        case DOUBLE: {
                            return CalcOpt::subtractDbl;
                        }
                        case FLOAT: {
                            return CalcOpt::subtractFlt;
                        }
                        case INTEGER: {
                            return CalcOpt::subtractInt;
                        }
                    }
                    break;
                }
                case MULTIPLY: {
                    switch (type) {
                        case DOUBLE: {
                            return CalcOpt::multiplyDbl;
                        }
                        case FLOAT: {
                            return CalcOpt::multiplyFlt;
                        }
                        case INTEGER: {
                            return CalcOpt::multiplyInt;
                        }
                    }
                    break;
                }
                case DIVIDE: {
                    switch (type) {
                        case DOUBLE: {
                            return CalcOpt::divideDbl;
                        }
                        case FLOAT: {
                            return CalcOpt::divideFlt;
                        }
                        case INTEGER: {
                            return CalcOpt::divideDec;
                        }
                    }
                    break;
                }
                case DIVIDEINT: {
                    switch (type) {
                        case DOUBLE: {
                            return CalcOpt::divideIntDbl;
                        }
                        case FLOAT: {
                            return CalcOpt::divideIntFlt;
                        }
                        case INTEGER: {
                            return CalcOpt::divideIntInt;
                        }
                    }
                    break;
                }
                case MODULO: {
                    switch (type) {
                        case DOUBLE: {
                            return CalcOpt::moduloDbl;
                        }
                        case FLOAT: {
                            return CalcOpt::moduloFlt;
                        }
                        case INTEGER: {
                            return CalcOpt::moduloInt;
                        }
                    }
                    break;
                }
            }
        }
        return null;
    }

    public Item eval(Item var1, Item var2, InputInfo var3) throws QueryException;

    public static Dbl addDbl(Item item1, Item item2, InputInfo info) throws QueryException {
        return Dbl.get(item1.dbl(info) + item2.dbl(info));
    }

    public static Dbl subtractDbl(Item item1, Item item2, InputInfo info) throws QueryException {
        return Dbl.get(item1.dbl(info) - item2.dbl(info));
    }

    public static Dbl multiplyDbl(Item item1, Item item2, InputInfo info) throws QueryException {
        return Dbl.get(item1.dbl(info) * item2.dbl(info));
    }

    public static Dbl divideDbl(Item item1, Item item2, InputInfo info) throws QueryException {
        return Dbl.get(item1.dbl(info) / item2.dbl(info));
    }

    public static Itr divideIntDbl(Item item1, Item item2, InputInfo info) throws QueryException {
        double n1 = item1.dbl(info);
        double n2 = item2.dbl(info);
        double n = n1 / n2;
        if (n2 == 0.0) {
            throw QueryError.DIVZERO_X.get(info, item1);
        }
        if (Double.isNaN(n) || Double.isInfinite(n)) {
            throw QueryError.INVIDIV.get(info, String.valueOf(item1) + " idiv " + String.valueOf(item2));
        }
        if (n < -9.223372036854776E18 || n > 9.223372036854776E18) {
            throw QueryError.RANGE_X.get(info, String.valueOf(item1) + " idiv " + String.valueOf(item2));
        }
        return Itr.get((long)n);
    }

    public static Dbl moduloDbl(Item item1, Item item2, InputInfo info) throws QueryException {
        return Dbl.get(item1.dbl(info) % item2.dbl(info));
    }

    public static Flt addFlt(Item item1, Item item2, InputInfo info) throws QueryException {
        return Flt.get(item1.flt(info) + item2.flt(info));
    }

    public static Flt subtractFlt(Item item1, Item item2, InputInfo info) throws QueryException {
        return Flt.get(item1.flt(info) - item2.flt(info));
    }

    public static Flt multiplyFlt(Item item1, Item item2, InputInfo info) throws QueryException {
        return Flt.get(item1.flt(info) * item2.flt(info));
    }

    public static Flt divideFlt(Item item1, Item item2, InputInfo info) throws QueryException {
        return Flt.get(item1.flt(info) / item2.flt(info));
    }

    public static Itr divideIntFlt(Item item1, Item item2, InputInfo info) throws QueryException {
        double n1 = item1.flt(info);
        double n2 = item2.flt(info);
        double n = n1 / n2;
        if (n2 == 0.0) {
            throw QueryError.DIVZERO_X.get(info, item1);
        }
        if (Double.isNaN(n) || Double.isInfinite(n)) {
            throw QueryError.INVIDIV.get(info, String.valueOf(item1) + " idiv " + String.valueOf(item2));
        }
        if (n < -9.223372036854776E18 || n > 9.223372036854776E18) {
            throw QueryError.RANGE_X.get(info, String.valueOf(item1) + " idiv " + String.valueOf(item2));
        }
        return Itr.get((long)n);
    }

    public static Flt moduloFlt(Item item1, Item item2, InputInfo info) throws QueryException {
        return Flt.get(item1.flt(info) % item2.flt(info));
    }

    public static Dec addDec(Item item1, Item item2, InputInfo info) throws QueryException {
        return Dec.get(item1.dec(info).add(item2.dec(info)));
    }

    public static Dec subtractDec(Item item1, Item item2, InputInfo info) throws QueryException {
        return Dec.get(item1.dec(info).subtract(item2.dec(info)));
    }

    public static Dec multiplyDec(Item item1, Item item2, InputInfo info) throws QueryException {
        return Dec.get(item1.dec(info).multiply(item2.dec(info)));
    }

    public static Dec divideDec(Item item1, Item item2, InputInfo info) throws QueryException {
        BigDecimal dec1 = item1.dec(info);
        BigDecimal dec2 = item2.dec(info);
        if (dec2.signum() == 0) {
            throw QueryError.DIVZERO_X.get(info, item1);
        }
        int scale = Math.max(18, Math.max(dec1.scale(), dec2.scale()));
        return Dec.get(dec1.divide(dec2, scale, RoundingMode.HALF_EVEN));
    }

    public static Itr divideIntDec(Item item1, Item item2, InputInfo info) throws QueryException {
        BigDecimal n1 = item1.dec(info);
        BigDecimal n2 = item2.dec(info);
        if (n2.signum() == 0) {
            throw QueryError.DIVZERO_X.get(info, item1);
        }
        BigDecimal n = n1.divideToIntegralValue(n2);
        if (Dec.BD_MINLONG.compareTo(n) > 0 || n.compareTo(Dec.BD_MAXLONG) > 0) {
            throw QueryError.RANGE_X.get(info, String.valueOf(item1) + " idiv " + String.valueOf(item2));
        }
        return Itr.get(n.longValueExact());
    }

    public static Dec moduloDec(Item item1, Item item2, InputInfo info) throws QueryException {
        BigDecimal dec1 = item1.dec(info);
        BigDecimal dec2 = item2.dec(info);
        if (dec2.signum() == 0) {
            throw QueryError.DIVZERO_X.get(info, item1);
        }
        BigDecimal sub = dec1.divide(dec2, 0, RoundingMode.DOWN);
        return Dec.get(dec1.subtract(sub.multiply(dec2)));
    }

    public static Itr addInt(Item item1, Item item2, InputInfo info) throws QueryException {
        long itr1 = item1.itr(info);
        long itr2 = item2.itr(info);
        if (itr2 > 0L ? itr1 > Long.MAX_VALUE - itr2 : itr1 < Long.MIN_VALUE - itr2) {
            throw QueryError.RANGE_X.get(info, itr1 + " + " + itr2);
        }
        return Itr.get(itr1 + itr2);
    }

    public static Itr subtractInt(Item item1, Item item2, InputInfo info) throws QueryException {
        long itr1 = item1.itr(info);
        long itr2 = item2.itr(info);
        if (itr2 < 0L ? itr1 > Long.MAX_VALUE + itr2 : itr1 < Long.MIN_VALUE + itr2) {
            throw QueryError.RANGE_X.get(info, itr1 + " - " + itr2);
        }
        return Itr.get(itr1 - itr2);
    }

    public static Itr multiplyInt(Item item1, Item item2, InputInfo info) throws QueryException {
        long l1 = item1.itr(info);
        long l2 = item2.itr(info);
        if (l2 > 0L ? l1 > Long.MAX_VALUE / l2 || l1 < Long.MIN_VALUE / l2 : (l2 < -1L ? l1 > Long.MIN_VALUE / l2 || l1 < Long.MAX_VALUE / l2 : l2 == -1L && l1 == Long.MIN_VALUE)) {
            throw QueryError.RANGE_X.get(info, l1 + " * " + l2);
        }
        return Itr.get(l1 * l2);
    }

    public static Itr divideIntInt(Item item1, Item item2, InputInfo info) throws QueryException {
        long n1 = item1.itr(info);
        long n2 = item2.itr(info);
        if (n2 == 0L) {
            throw QueryError.DIVZERO_X.get(info, item1);
        }
        if (n1 == Integer.MIN_VALUE && n2 == -1L) {
            throw QueryError.RANGE_X.get(info, String.valueOf(item1) + " idiv " + String.valueOf(item2));
        }
        return Itr.get(n1 / n2);
    }

    public static Itr moduloInt(Item item1, Item item2, InputInfo info) throws QueryException {
        long itr1 = item1.itr(info);
        long itr2 = item2.itr(info);
        if (itr2 == 0L) {
            throw QueryError.DIVZERO_X.get(info, item1);
        }
        return Itr.get(itr1 % itr2);
    }
}

