/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.func.fn.FnParseUri;
import org.basex.query.func.fn.UriOptions;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.XQMap;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class FnBuildUri
extends FnParseUri {
    @Override
    public Str item(QueryContext qc, InputInfo ii) throws QueryException {
        Value segments;
        String port;
        String userinfo;
        boolean hrrchcl;
        XQMap parts = this.toMap(this.arg(0), qc);
        UriOptions options = this.toOptions(this.arg(1), new UriOptions(), qc);
        TokenBuilder uri = new TokenBuilder();
        String scheme = this.get(parts, "scheme", qc);
        Value hierarchical = parts.get(Str.get("hierarchical"));
        boolean bl = hierarchical.isEmpty() ? !NON_HIERARCHICAL.contains(scheme) : (hrrchcl = this.toBoolean(hierarchical, qc));
        if (!scheme.isEmpty()) {
            uri.add(scheme);
            uri.add(hrrchcl ? "://" : ":");
            if (scheme.equals("file") && options.get(UriOptions.UNC_PATH).booleanValue()) {
                uri.add("//");
            }
        }
        if ((userinfo = this.get(parts, "userinfo", qc)).contains(":") && !options.get(UriOptions.ALLOW_DEPRECATED_FEATURES).booleanValue()) {
            userinfo = "";
        }
        if (FnBuildUri.omitPort(port = Token.string(this.toZeroToken(parts.get(Str.get("port")), qc)), scheme, options)) {
            port = "";
        }
        String host = this.get(parts, "host", qc);
        String authority = this.get(parts, "authority", qc);
        if (!(userinfo.isEmpty() && host.isEmpty() && port.isEmpty())) {
            if (!userinfo.isEmpty()) {
                uri.add(userinfo).add(64);
            }
            uri.add(host);
            if (!port.isEmpty()) {
                uri.add(58).add(port);
            }
        } else if (!authority.isEmpty()) {
            uri.add(authority);
        }
        if (!(segments = parts.get(Str.get("path-segments"))).isEmpty()) {
            int a = 0;
            for (Item segment : segments) {
                if (a++ != 0) {
                    uri.add("/");
                }
                byte[] sgmnt = this.toToken(segment, qc);
                uri.add(hrrchcl ? Token.encodeUri(sgmnt, Token.UriEncoder.PATH) : sgmnt);
            }
        } else {
            uri.add(this.get(parts, "path", qc));
        }
        Value qp = parts.get(Str.get("query-parameters"));
        Value query = parts.get(Str.get("query"));
        if (!qp.isEmpty()) {
            TokenBuilder tmp = new TokenBuilder();
            this.toMap(qp, qc).forEach((key, value) -> {
                byte[] k = Token.encodeUri(this.toToken((Item)key), Token.UriEncoder.QUERY);
                for (Item item : value) {
                    tmp.add(tmp.isEmpty() ? "?" : "&");
                    if (k.length != 0) {
                        tmp.add(k).add(61);
                    }
                    tmp.add(Token.encodeUri(this.toToken(item), Token.UriEncoder.QUERY));
                }
            });
            uri.add(tmp);
        } else if (!query.isEmpty()) {
            uri.add(63).add(Token.encodeUri(this.toToken(query, qc), Token.UriEncoder.QUERY));
        }
        String fragment = this.get(parts, "fragment", qc);
        if (!fragment.isEmpty()) {
            uri.add(35).add(Token.encodeUri(Token.token(fragment), Token.UriEncoder.FRAGMENT));
        }
        return Str.get(uri.finish());
    }

    private String get(XQMap map, String key, QueryContext qc) throws QueryException {
        Value value = map.get(Str.get(key));
        return value.isEmpty() ? "" : Token.string(this.toToken(value, qc));
    }
}

