/*
 * Decompiled with CFR 0.152.
 */
package de.bottlecaps.markup.blitz.transform;

import java.util.TreeMap;

public class Map2D
extends TreeMap<Index, Integer> {
    private static final long serialVersionUID = 1L;
    private int endX;
    private int endY;

    public Map2D(int endX, int endY) {
        this.endX = endX;
        this.endY = endY;
    }

    @Override
    public Integer put(Index key, Integer value) {
        if (key.x > this.getEndX() || key.y > this.getEndY()) {
            throw new IllegalArgumentException();
        }
        return super.put(key, value);
    }

    public int getEndX() {
        return this.endX;
    }

    public int getEndY() {
        return this.endY;
    }

    public static class Index
    implements Comparable<Index> {
        private int x;
        private int y;

        public Index(int x, int y) {
            this.x = x;
            this.y = y;
        }

        @Override
        public int compareTo(Index o) {
            return this.getX() != o.getX() ? this.getX() - o.getX() : this.getY() - o.getY();
        }

        public String toString() {
            return "[" + this.getX() + ", " + this.getY() + "]";
        }

        public int getY() {
            return this.y;
        }

        public int getX() {
            return this.x;
        }
    }
}

